/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd.icq;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import net.kano.joscar.BinaryTools;
import net.kano.joscar.LEBinaryTools;
import net.kano.joscar.Writable;

public class DetailTlv
implements Writable {
    private byte[] data = new byte[0];
    private int type;

    public DetailTlv(int type) {
        this.type = type;
    }

    public void write(OutputStream out) throws IOException {
        LEBinaryTools.writeUShort(out, this.type);
        LEBinaryTools.writeUShort(out, this.data.length);
        out.write(this.data);
    }

    public long getWritableLength() {
        return 4 + this.data.length;
    }

    public void writeUInt(long number) {
        byte[] tmp = LEBinaryTools.getUInt(number);
        byte[] newData = new byte[this.data.length + tmp.length];
        System.arraycopy(this.data, 0, newData, 0, this.data.length);
        System.arraycopy(tmp, 0, newData, this.data.length, tmp.length);
        this.data = newData;
    }

    public void writeUShort(int number) {
        byte[] tmp = LEBinaryTools.getUShort(number);
        byte[] newData = new byte[this.data.length + tmp.length];
        System.arraycopy(this.data, 0, newData, 0, this.data.length);
        System.arraycopy(tmp, 0, newData, this.data.length, tmp.length);
        this.data = newData;
    }

    public void writeUByte(int number) {
        byte[] tmp = LEBinaryTools.getUByte(number);
        byte[] newData = new byte[this.data.length + tmp.length];
        System.arraycopy(this.data, 0, newData, 0, this.data.length);
        System.arraycopy(tmp, 0, newData, this.data.length, tmp.length);
        this.data = newData;
    }

    public void writeString(String str) {
        if (str == null) {
            str = "";
        }
        byte[] tmp = BinaryTools.getAsciiBytes(str);
        this.writeUShort(tmp.length);
        byte[] newData = new byte[this.data.length + tmp.length];
        System.arraycopy(this.data, 0, newData, 0, this.data.length);
        System.arraycopy(tmp, 0, newData, this.data.length, tmp.length);
        this.data = newData;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("TLV: type=0x");
        buffer.append(Integer.toHexString(this.type));
        if (this.data == null) {
            buffer.append(" (no data block)");
        } else {
            int len = this.data.length;
            buffer.append(", length=" + len);
            if (len > 0) {
                CharsetDecoder ascii = Charset.forName("US-ASCII").newDecoder();
                CharBuffer chars = null;
                try {
                    chars = ascii.decode(ByteBuffer.wrap(this.data));
                }
                catch (CharacterCodingException e) {
                    // empty catch block
                }
                boolean alternatevalue = false;
                if (chars != null) {
                    buffer.append(", ascii value=\"" + chars.toString() + "\"");
                    alternatevalue = true;
                }
                if (!alternatevalue) {
                    buffer.append(" - hex: ");
                } else {
                    buffer.append(": ");
                }
            }
        }
        return buffer.toString();
    }
}

