/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.rvproto.getfile;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import net.kano.joscar.BinaryTools;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.LiveWritable;
import net.kano.joscar.rvproto.getfile.GetFileEntry;
import net.kano.joscar.tlv.ImmutableTlvChain;
import net.kano.joscar.tlv.Tlv;
import net.kano.joscar.tlv.TlvTools;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetFileList
implements LiveWritable {
    public static final String GFLISTVERSION_DEFAULT = "Lst1";
    private final String gfListVersion;
    private final List<GetFileEntry> files;

    @Nullable
    public static GetFileList readGetFileList(ByteBlock block) {
        GetFileEntry entry;
        DefensiveTools.checkNull(block, "block");
        if (block.getLength() < 4) {
            return null;
        }
        String version = BinaryTools.getAsciiString(block.subBlock(0, 4));
        ByteBlock rest = block.subBlock(4);
        ImmutableTlvChain chain = TlvTools.readChain(rest);
        List<Tlv> tlvs = chain.getTlvs();
        LinkedList<GetFileEntry> entries = new LinkedList<GetFileEntry>();
        for (int i = 0; i < tlvs.size() && (entry = GetFileEntry.readEntry(tlvs, i)) != null; i += entry.getTotalTlvCount()) {
            entries.add(entry);
        }
        return new GetFileList(version, entries);
    }

    public GetFileList(Collection<GetFileEntry> files) {
        this(GFLISTVERSION_DEFAULT, files);
    }

    public GetFileList(String gfListVersion, Collection<GetFileEntry> files) {
        DefensiveTools.checkNull(gfListVersion, "gfListVersion");
        this.files = DefensiveTools.getSafeNonnullListCopy(files, "files");
        this.gfListVersion = gfListVersion;
    }

    public final String getGfListVersion() {
        return this.gfListVersion;
    }

    public final List<GetFileEntry> getFileEntries() {
        return this.files;
    }

    @Override
    public final void write(OutputStream out) throws IOException {
        out.write(BinaryTools.getAsciiBytes(this.gfListVersion));
        for (GetFileEntry file : this.files) {
            file.write(out);
        }
    }

    public String toString() {
        return "GetFileList: version=" + this.gfListVersion + ", files=" + this.files.size();
    }
}

