/*
 * Decompiled with CFR 0.152.
 */
package com.explodingpixels.macwidgets;

import com.explodingpixels.macwidgets.MacColorUtils;
import com.explodingpixels.macwidgets.MacPainterFactory;
import com.explodingpixels.macwidgets.MacWidgetFactory;
import com.explodingpixels.macwidgets.plaf.EmphasizedLabelUI;
import com.explodingpixels.painter.Painter;
import com.explodingpixels.widgets.TableHeaderUtils;
import com.explodingpixels.widgets.TableUtils;
import com.explodingpixels.widgets.WindowUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.table.TableCellRenderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ITunesTableHeaderRenderer
extends JLabel
implements TableCellRenderer {
    private JTable fTable;
    private int fColumnModelIndexBeingPainted = -1;
    private static Color BORDER_COLOR = new Color(0, 0, 0, 51);
    private static Color UNFOCUSED_FONT_COLOR = new Color(0x8F8F8F);
    private static Border BORDER = BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, MacColorUtils.LEOPARD_BORDER_COLOR), BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 0, 1, BORDER_COLOR), BorderFactory.createEmptyBorder(1, 5, 0, 5)));
    private static final int SORT_ICON_INDENT_PIXELS = 6;
    private static final Color SORT_ICON_COLOR = new Color(0, 0, 0, 175);

    public ITunesTableHeaderRenderer(JTable table) {
        this.fTable = table;
        this.init();
    }

    private void init() {
        MacWidgetFactory.makeEmphasizedLabel(this, EmphasizedLabelUI.DEFAULT_FOCUSED_FONT_COLOR, UNFOCUSED_FONT_COLOR, EmphasizedLabelUI.DEFAULT_EMPHASIS_COLOR);
        this.setBorder(BORDER);
        this.fTable.getTableHeader().setReorderingAllowed(false);
    }

    public void setSortDelegate(TableUtils.SortDelegate sortDelegate) {
        TableUtils.makeSortable(this.fTable, sortDelegate);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (value instanceof Icon) {
            this.setIcon((Icon)value);
            this.setText("");
            this.setHorizontalAlignment(0);
        } else {
            this.setText(value.toString());
            this.setFont(this.fTable.getTableHeader().getFont());
            this.setHorizontalAlignment(2);
        }
        this.fColumnModelIndexBeingPainted = 0 <= column && column < this.fTable.getColumnCount() ? this.fTable.convertColumnIndexToModel(column) : -1;
        return this;
    }

    @Override
    protected void paintComponent(Graphics g) {
        Graphics2D graphics2d = (Graphics2D)g.create();
        Painter<Component> painter = this.getBackgroundPainter();
        painter.paint(graphics2d, this, this.getWidth(), this.getHeight());
        super.paintComponent(g);
        this.paintSortIndicatorIfNecessary(graphics2d);
        graphics2d.dispose();
    }

    private void paintSortIndicatorIfNecessary(Graphics2D graphics2d) {
        TableUtils.SortDirection sortDirection = this.getColumnBeingPaintedSortDirection();
        if (sortDirection != TableUtils.SortDirection.NONE) {
            this.paintSortIndicator(graphics2d, sortDirection);
        }
    }

    private void paintSortIndicator(Graphics2D graphics2d, TableUtils.SortDirection sortDirection) {
        GeneralPath sortShape = sortDirection == TableUtils.SortDirection.ASCENDING ? ITunesTableHeaderRenderer.createSortAscendingShape() : ITunesTableHeaderRenderer.createSortDescendingShape();
        int x = this.getWidth() - sortShape.getBounds().width - 6;
        int y = this.getHeight() / 2 - sortShape.getBounds().height / 2;
        graphics2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2d.translate(x, y);
        graphics2d.setColor(SORT_ICON_COLOR);
        graphics2d.fill(sortShape);
    }

    private boolean isColumnBeingPaintedPressed() {
        return TableHeaderUtils.isColumnPressed(this.fTable.getTableHeader(), this.fColumnModelIndexBeingPainted);
    }

    private boolean isColumnBeingPaintedSelected() {
        return TableHeaderUtils.isColumnSelected(this.fTable.getTableHeader(), this.fColumnModelIndexBeingPainted);
    }

    private TableUtils.SortDirection getColumnBeingPaintedSortDirection() {
        return TableHeaderUtils.getSortDirection(this.fTable.getTableHeader(), this.fColumnModelIndexBeingPainted);
    }

    private Painter<Component> getBackgroundPainter() {
        boolean windowHasFocus = WindowUtils.isParentWindowFocused(this.fTable);
        boolean isColumnSelected = this.isColumnBeingPaintedSelected();
        boolean isColumnPressed = this.isColumnBeingPaintedPressed();
        Painter<Component> retVal = !this.fTable.isEnabled() ? MacPainterFactory.createIAppUnpressedUnselectedHeaderPainter() : (windowHasFocus && isColumnPressed && isColumnSelected ? MacPainterFactory.createIAppPressedSelectedHeaderPainter() : (windowHasFocus && isColumnPressed ? MacPainterFactory.createIAppPressedUnselectedHeaderPainter() : (windowHasFocus && isColumnSelected ? MacPainterFactory.createIAppUnpressedSelectedHeaderPainter() : MacPainterFactory.createIAppUnpressedUnselectedHeaderPainter())));
        return retVal;
    }

    private static GeneralPath createSortAscendingShape() {
        float width = 7.0f;
        float height = 6.0f;
        GeneralPath path = new GeneralPath();
        path.moveTo(width / 2.0f, 0.0f);
        path.lineTo(width, height);
        path.lineTo(0.0f, height);
        path.lineTo(width / 2.0f, 0.0f);
        return path;
    }

    private static GeneralPath createSortDescendingShape() {
        GeneralPath path = ITunesTableHeaderRenderer.createSortAscendingShape();
        double centerX = path.getBounds2D().getWidth() / 2.0;
        double centerY = path.getBounds2D().getHeight() / 2.0;
        path.transform(AffineTransform.getRotateInstance(Math.PI, centerX, centerY));
        return path;
    }
}

