/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.notificationwiring;

import net.java.sip.communicator.plugin.notificationwiring.NotificationManager;
import net.java.sip.communicator.service.gui.ImageLoaderService;
import net.java.sip.communicator.service.gui.UIService;
import net.java.sip.communicator.service.notification.NotificationService;
import net.java.sip.communicator.util.Logger;
import net.java.sip.communicator.util.ServiceUtils;
import org.jitsi.service.neomedia.MediaService;
import org.jitsi.service.resources.ResourceManagementService;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class NotificationWiringActivator
implements BundleActivator {
    private final Logger logger = Logger.getLogger(NotificationWiringActivator.class);
    protected static BundleContext bundleContext;
    private static NotificationService notificationService;
    private static ResourceManagementService resourcesService;
    private static UIService uiService;
    private static MediaService mediaService;
    private static ImageLoaderService<?> imageLoaderService;

    public void start(BundleContext bc) throws Exception {
        bundleContext = bc;
        try {
            this.logger.logEntry();
            this.logger.info((Object)"Notification wiring plugin...[  STARTED ]");
            ServiceReference notifReference = bundleContext.getServiceReference(NotificationService.class.getName());
            notificationService = (NotificationService)bundleContext.getService(notifReference);
            new NotificationManager().init();
            this.logger.info((Object)"Notification wiring plugin ...[REGISTERED]");
        }
        finally {
            this.logger.logExit();
        }
    }

    public void stop(BundleContext bc) throws Exception {
        this.logger.info((Object)"Notification handler Service ...[STOPPED]");
    }

    public static NotificationService getNotificationService() {
        return notificationService;
    }

    public static ResourceManagementService getResources() {
        if (resourcesService == null) {
            resourcesService = (ResourceManagementService)ServiceUtils.getService((BundleContext)bundleContext, ResourceManagementService.class);
        }
        return resourcesService;
    }

    public static UIService getUIService() {
        if (uiService == null) {
            uiService = (UIService)ServiceUtils.getService((BundleContext)bundleContext, UIService.class);
        }
        return uiService;
    }

    public static MediaService getMediaService() {
        if (mediaService == null) {
            mediaService = (MediaService)ServiceUtils.getService((BundleContext)bundleContext, MediaService.class);
        }
        return mediaService;
    }

    public static ImageLoaderService<?> getImageLoaderService() {
        if (imageLoaderService == null) {
            imageLoaderService = (ImageLoaderService)ServiceUtils.getService((BundleContext)bundleContext, ImageLoaderService.class);
        }
        return imageLoaderService;
    }

    static {
        uiService = null;
    }
}

