/*
 * Decompiled with CFR 0.152.
 */
package net.htmlparser.jericho;

import java.io.IOException;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.htmlparser.jericho.CharStreamSource;
import net.htmlparser.jericho.CharStreamSourceUtil;
import net.htmlparser.jericho.CharacterReference;
import net.htmlparser.jericho.Config;
import net.htmlparser.jericho.Element;
import net.htmlparser.jericho.HTMLElements;
import net.htmlparser.jericho.RendererCSS;
import net.htmlparser.jericho.Segment;
import net.htmlparser.jericho.Source;
import net.htmlparser.jericho.StartTag;
import net.htmlparser.jericho.Tag;

public class Renderer
implements CharStreamSource {
    private final Segment rootSegment;
    private int maxLineLength = 76;
    private int hrLineLength = 72;
    private String newLine = "\r\n";
    private boolean includeHyperlinkURLs = true;
    private boolean includeAlternateText = true;
    private boolean decorateFontStyles = false;
    private boolean convertNonBreakingSpaces = Config.ConvertNonBreakingSpaces;
    private int blockIndentSize = 4;
    private int listIndentSize = 6;
    private char[] listBullets = new char[]{'*', 'o', '+', '#'};
    private boolean includeFirstElementTopMargin = false;
    private String tableCellSeparator = " \t";
    private static final int DEFAULT_LINE_LENGTH = 76;
    private static final int UNORDERED_LIST = -1;
    private static Map<String, ElementHandler> ELEMENT_HANDLERS = new HashMap<String, ElementHandler>();

    public Renderer(Segment segment) {
        this.rootSegment = segment;
    }

    @Override
    public void writeTo(Writer writer) throws IOException {
        this.appendTo(writer);
        writer.flush();
    }

    @Override
    public void appendTo(Appendable appendable) throws IOException {
        new Processor(this, this.rootSegment, this.getMaxLineLength(), this.getHRLineLength(), this.getNewLine(), this.getIncludeHyperlinkURLs(), this.getIncludeAlternateText(), this.getDecorateFontStyles(), this.getConvertNonBreakingSpaces(), this.getBlockIndentSize(), this.getListIndentSize(), this.getListBullets(), this.getTableCellSeparator()).appendTo(appendable);
    }

    @Override
    public long getEstimatedMaximumOutputLength() {
        return this.rootSegment.length();
    }

    @Override
    public String toString() {
        return CharStreamSourceUtil.toString(this);
    }

    public Renderer setMaxLineLength(int n) {
        this.maxLineLength = n;
        if (n > 0) {
            this.hrLineLength = Math.max(2, n - 4);
        }
        return this;
    }

    public int getMaxLineLength() {
        return this.maxLineLength;
    }

    public Renderer setHRLineLength(int n) {
        this.hrLineLength = n;
        return this;
    }

    public int getHRLineLength() {
        return this.hrLineLength;
    }

    public Renderer setNewLine(String string) {
        this.newLine = string;
        return this;
    }

    public String getNewLine() {
        if (this.newLine == null) {
            this.newLine = this.rootSegment.source.getBestGuessNewLine();
        }
        return this.newLine;
    }

    public Renderer setIncludeHyperlinkURLs(boolean bl) {
        this.includeHyperlinkURLs = bl;
        return this;
    }

    public boolean getIncludeHyperlinkURLs() {
        return this.includeHyperlinkURLs;
    }

    public String renderHyperlinkURL(StartTag startTag) {
        String string = startTag.getAttributeValue("href");
        if (string == null || string.startsWith("javascript:")) {
            return null;
        }
        try {
            URI uRI = new URI(string);
            if (!uRI.isAbsolute()) {
                return null;
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            return null;
        }
        return '<' + string + '>';
    }

    public Renderer setIncludeAlternateText(boolean bl) {
        this.includeAlternateText = bl;
        return this;
    }

    public boolean getIncludeAlternateText() {
        return this.includeAlternateText;
    }

    public String renderAlternateText(StartTag startTag) {
        if (startTag.getName() == "area") {
            return null;
        }
        String string = startTag.getAttributeValue("alt");
        if (string == null || string.length() == 0) {
            return null;
        }
        return '[' + string + ']';
    }

    public Renderer setDecorateFontStyles(boolean bl) {
        this.decorateFontStyles = bl;
        return this;
    }

    public boolean getDecorateFontStyles() {
        return this.decorateFontStyles;
    }

    public Renderer setConvertNonBreakingSpaces(boolean bl) {
        this.convertNonBreakingSpaces = bl;
        return this;
    }

    public boolean getConvertNonBreakingSpaces() {
        return this.convertNonBreakingSpaces;
    }

    public Renderer setBlockIndentSize(int n) {
        this.blockIndentSize = n;
        return this;
    }

    public int getBlockIndentSize() {
        return this.blockIndentSize;
    }

    public Renderer setListIndentSize(int n) {
        this.listIndentSize = n;
        return this;
    }

    public int getListIndentSize() {
        return this.listIndentSize;
    }

    public Renderer setListBullets(char[] cArray) {
        if (cArray == null || cArray.length == 0) {
            throw new IllegalArgumentException("listBullets argument must be an array of at least one character");
        }
        this.listBullets = cArray;
        return this;
    }

    public char[] getListBullets() {
        return this.listBullets;
    }

    public Renderer setIncludeFirstElementTopMargin(boolean bl) {
        this.includeFirstElementTopMargin = bl;
        return this;
    }

    public boolean getIncludeFirstElementTopMargin() {
        return this.includeFirstElementTopMargin;
    }

    public Renderer setTableCellSeparator(String string) {
        this.tableCellSeparator = string;
        return this;
    }

    public String getTableCellSeparator() {
        return this.tableCellSeparator;
    }

    public static void setDefaultTopMargin(String string, int n) {
        string = HTMLElements.getConstantElementName(string.toLowerCase());
        ELEMENT_HANDLERS.put(string, Renderer.getAbstractBlockElementHandler(string).newTopMargin(n));
    }

    public static int getDefaultTopMargin(String string) {
        return Renderer.getAbstractBlockElementHandler(string.toLowerCase()).getTopMargin();
    }

    public static void setDefaultBottomMargin(String string, int n) {
        string = HTMLElements.getConstantElementName(string.toLowerCase());
        ELEMENT_HANDLERS.put(string, Renderer.getAbstractBlockElementHandler(string).newBottomMargin(n));
    }

    public static int getDefaultBottomMargin(String string) {
        return Renderer.getAbstractBlockElementHandler(string.toLowerCase()).getBottomMargin();
    }

    public static void setDefaultIndent(String string, boolean bl) {
        if ((string = HTMLElements.getConstantElementName(string.toLowerCase())) == "li") {
            throw new UnsupportedOperationException();
        }
        ELEMENT_HANDLERS.put(string, Renderer.getAbstractBlockElementHandler(string).newIndent(bl));
    }

    public static boolean isDefaultIndent(String string) {
        if ((string = HTMLElements.getConstantElementName(string.toLowerCase())) == "li") {
            throw new UnsupportedOperationException();
        }
        return Renderer.getAbstractBlockElementHandler(string.toLowerCase()).isIndent();
    }

    private static AbstractBlockElementHandler getAbstractBlockElementHandler(String string) {
        ElementHandler elementHandler = ELEMENT_HANDLERS.get(string);
        if (elementHandler == null || !(elementHandler instanceof AbstractBlockElementHandler)) {
            throw new UnsupportedOperationException("Cannot set block properties on element " + string);
        }
        return (AbstractBlockElementHandler)elementHandler;
    }

    private static final String getInformalURL(String string) {
        if (string.startsWith("http://")) {
            string = string.substring(7);
        }
        if (string.endsWith("/")) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    static {
        ELEMENT_HANDLERS.put("a", A_ElementHandler.INSTANCE);
        ELEMENT_HANDLERS.put("address", StandardBlockElementHandler.INSTANCE_0_0);
        ELEMENT_HANDLERS.put("applet", AlternateTextElementHandler.INSTANCE);
        ELEMENT_HANDLERS.put("b", FontStyleElementHandler.INSTANCE_B);
        ELEMENT_HANDLERS.put("blockquote", StandardBlockElementHandler.INSTANCE_1_1_INDENT);
        ELEMENT_HANDLERS.put("br", BR_ElementHandler.INSTANCE);
        ELEMENT_HANDLERS.put("button", RemoveElementHandler.INSTANCE);
        ELEMENT_HANDLERS.put("caption", StandardBlockElementHandler.INSTANCE_0_0);
        ELEMENT_HANDLERS.put("center", StandardBlockElementHandler.INSTANCE_1_1);
        ELEMENT_HANDLERS.put("code", FontStyleElementHandler.INSTANCE_CODE);
        ELEMENT_HANDLERS.put("dd", StandardBlockElementHandler.INSTANCE_0_0_INDENT);
        ELEMENT_HANDLERS.put("dir", ListElementHandler.INSTANCE_UL);
        ELEMENT_HANDLERS.put("div", StandardBlockElementHandler.INSTANCE_0_0);
        ELEMENT_HANDLERS.put("dt", StandardBlockElementHandler.INSTANCE_0_0);
        ELEMENT_HANDLERS.put("em", FontStyleElementHandler.INSTANCE_I);
        ELEMENT_HANDLERS.put("fieldset", StandardBlockElementHandler.INSTANCE_1_1);
        ELEMENT_HANDLERS.put("form", StandardBlockElementHandler.INSTANCE_1_1);
        ELEMENT_HANDLERS.put("h1", StandardBlockElementHandler.INSTANCE_2_1);
        ELEMENT_HANDLERS.put("h2", StandardBlockElementHandler.INSTANCE_2_1);
        ELEMENT_HANDLERS.put("h3", StandardBlockElementHandler.INSTANCE_2_1);
        ELEMENT_HANDLERS.put("h4", StandardBlockElementHandler.INSTANCE_2_1);
        ELEMENT_HANDLERS.put("h5", StandardBlockElementHandler.INSTANCE_2_1);
        ELEMENT_HANDLERS.put("h6", StandardBlockElementHandler.INSTANCE_2_1);
        ELEMENT_HANDLERS.put("head", RemoveElementHandler.INSTANCE);
        ELEMENT_HANDLERS.put("hr", HR_ElementHandler.INSTANCE);
        ELEMENT_HANDLERS.put("i", FontStyleElementHandler.INSTANCE_I);
        ELEMENT_HANDLERS.put("img", AlternateTextElementHandler.INSTANCE);
        ELEMENT_HANDLERS.put("input", AlternateTextElementHandler.INSTANCE);
        ELEMENT_HANDLERS.put("legend", StandardBlockElementHandler.INSTANCE_0_0);
        ELEMENT_HANDLERS.put("li", LI_ElementHandler.INSTANCE);
        ELEMENT_HANDLERS.put("menu", ListElementHandler.INSTANCE_UL);
        ELEMENT_HANDLERS.put("map", RemoveElementHandler.INSTANCE);
        ELEMENT_HANDLERS.put("noframes", RemoveElementHandler.INSTANCE);
        ELEMENT_HANDLERS.put("noscript", RemoveElementHandler.INSTANCE);
        ELEMENT_HANDLERS.put("ol", ListElementHandler.INSTANCE_OL);
        ELEMENT_HANDLERS.put("p", StandardBlockElementHandler.INSTANCE_1_1);
        ELEMENT_HANDLERS.put("pre", PRE_ElementHandler.INSTANCE);
        ELEMENT_HANDLERS.put("script", RemoveElementHandler.INSTANCE);
        ELEMENT_HANDLERS.put("select", RemoveElementHandler.INSTANCE);
        ELEMENT_HANDLERS.put("strong", FontStyleElementHandler.INSTANCE_B);
        ELEMENT_HANDLERS.put("style", RemoveElementHandler.INSTANCE);
        ELEMENT_HANDLERS.put("textarea", RemoveElementHandler.INSTANCE);
        ELEMENT_HANDLERS.put("td", TD_ElementHandler.INSTANCE);
        ELEMENT_HANDLERS.put("th", TD_ElementHandler.INSTANCE);
        ELEMENT_HANDLERS.put("tr", StandardBlockElementHandler.INSTANCE_0_0);
        ELEMENT_HANDLERS.put("u", FontStyleElementHandler.INSTANCE_U);
        ELEMENT_HANDLERS.put("ul", ListElementHandler.INSTANCE_UL);
    }

    private static final class TD_ElementHandler
    implements ElementHandler {
        public static final ElementHandler INSTANCE = new TD_ElementHandler();

        private TD_ElementHandler() {
        }

        @Override
        public void process(Processor processor, Element element) throws IOException {
            if (!processor.isBlockBoundary()) {
                processor.append(processor.tableCellSeparator);
            }
            processor.lastCharWhiteSpace = false;
            processor.appendElementContent(element);
        }
    }

    private static final class PRE_ElementHandler
    extends AbstractBlockElementHandler {
        public static final ElementHandler INSTANCE = new PRE_ElementHandler();

        private PRE_ElementHandler() {
            this(1, 1, false);
        }

        private PRE_ElementHandler(int n, int n2, boolean bl) {
            super(n, n2, bl);
        }

        @Override
        protected void processBlockContent(Processor processor, Element element) throws IOException {
            boolean bl = processor.preformatted;
            processor.preformatted = true;
            processor.appendElementContent(element);
            processor.preformatted = bl;
        }

        @Override
        protected AbstractBlockElementHandler newInstance(int n, int n2, boolean bl) {
            return new PRE_ElementHandler(n, n2, bl);
        }
    }

    private static final class LI_ElementHandler
    extends AbstractBlockElementHandler {
        public static final ElementHandler INSTANCE = new LI_ElementHandler();

        private LI_ElementHandler() {
            this(0, 0, false);
        }

        private LI_ElementHandler(int n, int n2, boolean bl) {
            super(n, n2, bl);
        }

        @Override
        protected void processBlockContent(Processor processor, Element element) throws IOException {
            if (processor.listBulletNumber != -1) {
                processor.listBulletNumber++;
            }
            processor.bullet = true;
            processor.appendBlockVerticalMargin();
            processor.appendIndent();
            processor.skipInitialNewLines = true;
            processor.blockBoundary(0);
            processor.appendElementContent(element);
            processor.bullet = false;
        }

        @Override
        protected AbstractBlockElementHandler newInstance(int n, int n2, boolean bl) {
            return new LI_ElementHandler(n, n2, bl);
        }
    }

    private static final class ListElementHandler
    extends AbstractBlockElementHandler {
        public static final ElementHandler INSTANCE_OL = new ListElementHandler(0);
        public static final ElementHandler INSTANCE_UL = new ListElementHandler(-1);
        private final int initialListBulletNumber;

        private ListElementHandler(int n) {
            this(n, 0, 0, false);
        }

        private ListElementHandler(int n, int n2, int n3, boolean bl) {
            super(n2, n3, bl);
            this.initialListBulletNumber = n;
        }

        @Override
        protected void processBlockContent(Processor processor, Element element) throws IOException {
            int n = processor.listBulletNumber;
            processor.listBulletNumber = this.initialListBulletNumber;
            processor.listIndentLevel++;
            processor.appendElementContent(element);
            processor.listIndentLevel--;
            processor.listBulletNumber = n;
        }

        @Override
        protected AbstractBlockElementHandler newInstance(int n, int n2, boolean bl) {
            return new ListElementHandler(this.initialListBulletNumber, n, n2, bl);
        }
    }

    private static final class AlternateTextElementHandler
    implements ElementHandler {
        public static final ElementHandler INSTANCE = new AlternateTextElementHandler();

        private AlternateTextElementHandler() {
        }

        @Override
        public void process(Processor processor, Element element) throws IOException {
            if (!processor.includeAlternateText) {
                return;
            }
            String string = processor.renderer.renderAlternateText(element.getStartTag());
            if (string == null) {
                return;
            }
            processor.appendText(string);
        }
    }

    private static final class HR_ElementHandler
    extends AbstractBlockElementHandler {
        public static final ElementHandler INSTANCE = new HR_ElementHandler();

        private HR_ElementHandler() {
            this(0, 0, false);
        }

        private HR_ElementHandler(int n, int n2, boolean bl) {
            super(n, n2, bl);
        }

        @Override
        protected void processBlockContent(Processor processor, Element element) throws IOException {
            processor.appendBlockVerticalMargin();
            processor.append('-');
            for (int i = processor.col; i < processor.hrLineLength; ++i) {
                processor.appendable.append('-');
            }
            processor.col = processor.hrLineLength;
        }

        @Override
        protected AbstractBlockElementHandler newInstance(int n, int n2, boolean bl) {
            return new HR_ElementHandler(n, n2, bl);
        }
    }

    private static final class BR_ElementHandler
    implements ElementHandler {
        public static final ElementHandler INSTANCE = new BR_ElementHandler();

        private BR_ElementHandler() {
        }

        @Override
        public void process(Processor processor, Element element) throws IOException {
            if (processor.isBlockBoundary() && !processor.atStartOfLine && !processor.skipInitialNewLines) {
                processor.newLine();
            }
            processor.newLine();
            processor.blockBoundary(0);
        }
    }

    private static final class A_ElementHandler
    implements ElementHandler {
        public static final ElementHandler INSTANCE = new A_ElementHandler();

        private A_ElementHandler() {
        }

        @Override
        public void process(Processor processor, Element element) throws IOException {
            if (!processor.includeHyperlinkURLs) {
                processor.appendElementContent(element);
                return;
            }
            String string = processor.renderer.renderHyperlinkURL(element.getStartTag());
            if (string == null) {
                processor.appendElementContent(element);
                return;
            }
            String string2 = element.getAttributeValue("href");
            boolean bl = string2 == null || !Renderer.getInformalURL(string2).equals(Renderer.getInformalURL(element.getContent().toString()));
            int n = string.length();
            if (bl) {
                processor.appendElementContent(element);
                ++n;
            }
            if (processor.maxLineLength > 0 && processor.col + n >= processor.maxLineLength) {
                processor.startNewLine(0);
            } else if (bl) {
                processor.append(' ');
            }
            processor.append(string);
            processor.lastCharWhiteSpace = true;
        }
    }

    private static final class StandardBlockElementHandler
    extends AbstractBlockElementHandler {
        public static final ElementHandler INSTANCE_0_0 = new StandardBlockElementHandler(0, 0, false);
        public static final ElementHandler INSTANCE_1_1 = new StandardBlockElementHandler(1, 1, false);
        public static final ElementHandler INSTANCE_2_1 = new StandardBlockElementHandler(2, 1, false);
        public static final ElementHandler INSTANCE_0_0_INDENT = new StandardBlockElementHandler(0, 0, true);
        public static final ElementHandler INSTANCE_1_1_INDENT = new StandardBlockElementHandler(1, 1, true);

        private StandardBlockElementHandler(int n, int n2, boolean bl) {
            super(n, n2, bl);
        }

        @Override
        protected void processBlockContent(Processor processor, Element element) throws IOException {
            processor.appendElementContent(element);
        }

        @Override
        protected AbstractBlockElementHandler newInstance(int n, int n2, boolean bl) {
            return new StandardBlockElementHandler(n, n2, bl);
        }
    }

    private static abstract class AbstractBlockElementHandler
    implements ElementHandler {
        private final int topMargin;
        private final int bottomMargin;
        private final boolean indent;

        protected AbstractBlockElementHandler(int n, int n2, boolean bl) {
            this.topMargin = n;
            this.bottomMargin = n2;
            this.indent = bl;
        }

        @Override
        public void process(Processor processor, Element element) throws IOException {
            processor.blockBoundary(RendererCSS.getTopMargin(element, this.topMargin));
            int n = RendererCSS.getLeftMargin(element, this.indent ? processor.blockIndentSize : 0);
            processor.indentSize += n;
            this.processBlockContent(processor, element);
            processor.indentSize -= n;
            processor.blockBoundary(RendererCSS.getBottomMargin(element, this.bottomMargin));
        }

        public AbstractBlockElementHandler newTopMargin(int n) {
            return this.newInstance(n, this.bottomMargin, this.indent);
        }

        public int getTopMargin() {
            return this.topMargin;
        }

        public AbstractBlockElementHandler newBottomMargin(int n) {
            return this.newInstance(this.topMargin, n, this.indent);
        }

        public int getBottomMargin() {
            return this.bottomMargin;
        }

        public AbstractBlockElementHandler newIndent(boolean bl) {
            return this.newInstance(this.topMargin, this.bottomMargin, bl);
        }

        public boolean isIndent() {
            return this.indent;
        }

        protected abstract void processBlockContent(Processor var1, Element var2) throws IOException;

        protected abstract AbstractBlockElementHandler newInstance(int var1, int var2, boolean var3);
    }

    private static final class FontStyleElementHandler
    implements ElementHandler {
        public static final ElementHandler INSTANCE_B = new FontStyleElementHandler('*');
        public static final ElementHandler INSTANCE_I = new FontStyleElementHandler('/');
        public static final ElementHandler INSTANCE_U = new FontStyleElementHandler('_');
        public static final ElementHandler INSTANCE_CODE = new FontStyleElementHandler('|');
        private final char decorationChar;

        public FontStyleElementHandler(char c) {
            this.decorationChar = c;
        }

        @Override
        public void process(Processor processor, Element element) throws IOException {
            if (processor.decorateFontStyles) {
                if (processor.isBlockBoundary()) {
                    processor.appendBlockVerticalMargin();
                } else if (processor.lastCharWhiteSpace) {
                    processor.append(' ');
                    processor.lastCharWhiteSpace = false;
                }
                processor.append(this.decorationChar);
                processor.appendElementContent(element);
                if (processor.decorateFontStyles) {
                    processor.append(this.decorationChar);
                }
            } else {
                processor.appendElementContent(element);
            }
        }
    }

    private static final class StandardInlineElementHandler
    implements ElementHandler {
        public static final ElementHandler INSTANCE = new StandardInlineElementHandler();

        private StandardInlineElementHandler() {
        }

        @Override
        public void process(Processor processor, Element element) throws IOException {
            processor.appendElementContent(element);
        }
    }

    private static final class RemoveElementHandler
    implements ElementHandler {
        public static final ElementHandler INSTANCE = new RemoveElementHandler();

        private RemoveElementHandler() {
        }

        @Override
        public void process(Processor processor, Element element) {
        }
    }

    private static interface ElementHandler {
        public void process(Processor var1, Element var2) throws IOException;
    }

    private static final class Processor {
        private final Renderer renderer;
        private final Segment rootSegment;
        private final Source source;
        private final int maxLineLength;
        private final int hrLineLength;
        private final String newLine;
        private final boolean includeHyperlinkURLs;
        private final boolean includeAlternateText;
        private final boolean decorateFontStyles;
        private final boolean convertNonBreakingSpaces;
        private final int blockIndentSize;
        private final int listIndentSize;
        private final char[] listBullets;
        private final String tableCellSeparator;
        private Appendable appendable;
        private int renderedIndex;
        private boolean atStartOfLine;
        private boolean skipInitialNewLines;
        private int col;
        private int listIndentLevel;
        private int indentSize;
        private int blockVerticalMargin;
        private boolean preformatted;
        private boolean lastCharWhiteSpace;
        private final boolean ignoreInitialWhiteSpace = false;
        private boolean bullet;
        private int listBulletNumber;
        private static final int NO_MARGIN = -1;

        public Processor(Renderer renderer, Segment segment, int n, int n2, String string, boolean bl, boolean bl2, boolean bl3, boolean bl4, int n3, int n4, char[] cArray, String string2) {
            this.renderer = renderer;
            this.rootSegment = segment;
            this.source = segment.source;
            this.maxLineLength = n;
            this.hrLineLength = n2;
            this.newLine = string;
            this.includeHyperlinkURLs = bl;
            this.includeAlternateText = bl2;
            this.decorateFontStyles = bl3;
            this.convertNonBreakingSpaces = bl4;
            this.blockIndentSize = n3;
            this.listIndentSize = n4;
            this.listBullets = cArray;
            this.tableCellSeparator = string2;
        }

        public void appendTo(Appendable appendable) throws IOException {
            this.reset();
            this.appendable = appendable;
            List<Element> list = this.rootSegment instanceof Element ? Collections.singletonList((Element)this.rootSegment) : this.rootSegment.getChildElements();
            this.appendSegmentProcessingChildElements(this.rootSegment.begin, this.rootSegment.end, list);
        }

        private void reset() {
            this.renderedIndex = 0;
            this.atStartOfLine = true;
            this.skipInitialNewLines = !this.renderer.includeFirstElementTopMargin;
            this.col = 0;
            this.listIndentLevel = 0;
            this.indentSize = 0;
            this.blockVerticalMargin = -1;
            this.preformatted = false;
            this.lastCharWhiteSpace = false;
            this.bullet = false;
        }

        private void appendElementContent(Element element) throws IOException {
            int n = element.getContentEnd();
            if (element.isEmpty() || this.renderedIndex >= n) {
                return;
            }
            int n2 = element.getStartTag().end;
            this.appendSegmentProcessingChildElements(Math.max(this.renderedIndex, n2), n, element.getChildElements());
        }

        private void appendSegmentProcessingChildElements(int n, int n2, List<Element> list) throws IOException {
            int n3 = n;
            for (Element element : list) {
                if (n3 >= element.end) continue;
                if (n3 < element.begin) {
                    this.appendSegmentRemovingTags(n3, element.begin);
                }
                Processor.getElementHandler(element).process(this, element);
                n3 = Math.max(this.renderedIndex, element.end);
            }
            if (n3 < n2) {
                this.appendSegmentRemovingTags(n3, n2);
            }
        }

        private static ElementHandler getElementHandler(Element element) {
            if (element.getStartTag().getStartTagType().isServerTag()) {
                return RemoveElementHandler.INSTANCE;
            }
            ElementHandler elementHandler = (ElementHandler)ELEMENT_HANDLERS.get(element.getName());
            return elementHandler != null ? elementHandler : StandardInlineElementHandler.INSTANCE;
        }

        private void appendSegmentRemovingTags(int n, int n2) throws IOException {
            Tag tag;
            int n3 = n;
            while ((tag = this.source.getNextTag(n3)) != null && tag.begin < n2) {
                this.appendSegment(n3, tag.begin);
                n3 = tag.end;
            }
            this.appendSegment(n3, n2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void appendSegment(int n, int n2) throws IOException {
            assert (n <= n2);
            if (n < this.renderedIndex) {
                n = this.renderedIndex;
            }
            if (n >= n2) {
                return;
            }
            try {
                if (this.preformatted) {
                    this.appendPreformattedSegment(n, n2);
                } else {
                    this.appendNonPreformattedSegment(n, n2);
                }
            }
            finally {
                if (this.renderedIndex < n2) {
                    this.renderedIndex = n2;
                }
            }
        }

        private void appendPreformattedSegment(int n, int n2) throws IOException {
            assert (n < n2);
            assert (n >= this.renderedIndex);
            if (this.isBlockBoundary()) {
                this.appendBlockVerticalMargin();
            }
            String string = CharacterReference.decode(this.source.subSequence(n, n2), false, this.convertNonBreakingSpaces);
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                if (c == '\n') {
                    this.newLine();
                    continue;
                }
                if (c == '\r') {
                    this.newLine();
                    int n3 = i + 1;
                    if (n3 == string.length()) break;
                    if (string.charAt(n3) != '\n') continue;
                    ++i;
                    continue;
                }
                this.append(c);
            }
        }

        private void appendNonPreformattedSegment(int n, int n2) throws IOException {
            assert (n < n2);
            assert (n >= this.renderedIndex);
            String string = CharacterReference.decodeCollapseWhiteSpace(this.source.subSequence(n, n2), this.convertNonBreakingSpaces);
            if (string.length() == 0) {
                this.lastCharWhiteSpace = true;
                return;
            }
            this.appendNonPreformattedText(string, Segment.isWhiteSpace(this.source.charAt(n)), Segment.isWhiteSpace(this.source.charAt(n2 - 1)));
        }

        private void appendText(String string) throws IOException {
            assert (string.length() > 0);
            this.appendNonPreformattedText(string, Segment.isWhiteSpace(string.charAt(0)), Segment.isWhiteSpace(string.charAt(string.length() - 1)));
        }

        private void appendNonPreformattedText(String string, boolean bl, boolean bl2) throws IOException {
            if (this.isBlockBoundary()) {
                this.appendBlockVerticalMargin();
            } else if (this.lastCharWhiteSpace || bl) {
                this.append(' ');
            }
            int n = 0;
            int n2 = 0;
            this.lastCharWhiteSpace = false;
            while (true) {
                if (n2 < string.length() && (string.charAt(n2) != ' ' || n2 + 1 < string.length() && string.charAt(n2 + 1) == '>' || n2 + 6 < string.length() && string.startsWith("From ", n2 + 1))) {
                    ++n2;
                    continue;
                }
                if (this.maxLineLength > 0 && this.col + n2 - n + 1 >= this.maxLineLength) {
                    if (this.lastCharWhiteSpace && (this.listIndentLevel | this.indentSize) == 0) {
                        this.append(' ');
                    }
                    this.startNewLine(0);
                } else if (this.lastCharWhiteSpace) {
                    this.append(' ');
                }
                this.append(string, n, n2);
                if (n2 == string.length()) break;
                this.lastCharWhiteSpace = true;
                n = ++n2;
            }
            this.lastCharWhiteSpace = bl2;
        }

        private boolean isBlockBoundary() {
            return this.blockVerticalMargin != -1;
        }

        private void appendBlockVerticalMargin() throws IOException {
            assert (this.blockVerticalMargin != -1);
            if (this.skipInitialNewLines) {
                this.skipInitialNewLines = false;
                int n = this.indentSize + this.listIndentLevel * this.listIndentSize;
                if (this.col == n) {
                    this.atStartOfLine = false;
                } else if (this.bullet || this.col > n) {
                    this.startNewLine(0);
                } else {
                    while (n > this.col) {
                        this.appendable.append(' ');
                        ++this.col;
                    }
                    this.atStartOfLine = false;
                }
            } else {
                this.startNewLine(this.blockVerticalMargin);
            }
            this.blockVerticalMargin = -1;
        }

        private void blockBoundary(int n) throws IOException {
            if (this.blockVerticalMargin < n) {
                this.blockVerticalMargin = n;
            }
        }

        private void startNewLine(int n) throws IOException {
            int n2 = n + (this.atStartOfLine ? 0 : 1);
            for (int i = 0; i < n2; ++i) {
                this.appendable.append(this.newLine);
            }
            this.atStartOfLine = true;
            this.col = 0;
        }

        private void newLine() throws IOException {
            this.appendable.append(this.newLine);
            this.atStartOfLine = true;
            this.col = 0;
        }

        private void appendTextInit() throws IOException {
            this.skipInitialNewLines = false;
            if (this.atStartOfLine) {
                this.appendIndent();
            }
        }

        private void appendIndent() throws IOException {
            int n;
            for (n = this.indentSize; n > 0; --n) {
                this.appendable.append(' ');
            }
            if (this.bullet) {
                for (n = (this.listIndentLevel - 1) * this.listIndentSize; n > 0; --n) {
                    this.appendable.append(' ');
                }
                if (this.listBulletNumber == -1) {
                    for (n = this.listIndentSize - 2; n > 0; --n) {
                        this.appendable.append(' ');
                    }
                    this.appendable.append(this.listBullets[(this.listIndentLevel - 1) % this.listBullets.length]).append(' ');
                } else {
                    String string = Integer.toString(this.listBulletNumber);
                    for (int i = this.listIndentSize - string.length() - 2; i > 0; --i) {
                        this.appendable.append(' ');
                    }
                    this.appendable.append(string).append(". ");
                }
                this.bullet = false;
            } else {
                for (n = this.listIndentLevel * this.listIndentSize; n > 0; --n) {
                    this.appendable.append(' ');
                }
            }
            this.col = this.indentSize + this.listIndentLevel * this.listIndentSize;
            this.atStartOfLine = false;
        }

        private Processor append(char c) throws IOException {
            this.appendTextInit();
            this.appendable.append(c);
            ++this.col;
            return this;
        }

        private Processor append(String string) throws IOException {
            this.appendTextInit();
            this.appendable.append(string);
            this.col += string.length();
            return this;
        }

        private void append(CharSequence charSequence, int n, int n2) throws IOException {
            this.appendTextInit();
            for (int i = n; i < n2; ++i) {
                this.appendable.append(charSequence.charAt(i));
            }
            this.col += n2 - n;
        }
    }
}

