/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rtextarea;

import org.fife.ui.rsyntaxtextarea.DocumentRange;

public class SearchResult
implements Comparable<SearchResult> {
    private DocumentRange matchRange;
    private int count;
    private int markedCount;

    public SearchResult() {
        this(null, 0, 0);
    }

    public SearchResult(DocumentRange documentRange, int n, int n2) {
        this.matchRange = documentRange;
        this.count = n;
        this.markedCount = n2;
    }

    @Override
    public int compareTo(SearchResult searchResult) {
        if (searchResult == null) {
            return 1;
        }
        if (searchResult == this) {
            return 0;
        }
        int n = this.count - searchResult.count;
        if (n != 0) {
            return n;
        }
        n = this.markedCount - searchResult.markedCount;
        if (n != 0) {
            return n;
        }
        if (this.matchRange == null) {
            return searchResult.matchRange == null ? 0 : -1;
        }
        return this.matchRange.compareTo(searchResult.matchRange);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof SearchResult) {
            return this.compareTo((SearchResult)object) == 0;
        }
        return false;
    }

    public int getCount() {
        return this.count;
    }

    public int getMarkedCount() {
        return this.markedCount;
    }

    public DocumentRange getMatchRange() {
        return this.matchRange;
    }

    public int hashCode() {
        int n = this.count + this.markedCount;
        if (this.matchRange != null) {
            n += this.matchRange.hashCode();
        }
        return n;
    }

    public void setCount(int n) {
        this.count = n;
    }

    public void setMarkedCount(int n) {
        this.markedCount = n;
    }

    public void setMatchRange(DocumentRange documentRange) {
        this.matchRange = documentRange;
    }

    public String toString() {
        return "[SearchResult: count=" + this.getCount() + ", markedCount=" + this.getMarkedCount() + ", matchRange=" + this.getMatchRange() + "]";
    }

    public boolean wasFound() {
        return this.getCount() > 0;
    }
}

