/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.qdox.tools;

import com.thoughtworks.qdox.JavaDocBuilder;
import com.thoughtworks.qdox.directorywalker.DirectoryScanner;
import com.thoughtworks.qdox.directorywalker.FileVisitor;
import com.thoughtworks.qdox.directorywalker.SuffixFilter;
import com.thoughtworks.qdox.parser.ParseException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class QDoxTester {
    private final Reporter reporter;

    public QDoxTester(Reporter reporter) {
        this.reporter = reporter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkZipOrJarFile(File file) throws IOException {
        ZipFile zipFile = new ZipFile(file);
        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
        while (enumeration.hasMoreElements()) {
            ZipEntry zipEntry = enumeration.nextElement();
            try (InputStream inputStream = zipFile.getInputStream(zipEntry);){
                this.verify(file.getName() + "!" + zipEntry.getName(), inputStream);
            }
        }
    }

    public void checkDirectory(File file) throws IOException {
        DirectoryScanner directoryScanner = new DirectoryScanner(file);
        directoryScanner.addFilter(new SuffixFilter(".java"));
        directoryScanner.scan(new FileVisitor(){

            @Override
            public void visitFile(File file) {
                try {
                    QDoxTester.this.checkJavaFile(file);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkJavaFile(File file) throws IOException {
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            this.verify(file.getName(), fileInputStream);
        }
    }

    private void verify(String string, InputStream inputStream) {
        try {
            JavaDocBuilder javaDocBuilder = new JavaDocBuilder();
            javaDocBuilder.addSource(new BufferedReader(new InputStreamReader(inputStream)));
            this.reporter.success(string);
        }
        catch (ParseException parseException) {
            this.reporter.parseFailure(string, parseException.getLine(), parseException.getColumn(), parseException.getMessage());
        }
        catch (Exception exception) {
            this.reporter.error(string, exception);
        }
    }

    public static void main(String[] stringArray) throws IOException {
        if (stringArray.length == 0) {
            System.err.println("Tool that verifies that QDox can parse some Java source.");
            System.err.println();
            System.err.println("Usage: java " + QDoxTester.class.getName() + " src1 [src2] [src3]...");
            System.err.println();
            System.err.println("Each src can be a single .java file, or a directory/zip/jar containing multiple source files");
            System.exit(-1);
        }
        ConsoleReporter consoleReporter = new ConsoleReporter(System.out);
        QDoxTester qDoxTester = new QDoxTester(consoleReporter);
        for (int i = 0; i < stringArray.length; ++i) {
            File file = new File(stringArray[i]);
            if (file.isDirectory()) {
                qDoxTester.checkDirectory(file);
                continue;
            }
            if (file.getName().endsWith(".java")) {
                qDoxTester.checkJavaFile(file);
                continue;
            }
            if (file.getName().endsWith(".jar") || file.getName().endsWith(".zip")) {
                qDoxTester.checkZipOrJarFile(file);
                continue;
            }
            System.err.println("Unknown input <" + file.getName() + ">. Should be zip, jar, java or directory");
        }
        consoleReporter.writeSummary();
    }

    private static class ConsoleReporter
    implements Reporter {
        private final PrintStream out;
        private int success;
        private int failure;
        private int error;
        private int dotsWrittenThisLine;

        public ConsoleReporter(PrintStream printStream) {
            this.out = printStream;
        }

        @Override
        public void success(String string) {
            ++this.success;
            if (++this.dotsWrittenThisLine > 80) {
                this.newLine();
            }
            this.out.print('.');
        }

        private void newLine() {
            this.dotsWrittenThisLine = 0;
            this.out.println();
            this.out.flush();
        }

        @Override
        public void parseFailure(String string, int n, int n2, String string2) {
            this.newLine();
            this.out.println("* " + string);
            this.out.println("  [" + n + ":" + n2 + "] " + string2);
            ++this.failure;
        }

        @Override
        public void error(String string, Throwable throwable) {
            this.newLine();
            this.out.println("* " + string);
            throwable.printStackTrace(this.out);
            ++this.error;
        }

        public void writeSummary() {
            this.newLine();
            this.out.println("-- Summary --------------");
            this.out.println("Success: " + this.success);
            this.out.println("Failure: " + this.failure);
            this.out.println("Error  : " + this.error);
            this.out.println("Total  : " + (this.success + this.failure + this.error));
            this.out.println("-------------------------");
        }
    }

    public static interface Reporter {
        public void success(String var1);

        public void parseFailure(String var1, int var2, int var3, String var4);

        public void error(String var1, Throwable var2);
    }
}

