/*
 * Decompiled with CFR 0.152.
 */
package org.hamcrest.generator.qdox.model;

import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class ClassLibrary
implements Serializable {
    private final Set classNames = new TreeSet();
    private final Map classNameToClassMap = new HashMap();
    private boolean defaultClassLoadersAdded = false;
    private transient List classLoaders = new ArrayList();
    private List sourceFolders = new ArrayList();

    public ClassLibrary() {
    }

    public ClassLibrary(ClassLoader classLoader) {
        this.classLoaders.add(classLoader);
    }

    public void add(String string) {
        this.classNames.add(string);
    }

    public boolean contains(String string) {
        if (this.classNames.contains(string)) {
            return true;
        }
        if (this.getSourceFile(string) != null) {
            return true;
        }
        return this.getClass(string) != null;
    }

    public File getSourceFile(String string) {
        for (File file : this.sourceFolders) {
            String string2;
            File file2 = new File(file, (string2 = string.split("\\$")[0]).replace('.', File.separatorChar) + ".java");
            if (!file2.exists() || !file2.isFile()) continue;
            return file2;
        }
        return null;
    }

    public Class getClass(String string) {
        Class clazz = (Class)this.classNameToClassMap.get(string);
        if (clazz != null) {
            return clazz;
        }
        for (ClassLoader classLoader : this.classLoaders) {
            if (classLoader == null) continue;
            try {
                Class<?> clazz2 = classLoader.loadClass(string);
                if (clazz2 == null) continue;
                this.classNameToClassMap.put(string, clazz2);
                return clazz2;
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
            }
        }
        return null;
    }

    public Collection all() {
        return Collections.unmodifiableCollection(this.classNames);
    }

    public void addClassLoader(ClassLoader classLoader) {
        this.classLoaders.add(classLoader);
    }

    public void addDefaultLoader() {
        if (!this.defaultClassLoadersAdded) {
            this.classLoaders.add(this.getClass().getClassLoader());
            this.classLoaders.add(Thread.currentThread().getContextClassLoader());
        }
        this.defaultClassLoadersAdded = true;
    }

    public void addSourceFolder(File file) {
        this.sourceFolders.add(file);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.classLoaders = new ArrayList();
        if (this.defaultClassLoadersAdded) {
            this.defaultClassLoadersAdded = false;
            this.addDefaultLoader();
        }
    }
}

