/*
 * Decompiled with CFR 0.152.
 */
package org.hamcrest.generator.qdox.model;

import java.beans.Introspector;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.hamcrest.generator.qdox.model.AbstractInheritableJavaEntity;
import org.hamcrest.generator.qdox.model.DocletTag;
import org.hamcrest.generator.qdox.model.IndentBuffer;
import org.hamcrest.generator.qdox.model.JavaClass;
import org.hamcrest.generator.qdox.model.JavaParameter;
import org.hamcrest.generator.qdox.model.Member;
import org.hamcrest.generator.qdox.model.Type;
import org.hamcrest.generator.qdox.model.TypeVariable;

public class JavaMethod
extends AbstractInheritableJavaEntity
implements Member {
    private TypeVariable[] typeParameters = TypeVariable.EMPTY_ARRAY;
    private Type returns = Type.VOID;
    private List parameters = new LinkedList();
    private JavaParameter[] parametersArray = JavaParameter.EMPTY_ARRAY;
    private Type[] exceptions = Type.EMPTY_ARRAY;
    private boolean constructor;
    private String sourceCode;
    private boolean varArgs;

    public JavaMethod() {
    }

    public JavaMethod(String string) {
        this.setName(string);
    }

    public JavaMethod(Type type, String string) {
        this.setReturns(type);
        this.setName(string);
    }

    public Type getReturns() {
        return this.returns;
    }

    public JavaParameter[] getParameters() {
        if (this.parametersArray == null) {
            this.parametersArray = new JavaParameter[this.parameters.size()];
            this.parameters.toArray(this.parametersArray);
        }
        return this.parametersArray;
    }

    public JavaParameter getParameterByName(String string) {
        JavaParameter[] javaParameterArray = this.getParameters();
        for (int i = 0; i < javaParameterArray.length; ++i) {
            if (!javaParameterArray[i].getName().equals(string)) continue;
            return javaParameterArray[i];
        }
        return null;
    }

    public Type[] getExceptions() {
        return this.exceptions;
    }

    public boolean isConstructor() {
        return this.constructor;
    }

    public boolean isVarArgs() {
        return this.varArgs;
    }

    @Override
    protected void writeBody(IndentBuffer indentBuffer) {
        this.writeBody(indentBuffer, true, true, true);
    }

    protected void writeBody(IndentBuffer indentBuffer, boolean bl, boolean bl2, boolean bl3) {
        int n;
        if (bl) {
            this.writeAccessibilityModifier(indentBuffer);
            this.writeNonAccessibilityModifiers(indentBuffer);
        }
        if (!this.constructor && bl2) {
            indentBuffer.write(this.returns.toString());
            indentBuffer.write(' ');
        }
        indentBuffer.write(this.name);
        indentBuffer.write('(');
        for (n = 0; n < this.getParameters().length; ++n) {
            JavaParameter javaParameter = this.parametersArray[n];
            if (n > 0) {
                indentBuffer.write(", ");
            }
            if (bl2) {
                indentBuffer.write(javaParameter.getType().toString());
                if (javaParameter.isVarArgs()) {
                    indentBuffer.write("...");
                }
                indentBuffer.write(' ');
            }
            indentBuffer.write(javaParameter.getName());
        }
        indentBuffer.write(')');
        if (bl2 && this.exceptions.length > 0) {
            indentBuffer.write(" throws ");
            for (n = 0; n < this.exceptions.length; ++n) {
                if (n > 0) {
                    indentBuffer.write(", ");
                }
                indentBuffer.write(this.exceptions[n].getValue());
            }
        }
        if (bl3) {
            if (this.sourceCode != null && this.sourceCode.length() > 0) {
                indentBuffer.write(" {");
                indentBuffer.newline();
                indentBuffer.write(this.sourceCode);
                indentBuffer.write("}");
                indentBuffer.newline();
            } else {
                indentBuffer.write(';');
                indentBuffer.newline();
            }
        }
    }

    private String getSignature(boolean bl, boolean bl2) {
        IndentBuffer indentBuffer = new IndentBuffer();
        this.writeBody(indentBuffer, bl, bl2, false);
        return indentBuffer.toString();
    }

    @Override
    public String getDeclarationSignature(boolean bl) {
        return this.getSignature(bl, true);
    }

    @Override
    public String getCallSignature() {
        return this.getSignature(false, false);
    }

    public void setReturns(Type type) {
        this.returns = type;
    }

    public void addParameter(JavaParameter javaParameter) {
        javaParameter.setParentMethod(this);
        this.parameters.add(javaParameter);
        this.parametersArray = null;
        this.varArgs = javaParameter.isVarArgs();
    }

    public void setExceptions(Type[] typeArray) {
        this.exceptions = typeArray;
    }

    public void setConstructor(boolean bl) {
        this.constructor = bl;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof JavaMethod)) {
            return false;
        }
        JavaMethod javaMethod = (JavaMethod)object;
        if (javaMethod.isConstructor() != this.isConstructor()) {
            return false;
        }
        if (javaMethod.getName() != null && !javaMethod.getName().equals(this.getName())) {
            return false;
        }
        if (this.getName() != null && !this.getName().equals(javaMethod.getName())) {
            return false;
        }
        if (javaMethod.getReturns() != null && !javaMethod.getReturns().equals(this.getReturns())) {
            return false;
        }
        if (this.getReturns() != null && !this.getReturns().equals(javaMethod.getReturns())) {
            return false;
        }
        JavaParameter[] javaParameterArray = this.getParameters();
        JavaParameter[] javaParameterArray2 = javaMethod.getParameters();
        if (javaParameterArray2.length != javaParameterArray.length) {
            return false;
        }
        for (int i = 0; i < javaParameterArray.length; ++i) {
            if (javaParameterArray2[i].equals(javaParameterArray[i])) continue;
            return false;
        }
        return this.varArgs == javaMethod.varArgs;
    }

    public boolean signatureMatches(String string, Type[] typeArray) {
        return this.signatureMatches(string, typeArray, false);
    }

    public boolean signatureMatches(String string, Type[] typeArray, boolean bl) {
        if (!string.equals(this.name)) {
            return false;
        }
        Type[] typeArray2 = typeArray = typeArray == null ? new Type[]{} : typeArray;
        if (typeArray.length != this.getParameters().length) {
            return false;
        }
        for (int i = 0; i < this.parametersArray.length; ++i) {
            if (this.parametersArray[i].getType().equals(typeArray[i])) continue;
            return false;
        }
        return this.varArgs == bl;
    }

    public int hashCode() {
        int n = this.name.hashCode();
        if (this.returns != null) {
            n *= this.returns.hashCode();
        }
        return n *= this.getParameters().length;
    }

    @Override
    public boolean isPublic() {
        return super.isPublic() || this.getParentClass() != null && this.getParentClass().isInterface();
    }

    public boolean isPropertyAccessor() {
        if (this.isStatic()) {
            return false;
        }
        if (this.getParameters().length != 0) {
            return false;
        }
        if (this.getName().startsWith("is")) {
            return this.getName().length() > 2 && Character.isUpperCase(this.getName().charAt(2));
        }
        if (this.getName().startsWith("get")) {
            return this.getName().length() > 3 && Character.isUpperCase(this.getName().charAt(3));
        }
        return false;
    }

    public boolean isPropertyMutator() {
        if (this.isStatic()) {
            return false;
        }
        if (this.getParameters().length != 1) {
            return false;
        }
        if (this.getName().startsWith("set")) {
            return this.getName().length() > 3 && Character.isUpperCase(this.getName().charAt(3));
        }
        return false;
    }

    public Type getPropertyType() {
        if (this.isPropertyAccessor()) {
            return this.getReturns();
        }
        if (this.isPropertyMutator()) {
            return this.getParameters()[0].getType();
        }
        return null;
    }

    public String getPropertyName() {
        int n = -1;
        if (this.getName().startsWith("get") || this.getName().startsWith("set")) {
            n = 3;
        } else if (this.getName().startsWith("is")) {
            n = 2;
        } else {
            return null;
        }
        return Introspector.decapitalize(this.getName().substring(n));
    }

    @Override
    public DocletTag[] getTagsByName(String string, boolean bl) {
        JavaClass javaClass = this.getParentClass();
        JavaParameter[] javaParameterArray = this.getParameters();
        Type[] typeArray = new Type[javaParameterArray.length];
        for (int i = 0; i < typeArray.length; ++i) {
            typeArray[i] = javaParameterArray[i].getType();
        }
        JavaMethod[] javaMethodArray = javaClass.getMethodsBySignature(this.getName(), typeArray, true);
        ArrayList<DocletTag> arrayList = new ArrayList<DocletTag>();
        for (int i = 0; i < javaMethodArray.length; ++i) {
            JavaMethod javaMethod = javaMethodArray[i];
            DocletTag[] docletTagArray = javaMethod.getTagsByName(string);
            for (int j = 0; j < docletTagArray.length; ++j) {
                DocletTag docletTag = docletTagArray[j];
                if (arrayList.contains(docletTag)) continue;
                arrayList.add(docletTag);
            }
        }
        return arrayList.toArray(new DocletTag[arrayList.size()]);
    }

    public int compareTo(Object object) {
        return this.getDeclarationSignature(false).compareTo(((JavaMethod)object).getDeclarationSignature(false));
    }

    public String getSourceCode() {
        return this.sourceCode;
    }

    public void setSourceCode(String string) {
        this.sourceCode = string;
    }

    public void setTypeParameters(TypeVariable[] typeVariableArray) {
        this.typeParameters = typeVariableArray;
    }

    public TypeVariable[] getTypeParameters() {
        return this.typeParameters;
    }

    public String toString() {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        if (this.isPrivate()) {
            stringBuffer.append("private ");
        } else if (this.isProtected()) {
            stringBuffer.append("protected ");
        } else if (this.isPublic()) {
            stringBuffer.append("public ");
        }
        if (this.isAbstract()) {
            stringBuffer.append("abstract ");
        }
        if (this.isStatic()) {
            stringBuffer.append("static ");
        }
        if (this.isFinal()) {
            stringBuffer.append("final ");
        }
        if (this.isSynchronized()) {
            stringBuffer.append("synchronized ");
        }
        if (this.isNative()) {
            stringBuffer.append("native ");
        }
        if (!this.constructor) {
            stringBuffer.append(this.getReturns().getValue() + " ");
        }
        if (this.getParentClass() != null) {
            stringBuffer.append(this.getParentClass().getFullyQualifiedName());
            if (!this.constructor) {
                stringBuffer.append(".");
            }
        }
        if (!this.constructor) {
            stringBuffer.append(this.getName());
        }
        stringBuffer.append("(");
        for (n = 0; n < this.getParameters().length; ++n) {
            if (n > 0) {
                stringBuffer.append(",");
            }
            String string = this.getParameters()[n].getType().getResolvedValue(this.getTypeParameters());
            stringBuffer.append(string);
        }
        stringBuffer.append(")");
        for (n = 0; n < this.exceptions.length; ++n) {
            stringBuffer.append(n == 0 ? " throws " : ",");
            stringBuffer.append(this.exceptions[n].getValue());
        }
        return stringBuffer.toString();
    }

    public Type getGenericReturnType() {
        return this.returns;
    }

    public Type getReturnType() {
        return this.getReturnType(false);
    }

    public Type getReturnType(boolean bl) {
        return this.getReturnType(bl, this.getParentClass());
    }

    protected Type getReturnType(boolean bl, JavaClass javaClass) {
        Type type = null;
        if (this.getReturns() != null) {
            type = this.getReturns().resolve(this.getParentClass(), javaClass);
            if (!bl && !this.returns.getFullyQualifiedName().equals(type.getFullyQualifiedName())) {
                type = new Type("java.lang.Object");
            }
        }
        return type;
    }

    public Type[] getParameterTypes() {
        return this.getParameterTypes(false);
    }

    public Type[] getParameterTypes(boolean bl) {
        return this.getParameterTypes(bl, this.getParentClass());
    }

    protected Type[] getParameterTypes(boolean bl, JavaClass javaClass) {
        Type[] typeArray = new Type[this.getParameters().length];
        for (int i = 0; i < this.getParameters().length; ++i) {
            Type type = this.getParameters()[i].getType().resolve(this.getParentClass(), javaClass);
            typeArray[i] = !bl && this.returns != null && !this.returns.getFullyQualifiedName().equals(type.getFullyQualifiedName()) ? new Type("java.lang.Object") : type;
        }
        return typeArray;
    }
}

