/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.httpclient;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.util.Collection;
import org.apache.commons.httpclient.AutoCloseInputStream;
import org.apache.commons.httpclient.ChunkedInputStream;
import org.apache.commons.httpclient.ContentLengthInputStream;
import org.apache.commons.httpclient.Cookie;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HeaderElement;
import org.apache.commons.httpclient.HeaderGroup;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpConnection;
import org.apache.commons.httpclient.HttpContentTooLargeException;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpHost;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpParser;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.HttpVersion;
import org.apache.commons.httpclient.MethodRetryHandler;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.NoHttpResponseException;
import org.apache.commons.httpclient.ProtocolException;
import org.apache.commons.httpclient.ResponseConsumedWatcher;
import org.apache.commons.httpclient.StatusLine;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.Wire;
import org.apache.commons.httpclient.WireLogInputStream;
import org.apache.commons.httpclient.auth.AuthState;
import org.apache.commons.httpclient.cookie.CookiePolicy;
import org.apache.commons.httpclient.cookie.CookieSpec;
import org.apache.commons.httpclient.cookie.CookieVersionSupport;
import org.apache.commons.httpclient.cookie.MalformedCookieException;
import org.apache.commons.httpclient.params.HttpMethodParams;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.util.EncodingUtil;
import org.apache.commons.httpclient.util.ExceptionUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class HttpMethodBase
implements HttpMethod {
    private static final Log LOG = LogFactory.getLog(HttpMethodBase.class);
    private HeaderGroup requestHeaders = new HeaderGroup();
    protected StatusLine statusLine = null;
    private HeaderGroup responseHeaders = new HeaderGroup();
    private HeaderGroup responseTrailerHeaders = new HeaderGroup();
    private String path = null;
    private String queryString = null;
    private InputStream responseStream = null;
    private HttpConnection responseConnection = null;
    private byte[] responseBody = null;
    private boolean followRedirects = false;
    private boolean doAuthentication = true;
    private HttpMethodParams params = new HttpMethodParams();
    private AuthState hostAuthState = new AuthState();
    private AuthState proxyAuthState = new AuthState();
    private boolean used = false;
    private int recoverableExceptionCount = 0;
    private HttpHost httphost = null;
    private MethodRetryHandler methodRetryHandler;
    private boolean connectionCloseForced = false;
    private static final int RESPONSE_WAIT_TIME_MS = 3000;
    protected HttpVersion effectiveVersion = null;
    private volatile boolean aborted = false;
    private boolean requestSent = false;
    private CookieSpec cookiespec = null;
    private static final int DEFAULT_INITIAL_BUFFER_SIZE = 4096;

    public HttpMethodBase() {
    }

    public HttpMethodBase(String string) throws IllegalArgumentException, IllegalStateException {
        try {
            if (string == null || string.equals("")) {
                string = "/";
            }
            String string2 = this.getParams().getUriCharset();
            this.setURI(new URI(string, true, string2));
        }
        catch (URIException uRIException) {
            throw new IllegalArgumentException("Invalid uri '" + string + "': " + uRIException.getMessage());
        }
    }

    @Override
    public abstract String getName();

    @Override
    public URI getURI() throws URIException {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.httphost != null) {
            stringBuffer.append(this.httphost.getProtocol().getScheme());
            stringBuffer.append("://");
            stringBuffer.append(this.httphost.getHostName());
            int n = this.httphost.getPort();
            if (n != -1 && n != this.httphost.getProtocol().getDefaultPort()) {
                stringBuffer.append(":");
                stringBuffer.append(n);
            }
        }
        stringBuffer.append(this.path);
        if (this.queryString != null) {
            stringBuffer.append('?');
            stringBuffer.append(this.queryString);
        }
        String string = this.getParams().getUriCharset();
        return new URI(stringBuffer.toString(), true, string);
    }

    @Override
    public void setURI(URI uRI) throws URIException {
        if (uRI.isAbsoluteURI()) {
            this.httphost = new HttpHost(uRI);
        }
        this.setPath(uRI.getPath() == null ? "/" : uRI.getEscapedPath());
        this.setQueryString(uRI.getEscapedQuery());
    }

    @Override
    public void setFollowRedirects(boolean bl) {
        this.followRedirects = bl;
    }

    @Override
    public boolean getFollowRedirects() {
        return this.followRedirects;
    }

    public void setHttp11(boolean bl) {
        if (bl) {
            this.params.setVersion(HttpVersion.HTTP_1_1);
        } else {
            this.params.setVersion(HttpVersion.HTTP_1_0);
        }
    }

    @Override
    public boolean getDoAuthentication() {
        return this.doAuthentication;
    }

    @Override
    public void setDoAuthentication(boolean bl) {
        this.doAuthentication = bl;
    }

    public boolean isHttp11() {
        return this.params.getVersion().equals(HttpVersion.HTTP_1_1);
    }

    @Override
    public void setPath(String string) {
        this.path = string;
    }

    @Override
    public void addRequestHeader(Header header) {
        LOG.trace((Object)"HttpMethodBase.addRequestHeader(Header)");
        if (header == null) {
            LOG.debug((Object)"null header value ignored");
        } else {
            this.getRequestHeaderGroup().addHeader(header);
        }
    }

    @Override
    public void addResponseFooter(Header header) {
        this.getResponseTrailerHeaderGroup().addHeader(header);
    }

    @Override
    public String getPath() {
        return this.path == null || this.path.equals("") ? "/" : this.path;
    }

    @Override
    public void setQueryString(String string) {
        this.queryString = string;
    }

    @Override
    public void setQueryString(NameValuePair[] nameValuePairArray) {
        LOG.trace((Object)"enter HttpMethodBase.setQueryString(NameValuePair[])");
        this.queryString = EncodingUtil.formUrlEncode(nameValuePairArray, "UTF-8");
    }

    @Override
    public String getQueryString() {
        return this.queryString;
    }

    @Override
    public void setRequestHeader(String string, String string2) {
        Header header = new Header(string, string2);
        this.setRequestHeader(header);
    }

    @Override
    public void setRequestHeader(Header header) {
        Header[] headerArray = this.getRequestHeaderGroup().getHeaders(header.getName());
        for (int i = 0; i < headerArray.length; ++i) {
            this.getRequestHeaderGroup().removeHeader(headerArray[i]);
        }
        this.getRequestHeaderGroup().addHeader(header);
    }

    @Override
    public Header getRequestHeader(String string) {
        if (string == null) {
            return null;
        }
        return this.getRequestHeaderGroup().getCondensedHeader(string);
    }

    @Override
    public Header[] getRequestHeaders() {
        return this.getRequestHeaderGroup().getAllHeaders();
    }

    @Override
    public Header[] getRequestHeaders(String string) {
        return this.getRequestHeaderGroup().getHeaders(string);
    }

    protected HeaderGroup getRequestHeaderGroup() {
        return this.requestHeaders;
    }

    protected HeaderGroup getResponseTrailerHeaderGroup() {
        return this.responseTrailerHeaders;
    }

    protected HeaderGroup getResponseHeaderGroup() {
        return this.responseHeaders;
    }

    @Override
    public Header[] getResponseHeaders(String string) {
        return this.getResponseHeaderGroup().getHeaders(string);
    }

    @Override
    public int getStatusCode() {
        return this.statusLine.getStatusCode();
    }

    @Override
    public StatusLine getStatusLine() {
        return this.statusLine;
    }

    private boolean responseAvailable() {
        return this.responseBody != null || this.responseStream != null;
    }

    @Override
    public Header[] getResponseHeaders() {
        return this.getResponseHeaderGroup().getAllHeaders();
    }

    @Override
    public Header getResponseHeader(String string) {
        if (string == null) {
            return null;
        }
        return this.getResponseHeaderGroup().getCondensedHeader(string);
    }

    public long getResponseContentLength() {
        Header[] headerArray = this.getResponseHeaderGroup().getHeaders("Content-Length");
        if (headerArray.length == 0) {
            return -1L;
        }
        if (headerArray.length > 1) {
            LOG.warn((Object)"Multiple content-length headers detected");
        }
        for (int i = headerArray.length - 1; i >= 0; --i) {
            Header header = headerArray[i];
            try {
                return Long.parseLong(header.getValue());
            }
            catch (NumberFormatException numberFormatException) {
                if (!LOG.isWarnEnabled()) continue;
                LOG.warn((Object)("Invalid content-length value: " + numberFormatException.getMessage()));
                continue;
            }
        }
        return -1L;
    }

    @Override
    public byte[] getResponseBody() throws IOException {
        InputStream inputStream;
        if (this.responseBody == null && (inputStream = this.getResponseBodyAsStream()) != null) {
            int n;
            long l = this.getResponseContentLength();
            if (l > Integer.MAX_VALUE) {
                throw new IOException("Content too large to be buffered: " + l + " bytes");
            }
            int n2 = this.getParams().getIntParameter("http.method.response.buffer.warnlimit", 0x100000);
            if (l == -1L || l > (long)n2) {
                LOG.warn((Object)"Going to buffer response body of large or unknown size. Using getResponseBodyAsStream instead is recommended.");
            }
            LOG.debug((Object)"Buffering response body");
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(l > 0L ? (int)l : 4096);
            byte[] byArray = new byte[4096];
            while ((n = inputStream.read(byArray)) > 0) {
                byteArrayOutputStream.write(byArray, 0, n);
            }
            byteArrayOutputStream.close();
            this.setResponseStream(null);
            this.responseBody = byteArrayOutputStream.toByteArray();
        }
        return this.responseBody;
    }

    public byte[] getResponseBody(int n) throws IOException {
        InputStream inputStream;
        if (n < 0) {
            throw new IllegalArgumentException("maxlen must be positive");
        }
        if (this.responseBody == null && (inputStream = this.getResponseBodyAsStream()) != null) {
            int n2;
            long l = this.getResponseContentLength();
            if (l != -1L && l > (long)n) {
                throw new HttpContentTooLargeException("Content-Length is " + l, n);
            }
            LOG.debug((Object)"Buffering response body");
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(l > 0L ? (int)l : 4096);
            byte[] byArray = new byte[2048];
            int n3 = 0;
            while ((n2 = inputStream.read(byArray, 0, Math.min(byArray.length, n - n3))) != -1) {
                byteArrayOutputStream.write(byArray, 0, n2);
                if ((n3 += n2) < n) continue;
            }
            this.setResponseStream(null);
            if (n3 == n && inputStream.read() != -1) {
                throw new HttpContentTooLargeException("Content-Length not known but larger than " + n, n);
            }
            this.responseBody = byteArrayOutputStream.toByteArray();
        }
        return this.responseBody;
    }

    @Override
    public InputStream getResponseBodyAsStream() throws IOException {
        if (this.responseStream != null) {
            return this.responseStream;
        }
        if (this.responseBody != null) {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.responseBody);
            LOG.debug((Object)"re-creating response stream from byte array");
            return byteArrayInputStream;
        }
        return null;
    }

    @Override
    public String getResponseBodyAsString() throws IOException {
        byte[] byArray = null;
        if (this.responseAvailable()) {
            byArray = this.getResponseBody();
        }
        if (byArray != null) {
            return EncodingUtil.getString(byArray, this.getResponseCharSet());
        }
        return null;
    }

    public String getResponseBodyAsString(int n) throws IOException {
        if (n < 0) {
            throw new IllegalArgumentException("maxlen must be positive");
        }
        byte[] byArray = null;
        if (this.responseAvailable()) {
            byArray = this.getResponseBody(n);
        }
        if (byArray != null) {
            return EncodingUtil.getString(byArray, this.getResponseCharSet());
        }
        return null;
    }

    @Override
    public Header[] getResponseFooters() {
        return this.getResponseTrailerHeaderGroup().getAllHeaders();
    }

    @Override
    public Header getResponseFooter(String string) {
        if (string == null) {
            return null;
        }
        return this.getResponseTrailerHeaderGroup().getCondensedHeader(string);
    }

    protected void setResponseStream(InputStream inputStream) {
        this.responseStream = inputStream;
    }

    protected InputStream getResponseStream() {
        return this.responseStream;
    }

    @Override
    public String getStatusText() {
        return this.statusLine.getReasonPhrase();
    }

    @Override
    public void setStrictMode(boolean bl) {
        if (bl) {
            this.params.makeStrict();
        } else {
            this.params.makeLenient();
        }
    }

    @Override
    public boolean isStrictMode() {
        return false;
    }

    @Override
    public void addRequestHeader(String string, String string2) {
        this.addRequestHeader(new Header(string, string2));
    }

    protected boolean isConnectionCloseForced() {
        return this.connectionCloseForced;
    }

    protected void setConnectionCloseForced(boolean bl) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Force-close connection: " + bl));
        }
        this.connectionCloseForced = bl;
    }

    protected boolean shouldCloseConnection(HttpConnection httpConnection) {
        if (this.isConnectionCloseForced()) {
            LOG.debug((Object)"Should force-close connection.");
            return true;
        }
        Header header = null;
        if (!httpConnection.isTransparent()) {
            header = this.responseHeaders.getFirstHeader("proxy-connection");
        }
        if (header == null) {
            header = this.responseHeaders.getFirstHeader("connection");
        }
        if (header == null) {
            header = this.requestHeaders.getFirstHeader("connection");
        }
        if (header != null) {
            if (header.getValue().equalsIgnoreCase("close")) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Should close connection in response to directive: " + header.getValue()));
                }
                return true;
            }
            if (header.getValue().equalsIgnoreCase("keep-alive")) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Should NOT close connection in response to directive: " + header.getValue()));
                }
                return false;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Unknown directive: " + header.toExternalForm()));
            }
        }
        LOG.debug((Object)"Resorting to protocol version default close connection policy");
        if (this.effectiveVersion.greaterEquals(HttpVersion.HTTP_1_1)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Should NOT close connection, using " + this.effectiveVersion.toString()));
            }
        } else if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Should close connection, using " + this.effectiveVersion.toString()));
        }
        return this.effectiveVersion.lessEquals(HttpVersion.HTTP_1_0);
    }

    private void checkExecuteConditions(HttpState httpState, HttpConnection httpConnection) throws HttpException {
        if (httpState == null) {
            throw new IllegalArgumentException("HttpState parameter may not be null");
        }
        if (httpConnection == null) {
            throw new IllegalArgumentException("HttpConnection parameter may not be null");
        }
        if (this.aborted) {
            throw new IllegalStateException("Method has been aborted");
        }
        if (!this.validate()) {
            throw new ProtocolException("HttpMethodBase object not valid");
        }
    }

    @Override
    public int execute(HttpState httpState, HttpConnection httpConnection) throws HttpException, IOException {
        LOG.trace((Object)"enter HttpMethodBase.execute(HttpState, HttpConnection)");
        this.responseConnection = httpConnection;
        this.checkExecuteConditions(httpState, httpConnection);
        this.statusLine = null;
        this.connectionCloseForced = false;
        httpConnection.setLastResponseInputStream(null);
        if (this.effectiveVersion == null) {
            this.effectiveVersion = this.params.getVersion();
        }
        this.writeRequest(httpState, httpConnection);
        this.requestSent = true;
        this.readResponse(httpState, httpConnection);
        this.used = true;
        return this.statusLine.getStatusCode();
    }

    @Override
    public void abort() {
        if (this.aborted) {
            return;
        }
        this.aborted = true;
        HttpConnection httpConnection = this.responseConnection;
        if (httpConnection != null) {
            httpConnection.close();
        }
    }

    @Override
    public boolean hasBeenUsed() {
        return this.used;
    }

    @Override
    public void recycle() {
        LOG.trace((Object)"enter HttpMethodBase.recycle()");
        this.releaseConnection();
        this.path = null;
        this.followRedirects = false;
        this.doAuthentication = true;
        this.queryString = null;
        this.getRequestHeaderGroup().clear();
        this.getResponseHeaderGroup().clear();
        this.getResponseTrailerHeaderGroup().clear();
        this.statusLine = null;
        this.effectiveVersion = null;
        this.aborted = false;
        this.used = false;
        this.params = new HttpMethodParams();
        this.responseBody = null;
        this.recoverableExceptionCount = 0;
        this.connectionCloseForced = false;
        this.hostAuthState.invalidate();
        this.proxyAuthState.invalidate();
        this.cookiespec = null;
        this.requestSent = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void releaseConnection() {
        try {
            if (this.responseStream != null) {
                try {
                    this.responseStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        finally {
            this.ensureConnectionRelease();
        }
    }

    @Override
    public void removeRequestHeader(String string) {
        Header[] headerArray = this.getRequestHeaderGroup().getHeaders(string);
        for (int i = 0; i < headerArray.length; ++i) {
            this.getRequestHeaderGroup().removeHeader(headerArray[i]);
        }
    }

    @Override
    public void removeRequestHeader(Header header) {
        if (header == null) {
            return;
        }
        this.getRequestHeaderGroup().removeHeader(header);
    }

    @Override
    public boolean validate() {
        return true;
    }

    private CookieSpec getCookieSpec(HttpState httpState) {
        if (this.cookiespec == null) {
            int n = httpState.getCookiePolicy();
            this.cookiespec = n == -1 ? CookiePolicy.getCookieSpec(this.params.getCookiePolicy()) : CookiePolicy.getSpecByPolicy(n);
            this.cookiespec.setValidDateFormats((Collection)this.params.getParameter("http.dateparser.patterns"));
        }
        return this.cookiespec;
    }

    protected void addCookieRequestHeader(HttpState httpState, HttpConnection httpConnection) throws IOException, HttpException {
        Cookie[] cookieArray;
        Object object;
        LOG.trace((Object)"enter HttpMethodBase.addCookieRequestHeader(HttpState, HttpConnection)");
        Header[] headerArray = this.getRequestHeaderGroup().getHeaders("Cookie");
        for (int i = 0; i < headerArray.length; ++i) {
            object = headerArray[i];
            if (!((Header)object).isAutogenerated()) continue;
            this.getRequestHeaderGroup().removeHeader((Header)object);
        }
        CookieSpec cookieSpec = this.getCookieSpec(httpState);
        object = this.params.getVirtualHost();
        if (object == null) {
            object = httpConnection.getHost();
        }
        if ((cookieArray = cookieSpec.match((String)object, httpConnection.getPort(), this.getPath(), httpConnection.isSecure(), httpState.getCookies())) != null && cookieArray.length > 0) {
            Object object2;
            if (this.getParams().isParameterTrue("http.protocol.single-cookie-header")) {
                object2 = cookieSpec.formatCookies(cookieArray);
                this.getRequestHeaderGroup().addHeader(new Header("Cookie", (String)object2, true));
            } else {
                for (int i = 0; i < cookieArray.length; ++i) {
                    String string = cookieSpec.formatCookie(cookieArray[i]);
                    this.getRequestHeaderGroup().addHeader(new Header("Cookie", string, true));
                }
            }
            if (cookieSpec instanceof CookieVersionSupport) {
                object2 = (CookieVersionSupport)((Object)cookieSpec);
                int n = object2.getVersion();
                boolean bl = false;
                for (int i = 0; i < cookieArray.length; ++i) {
                    if (n == cookieArray[i].getVersion()) continue;
                    bl = true;
                }
                if (bl) {
                    this.getRequestHeaderGroup().addHeader(object2.getVersionHeader());
                }
            }
        }
    }

    protected void addHostRequestHeader(HttpState httpState, HttpConnection httpConnection) throws IOException, HttpException {
        LOG.trace((Object)"enter HttpMethodBase.addHostRequestHeader(HttpState, HttpConnection)");
        String string = this.params.getVirtualHost();
        if (string != null) {
            LOG.debug((Object)("Using virtual host name: " + string));
        } else {
            string = httpConnection.getHost();
        }
        int n = httpConnection.getPort();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Adding Host request header");
        }
        if (httpConnection.getProtocol().getDefaultPort() != n) {
            string = string + ":" + n;
        }
        this.setRequestHeader("Host", string);
    }

    protected void addProxyConnectionHeader(HttpState httpState, HttpConnection httpConnection) throws IOException, HttpException {
        LOG.trace((Object)"enter HttpMethodBase.addProxyConnectionHeader(HttpState, HttpConnection)");
        if (!httpConnection.isTransparent() && this.getRequestHeader("Proxy-Connection") == null) {
            this.addRequestHeader("Proxy-Connection", "Keep-Alive");
        }
    }

    protected void addRequestHeaders(HttpState httpState, HttpConnection httpConnection) throws IOException, HttpException {
        LOG.trace((Object)"enter HttpMethodBase.addRequestHeaders(HttpState, HttpConnection)");
        this.addUserAgentRequestHeader(httpState, httpConnection);
        this.addHostRequestHeader(httpState, httpConnection);
        this.addCookieRequestHeader(httpState, httpConnection);
        this.addProxyConnectionHeader(httpState, httpConnection);
    }

    protected void addUserAgentRequestHeader(HttpState httpState, HttpConnection httpConnection) throws IOException, HttpException {
        LOG.trace((Object)"enter HttpMethodBase.addUserAgentRequestHeaders(HttpState, HttpConnection)");
        if (this.getRequestHeader("User-Agent") == null) {
            String string = (String)this.getParams().getParameter("http.useragent");
            if (string == null) {
                string = "Jakarta Commons-HttpClient";
            }
            this.setRequestHeader("User-Agent", string);
        }
    }

    protected void checkNotUsed() throws IllegalStateException {
        if (this.used) {
            throw new IllegalStateException("Already used.");
        }
    }

    protected void checkUsed() throws IllegalStateException {
        if (!this.used) {
            throw new IllegalStateException("Not Used.");
        }
    }

    protected static String generateRequestLine(HttpConnection httpConnection, String string, String string2, String string3, String string4) {
        LOG.trace((Object)"enter HttpMethodBase.generateRequestLine(HttpConnection, String, String, String, String)");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string);
        stringBuffer.append(" ");
        if (!httpConnection.isTransparent()) {
            Protocol protocol = httpConnection.getProtocol();
            stringBuffer.append(protocol.getScheme().toLowerCase());
            stringBuffer.append("://");
            stringBuffer.append(httpConnection.getHost());
            if (httpConnection.getPort() != -1 && httpConnection.getPort() != protocol.getDefaultPort()) {
                stringBuffer.append(":");
                stringBuffer.append(httpConnection.getPort());
            }
        }
        if (string2 == null) {
            stringBuffer.append("/");
        } else {
            if (!httpConnection.isTransparent() && !string2.startsWith("/")) {
                stringBuffer.append("/");
            }
            stringBuffer.append(string2);
        }
        if (string3 != null) {
            if (string3.indexOf("?") != 0) {
                stringBuffer.append("?");
            }
            stringBuffer.append(string3);
        }
        stringBuffer.append(" ");
        stringBuffer.append(string4);
        stringBuffer.append("\r\n");
        return stringBuffer.toString();
    }

    protected void processResponseBody(HttpState httpState, HttpConnection httpConnection) {
    }

    protected void processResponseHeaders(HttpState httpState, HttpConnection httpConnection) {
        CookieVersionSupport cookieVersionSupport;
        LOG.trace((Object)"enter HttpMethodBase.processResponseHeaders(HttpState, HttpConnection)");
        CookieSpec cookieSpec = this.getCookieSpec(httpState);
        Header[] headerArray = this.getResponseHeaderGroup().getHeaders("set-cookie");
        this.processCookieHeaders(cookieSpec, headerArray, httpState, httpConnection);
        if (cookieSpec instanceof CookieVersionSupport && (cookieVersionSupport = (CookieVersionSupport)((Object)cookieSpec)).getVersion() > 0) {
            headerArray = this.getResponseHeaderGroup().getHeaders("set-cookie2");
            this.processCookieHeaders(cookieSpec, headerArray, httpState, httpConnection);
        }
    }

    protected void processCookieHeaders(CookieSpec cookieSpec, Header[] headerArray, HttpState httpState, HttpConnection httpConnection) {
        LOG.trace((Object)"enter HttpMethodBase.processCookieHeaders(Header[], HttpState, HttpConnection)");
        String string = this.params.getVirtualHost();
        if (string == null) {
            string = httpConnection.getHost();
        }
        for (int i = 0; i < headerArray.length; ++i) {
            Cookie[] cookieArray;
            block7: {
                Header header = headerArray[i];
                cookieArray = null;
                try {
                    cookieArray = cookieSpec.parse(string, httpConnection.getPort(), this.getPath(), httpConnection.isSecure(), header);
                }
                catch (MalformedCookieException malformedCookieException) {
                    if (!LOG.isWarnEnabled()) break block7;
                    LOG.warn((Object)("Invalid cookie header: \"" + header.getValue() + "\". " + malformedCookieException.getMessage()));
                }
            }
            if (cookieArray == null) continue;
            for (int j = 0; j < cookieArray.length; ++j) {
                Cookie cookie = cookieArray[j];
                try {
                    cookieSpec.validate(string, httpConnection.getPort(), this.getPath(), httpConnection.isSecure(), cookie);
                    httpState.addCookie(cookie);
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug((Object)("Cookie accepted: \"" + cookieSpec.formatCookie(cookie) + "\""));
                    continue;
                }
                catch (MalformedCookieException malformedCookieException) {
                    if (!LOG.isWarnEnabled()) continue;
                    LOG.warn((Object)("Cookie rejected: \"" + cookieSpec.formatCookie(cookie) + "\". " + malformedCookieException.getMessage()));
                }
            }
        }
    }

    protected void processStatusLine(HttpState httpState, HttpConnection httpConnection) {
    }

    protected void readResponse(HttpState httpState, HttpConnection httpConnection) throws IOException, HttpException {
        LOG.trace((Object)"enter HttpMethodBase.readResponse(HttpState, HttpConnection)");
        while (this.statusLine == null) {
            this.readStatusLine(httpState, httpConnection);
            this.processStatusLine(httpState, httpConnection);
            this.readResponseHeaders(httpState, httpConnection);
            this.processResponseHeaders(httpState, httpConnection);
            int n = this.statusLine.getStatusCode();
            if (n < 100 || n >= 200) continue;
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("Discarding unexpected response: " + this.statusLine.toString()));
            }
            this.statusLine = null;
        }
        this.readResponseBody(httpState, httpConnection);
        this.processResponseBody(httpState, httpConnection);
    }

    protected void readResponseBody(HttpState httpState, HttpConnection httpConnection) throws IOException, HttpException {
        LOG.trace((Object)"enter HttpMethodBase.readResponseBody(HttpState, HttpConnection)");
        InputStream inputStream = this.readResponseBody(httpConnection);
        if (inputStream == null) {
            this.responseBodyConsumed();
        } else {
            httpConnection.setLastResponseInputStream(inputStream);
            this.setResponseStream(inputStream);
        }
    }

    private InputStream readResponseBody(HttpConnection httpConnection) throws HttpException, IOException {
        LOG.trace((Object)"enter HttpMethodBase.readResponseBody(HttpConnection)");
        this.responseBody = null;
        InputStream inputStream = httpConnection.getResponseInputStream();
        if (Wire.CONTENT_WIRE.enabled()) {
            inputStream = new WireLogInputStream(inputStream, Wire.CONTENT_WIRE);
        }
        boolean bl = HttpMethodBase.canResponseHaveBody(this.statusLine.getStatusCode());
        InputStream inputStream2 = null;
        Header header = this.responseHeaders.getFirstHeader("Transfer-Encoding");
        if (header != null) {
            HeaderElement[] headerElementArray;
            int n;
            String string = header.getValue();
            if (!"chunked".equalsIgnoreCase(string) && !"identity".equalsIgnoreCase(string) && LOG.isWarnEnabled()) {
                LOG.warn((Object)("Unsupported transfer encoding: " + string));
            }
            if ((n = (headerElementArray = header.getElements()).length) > 0 && "chunked".equalsIgnoreCase(headerElementArray[n - 1].getName())) {
                if (httpConnection.isResponseAvailable(httpConnection.getParams().getSoTimeout())) {
                    inputStream2 = new ChunkedInputStream(inputStream, this);
                } else {
                    if (this.getParams().isParameterTrue("http.protocol.strict-transfer-encoding")) {
                        throw new ProtocolException("Chunk-encoded body declared but not sent");
                    }
                    LOG.warn((Object)"Chunk-encoded body missing");
                }
            } else {
                LOG.info((Object)"Response content is not chunk-encoded");
                this.setConnectionCloseForced(true);
                inputStream2 = inputStream;
            }
        } else {
            long l = this.getResponseContentLength();
            if (l == -1L) {
                if (bl && this.effectiveVersion.greaterEquals(HttpVersion.HTTP_1_1)) {
                    Header header2 = this.responseHeaders.getFirstHeader("Connection");
                    String string = null;
                    if (header2 != null) {
                        string = header2.getValue();
                    }
                    if (!"close".equalsIgnoreCase(string)) {
                        LOG.info((Object)"Response content length is not known");
                        this.setConnectionCloseForced(true);
                    }
                }
                inputStream2 = inputStream;
            } else {
                inputStream2 = new ContentLengthInputStream(inputStream, l);
            }
        }
        if (!bl) {
            inputStream2 = null;
        }
        if (inputStream2 != null) {
            inputStream2 = new AutoCloseInputStream(inputStream2, new ResponseConsumedWatcher(){

                @Override
                public void responseConsumed() {
                    HttpMethodBase.this.responseBodyConsumed();
                }
            });
        }
        return inputStream2;
    }

    protected void readResponseHeaders(HttpState httpState, HttpConnection httpConnection) throws IOException, HttpException {
        LOG.trace((Object)"enter HttpMethodBase.readResponseHeaders(HttpState,HttpConnection)");
        this.getResponseHeaderGroup().clear();
        Header[] headerArray = HttpParser.parseHeaders(httpConnection.getResponseInputStream(), this.getParams().getHttpElementCharset());
        this.getResponseHeaderGroup().setHeaders(headerArray);
    }

    protected void readStatusLine(HttpState httpState, HttpConnection httpConnection) throws IOException, HttpException {
        String string;
        LOG.trace((Object)"enter HttpMethodBase.readStatusLine(HttpState, HttpConnection)");
        int n = this.getParams().getIntParameter("http.protocol.status-line-garbage-limit", Integer.MAX_VALUE);
        int n2 = 0;
        while (true) {
            if ((string = httpConnection.readLine(this.getParams().getHttpElementCharset())) == null && n2 == 0) {
                throw new NoHttpResponseException("The server " + httpConnection.getHost() + " failed to respond");
            }
            if (Wire.HEADER_WIRE.enabled()) {
                Wire.HEADER_WIRE.input(string + "\r\n");
            }
            if (string != null && StatusLine.startsWithHTTP(string)) break;
            if (string == null || n2 >= n) {
                throw new ProtocolException("The server " + httpConnection.getHost() + " failed to respond with a valid HTTP response");
            }
            ++n2;
        }
        this.statusLine = new StatusLine(string);
        String string2 = this.statusLine.getHttpVersion();
        if (this.getParams().isParameterFalse("http.protocol.unambiguous-statusline") && string2.equals("HTTP")) {
            this.getParams().setVersion(HttpVersion.HTTP_1_0);
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)("Ambiguous status line (HTTP protocol version missing):" + this.statusLine.toString()));
            }
        } else {
            this.effectiveVersion = HttpVersion.parse(string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeRequest(HttpState httpState, HttpConnection httpConnection) throws IOException, HttpException {
        LOG.trace((Object)"enter HttpMethodBase.writeRequest(HttpState, HttpConnection)");
        this.writeRequestLine(httpState, httpConnection);
        this.writeRequestHeaders(httpState, httpConnection);
        httpConnection.writeLine();
        if (Wire.HEADER_WIRE.enabled()) {
            Wire.HEADER_WIRE.output("\r\n");
        }
        HttpVersion httpVersion = this.getParams().getVersion();
        Header header = this.getRequestHeader("Expect");
        String string = null;
        if (header != null) {
            string = header.getValue();
        }
        if (string != null && string.compareToIgnoreCase("100-continue") == 0) {
            if (httpVersion.greaterEquals(HttpVersion.HTTP_1_1)) {
                httpConnection.flushRequestOutputStream();
                int n = httpConnection.getParams().getSoTimeout();
                try {
                    httpConnection.setSocketTimeout(3000);
                    this.readStatusLine(httpState, httpConnection);
                    this.processStatusLine(httpState, httpConnection);
                    this.readResponseHeaders(httpState, httpConnection);
                    this.processResponseHeaders(httpState, httpConnection);
                    if (this.statusLine.getStatusCode() == 100) {
                        this.statusLine = null;
                        LOG.debug((Object)"OK to continue received");
                    }
                    return;
                }
                catch (InterruptedIOException interruptedIOException) {
                    if (!ExceptionUtil.isSocketTimeoutException(interruptedIOException)) {
                        throw interruptedIOException;
                    }
                    this.removeRequestHeader("Expect");
                    LOG.info((Object)"100 (continue) read timeout. Resume sending the request");
                }
                finally {
                    httpConnection.setSocketTimeout(n);
                }
            } else {
                this.removeRequestHeader("Expect");
                LOG.info((Object)"'Expect: 100-continue' handshake is only supported by HTTP/1.1 or higher");
            }
        }
        this.writeRequestBody(httpState, httpConnection);
        httpConnection.flushRequestOutputStream();
    }

    protected boolean writeRequestBody(HttpState httpState, HttpConnection httpConnection) throws IOException, HttpException {
        return true;
    }

    protected void writeRequestHeaders(HttpState httpState, HttpConnection httpConnection) throws IOException, HttpException {
        LOG.trace((Object)"enter HttpMethodBase.writeRequestHeaders(HttpState,HttpConnection)");
        this.addRequestHeaders(httpState, httpConnection);
        String string = this.getParams().getHttpElementCharset();
        Header[] headerArray = this.getRequestHeaders();
        for (int i = 0; i < headerArray.length; ++i) {
            String string2 = headerArray[i].toExternalForm();
            if (Wire.HEADER_WIRE.enabled()) {
                Wire.HEADER_WIRE.output(string2);
            }
            httpConnection.print(string2, string);
        }
    }

    protected void writeRequestLine(HttpState httpState, HttpConnection httpConnection) throws IOException, HttpException {
        LOG.trace((Object)"enter HttpMethodBase.writeRequestLine(HttpState, HttpConnection)");
        String string = this.getRequestLine(httpConnection);
        if (Wire.HEADER_WIRE.enabled()) {
            Wire.HEADER_WIRE.output(string);
        }
        httpConnection.print(string, this.getParams().getHttpElementCharset());
    }

    private String getRequestLine(HttpConnection httpConnection) {
        return HttpMethodBase.generateRequestLine(httpConnection, this.getName(), this.getPath(), this.getQueryString(), this.effectiveVersion.toString());
    }

    @Override
    public HttpMethodParams getParams() {
        return this.params;
    }

    @Override
    public void setParams(HttpMethodParams httpMethodParams) {
        if (httpMethodParams == null) {
            throw new IllegalArgumentException("Parameters may not be null");
        }
        this.params = httpMethodParams;
    }

    public HttpVersion getEffectiveVersion() {
        return this.effectiveVersion;
    }

    private static boolean canResponseHaveBody(int n) {
        LOG.trace((Object)"enter HttpMethodBase.canResponseHaveBody(int)");
        boolean bl = true;
        if (n >= 100 && n <= 199 || n == 204 || n == 304) {
            bl = false;
        }
        return bl;
    }

    public String getProxyAuthenticationRealm() {
        return this.proxyAuthState.getRealm();
    }

    public String getAuthenticationRealm() {
        return this.hostAuthState.getRealm();
    }

    protected String getContentCharSet(Header header) {
        NameValuePair nameValuePair;
        HeaderElement[] headerElementArray;
        LOG.trace((Object)"enter getContentCharSet( Header contentheader )");
        String string = null;
        if (header != null && (headerElementArray = header.getElements()).length == 1 && (nameValuePair = headerElementArray[0].getParameterByName("charset")) != null) {
            string = nameValuePair.getValue();
        }
        if (string == null) {
            string = this.getParams().getContentCharset();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Default charset used: " + string));
            }
        }
        return string;
    }

    public String getRequestCharSet() {
        return this.getContentCharSet(this.getRequestHeader("Content-Type"));
    }

    public String getResponseCharSet() {
        return this.getContentCharSet(this.getResponseHeader("Content-Type"));
    }

    public int getRecoverableExceptionCount() {
        return this.recoverableExceptionCount;
    }

    protected void responseBodyConsumed() {
        this.responseStream = null;
        if (this.responseConnection != null) {
            this.responseConnection.setLastResponseInputStream(null);
            if (this.shouldCloseConnection(this.responseConnection)) {
                this.responseConnection.close();
            } else {
                try {
                    if (this.responseConnection.isResponseAvailable()) {
                        boolean bl = this.getParams().isParameterTrue("http.protocol.warn-extra-input");
                        if (bl) {
                            LOG.warn((Object)"Extra response data detected - closing connection");
                        }
                        this.responseConnection.close();
                    }
                }
                catch (IOException iOException) {
                    LOG.warn((Object)iOException.getMessage());
                    this.responseConnection.close();
                }
            }
        }
        this.connectionCloseForced = false;
        this.ensureConnectionRelease();
    }

    private void ensureConnectionRelease() {
        if (this.responseConnection != null) {
            this.responseConnection.releaseConnection();
            this.responseConnection = null;
        }
    }

    @Override
    public HostConfiguration getHostConfiguration() {
        HostConfiguration hostConfiguration = new HostConfiguration();
        hostConfiguration.setHost(this.httphost);
        return hostConfiguration;
    }

    public void setHostConfiguration(HostConfiguration hostConfiguration) {
        this.httphost = hostConfiguration != null ? new HttpHost(hostConfiguration.getHost(), hostConfiguration.getPort(), hostConfiguration.getProtocol()) : null;
    }

    public MethodRetryHandler getMethodRetryHandler() {
        return this.methodRetryHandler;
    }

    public void setMethodRetryHandler(MethodRetryHandler methodRetryHandler) {
        this.methodRetryHandler = methodRetryHandler;
    }

    void fakeResponse(StatusLine statusLine, HeaderGroup headerGroup, InputStream inputStream) {
        this.used = true;
        this.statusLine = statusLine;
        this.responseHeaders = headerGroup;
        this.responseBody = null;
        this.responseStream = inputStream;
    }

    @Override
    public AuthState getHostAuthState() {
        return this.hostAuthState;
    }

    @Override
    public AuthState getProxyAuthState() {
        return this.proxyAuthState;
    }

    public boolean isAborted() {
        return this.aborted;
    }

    @Override
    public boolean isRequestSent() {
        return this.requestSent;
    }
}

