/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.compressors.lzma;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.compress.compressors.CompressorInputStream;
import org.tukaani.xz.LZMAInputStream;

public class LZMACompressorInputStream
extends CompressorInputStream {
    private final InputStream in;

    public LZMACompressorInputStream(InputStream inputStream) throws IOException {
        this.in = new LZMAInputStream(inputStream);
    }

    @Override
    public int read() throws IOException {
        int n = this.in.read();
        this.count(n == -1 ? 0 : 1);
        return n;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = this.in.read(byArray, n, n2);
        this.count(n3);
        return n3;
    }

    @Override
    public long skip(long l) throws IOException {
        return this.in.skip(l);
    }

    @Override
    public int available() throws IOException {
        return this.in.available();
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }

    public static boolean matches(byte[] byArray, int n) {
        if (byArray == null || n < 3) {
            return false;
        }
        if (byArray[0] != 93) {
            return false;
        }
        if (byArray[1] != 0) {
            return false;
        }
        return byArray[2] == 0;
    }
}

