/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.compress.archivers.ArchiveEntry;

public abstract class ArchiveInputStream
extends InputStream {
    private final byte[] single = new byte[1];
    private static final int BYTE_MASK = 255;
    private long bytesRead = 0L;

    public abstract ArchiveEntry getNextEntry() throws IOException;

    @Override
    public int read() throws IOException {
        int n = this.read(this.single, 0, 1);
        return n == -1 ? -1 : this.single[0] & 0xFF;
    }

    protected void count(int n) {
        this.count((long)n);
    }

    protected void count(long l) {
        if (l != -1L) {
            this.bytesRead += l;
        }
    }

    protected void pushedBackBytes(long l) {
        this.bytesRead -= l;
    }

    @Deprecated
    public int getCount() {
        return (int)this.bytesRead;
    }

    public long getBytesRead() {
        return this.bytesRead;
    }

    public boolean canReadEntryData(ArchiveEntry archiveEntry) {
        return true;
    }
}

