/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.framework.configuration;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.avalon.framework.configuration.AbstractConfiguration;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.configuration.ConfigurationUtil;
import org.apache.avalon.framework.configuration.DefaultConfiguration;

public class DefaultImmutableConfiguration
extends AbstractConfiguration
implements Serializable {
    protected static final Configuration[] EMPTY_ARRAY = new Configuration[0];
    private final String m_name;
    private final String m_location;
    private final String m_namespace;
    private final String m_prefix;
    private final HashMap m_attributes;
    private final ArrayList m_children;
    private final String m_value;

    public DefaultImmutableConfiguration(Configuration configuration) throws ConfigurationException {
        Configuration[] configurationArray;
        this.m_name = configuration.getName();
        this.m_location = configuration.getLocation();
        this.m_namespace = configuration.getNamespace();
        this.m_prefix = configuration instanceof AbstractConfiguration ? ((AbstractConfiguration)configuration).getPrefix() : "";
        this.m_value = configuration.getValue(null);
        String[] stringArray = configuration.getAttributeNames();
        if (stringArray.length > 0) {
            this.m_attributes = new HashMap();
            for (int i = 0; i < stringArray.length; ++i) {
                String string = stringArray[i];
                String string2 = configuration.getAttribute(string, null);
                this.m_attributes.put(string, string2);
            }
        } else {
            this.m_attributes = null;
        }
        if ((configurationArray = configuration.getChildren()).length > 0) {
            this.m_children = new ArrayList();
            for (int i = 0; i < configurationArray.length; ++i) {
                this.m_children.add(new DefaultImmutableConfiguration(configurationArray[i]));
            }
        } else {
            this.m_children = null;
        }
    }

    @Override
    public String getName() {
        return this.m_name;
    }

    @Override
    public String getNamespace() throws ConfigurationException {
        if (null != this.m_namespace) {
            return this.m_namespace;
        }
        throw new ConfigurationException("No namespace (not even default \"\") is associated with the configuration element \"" + this.getName() + "\" at " + this.getLocation());
    }

    @Override
    protected String getPrefix() throws ConfigurationException {
        if (null != this.m_prefix) {
            return this.m_prefix;
        }
        throw new ConfigurationException("No prefix (not even default \"\") is associated with the configuration element \"" + this.getName() + "\" at " + this.getLocation());
    }

    @Override
    public String getLocation() {
        return this.m_location;
    }

    @Override
    public String getValue(String string) {
        if (null != this.m_value) {
            return this.m_value;
        }
        return string;
    }

    @Override
    public String getValue() throws ConfigurationException {
        if (null != this.m_value) {
            return this.m_value;
        }
        throw new ConfigurationException("No value is associated with the configuration element \"" + this.getName() + "\" at " + this.getLocation());
    }

    @Override
    public String[] getAttributeNames() {
        if (null == this.m_attributes) {
            return new String[0];
        }
        return this.m_attributes.keySet().toArray(new String[0]);
    }

    @Override
    public Configuration[] getChildren() {
        if (null == this.m_children) {
            return new Configuration[0];
        }
        return this.m_children.toArray(new Configuration[0]);
    }

    @Override
    public String getAttribute(String string) throws ConfigurationException {
        String string2;
        String string3 = string2 = null != this.m_attributes ? (String)this.m_attributes.get(string) : null;
        if (null != string2) {
            return string2;
        }
        throw new ConfigurationException("No attribute named \"" + string + "\" is " + "associated with the configuration element \"" + this.getName() + "\" at " + this.getLocation());
    }

    @Override
    public Configuration getChild(String string, boolean bl) {
        if (null != this.m_children) {
            int n = this.m_children.size();
            for (int i = 0; i < n; ++i) {
                Configuration configuration = (Configuration)this.m_children.get(i);
                if (!string.equals(configuration.getName())) continue;
                return configuration;
            }
        }
        if (bl) {
            return new DefaultConfiguration(string, "<generated>" + this.getLocation(), this.m_namespace, this.m_prefix);
        }
        return null;
    }

    @Override
    public Configuration[] getChildren(String string) {
        if (null == this.m_children) {
            return new Configuration[0];
        }
        ArrayList<Configuration> arrayList = new ArrayList<Configuration>();
        int n = this.m_children.size();
        for (int i = 0; i < n; ++i) {
            Configuration configuration = (Configuration)this.m_children.get(i);
            if (!string.equals(configuration.getName())) continue;
            arrayList.add(configuration);
        }
        return arrayList.toArray(new Configuration[0]);
    }

    public int getChildCount() {
        if (null == this.m_children) {
            return 0;
        }
        return this.m_children.size();
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof Configuration)) {
            return false;
        }
        return ConfigurationUtil.equals(this, (Configuration)object);
    }

    public int hashCode() {
        int n = this.m_prefix.hashCode();
        if (this.m_name != null) {
            n ^= this.m_name.hashCode();
        }
        n >>>= 7;
        if (this.m_location != null) {
            n ^= this.m_location.hashCode();
        }
        n >>>= 7;
        if (this.m_namespace != null) {
            n ^= this.m_namespace.hashCode();
        }
        n >>>= 7;
        if (this.m_attributes != null) {
            n ^= this.m_attributes.hashCode();
        }
        n >>>= 7;
        if (this.m_children != null) {
            n ^= this.m_children.hashCode();
        }
        n >>>= 7;
        if (this.m_value != null) {
            n ^= this.m_value.hashCode();
        }
        return n >>>= 7;
    }
}

