/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.framework.configuration;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.configuration.NamespacedSAXConfigurationHandler;
import org.apache.avalon.framework.configuration.SAXConfigurationHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class DefaultConfigurationBuilder {
    private SAXConfigurationHandler m_handler;
    private XMLReader m_parser;

    public DefaultConfigurationBuilder() {
        this(false);
    }

    public DefaultConfigurationBuilder(boolean bl) {
        try {
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            if (bl) {
                sAXParserFactory.setNamespaceAware(true);
            }
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            this.setParser(sAXParser.getXMLReader());
        }
        catch (Exception exception) {
            throw new Error("Unable to setup SAX parser" + exception);
        }
    }

    public DefaultConfigurationBuilder(XMLReader xMLReader) {
        this.setParser(xMLReader);
    }

    private void setParser(XMLReader xMLReader) {
        this.m_parser = xMLReader;
        this.m_handler = this.getHandler();
        this.m_parser.setContentHandler(this.m_handler);
        this.m_parser.setErrorHandler(this.m_handler);
    }

    protected SAXConfigurationHandler getHandler() {
        try {
            if (this.m_parser.getFeature("http://xml.org/sax/features/namespaces")) {
                return new NamespacedSAXConfigurationHandler();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new SAXConfigurationHandler();
    }

    public Configuration buildFromFile(String string) throws SAXException, IOException, ConfigurationException {
        return this.buildFromFile(new File(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Configuration buildFromFile(File file) throws SAXException, IOException, ConfigurationException {
        DefaultConfigurationBuilder defaultConfigurationBuilder = this;
        synchronized (defaultConfigurationBuilder) {
            this.m_handler.clear();
            this.m_parser.parse(file.toURL().toString());
            return this.m_handler.getConfiguration();
        }
    }

    public Configuration build(InputStream inputStream) throws SAXException, IOException, ConfigurationException {
        return this.build(new InputSource(inputStream));
    }

    public Configuration build(InputStream inputStream, String string) throws SAXException, IOException, ConfigurationException {
        InputSource inputSource = new InputSource(inputStream);
        inputSource.setSystemId(string);
        return this.build(inputSource);
    }

    public Configuration build(String string) throws SAXException, IOException, ConfigurationException {
        return this.build(new InputSource(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Configuration build(InputSource inputSource) throws SAXException, IOException, ConfigurationException {
        DefaultConfigurationBuilder defaultConfigurationBuilder = this;
        synchronized (defaultConfigurationBuilder) {
            this.m_handler.clear();
            this.m_parser.parse(inputSource);
            return this.m_handler.getConfiguration();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEntityResolver(EntityResolver entityResolver) {
        DefaultConfigurationBuilder defaultConfigurationBuilder = this;
        synchronized (defaultConfigurationBuilder) {
            this.m_parser.setEntityResolver(entityResolver);
        }
    }
}

