/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.framework.logger;

import org.apache.avalon.framework.logger.Logger;

public final class ConsoleLogger
implements Logger {
    public static final int LEVEL_DEBUG = 0;
    public static final int LEVEL_INFO = 1;
    public static final int LEVEL_WARN = 2;
    public static final int LEVEL_ERROR = 3;
    public static final int LEVEL_FATAL = 4;
    public static final int LEVEL_DISABLED = 5;
    private final int m_logLevel;

    public ConsoleLogger() {
        this(0);
    }

    public ConsoleLogger(int n) {
        this.m_logLevel = n;
    }

    public void debug(String string) {
        this.debug(string, null);
    }

    public void debug(String string, Throwable throwable) {
        if (this.m_logLevel <= 0) {
            System.out.print("[DEBUG] ");
            System.out.println(string);
            if (null != throwable) {
                throwable.printStackTrace(System.out);
            }
        }
    }

    public boolean isDebugEnabled() {
        return this.m_logLevel <= 0;
    }

    public void info(String string) {
        this.info(string, null);
    }

    public void info(String string, Throwable throwable) {
        if (this.m_logLevel <= 1) {
            System.out.print("[INFO] ");
            System.out.println(string);
            if (null != throwable) {
                throwable.printStackTrace(System.out);
            }
        }
    }

    public boolean isInfoEnabled() {
        return this.m_logLevel <= 1;
    }

    public void warn(String string) {
        this.warn(string, null);
    }

    public void warn(String string, Throwable throwable) {
        if (this.m_logLevel <= 2) {
            System.out.print("[WARNING] ");
            System.out.println(string);
            if (null != throwable) {
                throwable.printStackTrace(System.out);
            }
        }
    }

    public boolean isWarnEnabled() {
        return this.m_logLevel <= 2;
    }

    public void error(String string) {
        this.error(string, null);
    }

    public void error(String string, Throwable throwable) {
        if (this.m_logLevel <= 3) {
            System.out.print("[ERROR] ");
            System.out.println(string);
            if (null != throwable) {
                throwable.printStackTrace(System.out);
            }
        }
    }

    public boolean isErrorEnabled() {
        return this.m_logLevel <= 3;
    }

    public void fatalError(String string) {
        this.fatalError(string, null);
    }

    public void fatalError(String string, Throwable throwable) {
        if (this.m_logLevel <= 4) {
            System.out.print("[FATAL ERROR] ");
            System.out.println(string);
            if (null != throwable) {
                throwable.printStackTrace(System.out);
            }
        }
    }

    public boolean isFatalErrorEnabled() {
        return this.m_logLevel <= 4;
    }

    public Logger getChildLogger(String string) {
        return this;
    }
}

