/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.framework.configuration;

import java.util.ArrayList;
import java.util.BitSet;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.DefaultConfiguration;
import org.xml.sax.Attributes;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class SAXConfigurationHandler
extends DefaultHandler
implements ErrorHandler {
    private static final int EXPECTED_DEPTH = 5;
    private final ArrayList m_elements = new ArrayList(5);
    private final ArrayList m_values = new ArrayList(5);
    private final BitSet m_preserveSpace = new BitSet();
    private Configuration m_configuration;
    private Locator m_locator;

    public Configuration getConfiguration() {
        return this.m_configuration;
    }

    public void clear() {
        this.m_elements.clear();
        this.m_values.clear();
        this.m_locator = null;
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.m_locator = locator;
    }

    @Override
    public void characters(char[] cArray, int n, int n2) throws SAXException {
        int n3 = this.m_values.size() - 1;
        StringBuffer stringBuffer = (StringBuffer)this.m_values.get(n3);
        stringBuffer.append(cArray, n, n2);
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
        int n = this.m_elements.size() - 1;
        DefaultConfiguration defaultConfiguration = (DefaultConfiguration)this.m_elements.remove(n);
        String string4 = ((StringBuffer)this.m_values.remove(n)).toString();
        if (defaultConfiguration.getChildren().length == 0) {
            Object object = this.m_preserveSpace.get(n) ? string4 : (0 == string4.length() ? null : string4.trim());
            defaultConfiguration.setValue((String)object);
        } else {
            String string5 = string4.trim();
            if (string5.length() > 0) {
                throw new SAXException("Not allowed to define mixed content in the element " + defaultConfiguration.getName() + " at " + defaultConfiguration.getLocation());
            }
        }
        if (0 == n) {
            this.m_configuration = defaultConfiguration;
        }
    }

    protected DefaultConfiguration createConfiguration(String string, String string2) {
        return new DefaultConfiguration(string, string2);
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        DefaultConfiguration defaultConfiguration = this.createConfiguration(string3, this.getLocationString());
        int n = this.m_elements.size();
        boolean bl = false;
        if (n > 0) {
            DefaultConfiguration defaultConfiguration2 = (DefaultConfiguration)this.m_elements.get(n - 1);
            defaultConfiguration2.addChild(defaultConfiguration);
            bl = this.m_preserveSpace.get(n - 1);
        }
        this.m_elements.add(defaultConfiguration);
        this.m_values.add(new StringBuffer());
        int n2 = attributes.getLength();
        for (int i = 0; i < n2; ++i) {
            String string4 = attributes.getQName(i);
            String string5 = attributes.getValue(i);
            if (!string4.equals("xml:space")) {
                defaultConfiguration.setAttribute(string4, string5);
                continue;
            }
            bl = string5.equals("preserve");
        }
        if (bl) {
            this.m_preserveSpace.set(n);
        } else {
            this.m_preserveSpace.clear(n);
        }
    }

    @Override
    public void error(SAXParseException sAXParseException) throws SAXException {
        throw sAXParseException;
    }

    @Override
    public void warning(SAXParseException sAXParseException) throws SAXException {
        throw sAXParseException;
    }

    @Override
    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        throw sAXParseException;
    }

    protected String getLocationString() {
        if (null == this.m_locator) {
            return "Unknown";
        }
        int n = this.m_locator.getColumnNumber();
        return this.m_locator.getSystemId() + ":" + this.m_locator.getLineNumber() + (n >= 0 ? ":" + n : "");
    }
}

