/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.framework.configuration;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.avalon.framework.configuration.AbstractConfiguration;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.configuration.ConfigurationUtil;
import org.apache.avalon.framework.configuration.MutableConfiguration;

public class DefaultConfiguration
extends AbstractConfiguration
implements MutableConfiguration,
Serializable {
    protected static final Configuration[] EMPTY_ARRAY = new Configuration[0];
    private final String m_name;
    private final String m_location;
    private final String m_namespace;
    private final String m_prefix;
    private HashMap m_attributes;
    private ArrayList m_children;
    private String m_value;
    private boolean m_readOnly;

    public DefaultConfiguration(Configuration configuration) throws ConfigurationException {
        this(configuration.getName(), configuration.getLocation(), configuration.getNamespace(), configuration instanceof AbstractConfiguration ? ((AbstractConfiguration)configuration).getPrefix() : "");
        this.addAll(configuration);
    }

    public DefaultConfiguration(String string) {
        this(string, null, "", "");
    }

    public DefaultConfiguration(String string, String string2) {
        this(string, string2, "", "");
    }

    public DefaultConfiguration(String string, String string2, String string3, String string4) {
        this.m_name = string;
        this.m_location = string2;
        this.m_namespace = string3;
        this.m_prefix = string4;
    }

    public String getName() {
        return this.m_name;
    }

    public String getNamespace() throws ConfigurationException {
        if (null != this.m_namespace) {
            return this.m_namespace;
        }
        throw new ConfigurationException("No namespace (not even default \"\") is associated with the configuration element \"" + this.getName() + "\" at " + this.getLocation());
    }

    @Override
    protected String getPrefix() throws ConfigurationException {
        if (null != this.m_prefix) {
            return this.m_prefix;
        }
        throw new ConfigurationException("No prefix (not even default \"\") is associated with the configuration element \"" + this.getName() + "\" at " + this.getLocation());
    }

    public String getLocation() {
        return this.m_location;
    }

    @Override
    public String getValue(String string) {
        if (null != this.m_value) {
            return this.m_value;
        }
        return string;
    }

    public String getValue() throws ConfigurationException {
        if (null != this.m_value) {
            return this.m_value;
        }
        throw new ConfigurationException("No value is associated with the configuration element \"" + this.getName() + "\" at " + this.getLocation());
    }

    public String[] getAttributeNames() {
        if (null == this.m_attributes) {
            return new String[0];
        }
        return this.m_attributes.keySet().toArray(new String[0]);
    }

    public Configuration[] getChildren() {
        if (null == this.m_children) {
            return new Configuration[0];
        }
        return this.m_children.toArray(new Configuration[0]);
    }

    public String getAttribute(String string) throws ConfigurationException {
        String string2;
        String string3 = string2 = null != this.m_attributes ? (String)this.m_attributes.get(string) : null;
        if (null != string2) {
            return string2;
        }
        throw new ConfigurationException("No attribute named \"" + string + "\" is " + "associated with the configuration element \"" + this.getName() + "\" at " + this.getLocation());
    }

    @Override
    public Configuration getChild(String string, boolean bl) {
        if (null != this.m_children) {
            int n = this.m_children.size();
            for (int i = 0; i < n; ++i) {
                Configuration configuration = (Configuration)this.m_children.get(i);
                if (!string.equals(configuration.getName())) continue;
                return configuration;
            }
        }
        if (bl) {
            return new DefaultConfiguration(string, "<generated>" + this.getLocation(), this.m_namespace, this.m_prefix);
        }
        return null;
    }

    public Configuration[] getChildren(String string) {
        if (null == this.m_children) {
            return new Configuration[0];
        }
        ArrayList<Configuration> arrayList = new ArrayList<Configuration>();
        int n = this.m_children.size();
        for (int i = 0; i < n; ++i) {
            Configuration configuration = (Configuration)this.m_children.get(i);
            if (!string.equals(configuration.getName())) continue;
            arrayList.add(configuration);
        }
        return arrayList.toArray(new Configuration[0]);
    }

    public void appendValueData(String string) {
        this.checkWriteable();
        this.m_value = null == this.m_value ? string : this.m_value + string;
    }

    @Override
    public void setValue(String string) {
        this.checkWriteable();
        this.m_value = string;
    }

    @Override
    public void setValue(int n) {
        this.setValue(String.valueOf(n));
    }

    @Override
    public void setValue(long l) {
        this.setValue(String.valueOf(l));
    }

    @Override
    public void setValue(boolean bl) {
        this.setValue(String.valueOf(bl));
    }

    @Override
    public void setValue(float f) {
        this.setValue(String.valueOf(f));
    }

    @Override
    public void setAttribute(String string, String string2) {
        this.checkWriteable();
        if (null != string2) {
            if (null == this.m_attributes) {
                this.m_attributes = new HashMap();
            }
            this.m_attributes.put(string, string2);
        } else if (null != this.m_attributes) {
            this.m_attributes.remove(string);
        }
    }

    @Override
    public void setAttribute(String string, int n) {
        this.setAttribute(string, String.valueOf(n));
    }

    @Override
    public void setAttribute(String string, long l) {
        this.setAttribute(string, String.valueOf(l));
    }

    @Override
    public void setAttribute(String string, boolean bl) {
        this.setAttribute(string, String.valueOf(bl));
    }

    @Override
    public void setAttribute(String string, float f) {
        this.setAttribute(string, String.valueOf(f));
    }

    public String addAttribute(String string, String string2) {
        this.checkWriteable();
        if (null == this.m_attributes) {
            this.m_attributes = new HashMap();
        }
        return this.m_attributes.put(string, string2);
    }

    @Override
    public void addChild(Configuration configuration) {
        this.checkWriteable();
        if (null == this.m_children) {
            this.m_children = new ArrayList();
        }
        this.m_children.add(configuration);
    }

    @Override
    public void addAll(Configuration configuration) {
        this.checkWriteable();
        this.setValue(configuration.getValue(null));
        this.addAllAttributes(configuration);
        this.addAllChildren(configuration);
    }

    @Override
    public void addAllAttributes(Configuration configuration) {
        this.checkWriteable();
        String[] stringArray = configuration.getAttributeNames();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            String string2 = configuration.getAttribute(string, null);
            this.setAttribute(string, string2);
        }
    }

    @Override
    public void addAllChildren(Configuration configuration) {
        this.checkWriteable();
        Configuration[] configurationArray = configuration.getChildren();
        for (int i = 0; i < configurationArray.length; ++i) {
            this.addChild(configurationArray[i]);
        }
    }

    @Override
    public void removeChild(Configuration configuration) {
        this.checkWriteable();
        if (null == this.m_children) {
            return;
        }
        this.m_children.remove(configuration);
    }

    public int getChildCount() {
        if (null == this.m_children) {
            return 0;
        }
        return this.m_children.size();
    }

    public void makeReadOnly() {
        this.m_readOnly = true;
    }

    protected final void checkWriteable() throws IllegalStateException {
        if (this.m_readOnly) {
            throw new IllegalStateException("Configuration is read only and can not be modified");
        }
    }

    protected final boolean isReadOnly() {
        return this.m_readOnly;
    }

    private MutableConfiguration toMutable(Configuration configuration) throws ConfigurationException {
        if (!(!(configuration instanceof MutableConfiguration) || configuration instanceof DefaultConfiguration && ((DefaultConfiguration)configuration).isReadOnly())) {
            return (MutableConfiguration)configuration;
        }
        this.checkWriteable();
        DefaultConfiguration defaultConfiguration = new DefaultConfiguration(configuration);
        for (int i = 0; i < this.m_children.size(); ++i) {
            if (this.m_children.get(i) != configuration) continue;
            this.m_children.set(i, defaultConfiguration);
            break;
        }
        return defaultConfiguration;
    }

    @Override
    public MutableConfiguration getMutableChild(String string) throws ConfigurationException {
        return this.getMutableChild(string, true);
    }

    @Override
    public MutableConfiguration getMutableChild(String string, boolean bl) throws ConfigurationException {
        Configuration configuration = this.getChild(string, false);
        if (configuration == null) {
            if (bl) {
                DefaultConfiguration defaultConfiguration = new DefaultConfiguration(string, "-");
                this.addChild(defaultConfiguration);
                return defaultConfiguration;
            }
            return null;
        }
        return this.toMutable(configuration);
    }

    @Override
    public MutableConfiguration[] getMutableChildren() throws ConfigurationException {
        if (null == this.m_children) {
            return new MutableConfiguration[0];
        }
        ArrayList<MutableConfiguration> arrayList = new ArrayList<MutableConfiguration>();
        int n = this.m_children.size();
        for (int i = 0; i < n; ++i) {
            Configuration configuration = (Configuration)this.m_children.get(i);
            arrayList.add(this.toMutable(configuration));
        }
        return arrayList.toArray(new MutableConfiguration[0]);
    }

    @Override
    public MutableConfiguration[] getMutableChildren(String string) throws ConfigurationException {
        if (null == this.m_children) {
            return new MutableConfiguration[0];
        }
        ArrayList<MutableConfiguration> arrayList = new ArrayList<MutableConfiguration>();
        int n = this.m_children.size();
        for (int i = 0; i < n; ++i) {
            Configuration configuration = (Configuration)this.m_children.get(i);
            if (!string.equals(configuration.getName())) continue;
            arrayList.add(this.toMutable(configuration));
        }
        return arrayList.toArray(new MutableConfiguration[0]);
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof Configuration)) {
            return false;
        }
        return ConfigurationUtil.equals(this, (Configuration)object);
    }

    public int hashCode() {
        int n = this.m_prefix.hashCode();
        if (this.m_name != null) {
            n ^= this.m_name.hashCode();
        }
        n >>>= 7;
        if (this.m_location != null) {
            n ^= this.m_location.hashCode();
        }
        n >>>= 7;
        if (this.m_namespace != null) {
            n ^= this.m_namespace.hashCode();
        }
        n >>>= 7;
        if (this.m_attributes != null) {
            n ^= this.m_attributes.hashCode();
        }
        n >>>= 7;
        if (this.m_children != null) {
            n ^= this.m_children.hashCode();
        }
        n >>>= 7;
        if (this.m_value != null) {
            n ^= this.m_value.hashCode();
        }
        n >>>= 7;
        return n ^= this.m_readOnly ? 1 : 3;
    }
}

