/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.animal_sniffer;

import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.codehaus.mojo.animal_sniffer.ClassFileVisitor;

public class Main
extends ClassFileVisitor {
    private boolean humanReadableName = false;
    private String maximumVersion = "00.0";
    private static final Map<String, String> HUMAN_READABLE_NAME = new HashMap<String, String>();

    public static void main(String[] stringArray) throws IOException {
        int n;
        if (stringArray.length == 0) {
            System.err.println("Usage: java -jar animal-sniffer.jar [JAR/CLASS FILES]");
            System.err.println("  -h   : show a human readable Java version number");
            System.err.println("  -t N : return exit code 1 if any file has a class file version number > N");
            System.exit(-1);
        }
        Main main = new Main();
        String string = null;
        ArrayList<File> arrayList = new ArrayList<File>();
        block0: for (n = 0; n < stringArray.length; ++n) {
            if (stringArray[n].equals("-h")) {
                main.humanReadableName = true;
                continue;
            }
            if (stringArray[n].equals("-t")) {
                string = stringArray[++n];
                for (Map.Entry<String, String> entry : HUMAN_READABLE_NAME.entrySet()) {
                    if (!entry.getValue().equals(string)) continue;
                    string = entry.getKey();
                    continue block0;
                }
                continue;
            }
            arrayList.add(new File(stringArray[n]));
        }
        for (n = 0; n < arrayList.size(); ++n) {
            main.process((File)arrayList.get(n));
        }
        if (string != null && main.maximumVersion.compareTo(string) > 0) {
            System.exit(1);
        }
    }

    @Override
    protected void process(String string, InputStream inputStream) throws IOException {
        String string2;
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        byte[] byArray = new byte[8];
        dataInputStream.readFully(byArray);
        String string3 = Main.u2(byArray[6], byArray[7]) + "." + Main.u2(byArray[4], byArray[5]);
        if (this.maximumVersion.compareTo(string3) < 0) {
            this.maximumVersion = string3;
        }
        if (this.humanReadableName && (string2 = HUMAN_READABLE_NAME.get(string3)) != null) {
            string3 = string2;
        }
        System.out.println(string3 + " " + string);
    }

    private static int u2(byte by, byte by2) {
        return by * 256 + by2;
    }

    static {
        HUMAN_READABLE_NAME.put("45.0", "Java1");
        HUMAN_READABLE_NAME.put("46.0", "Java2");
        HUMAN_READABLE_NAME.put("47.0", "Java3");
        HUMAN_READABLE_NAME.put("48.0", "Java4");
        HUMAN_READABLE_NAME.put("49.0", "Java5");
        HUMAN_READABLE_NAME.put("50.0", "Java6");
    }
}

