/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.security.policyeditor;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Collection;
import java.util.Objects;
import java.util.TreeSet;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import net.sourceforge.jnlp.runtime.Translator;
import net.sourceforge.jnlp.security.policyeditor.PermissionActions;
import net.sourceforge.jnlp.security.policyeditor.PermissionTarget;
import net.sourceforge.jnlp.security.policyeditor.PermissionType;
import net.sourceforge.jnlp.security.policyeditor.PolicyEditor;
import net.sourceforge.jnlp.security.policyeditor.PolicyIdentifier;
import sun.security.provider.PolicyParser;

public class CustomPolicyViewer
extends JFrame {
    private final Collection<DisplayablePermission> customPermissions = new TreeSet<DisplayablePermission>();
    private final JScrollPane scrollPane = new JScrollPane();
    private final DefaultListModel<DisplayablePermission> listModel = new DefaultListModel();
    private final JList<DisplayablePermission> list = new JList<DisplayablePermission>(this.listModel);
    private final JButton addButton = new JButton();
    private final JButton removeButton = new JButton();
    private final JButton closeButton = new JButton();
    private final JLabel listLabel = new JLabel();
    private final ActionListener addButtonAction;
    private final ActionListener removeButtonAction;
    private final ActionListener closeButtonAction;
    private final PolicyEditor parent;
    private final PolicyIdentifier policyIdentifier;

    public CustomPolicyViewer(PolicyEditor parent, PolicyIdentifier policyIdentifier) {
        Objects.requireNonNull(parent);
        Objects.requireNonNull(policyIdentifier);
        this.parent = parent;
        this.policyIdentifier = policyIdentifier;
        this.setLayout(new GridBagLayout());
        this.setTitle(Translator.R("PECPTitle"));
        for (PolicyParser.PermissionEntry permissionEntry : parent.getCustomPermissions(policyIdentifier)) {
            this.customPermissions.add(DisplayablePermission.from(permissionEntry));
        }
        for (DisplayablePermission perm : this.customPermissions) {
            this.listModel.addElement(perm);
        }
        this.addButtonAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String prefill = Translator.R("PECPType") + " " + Translator.R("PECPTarget") + " [" + Translator.R("PECPActions") + "]";
                String string = JOptionPane.showInputDialog(CustomPolicyViewer.this, Translator.R("PECPPrompt"), prefill);
                if (string == null || string.isEmpty()) {
                    return;
                }
                String[] parts = (string = string.replaceAll("\\s+", " ").trim()).split(" ");
                if (parts.length < 2) {
                    return;
                }
                String type = parts[0];
                String target = parts[1];
                String actions = parts.length > 2 ? parts[2] : "";
                PolicyParser.PermissionEntry perm = new PolicyParser.PermissionEntry(type, target, actions);
                CustomPolicyViewer.this.addCustomPermission(perm);
            }
        };
        this.addButton.setText(Translator.R("PECPAddButton"));
        this.addButton.addActionListener(this.addButtonAction);
        this.removeButtonAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PolicyParser.PermissionEntry selected = (PolicyParser.PermissionEntry)CustomPolicyViewer.this.list.getSelectedValue();
                if (selected == null) {
                    return;
                }
                CustomPolicyViewer.this.removeCustomPermission(selected);
            }
        };
        this.removeButton.setText(Translator.R("PECPRemoveButton"));
        this.removeButton.addActionListener(this.removeButtonAction);
        this.closeButtonAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CustomPolicyViewer.this.quit();
            }
        };
        this.closeButton.setText(Translator.R("PECPCloseButton"));
        this.closeButton.addActionListener(this.closeButtonAction);
        this.listLabel.setText(Translator.R("PECPListLabel", policyIdentifier.toStringNoHtml()));
        this.scrollPane.setHorizontalScrollBarPolicy(30);
        this.scrollPane.setVerticalScrollBarPolicy(22);
        this.list.setSelectedIndex(0);
        this.setupLayout();
        this.setDefaultCloseOperation(2);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                CustomPolicyViewer.this.quit();
            }
        });
    }

    private void setupLayout() {
        GridBagConstraints labelConstraints = new GridBagConstraints();
        labelConstraints.gridx = 0;
        labelConstraints.gridy = 0;
        EmptyBorder border = new EmptyBorder(2, 2, 2, 2);
        this.listLabel.setBorder(border);
        this.add((Component)this.listLabel, labelConstraints);
        GridBagConstraints scrollPaneConstraints = new GridBagConstraints();
        scrollPaneConstraints.gridx = 0;
        scrollPaneConstraints.gridy = 1;
        scrollPaneConstraints.weightx = 1.0;
        scrollPaneConstraints.weighty = 1.0;
        scrollPaneConstraints.gridwidth = 3;
        scrollPaneConstraints.fill = 1;
        this.list.setSelectionMode(0);
        this.scrollPane.setViewportView(this.list);
        this.add((Component)this.scrollPane, scrollPaneConstraints);
        GridBagConstraints addButtonConstraints = new GridBagConstraints();
        addButtonConstraints.gridx = 0;
        addButtonConstraints.gridy = scrollPaneConstraints.gridy + 1;
        addButtonConstraints.fill = 2;
        this.add((Component)this.addButton, addButtonConstraints);
        GridBagConstraints removeButtonConstraints = new GridBagConstraints();
        removeButtonConstraints.gridx = addButtonConstraints.gridx + 1;
        removeButtonConstraints.gridy = addButtonConstraints.gridy;
        removeButtonConstraints.fill = 2;
        this.add((Component)this.removeButton, removeButtonConstraints);
        GridBagConstraints closeButtonConstraints = new GridBagConstraints();
        closeButtonConstraints.gridx = removeButtonConstraints.gridx + 1;
        closeButtonConstraints.gridy = removeButtonConstraints.gridy;
        closeButtonConstraints.fill = 2;
        this.add((Component)this.closeButton, closeButtonConstraints);
        this.pack();
        this.setMinimumSize(this.getPreferredSize());
    }

    private void quit() {
        this.parent.customPolicyViewerClosing();
        this.dispose();
    }

    private void updateCustomPermissions() {
        this.parent.setChangesMade(true);
        this.parent.clearCustomPermissions(this.policyIdentifier);
        for (PolicyParser.PermissionEntry permissionEntry : this.customPermissions) {
            this.parent.addCustomPermission(this.policyIdentifier, permissionEntry);
        }
    }

    void addCustomPermission(PolicyParser.PermissionEntry permission) {
        Objects.requireNonNull(permission);
        DisplayablePermission displayablePermission = DisplayablePermission.from(permission);
        if (this.customPermissions.add(displayablePermission)) {
            this.listModel.addElement(displayablePermission);
            this.updateCustomPermissions();
        }
        this.list.setSelectedValue(permission, true);
    }

    void removeCustomPermission(PolicyParser.PermissionEntry permission) {
        Objects.requireNonNull(permission);
        this.customPermissions.remove(DisplayablePermission.from(permission));
        this.listModel.removeElement(permission);
        this.updateCustomPermissions();
    }

    Collection<DisplayablePermission> getCopyOfCustomPermissions() {
        return new TreeSet<DisplayablePermission>(this.customPermissions);
    }

    public static class DisplayablePermission
    extends PolicyParser.PermissionEntry
    implements Comparable<PolicyParser.PermissionEntry> {
        public DisplayablePermission(PermissionType type, PermissionTarget target) {
            this(type, target, PermissionActions.NONE);
        }

        public DisplayablePermission(PermissionType type, PermissionTarget target, PermissionActions actions) {
            this(type.type, target.target, actions.rawString());
        }

        public DisplayablePermission(String type, String target) {
            this(type, target, null);
        }

        public DisplayablePermission(String permission, String name, String action) {
            super(permission, name, action);
        }

        public static DisplayablePermission from(PolicyParser.PermissionEntry permissionEntry) {
            return new DisplayablePermission(permissionEntry.permission, permissionEntry.name, permissionEntry.action);
        }

        @Override
        public int compareTo(PolicyParser.PermissionEntry o) {
            return this.name.compareTo(o.name);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("permission ");
            sb.append(this.permission);
            sb.append(" \"");
            sb.append(this.name);
            sb.append("\"");
            if (this.action == null || !this.action.trim().equals(PermissionActions.NONE.rawString())) {
                sb.append(", \"");
                sb.append(this.action);
                sb.append("\"");
            }
            sb.append(";");
            return sb.toString();
        }
    }
}

