SCM_GLOBAL_SMOB (scm_tc16_gnutls_cipher_enum, "cipher", 0);
SCM scm_gnutls_cipher_enum_values = SCM_EOL;
SCM_SMOB_PRINT (scm_tc16_gnutls_cipher_enum, cipher_print, obj, port, pstate)
{
  scm_puts ("#<gnutls-cipher-enum ", port);
  scm_puts (gnutls_cipher_get_name (scm_to_gnutls_cipher (obj, 1, "cipher_print")), port);
  scm_puts (">", port);
  return 1;
}
SCM_DEFINE (scm_gnutls_cipher_to_string, "cipher->string", 1, 0, 0,
            (SCM enumval),
            "Return a string describing @var{enumval}, a @code{cipher} value.")
#define FUNC_NAME s_scm_gnutls_cipher_to_string
{
  gnutls_cipher_algorithm_t c_enum;
  const char *c_string;
  c_enum = scm_to_gnutls_cipher (enumval, 1, FUNC_NAME);
  c_string = gnutls_cipher_get_name (c_enum);
  return (scm_from_locale_string (c_string));
}
#undef FUNC_NAME
SCM_GLOBAL_SMOB (scm_tc16_gnutls_kx_enum, "kx", 0);
SCM scm_gnutls_kx_enum_values = SCM_EOL;
SCM_SMOB_PRINT (scm_tc16_gnutls_kx_enum, kx_print, obj, port, pstate)
{
  scm_puts ("#<gnutls-kx-enum ", port);
  scm_puts (gnutls_kx_get_name (scm_to_gnutls_kx (obj, 1, "kx_print")), port);
  scm_puts (">", port);
  return 1;
}
SCM_DEFINE (scm_gnutls_kx_to_string, "kx->string", 1, 0, 0,
            (SCM enumval),
            "Return a string describing @var{enumval}, a @code{kx} value.")
#define FUNC_NAME s_scm_gnutls_kx_to_string
{
  gnutls_kx_algorithm_t c_enum;
  const char *c_string;
  c_enum = scm_to_gnutls_kx (enumval, 1, FUNC_NAME);
  c_string = gnutls_kx_get_name (c_enum);
  return (scm_from_locale_string (c_string));
}
#undef FUNC_NAME
SCM_GLOBAL_SMOB (scm_tc16_gnutls_params_enum, "params", 0);
SCM scm_gnutls_params_enum_values = SCM_EOL;
static const char *
scm_gnutls_params_to_c_string (gnutls_params_type_t c_obj)
{
  static const struct { gnutls_params_type_t value; const char *name; } table[] =
    {
#ifndef NO_GNUTLS_PARAMS_RSA_EXPORT
       { GNUTLS_PARAMS_RSA_EXPORT, "rsa-export" },
#endif /* not NO_GNUTLS_PARAMS_RSA_EXPORT */
#ifndef NO_GNUTLS_PARAMS_DH
       { GNUTLS_PARAMS_DH, "dh" },
#endif /* not NO_GNUTLS_PARAMS_DH */
    };
  unsigned i;
  const char *name = NULL;
  for (i = 0; i < sizeof (table) / sizeof (table[0]); i++)
    {
      if (table[i].value == c_obj)
        {
          name = table[i].name;
          break;
        }
    }
  return (name);
}
SCM_SMOB_PRINT (scm_tc16_gnutls_params_enum, params_print, obj, port, pstate)
{
  scm_puts ("#<gnutls-params-enum ", port);
  scm_puts (scm_gnutls_params_to_c_string (scm_to_gnutls_params (obj, 1, "params_print")), port);
  scm_puts (">", port);
  return 1;
}
SCM_DEFINE (scm_gnutls_params_to_string, "params->string", 1, 0, 0,
            (SCM enumval),
            "Return a string describing @var{enumval}, a @code{params} value.")
#define FUNC_NAME s_scm_gnutls_params_to_string
{
  gnutls_params_type_t c_enum;
  const char *c_string;
  c_enum = scm_to_gnutls_params (enumval, 1, FUNC_NAME);
  c_string = scm_gnutls_params_to_c_string (c_enum);
  return (scm_from_locale_string (c_string));
}
#undef FUNC_NAME
SCM_GLOBAL_SMOB (scm_tc16_gnutls_credentials_enum, "credentials", 0);
SCM scm_gnutls_credentials_enum_values = SCM_EOL;
static const char *
scm_gnutls_credentials_to_c_string (gnutls_credentials_type_t c_obj)
{
  static const struct { gnutls_credentials_type_t value; const char *name; } table[] =
    {
#ifndef NO_GNUTLS_CRD_CERTIFICATE
       { GNUTLS_CRD_CERTIFICATE, "certificate" },
#endif /* not NO_GNUTLS_CRD_CERTIFICATE */
#ifndef NO_GNUTLS_CRD_ANON
       { GNUTLS_CRD_ANON, "anon" },
#endif /* not NO_GNUTLS_CRD_ANON */
#ifndef NO_GNUTLS_CRD_SRP
       { GNUTLS_CRD_SRP, "srp" },
#endif /* not NO_GNUTLS_CRD_SRP */
#ifndef NO_GNUTLS_CRD_PSK
       { GNUTLS_CRD_PSK, "psk" },
#endif /* not NO_GNUTLS_CRD_PSK */
#ifndef NO_GNUTLS_CRD_IA
       { GNUTLS_CRD_IA, "ia" },
#endif /* not NO_GNUTLS_CRD_IA */
    };
  unsigned i;
  const char *name = NULL;
  for (i = 0; i < sizeof (table) / sizeof (table[0]); i++)
    {
      if (table[i].value == c_obj)
        {
          name = table[i].name;
          break;
        }
    }
  return (name);
}
SCM_SMOB_PRINT (scm_tc16_gnutls_credentials_enum, credentials_print, obj, port, pstate)
{
  scm_puts ("#<gnutls-credentials-enum ", port);
  scm_puts (scm_gnutls_credentials_to_c_string (scm_to_gnutls_credentials (obj, 1, "credentials_print")), port);
  scm_puts (">", port);
  return 1;
}
SCM_DEFINE (scm_gnutls_credentials_to_string, "credentials->string", 1, 0, 0,
            (SCM enumval),
            "Return a string describing @var{enumval}, a @code{credentials} value.")
#define FUNC_NAME s_scm_gnutls_credentials_to_string
{
  gnutls_credentials_type_t c_enum;
  const char *c_string;
  c_enum = scm_to_gnutls_credentials (enumval, 1, FUNC_NAME);
  c_string = scm_gnutls_credentials_to_c_string (c_enum);
  return (scm_from_locale_string (c_string));
}
#undef FUNC_NAME
SCM_GLOBAL_SMOB (scm_tc16_gnutls_mac_enum, "mac", 0);
SCM scm_gnutls_mac_enum_values = SCM_EOL;
SCM_SMOB_PRINT (scm_tc16_gnutls_mac_enum, mac_print, obj, port, pstate)
{
  scm_puts ("#<gnutls-mac-enum ", port);
  scm_puts (gnutls_mac_get_name (scm_to_gnutls_mac (obj, 1, "mac_print")), port);
  scm_puts (">", port);
  return 1;
}
SCM_DEFINE (scm_gnutls_mac_to_string, "mac->string", 1, 0, 0,
            (SCM enumval),
            "Return a string describing @var{enumval}, a @code{mac} value.")
#define FUNC_NAME s_scm_gnutls_mac_to_string
{
  gnutls_mac_algorithm_t c_enum;
  const char *c_string;
  c_enum = scm_to_gnutls_mac (enumval, 1, FUNC_NAME);
  c_string = gnutls_mac_get_name (c_enum);
  return (scm_from_locale_string (c_string));
}
#undef FUNC_NAME
SCM_GLOBAL_SMOB (scm_tc16_gnutls_digest_enum, "digest", 0);
SCM scm_gnutls_digest_enum_values = SCM_EOL;
static const char *
scm_gnutls_digest_to_c_string (gnutls_digest_algorithm_t c_obj)
{
  static const struct { gnutls_digest_algorithm_t value; const char *name; } table[] =
    {
#ifndef NO_GNUTLS_DIG_NULL
       { GNUTLS_DIG_NULL, "null" },
#endif /* not NO_GNUTLS_DIG_NULL */
#ifndef NO_GNUTLS_DIG_MD5
       { GNUTLS_DIG_MD5, "md5" },
#endif /* not NO_GNUTLS_DIG_MD5 */
#ifndef NO_GNUTLS_DIG_SHA1
       { GNUTLS_DIG_SHA1, "sha1" },
#endif /* not NO_GNUTLS_DIG_SHA1 */
#ifndef NO_GNUTLS_DIG_RMD160
       { GNUTLS_DIG_RMD160, "rmd160" },
#endif /* not NO_GNUTLS_DIG_RMD160 */
#ifndef NO_GNUTLS_DIG_MD2
       { GNUTLS_DIG_MD2, "md2" },
#endif /* not NO_GNUTLS_DIG_MD2 */
#ifndef NO_GNUTLS_DIG_SHA256
       { GNUTLS_DIG_SHA256, "sha256" },
#endif /* not NO_GNUTLS_DIG_SHA256 */
#ifndef NO_GNUTLS_DIG_SHA384
       { GNUTLS_DIG_SHA384, "sha384" },
#endif /* not NO_GNUTLS_DIG_SHA384 */
#ifndef NO_GNUTLS_DIG_SHA512
       { GNUTLS_DIG_SHA512, "sha512" },
#endif /* not NO_GNUTLS_DIG_SHA512 */
#ifndef NO_GNUTLS_DIG_SHA224
       { GNUTLS_DIG_SHA224, "sha224" },
#endif /* not NO_GNUTLS_DIG_SHA224 */
#ifndef NO_GNUTLS_DIG_SHA3_224
       { GNUTLS_DIG_SHA3_224, "sha3-224" },
#endif /* not NO_GNUTLS_DIG_SHA3_224 */
#ifndef NO_GNUTLS_DIG_SHA3_256
       { GNUTLS_DIG_SHA3_256, "sha3-256" },
#endif /* not NO_GNUTLS_DIG_SHA3_256 */
#ifndef NO_GNUTLS_DIG_SHA3_384
       { GNUTLS_DIG_SHA3_384, "sha3-384" },
#endif /* not NO_GNUTLS_DIG_SHA3_384 */
#ifndef NO_GNUTLS_DIG_SHA3_512
       { GNUTLS_DIG_SHA3_512, "sha3-512" },
#endif /* not NO_GNUTLS_DIG_SHA3_512 */
#ifndef NO_GNUTLS_DIG_MD5_SHA1
       { GNUTLS_DIG_MD5_SHA1, "md5-sha1" },
#endif /* not NO_GNUTLS_DIG_MD5_SHA1 */
#ifndef NO_GNUTLS_DIG_GOSTR_94
       { GNUTLS_DIG_GOSTR_94, "gostr-94" },
#endif /* not NO_GNUTLS_DIG_GOSTR_94 */
#ifndef NO_GNUTLS_DIG_STREEBOG_256
       { GNUTLS_DIG_STREEBOG_256, "streebog-256" },
#endif /* not NO_GNUTLS_DIG_STREEBOG_256 */
#ifndef NO_GNUTLS_DIG_STREEBOG_512
       { GNUTLS_DIG_STREEBOG_512, "streebog-512" },
#endif /* not NO_GNUTLS_DIG_STREEBOG_512 */
    };
  unsigned i;
  const char *name = NULL;
  for (i = 0; i < sizeof (table) / sizeof (table[0]); i++)
    {
      if (table[i].value == c_obj)
        {
          name = table[i].name;
          break;
        }
    }
  return (name);
}
SCM_SMOB_PRINT (scm_tc16_gnutls_digest_enum, digest_print, obj, port, pstate)
{
  scm_puts ("#<gnutls-digest-enum ", port);
  scm_puts (scm_gnutls_digest_to_c_string (scm_to_gnutls_digest (obj, 1, "digest_print")), port);
  scm_puts (">", port);
  return 1;
}
SCM_DEFINE (scm_gnutls_digest_to_string, "digest->string", 1, 0, 0,
            (SCM enumval),
            "Return a string describing @var{enumval}, a @code{digest} value.")
#define FUNC_NAME s_scm_gnutls_digest_to_string
{
  gnutls_digest_algorithm_t c_enum;
  const char *c_string;
  c_enum = scm_to_gnutls_digest (enumval, 1, FUNC_NAME);
  c_string = scm_gnutls_digest_to_c_string (c_enum);
  return (scm_from_locale_string (c_string));
}
#undef FUNC_NAME
SCM_GLOBAL_SMOB (scm_tc16_gnutls_compression_method_enum, "compression-method", 0);
SCM scm_gnutls_compression_method_enum_values = SCM_EOL;
SCM_SMOB_PRINT (scm_tc16_gnutls_compression_method_enum, compression_method_print, obj, port, pstate)
{
  scm_puts ("#<gnutls-compression-method-enum ", port);
  scm_puts (gnutls_compression_get_name (scm_to_gnutls_compression_method (obj, 1, "compression_method_print")), port);
  scm_puts (">", port);
  return 1;
}
SCM_DEFINE (scm_gnutls_compression_method_to_string, "compression-method->string", 1, 0, 0,
            (SCM enumval),
            "Return a string describing @var{enumval}, a @code{compression-method} value.")
#define FUNC_NAME s_scm_gnutls_compression_method_to_string
{
  gnutls_compression_method_t c_enum;
  const char *c_string;
  c_enum = scm_to_gnutls_compression_method (enumval, 1, FUNC_NAME);
  c_string = gnutls_compression_get_name (c_enum);
  return (scm_from_locale_string (c_string));
}
#undef FUNC_NAME
SCM_GLOBAL_SMOB (scm_tc16_gnutls_connection_end_enum, "connection-end", 0);
SCM scm_gnutls_connection_end_enum_values = SCM_EOL;
static const char *
scm_gnutls_connection_end_to_c_string (gnutls_connection_end_t c_obj)
{
  static const struct { gnutls_connection_end_t value; const char *name; } table[] =
    {
#ifndef NO_GNUTLS_SERVER
       { GNUTLS_SERVER, "server" },
#endif /* not NO_GNUTLS_SERVER */
#ifndef NO_GNUTLS_CLIENT
       { GNUTLS_CLIENT, "client" },
#endif /* not NO_GNUTLS_CLIENT */
    };
  unsigned i;
  const char *name = NULL;
  for (i = 0; i < sizeof (table) / sizeof (table[0]); i++)
    {
      if (table[i].value == c_obj)
        {
          name = table[i].name;
          break;
        }
    }
  return (name);
}
SCM_SMOB_PRINT (scm_tc16_gnutls_connection_end_enum, connection_end_print, obj, port, pstate)
{
  scm_puts ("#<gnutls-connection-end-enum ", port);
  scm_puts (scm_gnutls_connection_end_to_c_string (scm_to_gnutls_connection_end (obj, 1, "connection_end_print")), port);
  scm_puts (">", port);
  return 1;
}
SCM_DEFINE (scm_gnutls_connection_end_to_string, "connection-end->string", 1, 0, 0,
            (SCM enumval),
            "Return a string describing @var{enumval}, a @code{connection-end} value.")
#define FUNC_NAME s_scm_gnutls_connection_end_to_string
{
  gnutls_connection_end_t c_enum;
  const char *c_string;
  c_enum = scm_to_gnutls_connection_end (enumval, 1, FUNC_NAME);
  c_string = scm_gnutls_connection_end_to_c_string (c_enum);
  return (scm_from_locale_string (c_string));
}
#undef FUNC_NAME
SCM_GLOBAL_SMOB (scm_tc16_gnutls_connection_flag_enum, "connection-flag", 0);
SCM scm_gnutls_connection_flag_enum_values = SCM_EOL;
static const char *
scm_gnutls_connection_flag_to_c_string (gnutls_init_flags_t c_obj)
{
  static const struct { gnutls_init_flags_t value; const char *name; } table[] =
    {
#ifndef NO_GNUTLS_DATAGRAM
       { GNUTLS_DATAGRAM, "datagram" },
#endif /* not NO_GNUTLS_DATAGRAM */
#ifndef NO_GNUTLS_NONBLOCK
       { GNUTLS_NONBLOCK, "nonblock" },
#endif /* not NO_GNUTLS_NONBLOCK */
#ifndef NO_GNUTLS_NO_EXTENSIONS
       { GNUTLS_NO_EXTENSIONS, "no-extensions" },
#endif /* not NO_GNUTLS_NO_EXTENSIONS */
#ifndef NO_GNUTLS_NO_REPLAY_PROTECTION
       { GNUTLS_NO_REPLAY_PROTECTION, "no-replay-protection" },
#endif /* not NO_GNUTLS_NO_REPLAY_PROTECTION */
#ifndef NO_GNUTLS_NO_SIGNAL
       { GNUTLS_NO_SIGNAL, "no-signal" },
#endif /* not NO_GNUTLS_NO_SIGNAL */
#ifndef NO_GNUTLS_ALLOW_ID_CHANGE
       { GNUTLS_ALLOW_ID_CHANGE, "allow-id-change" },
#endif /* not NO_GNUTLS_ALLOW_ID_CHANGE */
#ifndef NO_GNUTLS_ENABLE_FALSE_START
       { GNUTLS_ENABLE_FALSE_START, "enable-false-start" },
#endif /* not NO_GNUTLS_ENABLE_FALSE_START */
#ifndef NO_GNUTLS_FORCE_CLIENT_CERT
       { GNUTLS_FORCE_CLIENT_CERT, "force-client-cert" },
#endif /* not NO_GNUTLS_FORCE_CLIENT_CERT */
#ifndef NO_GNUTLS_NO_TICKETS
       { GNUTLS_NO_TICKETS, "no-tickets" },
#endif /* not NO_GNUTLS_NO_TICKETS */
#ifndef NO_GNUTLS_KEY_SHARE_TOP
       { GNUTLS_KEY_SHARE_TOP, "key-share-top" },
#endif /* not NO_GNUTLS_KEY_SHARE_TOP */
#ifndef NO_GNUTLS_KEY_SHARE_TOP2
       { GNUTLS_KEY_SHARE_TOP2, "key-share-top2" },
#endif /* not NO_GNUTLS_KEY_SHARE_TOP2 */
#ifndef NO_GNUTLS_KEY_SHARE_TOP3
       { GNUTLS_KEY_SHARE_TOP3, "key-share-top3" },
#endif /* not NO_GNUTLS_KEY_SHARE_TOP3 */
#ifndef NO_GNUTLS_POST_HANDSHAKE_AUTH
       { GNUTLS_POST_HANDSHAKE_AUTH, "post-handshake-auth" },
#endif /* not NO_GNUTLS_POST_HANDSHAKE_AUTH */
#ifndef NO_GNUTLS_NO_AUTO_REKEY
       { GNUTLS_NO_AUTO_REKEY, "no-auto-rekey" },
#endif /* not NO_GNUTLS_NO_AUTO_REKEY */
#ifndef NO_GNUTLS_SAFE_PADDING_CHECK
       { GNUTLS_SAFE_PADDING_CHECK, "safe-padding-check" },
#endif /* not NO_GNUTLS_SAFE_PADDING_CHECK */
#ifndef NO_GNUTLS_ENABLE_EARLY_START
       { GNUTLS_ENABLE_EARLY_START, "enable-early-start" },
#endif /* not NO_GNUTLS_ENABLE_EARLY_START */
#ifndef NO_GNUTLS_ENABLE_RAWPK
       { GNUTLS_ENABLE_RAWPK, "enable-rawpk" },
#endif /* not NO_GNUTLS_ENABLE_RAWPK */
#ifndef NO_GNUTLS_AUTO_REAUTH
       { GNUTLS_AUTO_REAUTH, "auto-reauth" },
#endif /* not NO_GNUTLS_AUTO_REAUTH */
#ifndef NO_GNUTLS_ENABLE_EARLY_DATA
       { GNUTLS_ENABLE_EARLY_DATA, "enable-early-data" },
#endif /* not NO_GNUTLS_ENABLE_EARLY_DATA */
    };
  unsigned i;
  const char *name = NULL;
  for (i = 0; i < sizeof (table) / sizeof (table[0]); i++)
    {
      if (table[i].value == c_obj)
        {
          name = table[i].name;
          break;
        }
    }
  return (name);
}
SCM_SMOB_PRINT (scm_tc16_gnutls_connection_flag_enum, connection_flag_print, obj, port, pstate)
{
  scm_puts ("#<gnutls-connection-flag-enum ", port);
  scm_puts (scm_gnutls_connection_flag_to_c_string (scm_to_gnutls_connection_flag (obj, 1, "connection_flag_print")), port);
  scm_puts (">", port);
  return 1;
}
SCM_DEFINE (scm_gnutls_connection_flag_to_string, "connection-flag->string", 1, 0, 0,
            (SCM enumval),
            "Return a string describing @var{enumval}, a @code{connection-flag} value.")
#define FUNC_NAME s_scm_gnutls_connection_flag_to_string
{
  gnutls_init_flags_t c_enum;
  const char *c_string;
  c_enum = scm_to_gnutls_connection_flag (enumval, 1, FUNC_NAME);
  c_string = scm_gnutls_connection_flag_to_c_string (c_enum);
  return (scm_from_locale_string (c_string));
}
#undef FUNC_NAME
SCM_GLOBAL_SMOB (scm_tc16_gnutls_alert_level_enum, "alert-level", 0);
SCM scm_gnutls_alert_level_enum_values = SCM_EOL;
static const char *
scm_gnutls_alert_level_to_c_string (gnutls_alert_level_t c_obj)
{
  static const struct { gnutls_alert_level_t value; const char *name; } table[] =
    {
#ifndef NO_GNUTLS_AL_WARNING
       { GNUTLS_AL_WARNING, "warning" },
#endif /* not NO_GNUTLS_AL_WARNING */
#ifndef NO_GNUTLS_AL_FATAL
       { GNUTLS_AL_FATAL, "fatal" },
#endif /* not NO_GNUTLS_AL_FATAL */
    };
  unsigned i;
  const char *name = NULL;
  for (i = 0; i < sizeof (table) / sizeof (table[0]); i++)
    {
      if (table[i].value == c_obj)
        {
          name = table[i].name;
          break;
        }
    }
  return (name);
}
SCM_SMOB_PRINT (scm_tc16_gnutls_alert_level_enum, alert_level_print, obj, port, pstate)
{
  scm_puts ("#<gnutls-alert-level-enum ", port);
  scm_puts (scm_gnutls_alert_level_to_c_string (scm_to_gnutls_alert_level (obj, 1, "alert_level_print")), port);
  scm_puts (">", port);
  return 1;
}
SCM_DEFINE (scm_gnutls_alert_level_to_string, "alert-level->string", 1, 0, 0,
            (SCM enumval),
            "Return a string describing @var{enumval}, a @code{alert-level} value.")
#define FUNC_NAME s_scm_gnutls_alert_level_to_string
{
  gnutls_alert_level_t c_enum;
  const char *c_string;
  c_enum = scm_to_gnutls_alert_level (enumval, 1, FUNC_NAME);
  c_string = scm_gnutls_alert_level_to_c_string (c_enum);
  return (scm_from_locale_string (c_string));
}
#undef FUNC_NAME
SCM_GLOBAL_SMOB (scm_tc16_gnutls_alert_description_enum, "alert-description", 0);
SCM scm_gnutls_alert_description_enum_values = SCM_EOL;
static const char *
scm_gnutls_alert_description_to_c_string (gnutls_alert_description_t c_obj)
{
  static const struct { gnutls_alert_description_t value; const char *name; } table[] =
    {
#ifndef NO_GNUTLS_A_CLOSE_NOTIFY
       { GNUTLS_A_CLOSE_NOTIFY, "close-notify" },
#endif /* not NO_GNUTLS_A_CLOSE_NOTIFY */
#ifndef NO_GNUTLS_A_UNEXPECTED_MESSAGE
       { GNUTLS_A_UNEXPECTED_MESSAGE, "unexpected-message" },
#endif /* not NO_GNUTLS_A_UNEXPECTED_MESSAGE */
#ifndef NO_GNUTLS_A_BAD_RECORD_MAC
       { GNUTLS_A_BAD_RECORD_MAC, "bad-record-mac" },
#endif /* not NO_GNUTLS_A_BAD_RECORD_MAC */
#ifndef NO_GNUTLS_A_DECRYPTION_FAILED
       { GNUTLS_A_DECRYPTION_FAILED, "decryption-failed" },
#endif /* not NO_GNUTLS_A_DECRYPTION_FAILED */
#ifndef NO_GNUTLS_A_RECORD_OVERFLOW
       { GNUTLS_A_RECORD_OVERFLOW, "record-overflow" },
#endif /* not NO_GNUTLS_A_RECORD_OVERFLOW */
#ifndef NO_GNUTLS_A_DECOMPRESSION_FAILURE
       { GNUTLS_A_DECOMPRESSION_FAILURE, "decompression-failure" },
#endif /* not NO_GNUTLS_A_DECOMPRESSION_FAILURE */
#ifndef NO_GNUTLS_A_HANDSHAKE_FAILURE
       { GNUTLS_A_HANDSHAKE_FAILURE, "handshake-failure" },
#endif /* not NO_GNUTLS_A_HANDSHAKE_FAILURE */
#ifndef NO_GNUTLS_A_SSL3_NO_CERTIFICATE
       { GNUTLS_A_SSL3_NO_CERTIFICATE, "ssl3-no-certificate" },
#endif /* not NO_GNUTLS_A_SSL3_NO_CERTIFICATE */
#ifndef NO_GNUTLS_A_BAD_CERTIFICATE
       { GNUTLS_A_BAD_CERTIFICATE, "bad-certificate" },
#endif /* not NO_GNUTLS_A_BAD_CERTIFICATE */
#ifndef NO_GNUTLS_A_UNSUPPORTED_CERTIFICATE
       { GNUTLS_A_UNSUPPORTED_CERTIFICATE, "unsupported-certificate" },
#endif /* not NO_GNUTLS_A_UNSUPPORTED_CERTIFICATE */
#ifndef NO_GNUTLS_A_CERTIFICATE_REVOKED
       { GNUTLS_A_CERTIFICATE_REVOKED, "certificate-revoked" },
#endif /* not NO_GNUTLS_A_CERTIFICATE_REVOKED */
#ifndef NO_GNUTLS_A_CERTIFICATE_EXPIRED
       { GNUTLS_A_CERTIFICATE_EXPIRED, "certificate-expired" },
#endif /* not NO_GNUTLS_A_CERTIFICATE_EXPIRED */
#ifndef NO_GNUTLS_A_CERTIFICATE_UNKNOWN
       { GNUTLS_A_CERTIFICATE_UNKNOWN, "certificate-unknown" },
#endif /* not NO_GNUTLS_A_CERTIFICATE_UNKNOWN */
#ifndef NO_GNUTLS_A_ILLEGAL_PARAMETER
       { GNUTLS_A_ILLEGAL_PARAMETER, "illegal-parameter" },
#endif /* not NO_GNUTLS_A_ILLEGAL_PARAMETER */
#ifndef NO_GNUTLS_A_UNKNOWN_CA
       { GNUTLS_A_UNKNOWN_CA, "unknown-ca" },
#endif /* not NO_GNUTLS_A_UNKNOWN_CA */
#ifndef NO_GNUTLS_A_ACCESS_DENIED
       { GNUTLS_A_ACCESS_DENIED, "access-denied" },
#endif /* not NO_GNUTLS_A_ACCESS_DENIED */
#ifndef NO_GNUTLS_A_DECODE_ERROR
       { GNUTLS_A_DECODE_ERROR, "decode-error" },
#endif /* not NO_GNUTLS_A_DECODE_ERROR */
#ifndef NO_GNUTLS_A_DECRYPT_ERROR
       { GNUTLS_A_DECRYPT_ERROR, "decrypt-error" },
#endif /* not NO_GNUTLS_A_DECRYPT_ERROR */
#ifndef NO_GNUTLS_A_EXPORT_RESTRICTION
       { GNUTLS_A_EXPORT_RESTRICTION, "export-restriction" },
#endif /* not NO_GNUTLS_A_EXPORT_RESTRICTION */
#ifndef NO_GNUTLS_A_PROTOCOL_VERSION
       { GNUTLS_A_PROTOCOL_VERSION, "protocol-version" },
#endif /* not NO_GNUTLS_A_PROTOCOL_VERSION */
#ifndef NO_GNUTLS_A_INSUFFICIENT_SECURITY
       { GNUTLS_A_INSUFFICIENT_SECURITY, "insufficient-security" },
#endif /* not NO_GNUTLS_A_INSUFFICIENT_SECURITY */
#ifndef NO_GNUTLS_A_INTERNAL_ERROR
       { GNUTLS_A_INTERNAL_ERROR, "internal-error" },
#endif /* not NO_GNUTLS_A_INTERNAL_ERROR */
#ifndef NO_GNUTLS_A_USER_CANCELED
       { GNUTLS_A_USER_CANCELED, "user-canceled" },
#endif /* not NO_GNUTLS_A_USER_CANCELED */
#ifndef NO_GNUTLS_A_NO_RENEGOTIATION
       { GNUTLS_A_NO_RENEGOTIATION, "no-renegotiation" },
#endif /* not NO_GNUTLS_A_NO_RENEGOTIATION */
#ifndef NO_GNUTLS_A_UNSUPPORTED_EXTENSION
       { GNUTLS_A_UNSUPPORTED_EXTENSION, "unsupported-extension" },
#endif /* not NO_GNUTLS_A_UNSUPPORTED_EXTENSION */
#ifndef NO_GNUTLS_A_CERTIFICATE_UNOBTAINABLE
       { GNUTLS_A_CERTIFICATE_UNOBTAINABLE, "certificate-unobtainable" },
#endif /* not NO_GNUTLS_A_CERTIFICATE_UNOBTAINABLE */
#ifndef NO_GNUTLS_A_UNRECOGNIZED_NAME
       { GNUTLS_A_UNRECOGNIZED_NAME, "unrecognized-name" },
#endif /* not NO_GNUTLS_A_UNRECOGNIZED_NAME */
#ifndef NO_GNUTLS_A_UNKNOWN_PSK_IDENTITY
       { GNUTLS_A_UNKNOWN_PSK_IDENTITY, "unknown-psk-identity" },
#endif /* not NO_GNUTLS_A_UNKNOWN_PSK_IDENTITY */
    };
  unsigned i;
  const char *name = NULL;
  for (i = 0; i < sizeof (table) / sizeof (table[0]); i++)
    {
      if (table[i].value == c_obj)
        {
          name = table[i].name;
          break;
        }
    }
  return (name);
}
SCM_SMOB_PRINT (scm_tc16_gnutls_alert_description_enum, alert_description_print, obj, port, pstate)
{
  scm_puts ("#<gnutls-alert-description-enum ", port);
  scm_puts (scm_gnutls_alert_description_to_c_string (scm_to_gnutls_alert_description (obj, 1, "alert_description_print")), port);
  scm_puts (">", port);
  return 1;
}
SCM_DEFINE (scm_gnutls_alert_description_to_string, "alert-description->string", 1, 0, 0,
            (SCM enumval),
            "Return a string describing @var{enumval}, a @code{alert-description} value.")
#define FUNC_NAME s_scm_gnutls_alert_description_to_string
{
  gnutls_alert_description_t c_enum;
  const char *c_string;
  c_enum = scm_to_gnutls_alert_description (enumval, 1, FUNC_NAME);
  c_string = scm_gnutls_alert_description_to_c_string (c_enum);
  return (scm_from_locale_string (c_string));
}
#undef FUNC_NAME
SCM_GLOBAL_SMOB (scm_tc16_gnutls_handshake_description_enum, "handshake-description", 0);
SCM scm_gnutls_handshake_description_enum_values = SCM_EOL;
static const char *
scm_gnutls_handshake_description_to_c_string (gnutls_handshake_description_t c_obj)
{
  static const struct { gnutls_handshake_description_t value; const char *name; } table[] =
    {
#ifndef NO_GNUTLS_HANDSHAKE_HELLO_REQUEST
       { GNUTLS_HANDSHAKE_HELLO_REQUEST, "hello-request" },
#endif /* not NO_GNUTLS_HANDSHAKE_HELLO_REQUEST */
#ifndef NO_GNUTLS_HANDSHAKE_CLIENT_HELLO
       { GNUTLS_HANDSHAKE_CLIENT_HELLO, "client-hello" },
#endif /* not NO_GNUTLS_HANDSHAKE_CLIENT_HELLO */
#ifndef NO_GNUTLS_HANDSHAKE_SERVER_HELLO
       { GNUTLS_HANDSHAKE_SERVER_HELLO, "server-hello" },
#endif /* not NO_GNUTLS_HANDSHAKE_SERVER_HELLO */
#ifndef NO_GNUTLS_HANDSHAKE_CERTIFICATE_PKT
       { GNUTLS_HANDSHAKE_CERTIFICATE_PKT, "certificate-pkt" },
#endif /* not NO_GNUTLS_HANDSHAKE_CERTIFICATE_PKT */
#ifndef NO_GNUTLS_HANDSHAKE_SERVER_KEY_EXCHANGE
       { GNUTLS_HANDSHAKE_SERVER_KEY_EXCHANGE, "server-key-exchange" },
#endif /* not NO_GNUTLS_HANDSHAKE_SERVER_KEY_EXCHANGE */
#ifndef NO_GNUTLS_HANDSHAKE_CERTIFICATE_REQUEST
       { GNUTLS_HANDSHAKE_CERTIFICATE_REQUEST, "certificate-request" },
#endif /* not NO_GNUTLS_HANDSHAKE_CERTIFICATE_REQUEST */
#ifndef NO_GNUTLS_HANDSHAKE_SERVER_HELLO_DONE
       { GNUTLS_HANDSHAKE_SERVER_HELLO_DONE, "server-hello-done" },
#endif /* not NO_GNUTLS_HANDSHAKE_SERVER_HELLO_DONE */
#ifndef NO_GNUTLS_HANDSHAKE_CERTIFICATE_VERIFY
       { GNUTLS_HANDSHAKE_CERTIFICATE_VERIFY, "certificate-verify" },
#endif /* not NO_GNUTLS_HANDSHAKE_CERTIFICATE_VERIFY */
#ifndef NO_GNUTLS_HANDSHAKE_CLIENT_KEY_EXCHANGE
       { GNUTLS_HANDSHAKE_CLIENT_KEY_EXCHANGE, "client-key-exchange" },
#endif /* not NO_GNUTLS_HANDSHAKE_CLIENT_KEY_EXCHANGE */
#ifndef NO_GNUTLS_HANDSHAKE_FINISHED
       { GNUTLS_HANDSHAKE_FINISHED, "finished" },
#endif /* not NO_GNUTLS_HANDSHAKE_FINISHED */
    };
  unsigned i;
  const char *name = NULL;
  for (i = 0; i < sizeof (table) / sizeof (table[0]); i++)
    {
      if (table[i].value == c_obj)
        {
          name = table[i].name;
          break;
        }
    }
  return (name);
}
SCM_SMOB_PRINT (scm_tc16_gnutls_handshake_description_enum, handshake_description_print, obj, port, pstate)
{
  scm_puts ("#<gnutls-handshake-description-enum ", port);
  scm_puts (scm_gnutls_handshake_description_to_c_string (scm_to_gnutls_handshake_description (obj, 1, "handshake_description_print")), port);
  scm_puts (">", port);
  return 1;
}
SCM_DEFINE (scm_gnutls_handshake_description_to_string, "handshake-description->string", 1, 0, 0,
            (SCM enumval),
            "Return a string describing @var{enumval}, a @code{handshake-description} value.")
#define FUNC_NAME s_scm_gnutls_handshake_description_to_string
{
  gnutls_handshake_description_t c_enum;
  const char *c_string;
  c_enum = scm_to_gnutls_handshake_description (enumval, 1, FUNC_NAME);
  c_string = scm_gnutls_handshake_description_to_c_string (c_enum);
  return (scm_from_locale_string (c_string));
}
#undef FUNC_NAME
SCM_GLOBAL_SMOB (scm_tc16_gnutls_certificate_status_enum, "certificate-status", 0);
SCM scm_gnutls_certificate_status_enum_values = SCM_EOL;
static const char *
scm_gnutls_certificate_status_to_c_string (gnutls_certificate_status_t c_obj)
{
  static const struct { gnutls_certificate_status_t value; const char *name; } table[] =
    {
#ifndef NO_GNUTLS_CERT_INVALID
       { GNUTLS_CERT_INVALID, "invalid" },
#endif /* not NO_GNUTLS_CERT_INVALID */
#ifndef NO_GNUTLS_CERT_REVOKED
       { GNUTLS_CERT_REVOKED, "revoked" },
#endif /* not NO_GNUTLS_CERT_REVOKED */
#ifndef NO_GNUTLS_CERT_SIGNER_NOT_FOUND
       { GNUTLS_CERT_SIGNER_NOT_FOUND, "signer-not-found" },
#endif /* not NO_GNUTLS_CERT_SIGNER_NOT_FOUND */
#ifndef NO_GNUTLS_CERT_SIGNER_NOT_CA
       { GNUTLS_CERT_SIGNER_NOT_CA, "signer-not-ca" },
#endif /* not NO_GNUTLS_CERT_SIGNER_NOT_CA */
#ifndef NO_GNUTLS_CERT_INSECURE_ALGORITHM
       { GNUTLS_CERT_INSECURE_ALGORITHM, "insecure-algorithm" },
#endif /* not NO_GNUTLS_CERT_INSECURE_ALGORITHM */
#ifndef NO_GNUTLS_CERT_NOT_ACTIVATED
       { GNUTLS_CERT_NOT_ACTIVATED, "not-activated" },
#endif /* not NO_GNUTLS_CERT_NOT_ACTIVATED */
#ifndef NO_GNUTLS_CERT_EXPIRED
       { GNUTLS_CERT_EXPIRED, "expired" },
#endif /* not NO_GNUTLS_CERT_EXPIRED */
#ifndef NO_GNUTLS_CERT_SIGNATURE_FAILURE
       { GNUTLS_CERT_SIGNATURE_FAILURE, "signature-failure" },
#endif /* not NO_GNUTLS_CERT_SIGNATURE_FAILURE */
#ifndef NO_GNUTLS_CERT_REVOCATION_DATA_SUPERSEDED
       { GNUTLS_CERT_REVOCATION_DATA_SUPERSEDED, "revocation-data-superseded" },
#endif /* not NO_GNUTLS_CERT_REVOCATION_DATA_SUPERSEDED */
#ifndef NO_GNUTLS_CERT_UNEXPECTED_OWNER
       { GNUTLS_CERT_UNEXPECTED_OWNER, "unexpected-owner" },
#endif /* not NO_GNUTLS_CERT_UNEXPECTED_OWNER */
#ifndef NO_GNUTLS_CERT_REVOCATION_DATA_ISSUED_IN_FUTURE
       { GNUTLS_CERT_REVOCATION_DATA_ISSUED_IN_FUTURE, "revocation-data-issued-in-future" },
#endif /* not NO_GNUTLS_CERT_REVOCATION_DATA_ISSUED_IN_FUTURE */
#ifndef NO_GNUTLS_CERT_SIGNER_CONSTRAINTS_FAILURE
       { GNUTLS_CERT_SIGNER_CONSTRAINTS_FAILURE, "signer-constraints-failure" },
#endif /* not NO_GNUTLS_CERT_SIGNER_CONSTRAINTS_FAILURE */
#ifndef NO_GNUTLS_CERT_MISMATCH
       { GNUTLS_CERT_MISMATCH, "mismatch" },
#endif /* not NO_GNUTLS_CERT_MISMATCH */
#ifndef NO_GNUTLS_CERT_PURPOSE_MISMATCH
       { GNUTLS_CERT_PURPOSE_MISMATCH, "purpose-mismatch" },
#endif /* not NO_GNUTLS_CERT_PURPOSE_MISMATCH */
#ifndef NO_GNUTLS_CERT_MISSING_OCSP_STATUS
       { GNUTLS_CERT_MISSING_OCSP_STATUS, "missing-ocsp-status" },
#endif /* not NO_GNUTLS_CERT_MISSING_OCSP_STATUS */
#ifndef NO_GNUTLS_CERT_INVALID_OCSP_STATUS
       { GNUTLS_CERT_INVALID_OCSP_STATUS, "invalid-ocsp-status" },
#endif /* not NO_GNUTLS_CERT_INVALID_OCSP_STATUS */
#ifndef NO_GNUTLS_CERT_UNKNOWN_CRIT_EXTENSIONS
       { GNUTLS_CERT_UNKNOWN_CRIT_EXTENSIONS, "unknown-crit-extensions" },
#endif /* not NO_GNUTLS_CERT_UNKNOWN_CRIT_EXTENSIONS */
    };
  unsigned i;
  const char *name = NULL;
  for (i = 0; i < sizeof (table) / sizeof (table[0]); i++)
    {
      if (table[i].value == c_obj)
        {
          name = table[i].name;
          break;
        }
    }
  return (name);
}
SCM_SMOB_PRINT (scm_tc16_gnutls_certificate_status_enum, certificate_status_print, obj, port, pstate)
{
  scm_puts ("#<gnutls-certificate-status-enum ", port);
  scm_puts (scm_gnutls_certificate_status_to_c_string (scm_to_gnutls_certificate_status (obj, 1, "certificate_status_print")), port);
  scm_puts (">", port);
  return 1;
}
SCM_DEFINE (scm_gnutls_certificate_status_to_string, "certificate-status->string", 1, 0, 0,
            (SCM enumval),
            "Return a string describing @var{enumval}, a @code{certificate-status} value.")
#define FUNC_NAME s_scm_gnutls_certificate_status_to_string
{
  gnutls_certificate_status_t c_enum;
  const char *c_string;
  c_enum = scm_to_gnutls_certificate_status (enumval, 1, FUNC_NAME);
  c_string = scm_gnutls_certificate_status_to_c_string (c_enum);
  return (scm_from_locale_string (c_string));
}
#undef FUNC_NAME
SCM_GLOBAL_SMOB (scm_tc16_gnutls_certificate_request_enum, "certificate-request", 0);
SCM scm_gnutls_certificate_request_enum_values = SCM_EOL;
static const char *
scm_gnutls_certificate_request_to_c_string (gnutls_certificate_request_t c_obj)
{
  static const struct { gnutls_certificate_request_t value; const char *name; } table[] =
    {
#ifndef NO_GNUTLS_CERT_IGNORE
       { GNUTLS_CERT_IGNORE, "ignore" },
#endif /* not NO_GNUTLS_CERT_IGNORE */
#ifndef NO_GNUTLS_CERT_REQUEST
       { GNUTLS_CERT_REQUEST, "request" },
#endif /* not NO_GNUTLS_CERT_REQUEST */
#ifndef NO_GNUTLS_CERT_REQUIRE
       { GNUTLS_CERT_REQUIRE, "require" },
#endif /* not NO_GNUTLS_CERT_REQUIRE */
    };
  unsigned i;
  const char *name = NULL;
  for (i = 0; i < sizeof (table) / sizeof (table[0]); i++)
    {
      if (table[i].value == c_obj)
        {
          name = table[i].name;
          break;
        }
    }
  return (name);
}
SCM_SMOB_PRINT (scm_tc16_gnutls_certificate_request_enum, certificate_request_print, obj, port, pstate)
{
  scm_puts ("#<gnutls-certificate-request-enum ", port);
  scm_puts (scm_gnutls_certificate_request_to_c_string (scm_to_gnutls_certificate_request (obj, 1, "certificate_request_print")), port);
  scm_puts (">", port);
  return 1;
}
SCM_DEFINE (scm_gnutls_certificate_request_to_string, "certificate-request->string", 1, 0, 0,
            (SCM enumval),
            "Return a string describing @var{enumval}, a @code{certificate-request} value.")
#define FUNC_NAME s_scm_gnutls_certificate_request_to_string
{
  gnutls_certificate_request_t c_enum;
  const char *c_string;
  c_enum = scm_to_gnutls_certificate_request (enumval, 1, FUNC_NAME);
  c_string = scm_gnutls_certificate_request_to_c_string (c_enum);
  return (scm_from_locale_string (c_string));
}
#undef FUNC_NAME
SCM_GLOBAL_SMOB (scm_tc16_gnutls_close_request_enum, "close-request", 0);
SCM scm_gnutls_close_request_enum_values = SCM_EOL;
static const char *
scm_gnutls_close_request_to_c_string (gnutls_close_request_t c_obj)
{
  static const struct { gnutls_close_request_t value; const char *name; } table[] =
    {
#ifndef NO_GNUTLS_SHUT_RDWR
       { GNUTLS_SHUT_RDWR, "rdwr" },
#endif /* not NO_GNUTLS_SHUT_RDWR */
#ifndef NO_GNUTLS_SHUT_WR
       { GNUTLS_SHUT_WR, "wr" },
#endif /* not NO_GNUTLS_SHUT_WR */
    };
  unsigned i;
  const char *name = NULL;
  for (i = 0; i < sizeof (table) / sizeof (table[0]); i++)
    {
      if (table[i].value == c_obj)
        {
          name = table[i].name;
          break;
        }
    }
  return (name);
}
SCM_SMOB_PRINT (scm_tc16_gnutls_close_request_enum, close_request_print, obj, port, pstate)
{
  scm_puts ("#<gnutls-close-request-enum ", port);
  scm_puts (scm_gnutls_close_request_to_c_string (scm_to_gnutls_close_request (obj, 1, "close_request_print")), port);
  scm_puts (">", port);
  return 1;
}
SCM_DEFINE (scm_gnutls_close_request_to_string, "close-request->string", 1, 0, 0,
            (SCM enumval),
            "Return a string describing @var{enumval}, a @code{close-request} value.")
#define FUNC_NAME s_scm_gnutls_close_request_to_string
{
  gnutls_close_request_t c_enum;
  const char *c_string;
  c_enum = scm_to_gnutls_close_request (enumval, 1, FUNC_NAME);
  c_string = scm_gnutls_close_request_to_c_string (c_enum);
  return (scm_from_locale_string (c_string));
}
#undef FUNC_NAME
SCM_GLOBAL_SMOB (scm_tc16_gnutls_protocol_enum, "protocol", 0);
SCM scm_gnutls_protocol_enum_values = SCM_EOL;
static const char *
scm_gnutls_protocol_to_c_string (gnutls_protocol_t c_obj)
{
  static const struct { gnutls_protocol_t value; const char *name; } table[] =
    {
#ifndef NO_GNUTLS_SSL3
       { GNUTLS_SSL3, "ssl3" },
#endif /* not NO_GNUTLS_SSL3 */
#ifndef NO_GNUTLS_TLS1_0
       { GNUTLS_TLS1_0, "tls1-0" },
#endif /* not NO_GNUTLS_TLS1_0 */
#ifndef NO_GNUTLS_TLS1_1
       { GNUTLS_TLS1_1, "tls1-1" },
#endif /* not NO_GNUTLS_TLS1_1 */
#ifndef NO_GNUTLS_VERSION_UNKNOWN
       { GNUTLS_VERSION_UNKNOWN, "version-unknown" },
#endif /* not NO_GNUTLS_VERSION_UNKNOWN */
    };
  unsigned i;
  const char *name = NULL;
  for (i = 0; i < sizeof (table) / sizeof (table[0]); i++)
    {
      if (table[i].value == c_obj)
        {
          name = table[i].name;
          break;
        }
    }
  return (name);
}
SCM_SMOB_PRINT (scm_tc16_gnutls_protocol_enum, protocol_print, obj, port, pstate)
{
  scm_puts ("#<gnutls-protocol-enum ", port);
  scm_puts (scm_gnutls_protocol_to_c_string (scm_to_gnutls_protocol (obj, 1, "protocol_print")), port);
  scm_puts (">", port);
  return 1;
}
SCM_DEFINE (scm_gnutls_protocol_to_string, "protocol->string", 1, 0, 0,
            (SCM enumval),
            "Return a string describing @var{enumval}, a @code{protocol} value.")
#define FUNC_NAME s_scm_gnutls_protocol_to_string
{
  gnutls_protocol_t c_enum;
  const char *c_string;
  c_enum = scm_to_gnutls_protocol (enumval, 1, FUNC_NAME);
  c_string = scm_gnutls_protocol_to_c_string (c_enum);
  return (scm_from_locale_string (c_string));
}
#undef FUNC_NAME
SCM_GLOBAL_SMOB (scm_tc16_gnutls_certificate_type_enum, "certificate-type", 0);
SCM scm_gnutls_certificate_type_enum_values = SCM_EOL;
SCM_SMOB_PRINT (scm_tc16_gnutls_certificate_type_enum, certificate_type_print, obj, port, pstate)
{
  scm_puts ("#<gnutls-certificate-type-enum ", port);
  scm_puts (gnutls_certificate_type_get_name (scm_to_gnutls_certificate_type (obj, 1, "certificate_type_print")), port);
  scm_puts (">", port);
  return 1;
}
SCM_DEFINE (scm_gnutls_certificate_type_to_string, "certificate-type->string", 1, 0, 0,
            (SCM enumval),
            "Return a string describing @var{enumval}, a @code{certificate-type} value.")
#define FUNC_NAME s_scm_gnutls_certificate_type_to_string
{
  gnutls_certificate_type_t c_enum;
  const char *c_string;
  c_enum = scm_to_gnutls_certificate_type (enumval, 1, FUNC_NAME);
  c_string = gnutls_certificate_type_get_name (c_enum);
  return (scm_from_locale_string (c_string));
}
#undef FUNC_NAME
SCM_GLOBAL_SMOB (scm_tc16_gnutls_x509_certificate_format_enum, "x509-certificate-format", 0);
SCM scm_gnutls_x509_certificate_format_enum_values = SCM_EOL;
static const char *
scm_gnutls_x509_certificate_format_to_c_string (gnutls_x509_crt_fmt_t c_obj)
{
  static const struct { gnutls_x509_crt_fmt_t value; const char *name; } table[] =
    {
#ifndef NO_GNUTLS_X509_FMT_DER
       { GNUTLS_X509_FMT_DER, "der" },
#endif /* not NO_GNUTLS_X509_FMT_DER */
#ifndef NO_GNUTLS_X509_FMT_PEM
       { GNUTLS_X509_FMT_PEM, "pem" },
#endif /* not NO_GNUTLS_X509_FMT_PEM */
    };
  unsigned i;
  const char *name = NULL;
  for (i = 0; i < sizeof (table) / sizeof (table[0]); i++)
    {
      if (table[i].value == c_obj)
        {
          name = table[i].name;
          break;
        }
    }
  return (name);
}
SCM_SMOB_PRINT (scm_tc16_gnutls_x509_certificate_format_enum, x509_certificate_format_print, obj, port, pstate)
{
  scm_puts ("#<gnutls-x509-certificate-format-enum ", port);
  scm_puts (scm_gnutls_x509_certificate_format_to_c_string (scm_to_gnutls_x509_certificate_format (obj, 1, "x509_certificate_format_print")), port);
  scm_puts (">", port);
  return 1;
}
SCM_DEFINE (scm_gnutls_x509_certificate_format_to_string, "x509-certificate-format->string", 1, 0, 0,
            (SCM enumval),
            "Return a string describing @var{enumval}, a @code{x509-certificate-format} value.")
#define FUNC_NAME s_scm_gnutls_x509_certificate_format_to_string
{
  gnutls_x509_crt_fmt_t c_enum;
  const char *c_string;
  c_enum = scm_to_gnutls_x509_certificate_format (enumval, 1, FUNC_NAME);
  c_string = scm_gnutls_x509_certificate_format_to_c_string (c_enum);
  return (scm_from_locale_string (c_string));
}
#undef FUNC_NAME
SCM_GLOBAL_SMOB (scm_tc16_gnutls_x509_subject_alternative_name_enum, "x509-subject-alternative-name", 0);
SCM scm_gnutls_x509_subject_alternative_name_enum_values = SCM_EOL;
static const char *
scm_gnutls_x509_subject_alternative_name_to_c_string (gnutls_x509_subject_alt_name_t c_obj)
{
  static const struct { gnutls_x509_subject_alt_name_t value; const char *name; } table[] =
    {
#ifndef NO_GNUTLS_SAN_DNSNAME
       { GNUTLS_SAN_DNSNAME, "dnsname" },
#endif /* not NO_GNUTLS_SAN_DNSNAME */
#ifndef NO_GNUTLS_SAN_RFC822NAME
       { GNUTLS_SAN_RFC822NAME, "rfc822name" },
#endif /* not NO_GNUTLS_SAN_RFC822NAME */
#ifndef NO_GNUTLS_SAN_URI
       { GNUTLS_SAN_URI, "uri" },
#endif /* not NO_GNUTLS_SAN_URI */
#ifndef NO_GNUTLS_SAN_IPADDRESS
       { GNUTLS_SAN_IPADDRESS, "ipaddress" },
#endif /* not NO_GNUTLS_SAN_IPADDRESS */
    };
  unsigned i;
  const char *name = NULL;
  for (i = 0; i < sizeof (table) / sizeof (table[0]); i++)
    {
      if (table[i].value == c_obj)
        {
          name = table[i].name;
          break;
        }
    }
  return (name);
}
SCM_SMOB_PRINT (scm_tc16_gnutls_x509_subject_alternative_name_enum, x509_subject_alternative_name_print, obj, port, pstate)
{
  scm_puts ("#<gnutls-x509-subject-alternative-name-enum ", port);
  scm_puts (scm_gnutls_x509_subject_alternative_name_to_c_string (scm_to_gnutls_x509_subject_alternative_name (obj, 1, "x509_subject_alternative_name_print")), port);
  scm_puts (">", port);
  return 1;
}
SCM_DEFINE (scm_gnutls_x509_subject_alternative_name_to_string, "x509-subject-alternative-name->string", 1, 0, 0,
            (SCM enumval),
            "Return a string describing @var{enumval}, a @code{x509-subject-alternative-name} value.")
#define FUNC_NAME s_scm_gnutls_x509_subject_alternative_name_to_string
{
  gnutls_x509_subject_alt_name_t c_enum;
  const char *c_string;
  c_enum = scm_to_gnutls_x509_subject_alternative_name (enumval, 1, FUNC_NAME);
  c_string = scm_gnutls_x509_subject_alternative_name_to_c_string (c_enum);
  return (scm_from_locale_string (c_string));
}
#undef FUNC_NAME
SCM_GLOBAL_SMOB (scm_tc16_gnutls_pk_algorithm_enum, "pk-algorithm", 0);
SCM scm_gnutls_pk_algorithm_enum_values = SCM_EOL;
SCM_SMOB_PRINT (scm_tc16_gnutls_pk_algorithm_enum, pk_algorithm_print, obj, port, pstate)
{
  scm_puts ("#<gnutls-pk-algorithm-enum ", port);
  scm_puts (gnutls_pk_algorithm_get_name (scm_to_gnutls_pk_algorithm (obj, 1, "pk_algorithm_print")), port);
  scm_puts (">", port);
  return 1;
}
SCM_DEFINE (scm_gnutls_pk_algorithm_to_string, "pk-algorithm->string", 1, 0, 0,
            (SCM enumval),
            "Return a string describing @var{enumval}, a @code{pk-algorithm} value.")
#define FUNC_NAME s_scm_gnutls_pk_algorithm_to_string
{
  gnutls_pk_algorithm_t c_enum;
  const char *c_string;
  c_enum = scm_to_gnutls_pk_algorithm (enumval, 1, FUNC_NAME);
  c_string = gnutls_pk_algorithm_get_name (c_enum);
  return (scm_from_locale_string (c_string));
}
#undef FUNC_NAME
SCM_GLOBAL_SMOB (scm_tc16_gnutls_sign_algorithm_enum, "sign-algorithm", 0);
SCM scm_gnutls_sign_algorithm_enum_values = SCM_EOL;
SCM_SMOB_PRINT (scm_tc16_gnutls_sign_algorithm_enum, sign_algorithm_print, obj, port, pstate)
{
  scm_puts ("#<gnutls-sign-algorithm-enum ", port);
  scm_puts (gnutls_sign_algorithm_get_name (scm_to_gnutls_sign_algorithm (obj, 1, "sign_algorithm_print")), port);
  scm_puts (">", port);
  return 1;
}
SCM_DEFINE (scm_gnutls_sign_algorithm_to_string, "sign-algorithm->string", 1, 0, 0,
            (SCM enumval),
            "Return a string describing @var{enumval}, a @code{sign-algorithm} value.")
#define FUNC_NAME s_scm_gnutls_sign_algorithm_to_string
{
  gnutls_sign_algorithm_t c_enum;
  const char *c_string;
  c_enum = scm_to_gnutls_sign_algorithm (enumval, 1, FUNC_NAME);
  c_string = gnutls_sign_algorithm_get_name (c_enum);
  return (scm_from_locale_string (c_string));
}
#undef FUNC_NAME
SCM_GLOBAL_SMOB (scm_tc16_gnutls_server_name_type_enum, "server-name-type", 0);
SCM scm_gnutls_server_name_type_enum_values = SCM_EOL;
static const char *
scm_gnutls_server_name_type_to_c_string (gnutls_server_name_type_t c_obj)
{
  static const struct { gnutls_server_name_type_t value; const char *name; } table[] =
    {
#ifndef NO_GNUTLS_NAME_DNS
       { GNUTLS_NAME_DNS, "dns" },
#endif /* not NO_GNUTLS_NAME_DNS */
    };
  unsigned i;
  const char *name = NULL;
  for (i = 0; i < sizeof (table) / sizeof (table[0]); i++)
    {
      if (table[i].value == c_obj)
        {
          name = table[i].name;
          break;
        }
    }
  return (name);
}
SCM_SMOB_PRINT (scm_tc16_gnutls_server_name_type_enum, server_name_type_print, obj, port, pstate)
{
  scm_puts ("#<gnutls-server-name-type-enum ", port);
  scm_puts (scm_gnutls_server_name_type_to_c_string (scm_to_gnutls_server_name_type (obj, 1, "server_name_type_print")), port);
  scm_puts (">", port);
  return 1;
}
SCM_DEFINE (scm_gnutls_server_name_type_to_string, "server-name-type->string", 1, 0, 0,
            (SCM enumval),
            "Return a string describing @var{enumval}, a @code{server-name-type} value.")
#define FUNC_NAME s_scm_gnutls_server_name_type_to_string
{
  gnutls_server_name_type_t c_enum;
  const char *c_string;
  c_enum = scm_to_gnutls_server_name_type (enumval, 1, FUNC_NAME);
  c_string = scm_gnutls_server_name_type_to_c_string (c_enum);
  return (scm_from_locale_string (c_string));
}
#undef FUNC_NAME
SCM_GLOBAL_SMOB (scm_tc16_gnutls_psk_key_format_enum, "psk-key-format", 0);
SCM scm_gnutls_psk_key_format_enum_values = SCM_EOL;
static const char *
scm_gnutls_psk_key_format_to_c_string (gnutls_psk_key_flags c_obj)
{
  static const struct { gnutls_psk_key_flags value; const char *name; } table[] =
    {
#ifndef NO_GNUTLS_PSK_KEY_RAW
       { GNUTLS_PSK_KEY_RAW, "raw" },
#endif /* not NO_GNUTLS_PSK_KEY_RAW */
#ifndef NO_GNUTLS_PSK_KEY_HEX
       { GNUTLS_PSK_KEY_HEX, "hex" },
#endif /* not NO_GNUTLS_PSK_KEY_HEX */
    };
  unsigned i;
  const char *name = NULL;
  for (i = 0; i < sizeof (table) / sizeof (table[0]); i++)
    {
      if (table[i].value == c_obj)
        {
          name = table[i].name;
          break;
        }
    }
  return (name);
}
SCM_SMOB_PRINT (scm_tc16_gnutls_psk_key_format_enum, psk_key_format_print, obj, port, pstate)
{
  scm_puts ("#<gnutls-psk-key-format-enum ", port);
  scm_puts (scm_gnutls_psk_key_format_to_c_string (scm_to_gnutls_psk_key_format (obj, 1, "psk_key_format_print")), port);
  scm_puts (">", port);
  return 1;
}
SCM_DEFINE (scm_gnutls_psk_key_format_to_string, "psk-key-format->string", 1, 0, 0,
            (SCM enumval),
            "Return a string describing @var{enumval}, a @code{psk-key-format} value.")
#define FUNC_NAME s_scm_gnutls_psk_key_format_to_string
{
  gnutls_psk_key_flags c_enum;
  const char *c_string;
  c_enum = scm_to_gnutls_psk_key_format (enumval, 1, FUNC_NAME);
  c_string = scm_gnutls_psk_key_format_to_c_string (c_enum);
  return (scm_from_locale_string (c_string));
}
#undef FUNC_NAME
SCM_GLOBAL_SMOB (scm_tc16_gnutls_key_usage_enum, "key-usage", 0);
SCM scm_gnutls_key_usage_enum_values = SCM_EOL;
static const char *
scm_gnutls_key_usage_to_c_string (int c_obj)
{
  static const struct { int value; const char *name; } table[] =
    {
#ifndef NO_GNUTLS_KEY_DIGITAL_SIGNATURE
       { GNUTLS_KEY_DIGITAL_SIGNATURE, "digital-signature" },
#endif /* not NO_GNUTLS_KEY_DIGITAL_SIGNATURE */
#ifndef NO_GNUTLS_KEY_NON_REPUDIATION
       { GNUTLS_KEY_NON_REPUDIATION, "non-repudiation" },
#endif /* not NO_GNUTLS_KEY_NON_REPUDIATION */
#ifndef NO_GNUTLS_KEY_KEY_ENCIPHERMENT
       { GNUTLS_KEY_KEY_ENCIPHERMENT, "key-encipherment" },
#endif /* not NO_GNUTLS_KEY_KEY_ENCIPHERMENT */
#ifndef NO_GNUTLS_KEY_DATA_ENCIPHERMENT
       { GNUTLS_KEY_DATA_ENCIPHERMENT, "data-encipherment" },
#endif /* not NO_GNUTLS_KEY_DATA_ENCIPHERMENT */
#ifndef NO_GNUTLS_KEY_KEY_AGREEMENT
       { GNUTLS_KEY_KEY_AGREEMENT, "key-agreement" },
#endif /* not NO_GNUTLS_KEY_KEY_AGREEMENT */
#ifndef NO_GNUTLS_KEY_KEY_CERT_SIGN
       { GNUTLS_KEY_KEY_CERT_SIGN, "key-cert-sign" },
#endif /* not NO_GNUTLS_KEY_KEY_CERT_SIGN */
#ifndef NO_GNUTLS_KEY_CRL_SIGN
       { GNUTLS_KEY_CRL_SIGN, "crl-sign" },
#endif /* not NO_GNUTLS_KEY_CRL_SIGN */
#ifndef NO_GNUTLS_KEY_ENCIPHER_ONLY
       { GNUTLS_KEY_ENCIPHER_ONLY, "encipher-only" },
#endif /* not NO_GNUTLS_KEY_ENCIPHER_ONLY */
#ifndef NO_GNUTLS_KEY_DECIPHER_ONLY
       { GNUTLS_KEY_DECIPHER_ONLY, "decipher-only" },
#endif /* not NO_GNUTLS_KEY_DECIPHER_ONLY */
    };
  unsigned i;
  const char *name = NULL;
  for (i = 0; i < sizeof (table) / sizeof (table[0]); i++)
    {
      if (table[i].value == c_obj)
        {
          name = table[i].name;
          break;
        }
    }
  return (name);
}
SCM_SMOB_PRINT (scm_tc16_gnutls_key_usage_enum, key_usage_print, obj, port, pstate)
{
  scm_puts ("#<gnutls-key-usage-enum ", port);
  scm_puts (scm_gnutls_key_usage_to_c_string (scm_to_gnutls_key_usage (obj, 1, "key_usage_print")), port);
  scm_puts (">", port);
  return 1;
}
SCM_DEFINE (scm_gnutls_key_usage_to_string, "key-usage->string", 1, 0, 0,
            (SCM enumval),
            "Return a string describing @var{enumval}, a @code{key-usage} value.")
#define FUNC_NAME s_scm_gnutls_key_usage_to_string
{
  int c_enum;
  const char *c_string;
  c_enum = scm_to_gnutls_key_usage (enumval, 1, FUNC_NAME);
  c_string = scm_gnutls_key_usage_to_c_string (c_enum);
  return (scm_from_locale_string (c_string));
}
#undef FUNC_NAME
SCM_GLOBAL_SMOB (scm_tc16_gnutls_certificate_verify_enum, "certificate-verify", 0);
SCM scm_gnutls_certificate_verify_enum_values = SCM_EOL;
static const char *
scm_gnutls_certificate_verify_to_c_string (gnutls_certificate_verify_flags c_obj)
{
  static const struct { gnutls_certificate_verify_flags value; const char *name; } table[] =
    {
#ifndef NO_GNUTLS_VERIFY_DISABLE_CA_SIGN
       { GNUTLS_VERIFY_DISABLE_CA_SIGN, "disable-ca-sign" },
#endif /* not NO_GNUTLS_VERIFY_DISABLE_CA_SIGN */
#ifndef NO_GNUTLS_VERIFY_ALLOW_X509_V1_CA_CRT
       { GNUTLS_VERIFY_ALLOW_X509_V1_CA_CRT, "allow-x509-v1-ca-crt" },
#endif /* not NO_GNUTLS_VERIFY_ALLOW_X509_V1_CA_CRT */
#ifndef NO_GNUTLS_VERIFY_DO_NOT_ALLOW_SAME
       { GNUTLS_VERIFY_DO_NOT_ALLOW_SAME, "do-not-allow-same" },
#endif /* not NO_GNUTLS_VERIFY_DO_NOT_ALLOW_SAME */
#ifndef NO_GNUTLS_VERIFY_ALLOW_ANY_X509_V1_CA_CRT
       { GNUTLS_VERIFY_ALLOW_ANY_X509_V1_CA_CRT, "allow-any-x509-v1-ca-crt" },
#endif /* not NO_GNUTLS_VERIFY_ALLOW_ANY_X509_V1_CA_CRT */
#ifndef NO_GNUTLS_VERIFY_ALLOW_SIGN_RSA_MD2
       { GNUTLS_VERIFY_ALLOW_SIGN_RSA_MD2, "allow-sign-rsa-md2" },
#endif /* not NO_GNUTLS_VERIFY_ALLOW_SIGN_RSA_MD2 */
#ifndef NO_GNUTLS_VERIFY_ALLOW_SIGN_RSA_MD5
       { GNUTLS_VERIFY_ALLOW_SIGN_RSA_MD5, "allow-sign-rsa-md5" },
#endif /* not NO_GNUTLS_VERIFY_ALLOW_SIGN_RSA_MD5 */
    };
  unsigned i;
  const char *name = NULL;
  for (i = 0; i < sizeof (table) / sizeof (table[0]); i++)
    {
      if (table[i].value == c_obj)
        {
          name = table[i].name;
          break;
        }
    }
  return (name);
}
SCM_SMOB_PRINT (scm_tc16_gnutls_certificate_verify_enum, certificate_verify_print, obj, port, pstate)
{
  scm_puts ("#<gnutls-certificate-verify-enum ", port);
  scm_puts (scm_gnutls_certificate_verify_to_c_string (scm_to_gnutls_certificate_verify (obj, 1, "certificate_verify_print")), port);
  scm_puts (">", port);
  return 1;
}
SCM_DEFINE (scm_gnutls_certificate_verify_to_string, "certificate-verify->string", 1, 0, 0,
            (SCM enumval),
            "Return a string describing @var{enumval}, a @code{certificate-verify} value.")
#define FUNC_NAME s_scm_gnutls_certificate_verify_to_string
{
  gnutls_certificate_verify_flags c_enum;
  const char *c_string;
  c_enum = scm_to_gnutls_certificate_verify (enumval, 1, FUNC_NAME);
  c_string = scm_gnutls_certificate_verify_to_c_string (c_enum);
  return (scm_from_locale_string (c_string));
}
#undef FUNC_NAME
SCM_GLOBAL_SMOB (scm_tc16_gnutls_error_enum, "error", 0);
SCM scm_gnutls_error_enum_values = SCM_EOL;
SCM_SMOB_PRINT (scm_tc16_gnutls_error_enum, error_print, obj, port, pstate)
{
  scm_puts ("#<gnutls-error-enum ", port);
  scm_puts (gnutls_strerror (scm_to_gnutls_error (obj, 1, "error_print")), port);
  scm_puts (">", port);
  return 1;
}
SCM_DEFINE (scm_gnutls_error_to_string, "error->string", 1, 0, 0,
            (SCM enumval),
            "Return a string describing @var{enumval}, a @code{error} value.")
#define FUNC_NAME s_scm_gnutls_error_to_string
{
  int c_enum;
  const char *c_string;
  c_enum = scm_to_gnutls_error (enumval, 1, FUNC_NAME);
  c_string = gnutls_strerror (c_enum);
  return (scm_from_locale_string (c_string));
}
#undef FUNC_NAME
SCM_GLOBAL_SMOB (scm_tc16_gnutls_openpgp_certificate_format_enum, "openpgp-certificate-format", 0);
SCM scm_gnutls_openpgp_certificate_format_enum_values = SCM_EOL;
static const char *
scm_gnutls_openpgp_certificate_format_to_c_string (gnutls_openpgp_crt_fmt_t c_obj)
{
  static const struct { gnutls_openpgp_crt_fmt_t value; const char *name; } table[] =
    {
#ifndef NO_GNUTLS_OPENPGP_FMT_RAW
       { GNUTLS_OPENPGP_FMT_RAW, "raw" },
#endif /* not NO_GNUTLS_OPENPGP_FMT_RAW */
#ifndef NO_GNUTLS_OPENPGP_FMT_BASE64
       { GNUTLS_OPENPGP_FMT_BASE64, "base64" },
#endif /* not NO_GNUTLS_OPENPGP_FMT_BASE64 */
    };
  unsigned i;
  const char *name = NULL;
  for (i = 0; i < sizeof (table) / sizeof (table[0]); i++)
    {
      if (table[i].value == c_obj)
        {
          name = table[i].name;
          break;
        }
    }
  return (name);
}
SCM_SMOB_PRINT (scm_tc16_gnutls_openpgp_certificate_format_enum, openpgp_certificate_format_print, obj, port, pstate)
{
  scm_puts ("#<gnutls-openpgp-certificate-format-enum ", port);
  scm_puts (scm_gnutls_openpgp_certificate_format_to_c_string (scm_to_gnutls_openpgp_certificate_format (obj, 1, "openpgp_certificate_format_print")), port);
  scm_puts (">", port);
  return 1;
}
SCM_DEFINE (scm_gnutls_openpgp_certificate_format_to_string, "openpgp-certificate-format->string", 1, 0, 0,
            (SCM enumval),
            "Return a string describing @var{enumval}, a @code{openpgp-certificate-format} value.")
#define FUNC_NAME s_scm_gnutls_openpgp_certificate_format_to_string
{
  gnutls_openpgp_crt_fmt_t c_enum;
  const char *c_string;
  c_enum = scm_to_gnutls_openpgp_certificate_format (enumval, 1, FUNC_NAME);
  c_string = scm_gnutls_openpgp_certificate_format_to_c_string (c_enum);
  return (scm_from_locale_string (c_string));
}
#undef FUNC_NAME
static inline void
scm_gnutls_define_enums (void)
{
  SCM enum_values, enum_smob;
  enum_values = SCM_EOL;
#ifndef NO_GNUTLS_CIPHER_NULL
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_cipher_enum, (scm_t_bits) GNUTLS_CIPHER_NULL);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("cipher/null", enum_smob);
#endif /* not NO_GNUTLS_CIPHER_NULL */
#ifndef NO_GNUTLS_CIPHER_ARCFOUR
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_cipher_enum, (scm_t_bits) GNUTLS_CIPHER_ARCFOUR);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("cipher/arcfour", enum_smob);
#endif /* not NO_GNUTLS_CIPHER_ARCFOUR */
#ifndef NO_GNUTLS_CIPHER_3DES_CBC
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_cipher_enum, (scm_t_bits) GNUTLS_CIPHER_3DES_CBC);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("cipher/3des-cbc", enum_smob);
#endif /* not NO_GNUTLS_CIPHER_3DES_CBC */
#ifndef NO_GNUTLS_CIPHER_AES_128_CBC
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_cipher_enum, (scm_t_bits) GNUTLS_CIPHER_AES_128_CBC);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("cipher/aes-128-cbc", enum_smob);
#endif /* not NO_GNUTLS_CIPHER_AES_128_CBC */
#ifndef NO_GNUTLS_CIPHER_AES_256_CBC
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_cipher_enum, (scm_t_bits) GNUTLS_CIPHER_AES_256_CBC);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("cipher/aes-256-cbc", enum_smob);
#endif /* not NO_GNUTLS_CIPHER_AES_256_CBC */
#ifndef NO_GNUTLS_CIPHER_ARCFOUR_40
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_cipher_enum, (scm_t_bits) GNUTLS_CIPHER_ARCFOUR_40);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("cipher/arcfour-40", enum_smob);
#endif /* not NO_GNUTLS_CIPHER_ARCFOUR_40 */
#ifndef NO_GNUTLS_CIPHER_RC2_40_CBC
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_cipher_enum, (scm_t_bits) GNUTLS_CIPHER_RC2_40_CBC);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("cipher/rc2-40-cbc", enum_smob);
#endif /* not NO_GNUTLS_CIPHER_RC2_40_CBC */
#ifndef NO_GNUTLS_CIPHER_DES_CBC
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_cipher_enum, (scm_t_bits) GNUTLS_CIPHER_DES_CBC);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("cipher/des-cbc", enum_smob);
#endif /* not NO_GNUTLS_CIPHER_DES_CBC */
  scm_gnutls_cipher_enum_values = scm_permanent_object (enum_values);
  enum_values = SCM_EOL;
#ifndef NO_GNUTLS_KX_RSA
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_kx_enum, (scm_t_bits) GNUTLS_KX_RSA);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("kx/rsa", enum_smob);
#endif /* not NO_GNUTLS_KX_RSA */
#ifndef NO_GNUTLS_KX_DHE_DSS
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_kx_enum, (scm_t_bits) GNUTLS_KX_DHE_DSS);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("kx/dhe-dss", enum_smob);
#endif /* not NO_GNUTLS_KX_DHE_DSS */
#ifndef NO_GNUTLS_KX_DHE_RSA
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_kx_enum, (scm_t_bits) GNUTLS_KX_DHE_RSA);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("kx/dhe-rsa", enum_smob);
#endif /* not NO_GNUTLS_KX_DHE_RSA */
#ifndef NO_GNUTLS_KX_ANON_DH
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_kx_enum, (scm_t_bits) GNUTLS_KX_ANON_DH);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("kx/anon-dh", enum_smob);
#endif /* not NO_GNUTLS_KX_ANON_DH */
#ifndef NO_GNUTLS_KX_SRP
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_kx_enum, (scm_t_bits) GNUTLS_KX_SRP);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("kx/srp", enum_smob);
#endif /* not NO_GNUTLS_KX_SRP */
#ifndef NO_GNUTLS_KX_RSA_EXPORT
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_kx_enum, (scm_t_bits) GNUTLS_KX_RSA_EXPORT);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("kx/rsa-export", enum_smob);
#endif /* not NO_GNUTLS_KX_RSA_EXPORT */
#ifndef NO_GNUTLS_KX_SRP_RSA
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_kx_enum, (scm_t_bits) GNUTLS_KX_SRP_RSA);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("kx/srp-rsa", enum_smob);
#endif /* not NO_GNUTLS_KX_SRP_RSA */
#ifndef NO_GNUTLS_KX_SRP_DSS
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_kx_enum, (scm_t_bits) GNUTLS_KX_SRP_DSS);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("kx/srp-dss", enum_smob);
#endif /* not NO_GNUTLS_KX_SRP_DSS */
#ifndef NO_GNUTLS_KX_PSK
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_kx_enum, (scm_t_bits) GNUTLS_KX_PSK);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("kx/psk", enum_smob);
#endif /* not NO_GNUTLS_KX_PSK */
#ifndef NO_GNUTLS_KX_DHE_DSS
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_kx_enum, (scm_t_bits) GNUTLS_KX_DHE_DSS);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("kx/dhe-dss", enum_smob);
#endif /* not NO_GNUTLS_KX_DHE_DSS */
  scm_gnutls_kx_enum_values = scm_permanent_object (enum_values);
  enum_values = SCM_EOL;
#ifndef NO_GNUTLS_PARAMS_RSA_EXPORT
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_params_enum, (scm_t_bits) GNUTLS_PARAMS_RSA_EXPORT);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("params/rsa-export", enum_smob);
#endif /* not NO_GNUTLS_PARAMS_RSA_EXPORT */
#ifndef NO_GNUTLS_PARAMS_DH
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_params_enum, (scm_t_bits) GNUTLS_PARAMS_DH);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("params/dh", enum_smob);
#endif /* not NO_GNUTLS_PARAMS_DH */
  scm_gnutls_params_enum_values = scm_permanent_object (enum_values);
  enum_values = SCM_EOL;
#ifndef NO_GNUTLS_CRD_CERTIFICATE
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_credentials_enum, (scm_t_bits) GNUTLS_CRD_CERTIFICATE);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("credentials/certificate", enum_smob);
#endif /* not NO_GNUTLS_CRD_CERTIFICATE */
#ifndef NO_GNUTLS_CRD_ANON
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_credentials_enum, (scm_t_bits) GNUTLS_CRD_ANON);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("credentials/anon", enum_smob);
#endif /* not NO_GNUTLS_CRD_ANON */
#ifndef NO_GNUTLS_CRD_SRP
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_credentials_enum, (scm_t_bits) GNUTLS_CRD_SRP);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("credentials/srp", enum_smob);
#endif /* not NO_GNUTLS_CRD_SRP */
#ifndef NO_GNUTLS_CRD_PSK
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_credentials_enum, (scm_t_bits) GNUTLS_CRD_PSK);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("credentials/psk", enum_smob);
#endif /* not NO_GNUTLS_CRD_PSK */
#ifndef NO_GNUTLS_CRD_IA
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_credentials_enum, (scm_t_bits) GNUTLS_CRD_IA);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("credentials/ia", enum_smob);
#endif /* not NO_GNUTLS_CRD_IA */
  scm_gnutls_credentials_enum_values = scm_permanent_object (enum_values);
  enum_values = SCM_EOL;
#ifndef NO_GNUTLS_MAC_UNKNOWN
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_mac_enum, (scm_t_bits) GNUTLS_MAC_UNKNOWN);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("mac/unknown", enum_smob);
#endif /* not NO_GNUTLS_MAC_UNKNOWN */
#ifndef NO_GNUTLS_MAC_NULL
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_mac_enum, (scm_t_bits) GNUTLS_MAC_NULL);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("mac/null", enum_smob);
#endif /* not NO_GNUTLS_MAC_NULL */
#ifndef NO_GNUTLS_MAC_MD5
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_mac_enum, (scm_t_bits) GNUTLS_MAC_MD5);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("mac/md5", enum_smob);
#endif /* not NO_GNUTLS_MAC_MD5 */
#ifndef NO_GNUTLS_MAC_SHA1
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_mac_enum, (scm_t_bits) GNUTLS_MAC_SHA1);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("mac/sha1", enum_smob);
#endif /* not NO_GNUTLS_MAC_SHA1 */
#ifndef NO_GNUTLS_MAC_RMD160
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_mac_enum, (scm_t_bits) GNUTLS_MAC_RMD160);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("mac/rmd160", enum_smob);
#endif /* not NO_GNUTLS_MAC_RMD160 */
#ifndef NO_GNUTLS_MAC_MD2
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_mac_enum, (scm_t_bits) GNUTLS_MAC_MD2);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("mac/md2", enum_smob);
#endif /* not NO_GNUTLS_MAC_MD2 */
#ifndef NO_GNUTLS_MAC_SHA256
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_mac_enum, (scm_t_bits) GNUTLS_MAC_SHA256);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("mac/sha256", enum_smob);
#endif /* not NO_GNUTLS_MAC_SHA256 */
#ifndef NO_GNUTLS_MAC_SHA384
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_mac_enum, (scm_t_bits) GNUTLS_MAC_SHA384);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("mac/sha384", enum_smob);
#endif /* not NO_GNUTLS_MAC_SHA384 */
#ifndef NO_GNUTLS_MAC_SHA512
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_mac_enum, (scm_t_bits) GNUTLS_MAC_SHA512);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("mac/sha512", enum_smob);
#endif /* not NO_GNUTLS_MAC_SHA512 */
#ifndef NO_GNUTLS_MAC_SHA224
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_mac_enum, (scm_t_bits) GNUTLS_MAC_SHA224);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("mac/sha224", enum_smob);
#endif /* not NO_GNUTLS_MAC_SHA224 */
#ifndef NO_GNUTLS_MAC_SHA3_224
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_mac_enum, (scm_t_bits) GNUTLS_MAC_SHA3_224);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("mac/sha3-224", enum_smob);
#endif /* not NO_GNUTLS_MAC_SHA3_224 */
#ifndef NO_GNUTLS_MAC_SHA3_256
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_mac_enum, (scm_t_bits) GNUTLS_MAC_SHA3_256);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("mac/sha3-256", enum_smob);
#endif /* not NO_GNUTLS_MAC_SHA3_256 */
#ifndef NO_GNUTLS_MAC_SHA3_384
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_mac_enum, (scm_t_bits) GNUTLS_MAC_SHA3_384);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("mac/sha3-384", enum_smob);
#endif /* not NO_GNUTLS_MAC_SHA3_384 */
#ifndef NO_GNUTLS_MAC_SHA3_512
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_mac_enum, (scm_t_bits) GNUTLS_MAC_SHA3_512);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("mac/sha3-512", enum_smob);
#endif /* not NO_GNUTLS_MAC_SHA3_512 */
#ifndef NO_GNUTLS_MAC_MD5_SHA1
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_mac_enum, (scm_t_bits) GNUTLS_MAC_MD5_SHA1);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("mac/md5-sha1", enum_smob);
#endif /* not NO_GNUTLS_MAC_MD5_SHA1 */
#ifndef NO_GNUTLS_MAC_GOSTR_94
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_mac_enum, (scm_t_bits) GNUTLS_MAC_GOSTR_94);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("mac/gostr-94", enum_smob);
#endif /* not NO_GNUTLS_MAC_GOSTR_94 */
#ifndef NO_GNUTLS_MAC_STREEBOG_256
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_mac_enum, (scm_t_bits) GNUTLS_MAC_STREEBOG_256);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("mac/streebog-256", enum_smob);
#endif /* not NO_GNUTLS_MAC_STREEBOG_256 */
#ifndef NO_GNUTLS_MAC_STREEBOG_512
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_mac_enum, (scm_t_bits) GNUTLS_MAC_STREEBOG_512);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("mac/streebog-512", enum_smob);
#endif /* not NO_GNUTLS_MAC_STREEBOG_512 */
#ifndef NO_GNUTLS_MAC_AEAD
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_mac_enum, (scm_t_bits) GNUTLS_MAC_AEAD);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("mac/aead", enum_smob);
#endif /* not NO_GNUTLS_MAC_AEAD */
#ifndef NO_GNUTLS_MAC_UMAC_96
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_mac_enum, (scm_t_bits) GNUTLS_MAC_UMAC_96);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("mac/umac-96", enum_smob);
#endif /* not NO_GNUTLS_MAC_UMAC_96 */
#ifndef NO_GNUTLS_MAC_UMAC_128
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_mac_enum, (scm_t_bits) GNUTLS_MAC_UMAC_128);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("mac/umac-128", enum_smob);
#endif /* not NO_GNUTLS_MAC_UMAC_128 */
#ifndef NO_GNUTLS_MAC_AES_CMAC_128
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_mac_enum, (scm_t_bits) GNUTLS_MAC_AES_CMAC_128);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("mac/aes-cmac-128", enum_smob);
#endif /* not NO_GNUTLS_MAC_AES_CMAC_128 */
#ifndef NO_GNUTLS_MAC_AES_CMAC_256
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_mac_enum, (scm_t_bits) GNUTLS_MAC_AES_CMAC_256);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("mac/aes-cmac-256", enum_smob);
#endif /* not NO_GNUTLS_MAC_AES_CMAC_256 */
#ifndef NO_GNUTLS_MAC_AES_GMAC_128
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_mac_enum, (scm_t_bits) GNUTLS_MAC_AES_GMAC_128);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("mac/aes-gmac-128", enum_smob);
#endif /* not NO_GNUTLS_MAC_AES_GMAC_128 */
#ifndef NO_GNUTLS_MAC_AES_GMAC_192
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_mac_enum, (scm_t_bits) GNUTLS_MAC_AES_GMAC_192);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("mac/aes-gmac-192", enum_smob);
#endif /* not NO_GNUTLS_MAC_AES_GMAC_192 */
#ifndef NO_GNUTLS_MAC_AES_GMAC_256
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_mac_enum, (scm_t_bits) GNUTLS_MAC_AES_GMAC_256);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("mac/aes-gmac-256", enum_smob);
#endif /* not NO_GNUTLS_MAC_AES_GMAC_256 */
#ifndef NO_GNUTLS_MAC_GOST28147_TC26Z_IMIT
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_mac_enum, (scm_t_bits) GNUTLS_MAC_GOST28147_TC26Z_IMIT);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("mac/gost28147-tc26z-imit", enum_smob);
#endif /* not NO_GNUTLS_MAC_GOST28147_TC26Z_IMIT */
#ifndef NO_GNUTLS_MAC_SHAKE_128
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_mac_enum, (scm_t_bits) GNUTLS_MAC_SHAKE_128);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("mac/shake-128", enum_smob);
#endif /* not NO_GNUTLS_MAC_SHAKE_128 */
#ifndef NO_GNUTLS_MAC_SHAKE_256
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_mac_enum, (scm_t_bits) GNUTLS_MAC_SHAKE_256);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("mac/shake-256", enum_smob);
#endif /* not NO_GNUTLS_MAC_SHAKE_256 */
#ifndef NO_GNUTLS_MAC_MAGMA_OMAC
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_mac_enum, (scm_t_bits) GNUTLS_MAC_MAGMA_OMAC);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("mac/magma-omac", enum_smob);
#endif /* not NO_GNUTLS_MAC_MAGMA_OMAC */
#ifndef NO_GNUTLS_MAC_KUZNYECHIK_OMAC
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_mac_enum, (scm_t_bits) GNUTLS_MAC_KUZNYECHIK_OMAC);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("mac/kuznyechik-omac", enum_smob);
#endif /* not NO_GNUTLS_MAC_KUZNYECHIK_OMAC */
  scm_gnutls_mac_enum_values = scm_permanent_object (enum_values);
  enum_values = SCM_EOL;
#ifndef NO_GNUTLS_DIG_NULL
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_digest_enum, (scm_t_bits) GNUTLS_DIG_NULL);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("digest/null", enum_smob);
#endif /* not NO_GNUTLS_DIG_NULL */
#ifndef NO_GNUTLS_DIG_MD5
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_digest_enum, (scm_t_bits) GNUTLS_DIG_MD5);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("digest/md5", enum_smob);
#endif /* not NO_GNUTLS_DIG_MD5 */
#ifndef NO_GNUTLS_DIG_SHA1
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_digest_enum, (scm_t_bits) GNUTLS_DIG_SHA1);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("digest/sha1", enum_smob);
#endif /* not NO_GNUTLS_DIG_SHA1 */
#ifndef NO_GNUTLS_DIG_RMD160
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_digest_enum, (scm_t_bits) GNUTLS_DIG_RMD160);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("digest/rmd160", enum_smob);
#endif /* not NO_GNUTLS_DIG_RMD160 */
#ifndef NO_GNUTLS_DIG_MD2
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_digest_enum, (scm_t_bits) GNUTLS_DIG_MD2);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("digest/md2", enum_smob);
#endif /* not NO_GNUTLS_DIG_MD2 */
#ifndef NO_GNUTLS_DIG_SHA256
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_digest_enum, (scm_t_bits) GNUTLS_DIG_SHA256);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("digest/sha256", enum_smob);
#endif /* not NO_GNUTLS_DIG_SHA256 */
#ifndef NO_GNUTLS_DIG_SHA384
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_digest_enum, (scm_t_bits) GNUTLS_DIG_SHA384);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("digest/sha384", enum_smob);
#endif /* not NO_GNUTLS_DIG_SHA384 */
#ifndef NO_GNUTLS_DIG_SHA512
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_digest_enum, (scm_t_bits) GNUTLS_DIG_SHA512);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("digest/sha512", enum_smob);
#endif /* not NO_GNUTLS_DIG_SHA512 */
#ifndef NO_GNUTLS_DIG_SHA224
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_digest_enum, (scm_t_bits) GNUTLS_DIG_SHA224);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("digest/sha224", enum_smob);
#endif /* not NO_GNUTLS_DIG_SHA224 */
#ifndef NO_GNUTLS_DIG_SHA3_224
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_digest_enum, (scm_t_bits) GNUTLS_DIG_SHA3_224);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("digest/sha3-224", enum_smob);
#endif /* not NO_GNUTLS_DIG_SHA3_224 */
#ifndef NO_GNUTLS_DIG_SHA3_256
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_digest_enum, (scm_t_bits) GNUTLS_DIG_SHA3_256);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("digest/sha3-256", enum_smob);
#endif /* not NO_GNUTLS_DIG_SHA3_256 */
#ifndef NO_GNUTLS_DIG_SHA3_384
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_digest_enum, (scm_t_bits) GNUTLS_DIG_SHA3_384);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("digest/sha3-384", enum_smob);
#endif /* not NO_GNUTLS_DIG_SHA3_384 */
#ifndef NO_GNUTLS_DIG_SHA3_512
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_digest_enum, (scm_t_bits) GNUTLS_DIG_SHA3_512);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("digest/sha3-512", enum_smob);
#endif /* not NO_GNUTLS_DIG_SHA3_512 */
#ifndef NO_GNUTLS_DIG_MD5_SHA1
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_digest_enum, (scm_t_bits) GNUTLS_DIG_MD5_SHA1);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("digest/md5-sha1", enum_smob);
#endif /* not NO_GNUTLS_DIG_MD5_SHA1 */
#ifndef NO_GNUTLS_DIG_GOSTR_94
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_digest_enum, (scm_t_bits) GNUTLS_DIG_GOSTR_94);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("digest/gostr-94", enum_smob);
#endif /* not NO_GNUTLS_DIG_GOSTR_94 */
#ifndef NO_GNUTLS_DIG_STREEBOG_256
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_digest_enum, (scm_t_bits) GNUTLS_DIG_STREEBOG_256);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("digest/streebog-256", enum_smob);
#endif /* not NO_GNUTLS_DIG_STREEBOG_256 */
#ifndef NO_GNUTLS_DIG_STREEBOG_512
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_digest_enum, (scm_t_bits) GNUTLS_DIG_STREEBOG_512);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("digest/streebog-512", enum_smob);
#endif /* not NO_GNUTLS_DIG_STREEBOG_512 */
  scm_gnutls_digest_enum_values = scm_permanent_object (enum_values);
  enum_values = SCM_EOL;
#ifndef NO_GNUTLS_COMP_NULL
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_compression_method_enum, (scm_t_bits) GNUTLS_COMP_NULL);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("compression-method/null", enum_smob);
#endif /* not NO_GNUTLS_COMP_NULL */
#ifndef NO_GNUTLS_COMP_DEFLATE
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_compression_method_enum, (scm_t_bits) GNUTLS_COMP_DEFLATE);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("compression-method/deflate", enum_smob);
#endif /* not NO_GNUTLS_COMP_DEFLATE */
  scm_gnutls_compression_method_enum_values = scm_permanent_object (enum_values);
  enum_values = SCM_EOL;
#ifndef NO_GNUTLS_SERVER
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_connection_end_enum, (scm_t_bits) GNUTLS_SERVER);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("connection-end/server", enum_smob);
#endif /* not NO_GNUTLS_SERVER */
#ifndef NO_GNUTLS_CLIENT
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_connection_end_enum, (scm_t_bits) GNUTLS_CLIENT);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("connection-end/client", enum_smob);
#endif /* not NO_GNUTLS_CLIENT */
  scm_gnutls_connection_end_enum_values = scm_permanent_object (enum_values);
  enum_values = SCM_EOL;
#ifndef NO_GNUTLS_DATAGRAM
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_connection_flag_enum, (scm_t_bits) GNUTLS_DATAGRAM);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("connection-flag/datagram", enum_smob);
#endif /* not NO_GNUTLS_DATAGRAM */
#ifndef NO_GNUTLS_NONBLOCK
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_connection_flag_enum, (scm_t_bits) GNUTLS_NONBLOCK);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("connection-flag/nonblock", enum_smob);
#endif /* not NO_GNUTLS_NONBLOCK */
#ifndef NO_GNUTLS_NO_EXTENSIONS
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_connection_flag_enum, (scm_t_bits) GNUTLS_NO_EXTENSIONS);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("connection-flag/no-extensions", enum_smob);
#endif /* not NO_GNUTLS_NO_EXTENSIONS */
#ifndef NO_GNUTLS_NO_REPLAY_PROTECTION
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_connection_flag_enum, (scm_t_bits) GNUTLS_NO_REPLAY_PROTECTION);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("connection-flag/no-replay-protection", enum_smob);
#endif /* not NO_GNUTLS_NO_REPLAY_PROTECTION */
#ifndef NO_GNUTLS_NO_SIGNAL
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_connection_flag_enum, (scm_t_bits) GNUTLS_NO_SIGNAL);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("connection-flag/no-signal", enum_smob);
#endif /* not NO_GNUTLS_NO_SIGNAL */
#ifndef NO_GNUTLS_ALLOW_ID_CHANGE
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_connection_flag_enum, (scm_t_bits) GNUTLS_ALLOW_ID_CHANGE);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("connection-flag/allow-id-change", enum_smob);
#endif /* not NO_GNUTLS_ALLOW_ID_CHANGE */
#ifndef NO_GNUTLS_ENABLE_FALSE_START
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_connection_flag_enum, (scm_t_bits) GNUTLS_ENABLE_FALSE_START);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("connection-flag/enable-false-start", enum_smob);
#endif /* not NO_GNUTLS_ENABLE_FALSE_START */
#ifndef NO_GNUTLS_FORCE_CLIENT_CERT
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_connection_flag_enum, (scm_t_bits) GNUTLS_FORCE_CLIENT_CERT);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("connection-flag/force-client-cert", enum_smob);
#endif /* not NO_GNUTLS_FORCE_CLIENT_CERT */
#ifndef NO_GNUTLS_NO_TICKETS
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_connection_flag_enum, (scm_t_bits) GNUTLS_NO_TICKETS);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("connection-flag/no-tickets", enum_smob);
#endif /* not NO_GNUTLS_NO_TICKETS */
#ifndef NO_GNUTLS_KEY_SHARE_TOP
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_connection_flag_enum, (scm_t_bits) GNUTLS_KEY_SHARE_TOP);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("connection-flag/key-share-top", enum_smob);
#endif /* not NO_GNUTLS_KEY_SHARE_TOP */
#ifndef NO_GNUTLS_KEY_SHARE_TOP2
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_connection_flag_enum, (scm_t_bits) GNUTLS_KEY_SHARE_TOP2);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("connection-flag/key-share-top2", enum_smob);
#endif /* not NO_GNUTLS_KEY_SHARE_TOP2 */
#ifndef NO_GNUTLS_KEY_SHARE_TOP3
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_connection_flag_enum, (scm_t_bits) GNUTLS_KEY_SHARE_TOP3);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("connection-flag/key-share-top3", enum_smob);
#endif /* not NO_GNUTLS_KEY_SHARE_TOP3 */
#ifndef NO_GNUTLS_POST_HANDSHAKE_AUTH
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_connection_flag_enum, (scm_t_bits) GNUTLS_POST_HANDSHAKE_AUTH);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("connection-flag/post-handshake-auth", enum_smob);
#endif /* not NO_GNUTLS_POST_HANDSHAKE_AUTH */
#ifndef NO_GNUTLS_NO_AUTO_REKEY
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_connection_flag_enum, (scm_t_bits) GNUTLS_NO_AUTO_REKEY);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("connection-flag/no-auto-rekey", enum_smob);
#endif /* not NO_GNUTLS_NO_AUTO_REKEY */
#ifndef NO_GNUTLS_SAFE_PADDING_CHECK
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_connection_flag_enum, (scm_t_bits) GNUTLS_SAFE_PADDING_CHECK);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("connection-flag/safe-padding-check", enum_smob);
#endif /* not NO_GNUTLS_SAFE_PADDING_CHECK */
#ifndef NO_GNUTLS_ENABLE_EARLY_START
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_connection_flag_enum, (scm_t_bits) GNUTLS_ENABLE_EARLY_START);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("connection-flag/enable-early-start", enum_smob);
#endif /* not NO_GNUTLS_ENABLE_EARLY_START */
#ifndef NO_GNUTLS_ENABLE_RAWPK
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_connection_flag_enum, (scm_t_bits) GNUTLS_ENABLE_RAWPK);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("connection-flag/enable-rawpk", enum_smob);
#endif /* not NO_GNUTLS_ENABLE_RAWPK */
#ifndef NO_GNUTLS_AUTO_REAUTH
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_connection_flag_enum, (scm_t_bits) GNUTLS_AUTO_REAUTH);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("connection-flag/auto-reauth", enum_smob);
#endif /* not NO_GNUTLS_AUTO_REAUTH */
#ifndef NO_GNUTLS_ENABLE_EARLY_DATA
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_connection_flag_enum, (scm_t_bits) GNUTLS_ENABLE_EARLY_DATA);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("connection-flag/enable-early-data", enum_smob);
#endif /* not NO_GNUTLS_ENABLE_EARLY_DATA */
  scm_gnutls_connection_flag_enum_values = scm_permanent_object (enum_values);
  enum_values = SCM_EOL;
#ifndef NO_GNUTLS_AL_WARNING
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_alert_level_enum, (scm_t_bits) GNUTLS_AL_WARNING);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("alert-level/warning", enum_smob);
#endif /* not NO_GNUTLS_AL_WARNING */
#ifndef NO_GNUTLS_AL_FATAL
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_alert_level_enum, (scm_t_bits) GNUTLS_AL_FATAL);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("alert-level/fatal", enum_smob);
#endif /* not NO_GNUTLS_AL_FATAL */
  scm_gnutls_alert_level_enum_values = scm_permanent_object (enum_values);
  enum_values = SCM_EOL;
#ifndef NO_GNUTLS_A_CLOSE_NOTIFY
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_alert_description_enum, (scm_t_bits) GNUTLS_A_CLOSE_NOTIFY);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("alert-description/close-notify", enum_smob);
#endif /* not NO_GNUTLS_A_CLOSE_NOTIFY */
#ifndef NO_GNUTLS_A_UNEXPECTED_MESSAGE
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_alert_description_enum, (scm_t_bits) GNUTLS_A_UNEXPECTED_MESSAGE);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("alert-description/unexpected-message", enum_smob);
#endif /* not NO_GNUTLS_A_UNEXPECTED_MESSAGE */
#ifndef NO_GNUTLS_A_BAD_RECORD_MAC
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_alert_description_enum, (scm_t_bits) GNUTLS_A_BAD_RECORD_MAC);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("alert-description/bad-record-mac", enum_smob);
#endif /* not NO_GNUTLS_A_BAD_RECORD_MAC */
#ifndef NO_GNUTLS_A_DECRYPTION_FAILED
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_alert_description_enum, (scm_t_bits) GNUTLS_A_DECRYPTION_FAILED);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("alert-description/decryption-failed", enum_smob);
#endif /* not NO_GNUTLS_A_DECRYPTION_FAILED */
#ifndef NO_GNUTLS_A_RECORD_OVERFLOW
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_alert_description_enum, (scm_t_bits) GNUTLS_A_RECORD_OVERFLOW);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("alert-description/record-overflow", enum_smob);
#endif /* not NO_GNUTLS_A_RECORD_OVERFLOW */
#ifndef NO_GNUTLS_A_DECOMPRESSION_FAILURE
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_alert_description_enum, (scm_t_bits) GNUTLS_A_DECOMPRESSION_FAILURE);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("alert-description/decompression-failure", enum_smob);
#endif /* not NO_GNUTLS_A_DECOMPRESSION_FAILURE */
#ifndef NO_GNUTLS_A_HANDSHAKE_FAILURE
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_alert_description_enum, (scm_t_bits) GNUTLS_A_HANDSHAKE_FAILURE);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("alert-description/handshake-failure", enum_smob);
#endif /* not NO_GNUTLS_A_HANDSHAKE_FAILURE */
#ifndef NO_GNUTLS_A_SSL3_NO_CERTIFICATE
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_alert_description_enum, (scm_t_bits) GNUTLS_A_SSL3_NO_CERTIFICATE);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("alert-description/ssl3-no-certificate", enum_smob);
#endif /* not NO_GNUTLS_A_SSL3_NO_CERTIFICATE */
#ifndef NO_GNUTLS_A_BAD_CERTIFICATE
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_alert_description_enum, (scm_t_bits) GNUTLS_A_BAD_CERTIFICATE);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("alert-description/bad-certificate", enum_smob);
#endif /* not NO_GNUTLS_A_BAD_CERTIFICATE */
#ifndef NO_GNUTLS_A_UNSUPPORTED_CERTIFICATE
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_alert_description_enum, (scm_t_bits) GNUTLS_A_UNSUPPORTED_CERTIFICATE);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("alert-description/unsupported-certificate", enum_smob);
#endif /* not NO_GNUTLS_A_UNSUPPORTED_CERTIFICATE */
#ifndef NO_GNUTLS_A_CERTIFICATE_REVOKED
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_alert_description_enum, (scm_t_bits) GNUTLS_A_CERTIFICATE_REVOKED);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("alert-description/certificate-revoked", enum_smob);
#endif /* not NO_GNUTLS_A_CERTIFICATE_REVOKED */
#ifndef NO_GNUTLS_A_CERTIFICATE_EXPIRED
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_alert_description_enum, (scm_t_bits) GNUTLS_A_CERTIFICATE_EXPIRED);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("alert-description/certificate-expired", enum_smob);
#endif /* not NO_GNUTLS_A_CERTIFICATE_EXPIRED */
#ifndef NO_GNUTLS_A_CERTIFICATE_UNKNOWN
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_alert_description_enum, (scm_t_bits) GNUTLS_A_CERTIFICATE_UNKNOWN);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("alert-description/certificate-unknown", enum_smob);
#endif /* not NO_GNUTLS_A_CERTIFICATE_UNKNOWN */
#ifndef NO_GNUTLS_A_ILLEGAL_PARAMETER
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_alert_description_enum, (scm_t_bits) GNUTLS_A_ILLEGAL_PARAMETER);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("alert-description/illegal-parameter", enum_smob);
#endif /* not NO_GNUTLS_A_ILLEGAL_PARAMETER */
#ifndef NO_GNUTLS_A_UNKNOWN_CA
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_alert_description_enum, (scm_t_bits) GNUTLS_A_UNKNOWN_CA);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("alert-description/unknown-ca", enum_smob);
#endif /* not NO_GNUTLS_A_UNKNOWN_CA */
#ifndef NO_GNUTLS_A_ACCESS_DENIED
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_alert_description_enum, (scm_t_bits) GNUTLS_A_ACCESS_DENIED);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("alert-description/access-denied", enum_smob);
#endif /* not NO_GNUTLS_A_ACCESS_DENIED */
#ifndef NO_GNUTLS_A_DECODE_ERROR
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_alert_description_enum, (scm_t_bits) GNUTLS_A_DECODE_ERROR);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("alert-description/decode-error", enum_smob);
#endif /* not NO_GNUTLS_A_DECODE_ERROR */
#ifndef NO_GNUTLS_A_DECRYPT_ERROR
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_alert_description_enum, (scm_t_bits) GNUTLS_A_DECRYPT_ERROR);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("alert-description/decrypt-error", enum_smob);
#endif /* not NO_GNUTLS_A_DECRYPT_ERROR */
#ifndef NO_GNUTLS_A_EXPORT_RESTRICTION
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_alert_description_enum, (scm_t_bits) GNUTLS_A_EXPORT_RESTRICTION);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("alert-description/export-restriction", enum_smob);
#endif /* not NO_GNUTLS_A_EXPORT_RESTRICTION */
#ifndef NO_GNUTLS_A_PROTOCOL_VERSION
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_alert_description_enum, (scm_t_bits) GNUTLS_A_PROTOCOL_VERSION);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("alert-description/protocol-version", enum_smob);
#endif /* not NO_GNUTLS_A_PROTOCOL_VERSION */
#ifndef NO_GNUTLS_A_INSUFFICIENT_SECURITY
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_alert_description_enum, (scm_t_bits) GNUTLS_A_INSUFFICIENT_SECURITY);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("alert-description/insufficient-security", enum_smob);
#endif /* not NO_GNUTLS_A_INSUFFICIENT_SECURITY */
#ifndef NO_GNUTLS_A_INTERNAL_ERROR
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_alert_description_enum, (scm_t_bits) GNUTLS_A_INTERNAL_ERROR);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("alert-description/internal-error", enum_smob);
#endif /* not NO_GNUTLS_A_INTERNAL_ERROR */
#ifndef NO_GNUTLS_A_USER_CANCELED
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_alert_description_enum, (scm_t_bits) GNUTLS_A_USER_CANCELED);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("alert-description/user-canceled", enum_smob);
#endif /* not NO_GNUTLS_A_USER_CANCELED */
#ifndef NO_GNUTLS_A_NO_RENEGOTIATION
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_alert_description_enum, (scm_t_bits) GNUTLS_A_NO_RENEGOTIATION);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("alert-description/no-renegotiation", enum_smob);
#endif /* not NO_GNUTLS_A_NO_RENEGOTIATION */
#ifndef NO_GNUTLS_A_UNSUPPORTED_EXTENSION
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_alert_description_enum, (scm_t_bits) GNUTLS_A_UNSUPPORTED_EXTENSION);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("alert-description/unsupported-extension", enum_smob);
#endif /* not NO_GNUTLS_A_UNSUPPORTED_EXTENSION */
#ifndef NO_GNUTLS_A_CERTIFICATE_UNOBTAINABLE
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_alert_description_enum, (scm_t_bits) GNUTLS_A_CERTIFICATE_UNOBTAINABLE);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("alert-description/certificate-unobtainable", enum_smob);
#endif /* not NO_GNUTLS_A_CERTIFICATE_UNOBTAINABLE */
#ifndef NO_GNUTLS_A_UNRECOGNIZED_NAME
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_alert_description_enum, (scm_t_bits) GNUTLS_A_UNRECOGNIZED_NAME);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("alert-description/unrecognized-name", enum_smob);
#endif /* not NO_GNUTLS_A_UNRECOGNIZED_NAME */
#ifndef NO_GNUTLS_A_UNKNOWN_PSK_IDENTITY
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_alert_description_enum, (scm_t_bits) GNUTLS_A_UNKNOWN_PSK_IDENTITY);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("alert-description/unknown-psk-identity", enum_smob);
#endif /* not NO_GNUTLS_A_UNKNOWN_PSK_IDENTITY */
  scm_gnutls_alert_description_enum_values = scm_permanent_object (enum_values);
  enum_values = SCM_EOL;
#ifndef NO_GNUTLS_HANDSHAKE_HELLO_REQUEST
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_handshake_description_enum, (scm_t_bits) GNUTLS_HANDSHAKE_HELLO_REQUEST);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("handshake-description/hello-request", enum_smob);
#endif /* not NO_GNUTLS_HANDSHAKE_HELLO_REQUEST */
#ifndef NO_GNUTLS_HANDSHAKE_CLIENT_HELLO
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_handshake_description_enum, (scm_t_bits) GNUTLS_HANDSHAKE_CLIENT_HELLO);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("handshake-description/client-hello", enum_smob);
#endif /* not NO_GNUTLS_HANDSHAKE_CLIENT_HELLO */
#ifndef NO_GNUTLS_HANDSHAKE_SERVER_HELLO
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_handshake_description_enum, (scm_t_bits) GNUTLS_HANDSHAKE_SERVER_HELLO);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("handshake-description/server-hello", enum_smob);
#endif /* not NO_GNUTLS_HANDSHAKE_SERVER_HELLO */
#ifndef NO_GNUTLS_HANDSHAKE_CERTIFICATE_PKT
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_handshake_description_enum, (scm_t_bits) GNUTLS_HANDSHAKE_CERTIFICATE_PKT);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("handshake-description/certificate-pkt", enum_smob);
#endif /* not NO_GNUTLS_HANDSHAKE_CERTIFICATE_PKT */
#ifndef NO_GNUTLS_HANDSHAKE_SERVER_KEY_EXCHANGE
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_handshake_description_enum, (scm_t_bits) GNUTLS_HANDSHAKE_SERVER_KEY_EXCHANGE);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("handshake-description/server-key-exchange", enum_smob);
#endif /* not NO_GNUTLS_HANDSHAKE_SERVER_KEY_EXCHANGE */
#ifndef NO_GNUTLS_HANDSHAKE_CERTIFICATE_REQUEST
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_handshake_description_enum, (scm_t_bits) GNUTLS_HANDSHAKE_CERTIFICATE_REQUEST);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("handshake-description/certificate-request", enum_smob);
#endif /* not NO_GNUTLS_HANDSHAKE_CERTIFICATE_REQUEST */
#ifndef NO_GNUTLS_HANDSHAKE_SERVER_HELLO_DONE
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_handshake_description_enum, (scm_t_bits) GNUTLS_HANDSHAKE_SERVER_HELLO_DONE);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("handshake-description/server-hello-done", enum_smob);
#endif /* not NO_GNUTLS_HANDSHAKE_SERVER_HELLO_DONE */
#ifndef NO_GNUTLS_HANDSHAKE_CERTIFICATE_VERIFY
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_handshake_description_enum, (scm_t_bits) GNUTLS_HANDSHAKE_CERTIFICATE_VERIFY);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("handshake-description/certificate-verify", enum_smob);
#endif /* not NO_GNUTLS_HANDSHAKE_CERTIFICATE_VERIFY */
#ifndef NO_GNUTLS_HANDSHAKE_CLIENT_KEY_EXCHANGE
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_handshake_description_enum, (scm_t_bits) GNUTLS_HANDSHAKE_CLIENT_KEY_EXCHANGE);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("handshake-description/client-key-exchange", enum_smob);
#endif /* not NO_GNUTLS_HANDSHAKE_CLIENT_KEY_EXCHANGE */
#ifndef NO_GNUTLS_HANDSHAKE_FINISHED
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_handshake_description_enum, (scm_t_bits) GNUTLS_HANDSHAKE_FINISHED);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("handshake-description/finished", enum_smob);
#endif /* not NO_GNUTLS_HANDSHAKE_FINISHED */
  scm_gnutls_handshake_description_enum_values = scm_permanent_object (enum_values);
  enum_values = SCM_EOL;
#ifndef NO_GNUTLS_CERT_INVALID
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_certificate_status_enum, (scm_t_bits) GNUTLS_CERT_INVALID);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("certificate-status/invalid", enum_smob);
#endif /* not NO_GNUTLS_CERT_INVALID */
#ifndef NO_GNUTLS_CERT_REVOKED
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_certificate_status_enum, (scm_t_bits) GNUTLS_CERT_REVOKED);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("certificate-status/revoked", enum_smob);
#endif /* not NO_GNUTLS_CERT_REVOKED */
#ifndef NO_GNUTLS_CERT_SIGNER_NOT_FOUND
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_certificate_status_enum, (scm_t_bits) GNUTLS_CERT_SIGNER_NOT_FOUND);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("certificate-status/signer-not-found", enum_smob);
#endif /* not NO_GNUTLS_CERT_SIGNER_NOT_FOUND */
#ifndef NO_GNUTLS_CERT_SIGNER_NOT_CA
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_certificate_status_enum, (scm_t_bits) GNUTLS_CERT_SIGNER_NOT_CA);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("certificate-status/signer-not-ca", enum_smob);
#endif /* not NO_GNUTLS_CERT_SIGNER_NOT_CA */
#ifndef NO_GNUTLS_CERT_INSECURE_ALGORITHM
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_certificate_status_enum, (scm_t_bits) GNUTLS_CERT_INSECURE_ALGORITHM);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("certificate-status/insecure-algorithm", enum_smob);
#endif /* not NO_GNUTLS_CERT_INSECURE_ALGORITHM */
#ifndef NO_GNUTLS_CERT_NOT_ACTIVATED
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_certificate_status_enum, (scm_t_bits) GNUTLS_CERT_NOT_ACTIVATED);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("certificate-status/not-activated", enum_smob);
#endif /* not NO_GNUTLS_CERT_NOT_ACTIVATED */
#ifndef NO_GNUTLS_CERT_EXPIRED
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_certificate_status_enum, (scm_t_bits) GNUTLS_CERT_EXPIRED);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("certificate-status/expired", enum_smob);
#endif /* not NO_GNUTLS_CERT_EXPIRED */
#ifndef NO_GNUTLS_CERT_SIGNATURE_FAILURE
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_certificate_status_enum, (scm_t_bits) GNUTLS_CERT_SIGNATURE_FAILURE);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("certificate-status/signature-failure", enum_smob);
#endif /* not NO_GNUTLS_CERT_SIGNATURE_FAILURE */
#ifndef NO_GNUTLS_CERT_REVOCATION_DATA_SUPERSEDED
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_certificate_status_enum, (scm_t_bits) GNUTLS_CERT_REVOCATION_DATA_SUPERSEDED);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("certificate-status/revocation-data-superseded", enum_smob);
#endif /* not NO_GNUTLS_CERT_REVOCATION_DATA_SUPERSEDED */
#ifndef NO_GNUTLS_CERT_UNEXPECTED_OWNER
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_certificate_status_enum, (scm_t_bits) GNUTLS_CERT_UNEXPECTED_OWNER);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("certificate-status/unexpected-owner", enum_smob);
#endif /* not NO_GNUTLS_CERT_UNEXPECTED_OWNER */
#ifndef NO_GNUTLS_CERT_REVOCATION_DATA_ISSUED_IN_FUTURE
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_certificate_status_enum, (scm_t_bits) GNUTLS_CERT_REVOCATION_DATA_ISSUED_IN_FUTURE);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("certificate-status/revocation-data-issued-in-future", enum_smob);
#endif /* not NO_GNUTLS_CERT_REVOCATION_DATA_ISSUED_IN_FUTURE */
#ifndef NO_GNUTLS_CERT_SIGNER_CONSTRAINTS_FAILURE
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_certificate_status_enum, (scm_t_bits) GNUTLS_CERT_SIGNER_CONSTRAINTS_FAILURE);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("certificate-status/signer-constraints-failure", enum_smob);
#endif /* not NO_GNUTLS_CERT_SIGNER_CONSTRAINTS_FAILURE */
#ifndef NO_GNUTLS_CERT_MISMATCH
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_certificate_status_enum, (scm_t_bits) GNUTLS_CERT_MISMATCH);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("certificate-status/mismatch", enum_smob);
#endif /* not NO_GNUTLS_CERT_MISMATCH */
#ifndef NO_GNUTLS_CERT_PURPOSE_MISMATCH
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_certificate_status_enum, (scm_t_bits) GNUTLS_CERT_PURPOSE_MISMATCH);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("certificate-status/purpose-mismatch", enum_smob);
#endif /* not NO_GNUTLS_CERT_PURPOSE_MISMATCH */
#ifndef NO_GNUTLS_CERT_MISSING_OCSP_STATUS
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_certificate_status_enum, (scm_t_bits) GNUTLS_CERT_MISSING_OCSP_STATUS);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("certificate-status/missing-ocsp-status", enum_smob);
#endif /* not NO_GNUTLS_CERT_MISSING_OCSP_STATUS */
#ifndef NO_GNUTLS_CERT_INVALID_OCSP_STATUS
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_certificate_status_enum, (scm_t_bits) GNUTLS_CERT_INVALID_OCSP_STATUS);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("certificate-status/invalid-ocsp-status", enum_smob);
#endif /* not NO_GNUTLS_CERT_INVALID_OCSP_STATUS */
#ifndef NO_GNUTLS_CERT_UNKNOWN_CRIT_EXTENSIONS
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_certificate_status_enum, (scm_t_bits) GNUTLS_CERT_UNKNOWN_CRIT_EXTENSIONS);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("certificate-status/unknown-crit-extensions", enum_smob);
#endif /* not NO_GNUTLS_CERT_UNKNOWN_CRIT_EXTENSIONS */
  scm_gnutls_certificate_status_enum_values = scm_permanent_object (enum_values);
  enum_values = SCM_EOL;
#ifndef NO_GNUTLS_CERT_IGNORE
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_certificate_request_enum, (scm_t_bits) GNUTLS_CERT_IGNORE);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("certificate-request/ignore", enum_smob);
#endif /* not NO_GNUTLS_CERT_IGNORE */
#ifndef NO_GNUTLS_CERT_REQUEST
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_certificate_request_enum, (scm_t_bits) GNUTLS_CERT_REQUEST);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("certificate-request/request", enum_smob);
#endif /* not NO_GNUTLS_CERT_REQUEST */
#ifndef NO_GNUTLS_CERT_REQUIRE
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_certificate_request_enum, (scm_t_bits) GNUTLS_CERT_REQUIRE);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("certificate-request/require", enum_smob);
#endif /* not NO_GNUTLS_CERT_REQUIRE */
  scm_gnutls_certificate_request_enum_values = scm_permanent_object (enum_values);
  enum_values = SCM_EOL;
#ifndef NO_GNUTLS_SHUT_RDWR
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_close_request_enum, (scm_t_bits) GNUTLS_SHUT_RDWR);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("close-request/rdwr", enum_smob);
#endif /* not NO_GNUTLS_SHUT_RDWR */
#ifndef NO_GNUTLS_SHUT_WR
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_close_request_enum, (scm_t_bits) GNUTLS_SHUT_WR);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("close-request/wr", enum_smob);
#endif /* not NO_GNUTLS_SHUT_WR */
  scm_gnutls_close_request_enum_values = scm_permanent_object (enum_values);
  enum_values = SCM_EOL;
#ifndef NO_GNUTLS_SSL3
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_protocol_enum, (scm_t_bits) GNUTLS_SSL3);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("protocol/ssl3", enum_smob);
#endif /* not NO_GNUTLS_SSL3 */
#ifndef NO_GNUTLS_TLS1_0
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_protocol_enum, (scm_t_bits) GNUTLS_TLS1_0);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("protocol/tls1-0", enum_smob);
#endif /* not NO_GNUTLS_TLS1_0 */
#ifndef NO_GNUTLS_TLS1_1
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_protocol_enum, (scm_t_bits) GNUTLS_TLS1_1);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("protocol/tls1-1", enum_smob);
#endif /* not NO_GNUTLS_TLS1_1 */
#ifndef NO_GNUTLS_VERSION_UNKNOWN
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_protocol_enum, (scm_t_bits) GNUTLS_VERSION_UNKNOWN);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("protocol/version-unknown", enum_smob);
#endif /* not NO_GNUTLS_VERSION_UNKNOWN */
  scm_gnutls_protocol_enum_values = scm_permanent_object (enum_values);
  enum_values = SCM_EOL;
#ifndef NO_GNUTLS_CRT_X509
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_certificate_type_enum, (scm_t_bits) GNUTLS_CRT_X509);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("certificate-type/x509", enum_smob);
#endif /* not NO_GNUTLS_CRT_X509 */
#ifndef NO_GNUTLS_CRT_OPENPGP
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_certificate_type_enum, (scm_t_bits) GNUTLS_CRT_OPENPGP);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("certificate-type/openpgp", enum_smob);
#endif /* not NO_GNUTLS_CRT_OPENPGP */
  scm_gnutls_certificate_type_enum_values = scm_permanent_object (enum_values);
  enum_values = SCM_EOL;
#ifndef NO_GNUTLS_X509_FMT_DER
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_x509_certificate_format_enum, (scm_t_bits) GNUTLS_X509_FMT_DER);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("x509-certificate-format/der", enum_smob);
#endif /* not NO_GNUTLS_X509_FMT_DER */
#ifndef NO_GNUTLS_X509_FMT_PEM
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_x509_certificate_format_enum, (scm_t_bits) GNUTLS_X509_FMT_PEM);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("x509-certificate-format/pem", enum_smob);
#endif /* not NO_GNUTLS_X509_FMT_PEM */
  scm_gnutls_x509_certificate_format_enum_values = scm_permanent_object (enum_values);
  enum_values = SCM_EOL;
#ifndef NO_GNUTLS_SAN_DNSNAME
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_x509_subject_alternative_name_enum, (scm_t_bits) GNUTLS_SAN_DNSNAME);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("x509-subject-alternative-name/dnsname", enum_smob);
#endif /* not NO_GNUTLS_SAN_DNSNAME */
#ifndef NO_GNUTLS_SAN_RFC822NAME
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_x509_subject_alternative_name_enum, (scm_t_bits) GNUTLS_SAN_RFC822NAME);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("x509-subject-alternative-name/rfc822name", enum_smob);
#endif /* not NO_GNUTLS_SAN_RFC822NAME */
#ifndef NO_GNUTLS_SAN_URI
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_x509_subject_alternative_name_enum, (scm_t_bits) GNUTLS_SAN_URI);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("x509-subject-alternative-name/uri", enum_smob);
#endif /* not NO_GNUTLS_SAN_URI */
#ifndef NO_GNUTLS_SAN_IPADDRESS
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_x509_subject_alternative_name_enum, (scm_t_bits) GNUTLS_SAN_IPADDRESS);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("x509-subject-alternative-name/ipaddress", enum_smob);
#endif /* not NO_GNUTLS_SAN_IPADDRESS */
  scm_gnutls_x509_subject_alternative_name_enum_values = scm_permanent_object (enum_values);
  enum_values = SCM_EOL;
#ifndef NO_GNUTLS_PK_UNKNOWN
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_pk_algorithm_enum, (scm_t_bits) GNUTLS_PK_UNKNOWN);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("pk-algorithm/unknown", enum_smob);
#endif /* not NO_GNUTLS_PK_UNKNOWN */
#ifndef NO_GNUTLS_PK_RSA
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_pk_algorithm_enum, (scm_t_bits) GNUTLS_PK_RSA);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("pk-algorithm/rsa", enum_smob);
#endif /* not NO_GNUTLS_PK_RSA */
#ifndef NO_GNUTLS_PK_DSA
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_pk_algorithm_enum, (scm_t_bits) GNUTLS_PK_DSA);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("pk-algorithm/dsa", enum_smob);
#endif /* not NO_GNUTLS_PK_DSA */
  scm_gnutls_pk_algorithm_enum_values = scm_permanent_object (enum_values);
  enum_values = SCM_EOL;
#ifndef NO_GNUTLS_SIGN_UNKNOWN
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_sign_algorithm_enum, (scm_t_bits) GNUTLS_SIGN_UNKNOWN);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("sign-algorithm/unknown", enum_smob);
#endif /* not NO_GNUTLS_SIGN_UNKNOWN */
#ifndef NO_GNUTLS_SIGN_RSA_SHA1
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_sign_algorithm_enum, (scm_t_bits) GNUTLS_SIGN_RSA_SHA1);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("sign-algorithm/rsa-sha1", enum_smob);
#endif /* not NO_GNUTLS_SIGN_RSA_SHA1 */
#ifndef NO_GNUTLS_SIGN_DSA_SHA1
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_sign_algorithm_enum, (scm_t_bits) GNUTLS_SIGN_DSA_SHA1);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("sign-algorithm/dsa-sha1", enum_smob);
#endif /* not NO_GNUTLS_SIGN_DSA_SHA1 */
#ifndef NO_GNUTLS_SIGN_RSA_MD5
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_sign_algorithm_enum, (scm_t_bits) GNUTLS_SIGN_RSA_MD5);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("sign-algorithm/rsa-md5", enum_smob);
#endif /* not NO_GNUTLS_SIGN_RSA_MD5 */
#ifndef NO_GNUTLS_SIGN_RSA_MD2
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_sign_algorithm_enum, (scm_t_bits) GNUTLS_SIGN_RSA_MD2);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("sign-algorithm/rsa-md2", enum_smob);
#endif /* not NO_GNUTLS_SIGN_RSA_MD2 */
#ifndef NO_GNUTLS_SIGN_RSA_RMD160
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_sign_algorithm_enum, (scm_t_bits) GNUTLS_SIGN_RSA_RMD160);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("sign-algorithm/rsa-rmd160", enum_smob);
#endif /* not NO_GNUTLS_SIGN_RSA_RMD160 */
  scm_gnutls_sign_algorithm_enum_values = scm_permanent_object (enum_values);
  enum_values = SCM_EOL;
#ifndef NO_GNUTLS_NAME_DNS
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_server_name_type_enum, (scm_t_bits) GNUTLS_NAME_DNS);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("server-name-type/dns", enum_smob);
#endif /* not NO_GNUTLS_NAME_DNS */
  scm_gnutls_server_name_type_enum_values = scm_permanent_object (enum_values);
  enum_values = SCM_EOL;
#ifndef NO_GNUTLS_PSK_KEY_RAW
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_psk_key_format_enum, (scm_t_bits) GNUTLS_PSK_KEY_RAW);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("psk-key-format/raw", enum_smob);
#endif /* not NO_GNUTLS_PSK_KEY_RAW */
#ifndef NO_GNUTLS_PSK_KEY_HEX
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_psk_key_format_enum, (scm_t_bits) GNUTLS_PSK_KEY_HEX);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("psk-key-format/hex", enum_smob);
#endif /* not NO_GNUTLS_PSK_KEY_HEX */
  scm_gnutls_psk_key_format_enum_values = scm_permanent_object (enum_values);
  enum_values = SCM_EOL;
#ifndef NO_GNUTLS_KEY_DIGITAL_SIGNATURE
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_key_usage_enum, (scm_t_bits) GNUTLS_KEY_DIGITAL_SIGNATURE);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("key-usage/digital-signature", enum_smob);
#endif /* not NO_GNUTLS_KEY_DIGITAL_SIGNATURE */
#ifndef NO_GNUTLS_KEY_NON_REPUDIATION
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_key_usage_enum, (scm_t_bits) GNUTLS_KEY_NON_REPUDIATION);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("key-usage/non-repudiation", enum_smob);
#endif /* not NO_GNUTLS_KEY_NON_REPUDIATION */
#ifndef NO_GNUTLS_KEY_KEY_ENCIPHERMENT
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_key_usage_enum, (scm_t_bits) GNUTLS_KEY_KEY_ENCIPHERMENT);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("key-usage/key-encipherment", enum_smob);
#endif /* not NO_GNUTLS_KEY_KEY_ENCIPHERMENT */
#ifndef NO_GNUTLS_KEY_DATA_ENCIPHERMENT
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_key_usage_enum, (scm_t_bits) GNUTLS_KEY_DATA_ENCIPHERMENT);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("key-usage/data-encipherment", enum_smob);
#endif /* not NO_GNUTLS_KEY_DATA_ENCIPHERMENT */
#ifndef NO_GNUTLS_KEY_KEY_AGREEMENT
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_key_usage_enum, (scm_t_bits) GNUTLS_KEY_KEY_AGREEMENT);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("key-usage/key-agreement", enum_smob);
#endif /* not NO_GNUTLS_KEY_KEY_AGREEMENT */
#ifndef NO_GNUTLS_KEY_KEY_CERT_SIGN
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_key_usage_enum, (scm_t_bits) GNUTLS_KEY_KEY_CERT_SIGN);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("key-usage/key-cert-sign", enum_smob);
#endif /* not NO_GNUTLS_KEY_KEY_CERT_SIGN */
#ifndef NO_GNUTLS_KEY_CRL_SIGN
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_key_usage_enum, (scm_t_bits) GNUTLS_KEY_CRL_SIGN);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("key-usage/crl-sign", enum_smob);
#endif /* not NO_GNUTLS_KEY_CRL_SIGN */
#ifndef NO_GNUTLS_KEY_ENCIPHER_ONLY
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_key_usage_enum, (scm_t_bits) GNUTLS_KEY_ENCIPHER_ONLY);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("key-usage/encipher-only", enum_smob);
#endif /* not NO_GNUTLS_KEY_ENCIPHER_ONLY */
#ifndef NO_GNUTLS_KEY_DECIPHER_ONLY
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_key_usage_enum, (scm_t_bits) GNUTLS_KEY_DECIPHER_ONLY);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("key-usage/decipher-only", enum_smob);
#endif /* not NO_GNUTLS_KEY_DECIPHER_ONLY */
  scm_gnutls_key_usage_enum_values = scm_permanent_object (enum_values);
  enum_values = SCM_EOL;
#ifndef NO_GNUTLS_VERIFY_DISABLE_CA_SIGN
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_certificate_verify_enum, (scm_t_bits) GNUTLS_VERIFY_DISABLE_CA_SIGN);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("certificate-verify/disable-ca-sign", enum_smob);
#endif /* not NO_GNUTLS_VERIFY_DISABLE_CA_SIGN */
#ifndef NO_GNUTLS_VERIFY_ALLOW_X509_V1_CA_CRT
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_certificate_verify_enum, (scm_t_bits) GNUTLS_VERIFY_ALLOW_X509_V1_CA_CRT);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("certificate-verify/allow-x509-v1-ca-crt", enum_smob);
#endif /* not NO_GNUTLS_VERIFY_ALLOW_X509_V1_CA_CRT */
#ifndef NO_GNUTLS_VERIFY_DO_NOT_ALLOW_SAME
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_certificate_verify_enum, (scm_t_bits) GNUTLS_VERIFY_DO_NOT_ALLOW_SAME);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("certificate-verify/do-not-allow-same", enum_smob);
#endif /* not NO_GNUTLS_VERIFY_DO_NOT_ALLOW_SAME */
#ifndef NO_GNUTLS_VERIFY_ALLOW_ANY_X509_V1_CA_CRT
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_certificate_verify_enum, (scm_t_bits) GNUTLS_VERIFY_ALLOW_ANY_X509_V1_CA_CRT);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("certificate-verify/allow-any-x509-v1-ca-crt", enum_smob);
#endif /* not NO_GNUTLS_VERIFY_ALLOW_ANY_X509_V1_CA_CRT */
#ifndef NO_GNUTLS_VERIFY_ALLOW_SIGN_RSA_MD2
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_certificate_verify_enum, (scm_t_bits) GNUTLS_VERIFY_ALLOW_SIGN_RSA_MD2);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("certificate-verify/allow-sign-rsa-md2", enum_smob);
#endif /* not NO_GNUTLS_VERIFY_ALLOW_SIGN_RSA_MD2 */
#ifndef NO_GNUTLS_VERIFY_ALLOW_SIGN_RSA_MD5
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_certificate_verify_enum, (scm_t_bits) GNUTLS_VERIFY_ALLOW_SIGN_RSA_MD5);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("certificate-verify/allow-sign-rsa-md5", enum_smob);
#endif /* not NO_GNUTLS_VERIFY_ALLOW_SIGN_RSA_MD5 */
  scm_gnutls_certificate_verify_enum_values = scm_permanent_object (enum_values);
  enum_values = SCM_EOL;
#ifndef NO_GNUTLS_E_SUCCESS
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_error_enum, (scm_t_bits) GNUTLS_E_SUCCESS);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/success", enum_smob);
#endif /* not NO_GNUTLS_E_SUCCESS */
#ifndef NO_GNUTLS_E_UNSUPPORTED_VERSION_PACKET
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_error_enum, (scm_t_bits) GNUTLS_E_UNSUPPORTED_VERSION_PACKET);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/unsupported-version-packet", enum_smob);
#endif /* not NO_GNUTLS_E_UNSUPPORTED_VERSION_PACKET */
#ifndef NO_GNUTLS_E_TLS_PACKET_DECODING_ERROR
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_error_enum, (scm_t_bits) GNUTLS_E_TLS_PACKET_DECODING_ERROR);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/tls-packet-decoding-error", enum_smob);
#endif /* not NO_GNUTLS_E_TLS_PACKET_DECODING_ERROR */
#ifndef NO_GNUTLS_E_UNEXPECTED_PACKET_LENGTH
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_error_enum, (scm_t_bits) GNUTLS_E_UNEXPECTED_PACKET_LENGTH);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/unexpected-packet-length", enum_smob);
#endif /* not NO_GNUTLS_E_UNEXPECTED_PACKET_LENGTH */
#ifndef NO_GNUTLS_E_INVALID_SESSION
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_error_enum, (scm_t_bits) GNUTLS_E_INVALID_SESSION);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/invalid-session", enum_smob);
#endif /* not NO_GNUTLS_E_INVALID_SESSION */
#ifndef NO_GNUTLS_E_FATAL_ALERT_RECEIVED
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_error_enum, (scm_t_bits) GNUTLS_E_FATAL_ALERT_RECEIVED);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/fatal-alert-received", enum_smob);
#endif /* not NO_GNUTLS_E_FATAL_ALERT_RECEIVED */
#ifndef NO_GNUTLS_E_UNEXPECTED_PACKET
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_error_enum, (scm_t_bits) GNUTLS_E_UNEXPECTED_PACKET);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/unexpected-packet", enum_smob);
#endif /* not NO_GNUTLS_E_UNEXPECTED_PACKET */
#ifndef NO_GNUTLS_E_WARNING_ALERT_RECEIVED
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_error_enum, (scm_t_bits) GNUTLS_E_WARNING_ALERT_RECEIVED);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/warning-alert-received", enum_smob);
#endif /* not NO_GNUTLS_E_WARNING_ALERT_RECEIVED */
#ifndef NO_GNUTLS_E_ERROR_IN_FINISHED_PACKET
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_error_enum, (scm_t_bits) GNUTLS_E_ERROR_IN_FINISHED_PACKET);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/error-in-finished-packet", enum_smob);
#endif /* not NO_GNUTLS_E_ERROR_IN_FINISHED_PACKET */
#ifndef NO_GNUTLS_E_UNEXPECTED_HANDSHAKE_PACKET
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_error_enum, (scm_t_bits) GNUTLS_E_UNEXPECTED_HANDSHAKE_PACKET);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/unexpected-handshake-packet", enum_smob);
#endif /* not NO_GNUTLS_E_UNEXPECTED_HANDSHAKE_PACKET */
#ifndef NO_GNUTLS_E_DECRYPTION_FAILED
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_error_enum, (scm_t_bits) GNUTLS_E_DECRYPTION_FAILED);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/decryption-failed", enum_smob);
#endif /* not NO_GNUTLS_E_DECRYPTION_FAILED */
#ifndef NO_GNUTLS_E_MEMORY_ERROR
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_error_enum, (scm_t_bits) GNUTLS_E_MEMORY_ERROR);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/memory-error", enum_smob);
#endif /* not NO_GNUTLS_E_MEMORY_ERROR */
#ifndef NO_GNUTLS_E_DECOMPRESSION_FAILED
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_error_enum, (scm_t_bits) GNUTLS_E_DECOMPRESSION_FAILED);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/decompression-failed", enum_smob);
#endif /* not NO_GNUTLS_E_DECOMPRESSION_FAILED */
#ifndef NO_GNUTLS_E_COMPRESSION_FAILED
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_error_enum, (scm_t_bits) GNUTLS_E_COMPRESSION_FAILED);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/compression-failed", enum_smob);
#endif /* not NO_GNUTLS_E_COMPRESSION_FAILED */
#ifndef NO_GNUTLS_E_AGAIN
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_error_enum, (scm_t_bits) GNUTLS_E_AGAIN);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/again", enum_smob);
#endif /* not NO_GNUTLS_E_AGAIN */
#ifndef NO_GNUTLS_E_EXPIRED
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_error_enum, (scm_t_bits) GNUTLS_E_EXPIRED);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/expired", enum_smob);
#endif /* not NO_GNUTLS_E_EXPIRED */
#ifndef NO_GNUTLS_E_DB_ERROR
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_error_enum, (scm_t_bits) GNUTLS_E_DB_ERROR);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/db-error", enum_smob);
#endif /* not NO_GNUTLS_E_DB_ERROR */
#ifndef NO_GNUTLS_E_SRP_PWD_ERROR
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_error_enum, (scm_t_bits) GNUTLS_E_SRP_PWD_ERROR);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/srp-pwd-error", enum_smob);
#endif /* not NO_GNUTLS_E_SRP_PWD_ERROR */
#ifndef NO_GNUTLS_E_KEYFILE_ERROR
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_error_enum, (scm_t_bits) GNUTLS_E_KEYFILE_ERROR);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/keyfile-error", enum_smob);
#endif /* not NO_GNUTLS_E_KEYFILE_ERROR */
#ifndef NO_GNUTLS_E_INSUFFICIENT_CREDENTIALS
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_error_enum, (scm_t_bits) GNUTLS_E_INSUFFICIENT_CREDENTIALS);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/insufficient-credentials", enum_smob);
#endif /* not NO_GNUTLS_E_INSUFFICIENT_CREDENTIALS */
#ifndef NO_GNUTLS_E_INSUFICIENT_CREDENTIALS
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_error_enum, (scm_t_bits) GNUTLS_E_INSUFICIENT_CREDENTIALS);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/insuficient-credentials", enum_smob);
#endif /* not NO_GNUTLS_E_INSUFICIENT_CREDENTIALS */
#ifndef NO_GNUTLS_E_INSUFFICIENT_CRED
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_error_enum, (scm_t_bits) GNUTLS_E_INSUFFICIENT_CRED);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/insufficient-cred", enum_smob);
#endif /* not NO_GNUTLS_E_INSUFFICIENT_CRED */
#ifndef NO_GNUTLS_E_INSUFICIENT_CRED
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_error_enum, (scm_t_bits) GNUTLS_E_INSUFICIENT_CRED);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/insuficient-cred", enum_smob);
#endif /* not NO_GNUTLS_E_INSUFICIENT_CRED */
#ifndef NO_GNUTLS_E_HASH_FAILED
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_error_enum, (scm_t_bits) GNUTLS_E_HASH_FAILED);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/hash-failed", enum_smob);
#endif /* not NO_GNUTLS_E_HASH_FAILED */
#ifndef NO_GNUTLS_E_BASE64_DECODING_ERROR
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_error_enum, (scm_t_bits) GNUTLS_E_BASE64_DECODING_ERROR);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/base64-decoding-error", enum_smob);
#endif /* not NO_GNUTLS_E_BASE64_DECODING_ERROR */
#ifndef NO_GNUTLS_E_REHANDSHAKE
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_error_enum, (scm_t_bits) GNUTLS_E_REHANDSHAKE);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/rehandshake", enum_smob);
#endif /* not NO_GNUTLS_E_REHANDSHAKE */
#ifndef NO_GNUTLS_E_GOT_APPLICATION_DATA
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_error_enum, (scm_t_bits) GNUTLS_E_GOT_APPLICATION_DATA);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/got-application-data", enum_smob);
#endif /* not NO_GNUTLS_E_GOT_APPLICATION_DATA */
#ifndef NO_GNUTLS_E_RECORD_LIMIT_REACHED
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_error_enum, (scm_t_bits) GNUTLS_E_RECORD_LIMIT_REACHED);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/record-limit-reached", enum_smob);
#endif /* not NO_GNUTLS_E_RECORD_LIMIT_REACHED */
#ifndef NO_GNUTLS_E_ENCRYPTION_FAILED
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_error_enum, (scm_t_bits) GNUTLS_E_ENCRYPTION_FAILED);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/encryption-failed", enum_smob);
#endif /* not NO_GNUTLS_E_ENCRYPTION_FAILED */
#ifndef NO_GNUTLS_E_PK_ENCRYPTION_FAILED
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_error_enum, (scm_t_bits) GNUTLS_E_PK_ENCRYPTION_FAILED);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/pk-encryption-failed", enum_smob);
#endif /* not NO_GNUTLS_E_PK_ENCRYPTION_FAILED */
#ifndef NO_GNUTLS_E_PK_DECRYPTION_FAILED
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_error_enum, (scm_t_bits) GNUTLS_E_PK_DECRYPTION_FAILED);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/pk-decryption-failed", enum_smob);
#endif /* not NO_GNUTLS_E_PK_DECRYPTION_FAILED */
#ifndef NO_GNUTLS_E_PK_SIGN_FAILED
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_error_enum, (scm_t_bits) GNUTLS_E_PK_SIGN_FAILED);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/pk-sign-failed", enum_smob);
#endif /* not NO_GNUTLS_E_PK_SIGN_FAILED */
#ifndef NO_GNUTLS_E_X509_UNSUPPORTED_CRITICAL_EXTENSION
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_error_enum, (scm_t_bits) GNUTLS_E_X509_UNSUPPORTED_CRITICAL_EXTENSION);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/x509-unsupported-critical-extension", enum_smob);
#endif /* not NO_GNUTLS_E_X509_UNSUPPORTED_CRITICAL_EXTENSION */
#ifndef NO_GNUTLS_E_KEY_USAGE_VIOLATION
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_error_enum, (scm_t_bits) GNUTLS_E_KEY_USAGE_VIOLATION);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/key-usage-violation", enum_smob);
#endif /* not NO_GNUTLS_E_KEY_USAGE_VIOLATION */
#ifndef NO_GNUTLS_E_NO_CERTIFICATE_FOUND
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_error_enum, (scm_t_bits) GNUTLS_E_NO_CERTIFICATE_FOUND);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/no-certificate-found", enum_smob);
#endif /* not NO_GNUTLS_E_NO_CERTIFICATE_FOUND */
#ifndef NO_GNUTLS_E_INVALID_REQUEST
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_error_enum, (scm_t_bits) GNUTLS_E_INVALID_REQUEST);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/invalid-request", enum_smob);
#endif /* not NO_GNUTLS_E_INVALID_REQUEST */
#ifndef NO_GNUTLS_E_SHORT_MEMORY_BUFFER
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_error_enum, (scm_t_bits) GNUTLS_E_SHORT_MEMORY_BUFFER);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/short-memory-buffer", enum_smob);
#endif /* not NO_GNUTLS_E_SHORT_MEMORY_BUFFER */
#ifndef NO_GNUTLS_E_INTERRUPTED
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_error_enum, (scm_t_bits) GNUTLS_E_INTERRUPTED);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/interrupted", enum_smob);
#endif /* not NO_GNUTLS_E_INTERRUPTED */
#ifndef NO_GNUTLS_E_PUSH_ERROR
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_error_enum, (scm_t_bits) GNUTLS_E_PUSH_ERROR);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/push-error", enum_smob);
#endif /* not NO_GNUTLS_E_PUSH_ERROR */
#ifndef NO_GNUTLS_E_PULL_ERROR
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_error_enum, (scm_t_bits) GNUTLS_E_PULL_ERROR);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/pull-error", enum_smob);
#endif /* not NO_GNUTLS_E_PULL_ERROR */
#ifndef NO_GNUTLS_E_RECEIVED_ILLEGAL_PARAMETER
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_error_enum, (scm_t_bits) GNUTLS_E_RECEIVED_ILLEGAL_PARAMETER);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/received-illegal-parameter", enum_smob);
#endif /* not NO_GNUTLS_E_RECEIVED_ILLEGAL_PARAMETER */
#ifndef NO_GNUTLS_E_REQUESTED_DATA_NOT_AVAILABLE
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_error_enum, (scm_t_bits) GNUTLS_E_REQUESTED_DATA_NOT_AVAILABLE);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/requested-data-not-available", enum_smob);
#endif /* not NO_GNUTLS_E_REQUESTED_DATA_NOT_AVAILABLE */
#ifndef NO_GNUTLS_E_PKCS1_WRONG_PAD
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_error_enum, (scm_t_bits) GNUTLS_E_PKCS1_WRONG_PAD);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/pkcs1-wrong-pad", enum_smob);
#endif /* not NO_GNUTLS_E_PKCS1_WRONG_PAD */
#ifndef NO_GNUTLS_E_RECEIVED_ILLEGAL_EXTENSION
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_error_enum, (scm_t_bits) GNUTLS_E_RECEIVED_ILLEGAL_EXTENSION);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/received-illegal-extension", enum_smob);
#endif /* not NO_GNUTLS_E_RECEIVED_ILLEGAL_EXTENSION */
#ifndef NO_GNUTLS_E_INTERNAL_ERROR
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_error_enum, (scm_t_bits) GNUTLS_E_INTERNAL_ERROR);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/internal-error", enum_smob);
#endif /* not NO_GNUTLS_E_INTERNAL_ERROR */
#ifndef NO_GNUTLS_E_DH_PRIME_UNACCEPTABLE
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_error_enum, (scm_t_bits) GNUTLS_E_DH_PRIME_UNACCEPTABLE);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/dh-prime-unacceptable", enum_smob);
#endif /* not NO_GNUTLS_E_DH_PRIME_UNACCEPTABLE */
#ifndef NO_GNUTLS_E_FILE_ERROR
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_error_enum, (scm_t_bits) GNUTLS_E_FILE_ERROR);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/file-error", enum_smob);
#endif /* not NO_GNUTLS_E_FILE_ERROR */
#ifndef NO_GNUTLS_E_TOO_MANY_EMPTY_PACKETS
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_error_enum, (scm_t_bits) GNUTLS_E_TOO_MANY_EMPTY_PACKETS);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/too-many-empty-packets", enum_smob);
#endif /* not NO_GNUTLS_E_TOO_MANY_EMPTY_PACKETS */
#ifndef NO_GNUTLS_E_UNKNOWN_PK_ALGORITHM
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_error_enum, (scm_t_bits) GNUTLS_E_UNKNOWN_PK_ALGORITHM);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/unknown-pk-algorithm", enum_smob);
#endif /* not NO_GNUTLS_E_UNKNOWN_PK_ALGORITHM */
#ifndef NO_GNUTLS_E_TOO_MANY_HANDSHAKE_PACKETS
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_error_enum, (scm_t_bits) GNUTLS_E_TOO_MANY_HANDSHAKE_PACKETS);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/too-many-handshake-packets", enum_smob);
#endif /* not NO_GNUTLS_E_TOO_MANY_HANDSHAKE_PACKETS */
#ifndef NO_GNUTLS_E_RECEIVED_DISALLOWED_NAME
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_error_enum, (scm_t_bits) GNUTLS_E_RECEIVED_DISALLOWED_NAME);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/received-disallowed-name", enum_smob);
#endif /* not NO_GNUTLS_E_RECEIVED_DISALLOWED_NAME */
#ifndef NO_GNUTLS_E_CERTIFICATE_REQUIRED
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_error_enum, (scm_t_bits) GNUTLS_E_CERTIFICATE_REQUIRED);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/certificate-required", enum_smob);
#endif /* not NO_GNUTLS_E_CERTIFICATE_REQUIRED */
#ifndef NO_GNUTLS_E_NO_TEMPORARY_RSA_PARAMS
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_error_enum, (scm_t_bits) GNUTLS_E_NO_TEMPORARY_RSA_PARAMS);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/no-temporary-rsa-params", enum_smob);
#endif /* not NO_GNUTLS_E_NO_TEMPORARY_RSA_PARAMS */
#ifndef NO_GNUTLS_E_NO_COMPRESSION_ALGORITHMS
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_error_enum, (scm_t_bits) GNUTLS_E_NO_COMPRESSION_ALGORITHMS);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/no-compression-algorithms", enum_smob);
#endif /* not NO_GNUTLS_E_NO_COMPRESSION_ALGORITHMS */
#ifndef NO_GNUTLS_E_NO_CIPHER_SUITES
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_error_enum, (scm_t_bits) GNUTLS_E_NO_CIPHER_SUITES);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/no-cipher-suites", enum_smob);
#endif /* not NO_GNUTLS_E_NO_CIPHER_SUITES */
#ifndef NO_GNUTLS_E_OPENPGP_GETKEY_FAILED
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_error_enum, (scm_t_bits) GNUTLS_E_OPENPGP_GETKEY_FAILED);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/openpgp-getkey-failed", enum_smob);
#endif /* not NO_GNUTLS_E_OPENPGP_GETKEY_FAILED */
#ifndef NO_GNUTLS_E_PK_SIG_VERIFY_FAILED
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_error_enum, (scm_t_bits) GNUTLS_E_PK_SIG_VERIFY_FAILED);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/pk-sig-verify-failed", enum_smob);
#endif /* not NO_GNUTLS_E_PK_SIG_VERIFY_FAILED */
#ifndef NO_GNUTLS_E_ILLEGAL_SRP_USERNAME
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_error_enum, (scm_t_bits) GNUTLS_E_ILLEGAL_SRP_USERNAME);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/illegal-srp-username", enum_smob);
#endif /* not NO_GNUTLS_E_ILLEGAL_SRP_USERNAME */
#ifndef NO_GNUTLS_E_SRP_PWD_PARSING_ERROR
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_error_enum, (scm_t_bits) GNUTLS_E_SRP_PWD_PARSING_ERROR);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/srp-pwd-parsing-error", enum_smob);
#endif /* not NO_GNUTLS_E_SRP_PWD_PARSING_ERROR */
#ifndef NO_GNUTLS_E_KEYFILE_PARSING_ERROR
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_error_enum, (scm_t_bits) GNUTLS_E_KEYFILE_PARSING_ERROR);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/keyfile-parsing-error", enum_smob);
#endif /* not NO_GNUTLS_E_KEYFILE_PARSING_ERROR */
#ifndef NO_GNUTLS_E_NO_TEMPORARY_DH_PARAMS
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_error_enum, (scm_t_bits) GNUTLS_E_NO_TEMPORARY_DH_PARAMS);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/no-temporary-dh-params", enum_smob);
#endif /* not NO_GNUTLS_E_NO_TEMPORARY_DH_PARAMS */
#ifndef NO_GNUTLS_E_ASN1_ELEMENT_NOT_FOUND
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_error_enum, (scm_t_bits) GNUTLS_E_ASN1_ELEMENT_NOT_FOUND);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/asn1-element-not-found", enum_smob);
#endif /* not NO_GNUTLS_E_ASN1_ELEMENT_NOT_FOUND */
#ifndef NO_GNUTLS_E_ASN1_IDENTIFIER_NOT_FOUND
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_error_enum, (scm_t_bits) GNUTLS_E_ASN1_IDENTIFIER_NOT_FOUND);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/asn1-identifier-not-found", enum_smob);
#endif /* not NO_GNUTLS_E_ASN1_IDENTIFIER_NOT_FOUND */
#ifndef NO_GNUTLS_E_ASN1_DER_ERROR
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_error_enum, (scm_t_bits) GNUTLS_E_ASN1_DER_ERROR);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/asn1-der-error", enum_smob);
#endif /* not NO_GNUTLS_E_ASN1_DER_ERROR */
#ifndef NO_GNUTLS_E_ASN1_VALUE_NOT_FOUND
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_error_enum, (scm_t_bits) GNUTLS_E_ASN1_VALUE_NOT_FOUND);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/asn1-value-not-found", enum_smob);
#endif /* not NO_GNUTLS_E_ASN1_VALUE_NOT_FOUND */
#ifndef NO_GNUTLS_E_ASN1_GENERIC_ERROR
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_error_enum, (scm_t_bits) GNUTLS_E_ASN1_GENERIC_ERROR);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/asn1-generic-error", enum_smob);
#endif /* not NO_GNUTLS_E_ASN1_GENERIC_ERROR */
#ifndef NO_GNUTLS_E_ASN1_VALUE_NOT_VALID
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_error_enum, (scm_t_bits) GNUTLS_E_ASN1_VALUE_NOT_VALID);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/asn1-value-not-valid", enum_smob);
#endif /* not NO_GNUTLS_E_ASN1_VALUE_NOT_VALID */
#ifndef NO_GNUTLS_E_ASN1_TAG_ERROR
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_error_enum, (scm_t_bits) GNUTLS_E_ASN1_TAG_ERROR);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/asn1-tag-error", enum_smob);
#endif /* not NO_GNUTLS_E_ASN1_TAG_ERROR */
#ifndef NO_GNUTLS_E_ASN1_TAG_IMPLICIT
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_error_enum, (scm_t_bits) GNUTLS_E_ASN1_TAG_IMPLICIT);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/asn1-tag-implicit", enum_smob);
#endif /* not NO_GNUTLS_E_ASN1_TAG_IMPLICIT */
#ifndef NO_GNUTLS_E_ASN1_TYPE_ANY_ERROR
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_error_enum, (scm_t_bits) GNUTLS_E_ASN1_TYPE_ANY_ERROR);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/asn1-type-any-error", enum_smob);
#endif /* not NO_GNUTLS_E_ASN1_TYPE_ANY_ERROR */
#ifndef NO_GNUTLS_E_ASN1_SYNTAX_ERROR
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_error_enum, (scm_t_bits) GNUTLS_E_ASN1_SYNTAX_ERROR);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/asn1-syntax-error", enum_smob);
#endif /* not NO_GNUTLS_E_ASN1_SYNTAX_ERROR */
#ifndef NO_GNUTLS_E_ASN1_DER_OVERFLOW
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_error_enum, (scm_t_bits) GNUTLS_E_ASN1_DER_OVERFLOW);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/asn1-der-overflow", enum_smob);
#endif /* not NO_GNUTLS_E_ASN1_DER_OVERFLOW */
#ifndef NO_GNUTLS_E_OPENPGP_UID_REVOKED
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_error_enum, (scm_t_bits) GNUTLS_E_OPENPGP_UID_REVOKED);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/openpgp-uid-revoked", enum_smob);
#endif /* not NO_GNUTLS_E_OPENPGP_UID_REVOKED */
#ifndef NO_GNUTLS_E_CERTIFICATE_ERROR
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_error_enum, (scm_t_bits) GNUTLS_E_CERTIFICATE_ERROR);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/certificate-error", enum_smob);
#endif /* not NO_GNUTLS_E_CERTIFICATE_ERROR */
#ifndef NO_GNUTLS_E_X509_CERTIFICATE_ERROR
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_error_enum, (scm_t_bits) GNUTLS_E_X509_CERTIFICATE_ERROR);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/x509-certificate-error", enum_smob);
#endif /* not NO_GNUTLS_E_X509_CERTIFICATE_ERROR */
#ifndef NO_GNUTLS_E_CERTIFICATE_KEY_MISMATCH
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_error_enum, (scm_t_bits) GNUTLS_E_CERTIFICATE_KEY_MISMATCH);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/certificate-key-mismatch", enum_smob);
#endif /* not NO_GNUTLS_E_CERTIFICATE_KEY_MISMATCH */
#ifndef NO_GNUTLS_E_UNSUPPORTED_CERTIFICATE_TYPE
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_error_enum, (scm_t_bits) GNUTLS_E_UNSUPPORTED_CERTIFICATE_TYPE);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/unsupported-certificate-type", enum_smob);
#endif /* not NO_GNUTLS_E_UNSUPPORTED_CERTIFICATE_TYPE */
#ifndef NO_GNUTLS_E_X509_UNKNOWN_SAN
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_error_enum, (scm_t_bits) GNUTLS_E_X509_UNKNOWN_SAN);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/x509-unknown-san", enum_smob);
#endif /* not NO_GNUTLS_E_X509_UNKNOWN_SAN */
#ifndef NO_GNUTLS_E_OPENPGP_FINGERPRINT_UNSUPPORTED
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_error_enum, (scm_t_bits) GNUTLS_E_OPENPGP_FINGERPRINT_UNSUPPORTED);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/openpgp-fingerprint-unsupported", enum_smob);
#endif /* not NO_GNUTLS_E_OPENPGP_FINGERPRINT_UNSUPPORTED */
#ifndef NO_GNUTLS_E_X509_UNSUPPORTED_ATTRIBUTE
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_error_enum, (scm_t_bits) GNUTLS_E_X509_UNSUPPORTED_ATTRIBUTE);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/x509-unsupported-attribute", enum_smob);
#endif /* not NO_GNUTLS_E_X509_UNSUPPORTED_ATTRIBUTE */
#ifndef NO_GNUTLS_E_UNKNOWN_HASH_ALGORITHM
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_error_enum, (scm_t_bits) GNUTLS_E_UNKNOWN_HASH_ALGORITHM);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/unknown-hash-algorithm", enum_smob);
#endif /* not NO_GNUTLS_E_UNKNOWN_HASH_ALGORITHM */
#ifndef NO_GNUTLS_E_UNKNOWN_PKCS_CONTENT_TYPE
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_error_enum, (scm_t_bits) GNUTLS_E_UNKNOWN_PKCS_CONTENT_TYPE);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/unknown-pkcs-content-type", enum_smob);
#endif /* not NO_GNUTLS_E_UNKNOWN_PKCS_CONTENT_TYPE */
#ifndef NO_GNUTLS_E_UNKNOWN_PKCS_BAG_TYPE
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_error_enum, (scm_t_bits) GNUTLS_E_UNKNOWN_PKCS_BAG_TYPE);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/unknown-pkcs-bag-type", enum_smob);
#endif /* not NO_GNUTLS_E_UNKNOWN_PKCS_BAG_TYPE */
#ifndef NO_GNUTLS_E_INVALID_PASSWORD
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_error_enum, (scm_t_bits) GNUTLS_E_INVALID_PASSWORD);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/invalid-password", enum_smob);
#endif /* not NO_GNUTLS_E_INVALID_PASSWORD */
#ifndef NO_GNUTLS_E_MAC_VERIFY_FAILED
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_error_enum, (scm_t_bits) GNUTLS_E_MAC_VERIFY_FAILED);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/mac-verify-failed", enum_smob);
#endif /* not NO_GNUTLS_E_MAC_VERIFY_FAILED */
#ifndef NO_GNUTLS_E_CONSTRAINT_ERROR
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_error_enum, (scm_t_bits) GNUTLS_E_CONSTRAINT_ERROR);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/constraint-error", enum_smob);
#endif /* not NO_GNUTLS_E_CONSTRAINT_ERROR */
#ifndef NO_GNUTLS_E_WARNING_IA_IPHF_RECEIVED
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_error_enum, (scm_t_bits) GNUTLS_E_WARNING_IA_IPHF_RECEIVED);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/warning-ia-iphf-received", enum_smob);
#endif /* not NO_GNUTLS_E_WARNING_IA_IPHF_RECEIVED */
#ifndef NO_GNUTLS_E_WARNING_IA_FPHF_RECEIVED
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_error_enum, (scm_t_bits) GNUTLS_E_WARNING_IA_FPHF_RECEIVED);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/warning-ia-fphf-received", enum_smob);
#endif /* not NO_GNUTLS_E_WARNING_IA_FPHF_RECEIVED */
#ifndef NO_GNUTLS_E_IA_VERIFY_FAILED
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_error_enum, (scm_t_bits) GNUTLS_E_IA_VERIFY_FAILED);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/ia-verify-failed", enum_smob);
#endif /* not NO_GNUTLS_E_IA_VERIFY_FAILED */
#ifndef NO_GNUTLS_E_UNKNOWN_ALGORITHM
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_error_enum, (scm_t_bits) GNUTLS_E_UNKNOWN_ALGORITHM);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/unknown-algorithm", enum_smob);
#endif /* not NO_GNUTLS_E_UNKNOWN_ALGORITHM */
#ifndef NO_GNUTLS_E_UNSUPPORTED_SIGNATURE_ALGORITHM
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_error_enum, (scm_t_bits) GNUTLS_E_UNSUPPORTED_SIGNATURE_ALGORITHM);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/unsupported-signature-algorithm", enum_smob);
#endif /* not NO_GNUTLS_E_UNSUPPORTED_SIGNATURE_ALGORITHM */
#ifndef NO_GNUTLS_E_SAFE_RENEGOTIATION_FAILED
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_error_enum, (scm_t_bits) GNUTLS_E_SAFE_RENEGOTIATION_FAILED);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/safe-renegotiation-failed", enum_smob);
#endif /* not NO_GNUTLS_E_SAFE_RENEGOTIATION_FAILED */
#ifndef NO_GNUTLS_E_UNSAFE_RENEGOTIATION_DENIED
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_error_enum, (scm_t_bits) GNUTLS_E_UNSAFE_RENEGOTIATION_DENIED);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/unsafe-renegotiation-denied", enum_smob);
#endif /* not NO_GNUTLS_E_UNSAFE_RENEGOTIATION_DENIED */
#ifndef NO_GNUTLS_E_UNKNOWN_SRP_USERNAME
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_error_enum, (scm_t_bits) GNUTLS_E_UNKNOWN_SRP_USERNAME);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/unknown-srp-username", enum_smob);
#endif /* not NO_GNUTLS_E_UNKNOWN_SRP_USERNAME */
#ifndef NO_GNUTLS_E_PREMATURE_TERMINATION
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_error_enum, (scm_t_bits) GNUTLS_E_PREMATURE_TERMINATION);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/premature-termination", enum_smob);
#endif /* not NO_GNUTLS_E_PREMATURE_TERMINATION */
#ifndef NO_GNUTLS_E_MALFORMED_CIDR
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_error_enum, (scm_t_bits) GNUTLS_E_MALFORMED_CIDR);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/malformed-cidr", enum_smob);
#endif /* not NO_GNUTLS_E_MALFORMED_CIDR */
#ifndef NO_GNUTLS_E_BASE64_ENCODING_ERROR
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_error_enum, (scm_t_bits) GNUTLS_E_BASE64_ENCODING_ERROR);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/base64-encoding-error", enum_smob);
#endif /* not NO_GNUTLS_E_BASE64_ENCODING_ERROR */
#ifndef NO_GNUTLS_E_INCOMPATIBLE_GCRYPT_LIBRARY
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_error_enum, (scm_t_bits) GNUTLS_E_INCOMPATIBLE_GCRYPT_LIBRARY);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/incompatible-gcrypt-library", enum_smob);
#endif /* not NO_GNUTLS_E_INCOMPATIBLE_GCRYPT_LIBRARY */
#ifndef NO_GNUTLS_E_INCOMPATIBLE_CRYPTO_LIBRARY
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_error_enum, (scm_t_bits) GNUTLS_E_INCOMPATIBLE_CRYPTO_LIBRARY);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/incompatible-crypto-library", enum_smob);
#endif /* not NO_GNUTLS_E_INCOMPATIBLE_CRYPTO_LIBRARY */
#ifndef NO_GNUTLS_E_INCOMPATIBLE_LIBTASN1_LIBRARY
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_error_enum, (scm_t_bits) GNUTLS_E_INCOMPATIBLE_LIBTASN1_LIBRARY);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/incompatible-libtasn1-library", enum_smob);
#endif /* not NO_GNUTLS_E_INCOMPATIBLE_LIBTASN1_LIBRARY */
#ifndef NO_GNUTLS_E_OPENPGP_KEYRING_ERROR
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_error_enum, (scm_t_bits) GNUTLS_E_OPENPGP_KEYRING_ERROR);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/openpgp-keyring-error", enum_smob);
#endif /* not NO_GNUTLS_E_OPENPGP_KEYRING_ERROR */
#ifndef NO_GNUTLS_E_X509_UNSUPPORTED_OID
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_error_enum, (scm_t_bits) GNUTLS_E_X509_UNSUPPORTED_OID);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/x509-unsupported-oid", enum_smob);
#endif /* not NO_GNUTLS_E_X509_UNSUPPORTED_OID */
#ifndef NO_GNUTLS_E_RANDOM_FAILED
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_error_enum, (scm_t_bits) GNUTLS_E_RANDOM_FAILED);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/random-failed", enum_smob);
#endif /* not NO_GNUTLS_E_RANDOM_FAILED */
#ifndef NO_GNUTLS_E_BASE64_UNEXPECTED_HEADER_ERROR
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_error_enum, (scm_t_bits) GNUTLS_E_BASE64_UNEXPECTED_HEADER_ERROR);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/base64-unexpected-header-error", enum_smob);
#endif /* not NO_GNUTLS_E_BASE64_UNEXPECTED_HEADER_ERROR */
#ifndef NO_GNUTLS_E_OPENPGP_SUBKEY_ERROR
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_error_enum, (scm_t_bits) GNUTLS_E_OPENPGP_SUBKEY_ERROR);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/openpgp-subkey-error", enum_smob);
#endif /* not NO_GNUTLS_E_OPENPGP_SUBKEY_ERROR */
#ifndef NO_GNUTLS_E_CRYPTO_ALREADY_REGISTERED
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_error_enum, (scm_t_bits) GNUTLS_E_CRYPTO_ALREADY_REGISTERED);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/crypto-already-registered", enum_smob);
#endif /* not NO_GNUTLS_E_CRYPTO_ALREADY_REGISTERED */
#ifndef NO_GNUTLS_E_ALREADY_REGISTERED
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_error_enum, (scm_t_bits) GNUTLS_E_ALREADY_REGISTERED);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/already-registered", enum_smob);
#endif /* not NO_GNUTLS_E_ALREADY_REGISTERED */
#ifndef NO_GNUTLS_E_HANDSHAKE_TOO_LARGE
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_error_enum, (scm_t_bits) GNUTLS_E_HANDSHAKE_TOO_LARGE);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/handshake-too-large", enum_smob);
#endif /* not NO_GNUTLS_E_HANDSHAKE_TOO_LARGE */
#ifndef NO_GNUTLS_E_CRYPTODEV_IOCTL_ERROR
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_error_enum, (scm_t_bits) GNUTLS_E_CRYPTODEV_IOCTL_ERROR);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/cryptodev-ioctl-error", enum_smob);
#endif /* not NO_GNUTLS_E_CRYPTODEV_IOCTL_ERROR */
#ifndef NO_GNUTLS_E_CRYPTODEV_DEVICE_ERROR
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_error_enum, (scm_t_bits) GNUTLS_E_CRYPTODEV_DEVICE_ERROR);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/cryptodev-device-error", enum_smob);
#endif /* not NO_GNUTLS_E_CRYPTODEV_DEVICE_ERROR */
#ifndef NO_GNUTLS_E_CHANNEL_BINDING_NOT_AVAILABLE
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_error_enum, (scm_t_bits) GNUTLS_E_CHANNEL_BINDING_NOT_AVAILABLE);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/channel-binding-not-available", enum_smob);
#endif /* not NO_GNUTLS_E_CHANNEL_BINDING_NOT_AVAILABLE */
#ifndef NO_GNUTLS_E_BAD_COOKIE
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_error_enum, (scm_t_bits) GNUTLS_E_BAD_COOKIE);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/bad-cookie", enum_smob);
#endif /* not NO_GNUTLS_E_BAD_COOKIE */
#ifndef NO_GNUTLS_E_OPENPGP_PREFERRED_KEY_ERROR
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_error_enum, (scm_t_bits) GNUTLS_E_OPENPGP_PREFERRED_KEY_ERROR);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/openpgp-preferred-key-error", enum_smob);
#endif /* not NO_GNUTLS_E_OPENPGP_PREFERRED_KEY_ERROR */
#ifndef NO_GNUTLS_E_INCOMPAT_DSA_KEY_WITH_TLS_PROTOCOL
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_error_enum, (scm_t_bits) GNUTLS_E_INCOMPAT_DSA_KEY_WITH_TLS_PROTOCOL);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/incompat-dsa-key-with-tls-protocol", enum_smob);
#endif /* not NO_GNUTLS_E_INCOMPAT_DSA_KEY_WITH_TLS_PROTOCOL */
#ifndef NO_GNUTLS_E_INSUFFICIENT_SECURITY
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_error_enum, (scm_t_bits) GNUTLS_E_INSUFFICIENT_SECURITY);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/insufficient-security", enum_smob);
#endif /* not NO_GNUTLS_E_INSUFFICIENT_SECURITY */
#ifndef NO_GNUTLS_E_HEARTBEAT_PONG_RECEIVED
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_error_enum, (scm_t_bits) GNUTLS_E_HEARTBEAT_PONG_RECEIVED);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/heartbeat-pong-received", enum_smob);
#endif /* not NO_GNUTLS_E_HEARTBEAT_PONG_RECEIVED */
#ifndef NO_GNUTLS_E_HEARTBEAT_PING_RECEIVED
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_error_enum, (scm_t_bits) GNUTLS_E_HEARTBEAT_PING_RECEIVED);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/heartbeat-ping-received", enum_smob);
#endif /* not NO_GNUTLS_E_HEARTBEAT_PING_RECEIVED */
#ifndef NO_GNUTLS_E_UNRECOGNIZED_NAME
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_error_enum, (scm_t_bits) GNUTLS_E_UNRECOGNIZED_NAME);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/unrecognized-name", enum_smob);
#endif /* not NO_GNUTLS_E_UNRECOGNIZED_NAME */
#ifndef NO_GNUTLS_E_PKCS11_ERROR
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_error_enum, (scm_t_bits) GNUTLS_E_PKCS11_ERROR);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/pkcs11-error", enum_smob);
#endif /* not NO_GNUTLS_E_PKCS11_ERROR */
#ifndef NO_GNUTLS_E_PKCS11_LOAD_ERROR
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_error_enum, (scm_t_bits) GNUTLS_E_PKCS11_LOAD_ERROR);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/pkcs11-load-error", enum_smob);
#endif /* not NO_GNUTLS_E_PKCS11_LOAD_ERROR */
#ifndef NO_GNUTLS_E_PARSING_ERROR
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_error_enum, (scm_t_bits) GNUTLS_E_PARSING_ERROR);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/parsing-error", enum_smob);
#endif /* not NO_GNUTLS_E_PARSING_ERROR */
#ifndef NO_GNUTLS_E_PKCS11_PIN_ERROR
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_error_enum, (scm_t_bits) GNUTLS_E_PKCS11_PIN_ERROR);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/pkcs11-pin-error", enum_smob);
#endif /* not NO_GNUTLS_E_PKCS11_PIN_ERROR */
#ifndef NO_GNUTLS_E_PKCS11_SLOT_ERROR
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_error_enum, (scm_t_bits) GNUTLS_E_PKCS11_SLOT_ERROR);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/pkcs11-slot-error", enum_smob);
#endif /* not NO_GNUTLS_E_PKCS11_SLOT_ERROR */
#ifndef NO_GNUTLS_E_LOCKING_ERROR
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_error_enum, (scm_t_bits) GNUTLS_E_LOCKING_ERROR);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/locking-error", enum_smob);
#endif /* not NO_GNUTLS_E_LOCKING_ERROR */
#ifndef NO_GNUTLS_E_PKCS11_ATTRIBUTE_ERROR
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_error_enum, (scm_t_bits) GNUTLS_E_PKCS11_ATTRIBUTE_ERROR);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/pkcs11-attribute-error", enum_smob);
#endif /* not NO_GNUTLS_E_PKCS11_ATTRIBUTE_ERROR */
#ifndef NO_GNUTLS_E_PKCS11_DEVICE_ERROR
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_error_enum, (scm_t_bits) GNUTLS_E_PKCS11_DEVICE_ERROR);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/pkcs11-device-error", enum_smob);
#endif /* not NO_GNUTLS_E_PKCS11_DEVICE_ERROR */
#ifndef NO_GNUTLS_E_PKCS11_DATA_ERROR
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_error_enum, (scm_t_bits) GNUTLS_E_PKCS11_DATA_ERROR);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/pkcs11-data-error", enum_smob);
#endif /* not NO_GNUTLS_E_PKCS11_DATA_ERROR */
#ifndef NO_GNUTLS_E_PKCS11_UNSUPPORTED_FEATURE_ERROR
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_error_enum, (scm_t_bits) GNUTLS_E_PKCS11_UNSUPPORTED_FEATURE_ERROR);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/pkcs11-unsupported-feature-error", enum_smob);
#endif /* not NO_GNUTLS_E_PKCS11_UNSUPPORTED_FEATURE_ERROR */
#ifndef NO_GNUTLS_E_PKCS11_KEY_ERROR
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_error_enum, (scm_t_bits) GNUTLS_E_PKCS11_KEY_ERROR);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/pkcs11-key-error", enum_smob);
#endif /* not NO_GNUTLS_E_PKCS11_KEY_ERROR */
#ifndef NO_GNUTLS_E_PKCS11_PIN_EXPIRED
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_error_enum, (scm_t_bits) GNUTLS_E_PKCS11_PIN_EXPIRED);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/pkcs11-pin-expired", enum_smob);
#endif /* not NO_GNUTLS_E_PKCS11_PIN_EXPIRED */
#ifndef NO_GNUTLS_E_PKCS11_PIN_LOCKED
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_error_enum, (scm_t_bits) GNUTLS_E_PKCS11_PIN_LOCKED);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/pkcs11-pin-locked", enum_smob);
#endif /* not NO_GNUTLS_E_PKCS11_PIN_LOCKED */
#ifndef NO_GNUTLS_E_PKCS11_SESSION_ERROR
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_error_enum, (scm_t_bits) GNUTLS_E_PKCS11_SESSION_ERROR);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/pkcs11-session-error", enum_smob);
#endif /* not NO_GNUTLS_E_PKCS11_SESSION_ERROR */
#ifndef NO_GNUTLS_E_PKCS11_SIGNATURE_ERROR
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_error_enum, (scm_t_bits) GNUTLS_E_PKCS11_SIGNATURE_ERROR);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/pkcs11-signature-error", enum_smob);
#endif /* not NO_GNUTLS_E_PKCS11_SIGNATURE_ERROR */
#ifndef NO_GNUTLS_E_PKCS11_TOKEN_ERROR
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_error_enum, (scm_t_bits) GNUTLS_E_PKCS11_TOKEN_ERROR);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/pkcs11-token-error", enum_smob);
#endif /* not NO_GNUTLS_E_PKCS11_TOKEN_ERROR */
#ifndef NO_GNUTLS_E_PKCS11_USER_ERROR
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_error_enum, (scm_t_bits) GNUTLS_E_PKCS11_USER_ERROR);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/pkcs11-user-error", enum_smob);
#endif /* not NO_GNUTLS_E_PKCS11_USER_ERROR */
#ifndef NO_GNUTLS_E_CRYPTO_INIT_FAILED
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_error_enum, (scm_t_bits) GNUTLS_E_CRYPTO_INIT_FAILED);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/crypto-init-failed", enum_smob);
#endif /* not NO_GNUTLS_E_CRYPTO_INIT_FAILED */
#ifndef NO_GNUTLS_E_TIMEDOUT
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_error_enum, (scm_t_bits) GNUTLS_E_TIMEDOUT);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/timedout", enum_smob);
#endif /* not NO_GNUTLS_E_TIMEDOUT */
#ifndef NO_GNUTLS_E_USER_ERROR
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_error_enum, (scm_t_bits) GNUTLS_E_USER_ERROR);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/user-error", enum_smob);
#endif /* not NO_GNUTLS_E_USER_ERROR */
#ifndef NO_GNUTLS_E_ECC_NO_SUPPORTED_CURVES
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_error_enum, (scm_t_bits) GNUTLS_E_ECC_NO_SUPPORTED_CURVES);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/ecc-no-supported-curves", enum_smob);
#endif /* not NO_GNUTLS_E_ECC_NO_SUPPORTED_CURVES */
#ifndef NO_GNUTLS_E_ECC_UNSUPPORTED_CURVE
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_error_enum, (scm_t_bits) GNUTLS_E_ECC_UNSUPPORTED_CURVE);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/ecc-unsupported-curve", enum_smob);
#endif /* not NO_GNUTLS_E_ECC_UNSUPPORTED_CURVE */
#ifndef NO_GNUTLS_E_PKCS11_REQUESTED_OBJECT_NOT_AVAILBLE
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_error_enum, (scm_t_bits) GNUTLS_E_PKCS11_REQUESTED_OBJECT_NOT_AVAILBLE);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/pkcs11-requested-object-not-availble", enum_smob);
#endif /* not NO_GNUTLS_E_PKCS11_REQUESTED_OBJECT_NOT_AVAILBLE */
#ifndef NO_GNUTLS_E_CERTIFICATE_LIST_UNSORTED
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_error_enum, (scm_t_bits) GNUTLS_E_CERTIFICATE_LIST_UNSORTED);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/certificate-list-unsorted", enum_smob);
#endif /* not NO_GNUTLS_E_CERTIFICATE_LIST_UNSORTED */
#ifndef NO_GNUTLS_E_ILLEGAL_PARAMETER
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_error_enum, (scm_t_bits) GNUTLS_E_ILLEGAL_PARAMETER);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/illegal-parameter", enum_smob);
#endif /* not NO_GNUTLS_E_ILLEGAL_PARAMETER */
#ifndef NO_GNUTLS_E_NO_PRIORITIES_WERE_SET
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_error_enum, (scm_t_bits) GNUTLS_E_NO_PRIORITIES_WERE_SET);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/no-priorities-were-set", enum_smob);
#endif /* not NO_GNUTLS_E_NO_PRIORITIES_WERE_SET */
#ifndef NO_GNUTLS_E_X509_UNSUPPORTED_EXTENSION
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_error_enum, (scm_t_bits) GNUTLS_E_X509_UNSUPPORTED_EXTENSION);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/x509-unsupported-extension", enum_smob);
#endif /* not NO_GNUTLS_E_X509_UNSUPPORTED_EXTENSION */
#ifndef NO_GNUTLS_E_SESSION_EOF
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_error_enum, (scm_t_bits) GNUTLS_E_SESSION_EOF);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/session-eof", enum_smob);
#endif /* not NO_GNUTLS_E_SESSION_EOF */
#ifndef NO_GNUTLS_E_TPM_ERROR
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_error_enum, (scm_t_bits) GNUTLS_E_TPM_ERROR);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/tpm-error", enum_smob);
#endif /* not NO_GNUTLS_E_TPM_ERROR */
#ifndef NO_GNUTLS_E_TPM_KEY_PASSWORD_ERROR
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_error_enum, (scm_t_bits) GNUTLS_E_TPM_KEY_PASSWORD_ERROR);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/tpm-key-password-error", enum_smob);
#endif /* not NO_GNUTLS_E_TPM_KEY_PASSWORD_ERROR */
#ifndef NO_GNUTLS_E_TPM_SRK_PASSWORD_ERROR
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_error_enum, (scm_t_bits) GNUTLS_E_TPM_SRK_PASSWORD_ERROR);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/tpm-srk-password-error", enum_smob);
#endif /* not NO_GNUTLS_E_TPM_SRK_PASSWORD_ERROR */
#ifndef NO_GNUTLS_E_TPM_SESSION_ERROR
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_error_enum, (scm_t_bits) GNUTLS_E_TPM_SESSION_ERROR);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/tpm-session-error", enum_smob);
#endif /* not NO_GNUTLS_E_TPM_SESSION_ERROR */
#ifndef NO_GNUTLS_E_TPM_KEY_NOT_FOUND
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_error_enum, (scm_t_bits) GNUTLS_E_TPM_KEY_NOT_FOUND);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/tpm-key-not-found", enum_smob);
#endif /* not NO_GNUTLS_E_TPM_KEY_NOT_FOUND */
#ifndef NO_GNUTLS_E_TPM_UNINITIALIZED
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_error_enum, (scm_t_bits) GNUTLS_E_TPM_UNINITIALIZED);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/tpm-uninitialized", enum_smob);
#endif /* not NO_GNUTLS_E_TPM_UNINITIALIZED */
#ifndef NO_GNUTLS_E_TPM_NO_LIB
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_error_enum, (scm_t_bits) GNUTLS_E_TPM_NO_LIB);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/tpm-no-lib", enum_smob);
#endif /* not NO_GNUTLS_E_TPM_NO_LIB */
#ifndef NO_GNUTLS_E_NO_CERTIFICATE_STATUS
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_error_enum, (scm_t_bits) GNUTLS_E_NO_CERTIFICATE_STATUS);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/no-certificate-status", enum_smob);
#endif /* not NO_GNUTLS_E_NO_CERTIFICATE_STATUS */
#ifndef NO_GNUTLS_E_OCSP_RESPONSE_ERROR
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_error_enum, (scm_t_bits) GNUTLS_E_OCSP_RESPONSE_ERROR);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/ocsp-response-error", enum_smob);
#endif /* not NO_GNUTLS_E_OCSP_RESPONSE_ERROR */
#ifndef NO_GNUTLS_E_RANDOM_DEVICE_ERROR
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_error_enum, (scm_t_bits) GNUTLS_E_RANDOM_DEVICE_ERROR);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/random-device-error", enum_smob);
#endif /* not NO_GNUTLS_E_RANDOM_DEVICE_ERROR */
#ifndef NO_GNUTLS_E_AUTH_ERROR
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_error_enum, (scm_t_bits) GNUTLS_E_AUTH_ERROR);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/auth-error", enum_smob);
#endif /* not NO_GNUTLS_E_AUTH_ERROR */
#ifndef NO_GNUTLS_E_NO_APPLICATION_PROTOCOL
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_error_enum, (scm_t_bits) GNUTLS_E_NO_APPLICATION_PROTOCOL);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/no-application-protocol", enum_smob);
#endif /* not NO_GNUTLS_E_NO_APPLICATION_PROTOCOL */
#ifndef NO_GNUTLS_E_SOCKETS_INIT_ERROR
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_error_enum, (scm_t_bits) GNUTLS_E_SOCKETS_INIT_ERROR);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/sockets-init-error", enum_smob);
#endif /* not NO_GNUTLS_E_SOCKETS_INIT_ERROR */
#ifndef NO_GNUTLS_E_KEY_IMPORT_FAILED
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_error_enum, (scm_t_bits) GNUTLS_E_KEY_IMPORT_FAILED);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/key-import-failed", enum_smob);
#endif /* not NO_GNUTLS_E_KEY_IMPORT_FAILED */
#ifndef NO_GNUTLS_E_INAPPROPRIATE_FALLBACK
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_error_enum, (scm_t_bits) GNUTLS_E_INAPPROPRIATE_FALLBACK);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/inappropriate-fallback", enum_smob);
#endif /* not NO_GNUTLS_E_INAPPROPRIATE_FALLBACK */
#ifndef NO_GNUTLS_E_CERTIFICATE_VERIFICATION_ERROR
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_error_enum, (scm_t_bits) GNUTLS_E_CERTIFICATE_VERIFICATION_ERROR);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/certificate-verification-error", enum_smob);
#endif /* not NO_GNUTLS_E_CERTIFICATE_VERIFICATION_ERROR */
#ifndef NO_GNUTLS_E_PRIVKEY_VERIFICATION_ERROR
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_error_enum, (scm_t_bits) GNUTLS_E_PRIVKEY_VERIFICATION_ERROR);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/privkey-verification-error", enum_smob);
#endif /* not NO_GNUTLS_E_PRIVKEY_VERIFICATION_ERROR */
#ifndef NO_GNUTLS_E_UNEXPECTED_EXTENSIONS_LENGTH
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_error_enum, (scm_t_bits) GNUTLS_E_UNEXPECTED_EXTENSIONS_LENGTH);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/unexpected-extensions-length", enum_smob);
#endif /* not NO_GNUTLS_E_UNEXPECTED_EXTENSIONS_LENGTH */
#ifndef NO_GNUTLS_E_ASN1_EMBEDDED_NULL_IN_STRING
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_error_enum, (scm_t_bits) GNUTLS_E_ASN1_EMBEDDED_NULL_IN_STRING);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/asn1-embedded-null-in-string", enum_smob);
#endif /* not NO_GNUTLS_E_ASN1_EMBEDDED_NULL_IN_STRING */
#ifndef NO_GNUTLS_E_SELF_TEST_ERROR
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_error_enum, (scm_t_bits) GNUTLS_E_SELF_TEST_ERROR);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/self-test-error", enum_smob);
#endif /* not NO_GNUTLS_E_SELF_TEST_ERROR */
#ifndef NO_GNUTLS_E_NO_SELF_TEST
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_error_enum, (scm_t_bits) GNUTLS_E_NO_SELF_TEST);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/no-self-test", enum_smob);
#endif /* not NO_GNUTLS_E_NO_SELF_TEST */
#ifndef NO_GNUTLS_E_LIB_IN_ERROR_STATE
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_error_enum, (scm_t_bits) GNUTLS_E_LIB_IN_ERROR_STATE);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/lib-in-error-state", enum_smob);
#endif /* not NO_GNUTLS_E_LIB_IN_ERROR_STATE */
#ifndef NO_GNUTLS_E_PK_GENERATION_ERROR
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_error_enum, (scm_t_bits) GNUTLS_E_PK_GENERATION_ERROR);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/pk-generation-error", enum_smob);
#endif /* not NO_GNUTLS_E_PK_GENERATION_ERROR */
#ifndef NO_GNUTLS_E_IDNA_ERROR
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_error_enum, (scm_t_bits) GNUTLS_E_IDNA_ERROR);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/idna-error", enum_smob);
#endif /* not NO_GNUTLS_E_IDNA_ERROR */
#ifndef NO_GNUTLS_E_NEED_FALLBACK
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_error_enum, (scm_t_bits) GNUTLS_E_NEED_FALLBACK);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/need-fallback", enum_smob);
#endif /* not NO_GNUTLS_E_NEED_FALLBACK */
#ifndef NO_GNUTLS_E_SESSION_USER_ID_CHANGED
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_error_enum, (scm_t_bits) GNUTLS_E_SESSION_USER_ID_CHANGED);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/session-user-id-changed", enum_smob);
#endif /* not NO_GNUTLS_E_SESSION_USER_ID_CHANGED */
#ifndef NO_GNUTLS_E_HANDSHAKE_DURING_FALSE_START
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_error_enum, (scm_t_bits) GNUTLS_E_HANDSHAKE_DURING_FALSE_START);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/handshake-during-false-start", enum_smob);
#endif /* not NO_GNUTLS_E_HANDSHAKE_DURING_FALSE_START */
#ifndef NO_GNUTLS_E_UNAVAILABLE_DURING_HANDSHAKE
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_error_enum, (scm_t_bits) GNUTLS_E_UNAVAILABLE_DURING_HANDSHAKE);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/unavailable-during-handshake", enum_smob);
#endif /* not NO_GNUTLS_E_UNAVAILABLE_DURING_HANDSHAKE */
#ifndef NO_GNUTLS_E_PK_INVALID_PUBKEY
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_error_enum, (scm_t_bits) GNUTLS_E_PK_INVALID_PUBKEY);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/pk-invalid-pubkey", enum_smob);
#endif /* not NO_GNUTLS_E_PK_INVALID_PUBKEY */
#ifndef NO_GNUTLS_E_PK_INVALID_PRIVKEY
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_error_enum, (scm_t_bits) GNUTLS_E_PK_INVALID_PRIVKEY);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/pk-invalid-privkey", enum_smob);
#endif /* not NO_GNUTLS_E_PK_INVALID_PRIVKEY */
#ifndef NO_GNUTLS_E_NOT_YET_ACTIVATED
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_error_enum, (scm_t_bits) GNUTLS_E_NOT_YET_ACTIVATED);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/not-yet-activated", enum_smob);
#endif /* not NO_GNUTLS_E_NOT_YET_ACTIVATED */
#ifndef NO_GNUTLS_E_INVALID_UTF8_STRING
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_error_enum, (scm_t_bits) GNUTLS_E_INVALID_UTF8_STRING);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/invalid-utf8-string", enum_smob);
#endif /* not NO_GNUTLS_E_INVALID_UTF8_STRING */
#ifndef NO_GNUTLS_E_NO_EMBEDDED_DATA
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_error_enum, (scm_t_bits) GNUTLS_E_NO_EMBEDDED_DATA);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/no-embedded-data", enum_smob);
#endif /* not NO_GNUTLS_E_NO_EMBEDDED_DATA */
#ifndef NO_GNUTLS_E_INVALID_UTF8_EMAIL
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_error_enum, (scm_t_bits) GNUTLS_E_INVALID_UTF8_EMAIL);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/invalid-utf8-email", enum_smob);
#endif /* not NO_GNUTLS_E_INVALID_UTF8_EMAIL */
#ifndef NO_GNUTLS_E_INVALID_PASSWORD_STRING
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_error_enum, (scm_t_bits) GNUTLS_E_INVALID_PASSWORD_STRING);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/invalid-password-string", enum_smob);
#endif /* not NO_GNUTLS_E_INVALID_PASSWORD_STRING */
#ifndef NO_GNUTLS_E_CERTIFICATE_TIME_ERROR
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_error_enum, (scm_t_bits) GNUTLS_E_CERTIFICATE_TIME_ERROR);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/certificate-time-error", enum_smob);
#endif /* not NO_GNUTLS_E_CERTIFICATE_TIME_ERROR */
#ifndef NO_GNUTLS_E_RECORD_OVERFLOW
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_error_enum, (scm_t_bits) GNUTLS_E_RECORD_OVERFLOW);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/record-overflow", enum_smob);
#endif /* not NO_GNUTLS_E_RECORD_OVERFLOW */
#ifndef NO_GNUTLS_E_ASN1_TIME_ERROR
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_error_enum, (scm_t_bits) GNUTLS_E_ASN1_TIME_ERROR);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/asn1-time-error", enum_smob);
#endif /* not NO_GNUTLS_E_ASN1_TIME_ERROR */
#ifndef NO_GNUTLS_E_INCOMPATIBLE_SIG_WITH_KEY
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_error_enum, (scm_t_bits) GNUTLS_E_INCOMPATIBLE_SIG_WITH_KEY);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/incompatible-sig-with-key", enum_smob);
#endif /* not NO_GNUTLS_E_INCOMPATIBLE_SIG_WITH_KEY */
#ifndef NO_GNUTLS_E_PK_INVALID_PUBKEY_PARAMS
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_error_enum, (scm_t_bits) GNUTLS_E_PK_INVALID_PUBKEY_PARAMS);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/pk-invalid-pubkey-params", enum_smob);
#endif /* not NO_GNUTLS_E_PK_INVALID_PUBKEY_PARAMS */
#ifndef NO_GNUTLS_E_PK_NO_VALIDATION_PARAMS
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_error_enum, (scm_t_bits) GNUTLS_E_PK_NO_VALIDATION_PARAMS);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/pk-no-validation-params", enum_smob);
#endif /* not NO_GNUTLS_E_PK_NO_VALIDATION_PARAMS */
#ifndef NO_GNUTLS_E_OCSP_MISMATCH_WITH_CERTS
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_error_enum, (scm_t_bits) GNUTLS_E_OCSP_MISMATCH_WITH_CERTS);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/ocsp-mismatch-with-certs", enum_smob);
#endif /* not NO_GNUTLS_E_OCSP_MISMATCH_WITH_CERTS */
#ifndef NO_GNUTLS_E_NO_COMMON_KEY_SHARE
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_error_enum, (scm_t_bits) GNUTLS_E_NO_COMMON_KEY_SHARE);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/no-common-key-share", enum_smob);
#endif /* not NO_GNUTLS_E_NO_COMMON_KEY_SHARE */
#ifndef NO_GNUTLS_E_REAUTH_REQUEST
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_error_enum, (scm_t_bits) GNUTLS_E_REAUTH_REQUEST);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/reauth-request", enum_smob);
#endif /* not NO_GNUTLS_E_REAUTH_REQUEST */
#ifndef NO_GNUTLS_E_TOO_MANY_MATCHES
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_error_enum, (scm_t_bits) GNUTLS_E_TOO_MANY_MATCHES);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/too-many-matches", enum_smob);
#endif /* not NO_GNUTLS_E_TOO_MANY_MATCHES */
#ifndef NO_GNUTLS_E_CRL_VERIFICATION_ERROR
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_error_enum, (scm_t_bits) GNUTLS_E_CRL_VERIFICATION_ERROR);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/crl-verification-error", enum_smob);
#endif /* not NO_GNUTLS_E_CRL_VERIFICATION_ERROR */
#ifndef NO_GNUTLS_E_MISSING_EXTENSION
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_error_enum, (scm_t_bits) GNUTLS_E_MISSING_EXTENSION);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/missing-extension", enum_smob);
#endif /* not NO_GNUTLS_E_MISSING_EXTENSION */
#ifndef NO_GNUTLS_E_DB_ENTRY_EXISTS
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_error_enum, (scm_t_bits) GNUTLS_E_DB_ENTRY_EXISTS);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/db-entry-exists", enum_smob);
#endif /* not NO_GNUTLS_E_DB_ENTRY_EXISTS */
#ifndef NO_GNUTLS_E_EARLY_DATA_REJECTED
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_error_enum, (scm_t_bits) GNUTLS_E_EARLY_DATA_REJECTED);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/early-data-rejected", enum_smob);
#endif /* not NO_GNUTLS_E_EARLY_DATA_REJECTED */
#ifndef NO_GNUTLS_E_UNIMPLEMENTED_FEATURE
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_error_enum, (scm_t_bits) GNUTLS_E_UNIMPLEMENTED_FEATURE);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/unimplemented-feature", enum_smob);
#endif /* not NO_GNUTLS_E_UNIMPLEMENTED_FEATURE */
#ifndef NO_GNUTLS_E_INT_RET_0
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_error_enum, (scm_t_bits) GNUTLS_E_INT_RET_0);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/int-ret-0", enum_smob);
#endif /* not NO_GNUTLS_E_INT_RET_0 */
#ifndef NO_GNUTLS_E_INT_CHECK_AGAIN
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_error_enum, (scm_t_bits) GNUTLS_E_INT_CHECK_AGAIN);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/int-check-again", enum_smob);
#endif /* not NO_GNUTLS_E_INT_CHECK_AGAIN */
#ifndef NO_GNUTLS_E_APPLICATION_ERROR_MAX
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_error_enum, (scm_t_bits) GNUTLS_E_APPLICATION_ERROR_MAX);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/application-error-max", enum_smob);
#endif /* not NO_GNUTLS_E_APPLICATION_ERROR_MAX */
#ifndef NO_GNUTLS_E_APPLICATION_ERROR_MIN
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_error_enum, (scm_t_bits) GNUTLS_E_APPLICATION_ERROR_MIN);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("error/application-error-min", enum_smob);
#endif /* not NO_GNUTLS_E_APPLICATION_ERROR_MIN */
  scm_gnutls_error_enum_values = scm_permanent_object (enum_values);
  enum_values = SCM_EOL;
#ifndef NO_GNUTLS_OPENPGP_FMT_RAW
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_openpgp_certificate_format_enum, (scm_t_bits) GNUTLS_OPENPGP_FMT_RAW);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("openpgp-certificate-format/raw", enum_smob);
#endif /* not NO_GNUTLS_OPENPGP_FMT_RAW */
#ifndef NO_GNUTLS_OPENPGP_FMT_BASE64
  SCM_NEWSMOB (enum_smob, scm_tc16_gnutls_openpgp_certificate_format_enum, (scm_t_bits) GNUTLS_OPENPGP_FMT_BASE64);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("openpgp-certificate-format/base64", enum_smob);
#endif /* not NO_GNUTLS_OPENPGP_FMT_BASE64 */
  scm_gnutls_openpgp_certificate_format_enum_values = scm_permanent_object (enum_values);
}
