SCM_GLOBAL_SMOB (scm_tc16_avahi_entry_group, "entry-group", 0);
SCM_DEFINE (scm_avahi_free_entry_group_x, "free-entry-group!", 1, 0, 0,
            (SCM obj),
            "Explicitly free @var{obj}, an object of type @code{entry-group}.")
#define FUNC_NAME s_scm_avahi_free_entry_group_x
{
  AvahiEntryGroup * c_obj;
  c_obj = scm_to_avahi_entry_group (obj, 1, 0);
  if (c_obj != NULL)
    {
      (void) avahi_entry_group_free (c_obj);
      scm_gc_unprotect_object (obj);
      SCM_SET_SMOB_DATA (obj, (scm_t_bits) NULL);
    }
  return SCM_UNSPECIFIED;
}
#undef FUNC_NAME
SCM_DEFINE (scm_avahi_freed_entry_group_p, "freed-entry-group?", 1, 0, 0,
            (SCM obj),
            "Return @code{#t} if @var{obj} is an object of type @code{entry-group} that has already been explicitly freed.")
#define FUNC_NAME s_scm_avahi_freed_entry_group_p
{
  AvahiEntryGroup * c_obj;
  c_obj = scm_to_avahi_entry_group (obj, 1, 0);
  return (scm_from_bool (c_obj == NULL));
}
#undef FUNC_NAME
SCM_DEFINE (scm_avahi_entry_group_p, "entry-group?", 1, 0, 0,
            (SCM obj),
            "Return true if @var{obj} is of type @code{entry-group}.")
#define FUNC_NAME s_scm_avahi_entry_group_p
{
  return (scm_from_bool (SCM_SMOB_PREDICATE (scm_tc16_avahi_entry_group, obj)));
}
#undef FUNC_NAME
