/*
 * Decompiled with CFR 0.152.
 */
package freenet.client.async;

import freenet.client.ArchiveManager;
import freenet.client.ClientMetadata;
import freenet.client.InsertContext;
import freenet.client.InsertException;
import freenet.client.Metadata;
import freenet.client.async.BaseClientPutter;
import freenet.client.async.ClientContext;
import freenet.client.async.ClientPutState;
import freenet.client.async.PersistentJob;
import freenet.client.async.PutCompletionCallback;
import freenet.client.async.SplitFileInserterSegmentStorage;
import freenet.client.async.SplitFileInserterSender;
import freenet.client.async.SplitFileInserterStorage;
import freenet.client.async.SplitFileInserterStorageCallback;
import freenet.crypt.CRCChecksumChecker;
import freenet.crypt.ChecksumFailedException;
import freenet.crypt.HashResult;
import freenet.support.Logger;
import freenet.support.api.LockableRandomAccessBuffer;
import freenet.support.compress.Compressor;
import freenet.support.io.ResumeFailedException;
import freenet.support.io.StorageFormatException;
import java.io.IOException;
import java.io.Serializable;

public class SplitFileInserter
implements ClientPutState,
Serializable,
SplitFileInserterStorageCallback {
    private static volatile boolean logMINOR;
    private static volatile boolean logDEBUG;
    private static final long serialVersionUID = 1L;
    final boolean persistent;
    final BaseClientPutter parent;
    private final PutCompletionCallback cb;
    private final LockableRandomAccessBuffer originalData;
    private final boolean freeData;
    private final LockableRandomAccessBuffer raf;
    private volatile transient SplitFileInserterStorage storage;
    private volatile transient SplitFileInserterSender sender;
    private transient ClientContext context;
    final boolean realTime;
    private final Object token;
    final InsertContext ctx;
    private transient boolean resumed;

    SplitFileInserter(boolean persistent, BaseClientPutter parent, PutCompletionCallback cb, LockableRandomAccessBuffer originalData, boolean freeData, InsertContext ctx, ClientContext context, long decompressedLength, Compressor.COMPRESSOR_TYPE compressionCodec, ClientMetadata meta, boolean isMetadata, ArchiveManager.ARCHIVE_TYPE archiveType, byte splitfileCryptoAlgorithm, byte[] splitfileCryptoKey, byte[] hashThisLayerOnly, HashResult[] hashes, boolean topDontCompress, int topRequiredBlocks, int topTotalBlocks, long origDataSize, long origCompressedDataSize, boolean realTime, Object token) throws InsertException {
        this.persistent = persistent;
        this.parent = parent;
        this.cb = cb;
        this.originalData = originalData;
        this.context = context;
        this.freeData = freeData;
        try {
            this.storage = new SplitFileInserterStorage(originalData, decompressedLength, this, compressionCodec, meta, isMetadata, archiveType, context.getRandomAccessBufferFactory(persistent), persistent, ctx, splitfileCryptoAlgorithm, splitfileCryptoKey, hashThisLayerOnly, hashes, context.tempBucketFactory, new CRCChecksumChecker(), context.fastWeakRandom, context.memoryLimitedJobRunner, context.getJobRunner(persistent), context.ticker, context.getChkInsertScheduler(realTime).fetchingKeys(), topDontCompress, topRequiredBlocks, topTotalBlocks, origDataSize, origCompressedDataSize);
            int mustSucceed = this.storage.topRequiredBlocks - topRequiredBlocks;
            parent.addMustSucceedBlocks(mustSucceed);
            parent.addRedundantBlocksInsert(this.storage.topTotalBlocks - topTotalBlocks - mustSucceed);
            parent.notifyClients(context);
        }
        catch (IOException e) {
            throw new InsertException(InsertException.InsertExceptionMode.BUCKET_ERROR, e, null);
        }
        this.raf = this.storage.getRAF();
        this.sender = new SplitFileInserterSender(this, this.storage);
        this.realTime = realTime;
        this.token = token;
        this.ctx = ctx;
    }

    @Override
    public BaseClientPutter getParent() {
        return this.parent;
    }

    @Override
    public void cancel(ClientContext context) {
        this.storage.fail(new InsertException(InsertException.InsertExceptionMode.CANCELLED));
    }

    @Override
    public void schedule(ClientContext context) throws InsertException {
        this.cb.onBlockSetFinished(this, context);
        this.storage.start();
        if (!this.ctx.getCHKOnly) {
            this.sender.clearWakeupTime(context);
            this.sender.schedule(context);
        }
    }

    @Override
    public Object getToken() {
        return this.token;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onResume(ClientContext context) throws InsertException, ResumeFailedException {
        assert (this.persistent);
        SplitFileInserter splitFileInserter = this;
        synchronized (splitFileInserter) {
            if (this.resumed) {
                return;
            }
            this.resumed = true;
        }
        this.context = context;
        try {
            this.raf.onResume(context);
            this.originalData.onResume(context);
            this.storage = new SplitFileInserterStorage(this.raf, this.originalData, this, context.fastWeakRandom, context.memoryLimitedJobRunner, context.getJobRunner(true), context.ticker, context.getChkInsertScheduler(this.realTime).fetchingKeys(), context.persistentFG, context.persistentFileTracker, context.getPersistentMasterSecret());
            this.storage.onResume(context);
            this.sender = new SplitFileInserterSender(this, this.storage);
            this.schedule(context);
        }
        catch (IOException e) {
            Logger.error(this, "Resume failed: " + e, (Throwable)e);
            this.raf.close();
            this.raf.free();
            this.originalData.close();
            if (this.freeData) {
                this.originalData.free();
            }
            throw new InsertException(InsertException.InsertExceptionMode.BUCKET_ERROR, e, null);
        }
        catch (StorageFormatException e) {
            Logger.error(this, "Resume failed: " + e, (Throwable)e);
            this.raf.close();
            this.raf.free();
            this.originalData.close();
            if (this.freeData) {
                this.originalData.free();
            }
            throw new InsertException(InsertException.InsertExceptionMode.BUCKET_ERROR, e, null);
        }
        catch (ChecksumFailedException e) {
            Logger.error(this, "Resume failed: " + e, (Throwable)e);
            this.raf.close();
            this.raf.free();
            this.originalData.close();
            if (this.freeData) {
                this.originalData.free();
            }
            throw new InsertException(InsertException.InsertExceptionMode.BUCKET_ERROR, e, null);
        }
    }

    @Override
    public void onFinishedEncode() {
    }

    @Override
    public void encodingProgress() {
        if (this.ctx.getCHKOnly) {
            return;
        }
        try {
            this.schedule(this.context);
        }
        catch (InsertException e) {
            this.storage.fail(e);
        }
    }

    @Override
    public void onHasKeys() {
        if (this.ctx.earlyEncode || this.ctx.getCHKOnly) {
            this.context.getJobRunner(this.persistent).queueNormalOrDrop(new PersistentJob(){

                @Override
                public boolean run(ClientContext context) {
                    try {
                        Metadata metadata = SplitFileInserter.this.storage.encodeMetadata();
                        SplitFileInserter.this.reportMetadata(metadata);
                        if (SplitFileInserter.this.ctx.getCHKOnly) {
                            SplitFileInserter.this.onSucceeded(metadata);
                        }
                    }
                    catch (IOException e) {
                        SplitFileInserter.this.storage.fail(new InsertException(InsertException.InsertExceptionMode.BUCKET_ERROR, e, null));
                    }
                    catch (SplitFileInserterSegmentStorage.MissingKeyException e) {
                        SplitFileInserter.this.storage.fail(new InsertException(InsertException.InsertExceptionMode.BUCKET_ERROR, "Lost one or more keys", e, null));
                    }
                    return false;
                }
            });
        }
    }

    @Override
    public void onSucceeded(final Metadata metadata) {
        this.context.getJobRunner(this.persistent).queueNormalOrDrop(new PersistentJob(){

            @Override
            public boolean run(ClientContext context) {
                if (logMINOR) {
                    Logger.minor(this, "Succeeding on " + SplitFileInserter.this);
                }
                SplitFileInserter.this.unregisterSender();
                if (!SplitFileInserter.this.ctx.earlyEncode && !SplitFileInserter.this.ctx.getCHKOnly) {
                    SplitFileInserter.this.reportMetadata(metadata);
                }
                SplitFileInserter.this.cb.onSuccess(SplitFileInserter.this, context);
                SplitFileInserter.this.raf.close();
                SplitFileInserter.this.raf.free();
                SplitFileInserter.this.originalData.close();
                if (SplitFileInserter.this.freeData) {
                    SplitFileInserter.this.originalData.free();
                }
                return true;
            }
        });
    }

    protected void unregisterSender() {
        this.sender.unregister(this.context, this.parent.getPriorityClass());
    }

    protected void reportMetadata(Metadata metadata) {
        this.cb.onMetadata(metadata, (ClientPutState)this, this.context);
    }

    @Override
    public void onFailed(final InsertException e) {
        this.context.getJobRunner(this.persistent).queueNormalOrDrop(new PersistentJob(){

            @Override
            public boolean run(ClientContext context) {
                SplitFileInserter.this.unregisterSender();
                SplitFileInserter.this.raf.close();
                SplitFileInserter.this.raf.free();
                SplitFileInserter.this.originalData.close();
                if (SplitFileInserter.this.freeData) {
                    SplitFileInserter.this.originalData.free();
                }
                SplitFileInserter.this.cb.onFailure(e, SplitFileInserter.this, context);
                return true;
            }
        });
    }

    public long getLength() {
        return this.storage.dataLength;
    }

    @Override
    public void onInsertedBlock() {
        this.parent.completedBlock(false, this.context);
    }

    @Override
    public void onShutdown(ClientContext context) {
        this.storage.onShutdown(context);
    }

    @Override
    public void clearCooldown() {
        this.sender.clearWakeupTime(this.context);
    }

    @Override
    public short getPriorityClass() {
        return this.parent.getPriorityClass();
    }

    static {
        Logger.registerClass(SplitFileInserter.class);
    }
}

