/*
 * Decompiled with CFR 0.152.
 */
package org.bitpedia.util;

import java.security.DigestException;
import java.security.MessageDigest;
import java.util.LinkedList;
import org.bitpedia.util.Tiger;

public class TigerTree
extends MessageDigest {
    private static final int BLOCKSIZE = 1024;
    private static final int HASHSIZE = 24;
    private final byte[] buffer = new byte[1024];
    private int bufferOffset = 0;
    private long byteCount = 0L;
    private MessageDigest tiger;
    private LinkedList nodes = new LinkedList();
    long blockCount = 0L;

    public TigerTree() {
        super("tigertree");
        this.tiger = new Tiger();
    }

    @Override
    protected int engineGetDigestLength() {
        return 24;
    }

    @Override
    protected void engineUpdate(byte by) {
        ++this.byteCount;
        this.buffer[this.bufferOffset++] = by;
        if (this.bufferOffset == 1024) {
            this.blockUpdate();
            this.bufferOffset = 0;
        }
    }

    @Override
    protected void engineUpdate(byte[] byArray, int n, int n2) {
        int n3;
        this.byteCount += (long)n2;
        while (n2 >= (n3 = 1024 - this.bufferOffset)) {
            System.arraycopy(byArray, n, this.buffer, this.bufferOffset, n3);
            this.bufferOffset += n3;
            this.blockUpdate();
            n2 -= n3;
            n += n3;
            this.bufferOffset = 0;
        }
        System.arraycopy(byArray, n, this.buffer, this.bufferOffset, n2);
        this.bufferOffset += n2;
    }

    @Override
    protected byte[] engineDigest() {
        byte[] byArray = new byte[24];
        try {
            this.engineDigest(byArray, 0, 24);
        }
        catch (DigestException digestException) {
            return null;
        }
        return byArray;
    }

    @Override
    protected int engineDigest(byte[] byArray, int n, int n2) throws DigestException {
        if (n2 < 24) {
            throw new DigestException();
        }
        this.blockUpdate();
        while (this.nodes.size() > 1) {
            this.composeNodes();
        }
        System.arraycopy(this.nodes.get(0), 0, byArray, n, 24);
        this.engineReset();
        return 24;
    }

    @Override
    protected void engineReset() {
        this.bufferOffset = 0;
        this.byteCount = 0L;
        this.nodes = new LinkedList();
        this.tiger.reset();
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    protected void blockUpdate() {
        this.tiger.reset();
        this.tiger.update((byte)0);
        this.tiger.update(this.buffer, 0, this.bufferOffset);
        if (this.bufferOffset == 0 & this.nodes.size() > 0) {
            return;
        }
        this.nodes.add(this.tiger.digest());
        ++this.blockCount;
        long l = this.blockCount;
        while (l % 2L == 0L) {
            this.composeNodes();
            l >>= 1;
        }
    }

    protected void composeNodes() {
        byte[] byArray = (byte[])this.nodes.removeLast();
        byte[] byArray2 = (byte[])this.nodes.removeLast();
        this.tiger.reset();
        this.tiger.update((byte)1);
        this.tiger.update(byArray2);
        this.tiger.update(byArray);
        this.nodes.add(this.tiger.digest());
    }
}

