/*
 * Decompiled with CFR 0.152.
 */
package org.bitpedia.collider.core;

import org.bitpedia.util.Sha1;

public class Mp3Handler {
    private static final int[] mpeg1Bitrates = new int[]{0, 32, 40, 48, 56, 64, 80, 96, 112, 128, 160, 192, 224, 256, 320};
    private static final int[] mpeg2Bitrates = new int[]{0, 8, 16, 24, 32, 40, 48, 56, 64, 80, 96, 112, 128, 144, 160};
    private static final int[] mpeg1SampleRates = new int[]{44100, 48000, 32000};
    private static final int[] mpeg2SampleRates = new int[]{22050, 24000, 16000};
    private static final int[] mpegLayer = new int[]{0, 3, 2, 1};
    public static final int ID3_TAG_LEN = 128;
    public int bitRate;
    public int sampleRate;
    public boolean stereo;
    public int duration;
    public byte[] audioSha;
    public int frames;
    public int mpegVer;
    public int avgBitRate;
    private int skipSize;
    private byte[] spanningHeader;
    private int spanningSize;
    private Sha1 sha;
    private int goodBytes;
    private int badBytes;
    private byte[] startBuffer;
    private int startBytes;
    private byte[] audioShaBuffer;
    private byte[] audioShaExtra;
    private int audioShaBytes;

    private static int extractBitRate(byte[] byArray, int n) {
        int n2 = byArray[n + 1] >= 0 ? byArray[n + 1] : byArray[n + 1] + 256;
        int n3 = byArray[n + 2] >= 0 ? byArray[n + 2] : byArray[n + 2] + 256;
        n2 = (n2 & 8) >> 3;
        n3 = (n3 & 0xF0) >> 4;
        if (0 != n2) {
            if (n3 < mpeg1Bitrates.length) {
                return mpeg1Bitrates[n3];
            }
        } else if (n3 < mpeg2Bitrates.length) {
            return mpeg2Bitrates[n3];
        }
        return 0;
    }

    private static int extractSampleRate(byte[] byArray, int n) {
        int n2 = byArray[n + 1] >= 0 ? byArray[n + 1] : byArray[n + 1] + 256;
        int n3 = byArray[n + 2] >= 0 ? byArray[n + 2] : byArray[n + 2] + 256;
        n2 = (n2 & 8) >> 3;
        n3 = n3 >> 2 & 3;
        if (0 != n2) {
            if (n3 < mpeg1SampleRates.length) {
                return mpeg1SampleRates[n3];
            }
        } else if (n3 < mpeg2SampleRates.length) {
            return mpeg2SampleRates[n3];
        }
        return 0;
    }

    private static boolean extractStereo(byte[] byArray, int n) {
        int n2 = byArray[n + 3] >= 0 ? byArray[n + 3] : byArray[n + 3] + 256;
        return 3 != (n2 & 0xC0) >> 6;
    }

    private static int extractMpegVer(byte[] byArray, int n) {
        int n2;
        int n3 = n2 = byArray[n + 1] >= 0 ? byArray[n + 1] : byArray[n + 1] + 256;
        if (0 == (n2 & 8) >> 3) {
            return 2;
        }
        return 1;
    }

    private static int extractMpegLayer(byte[] byArray, int n) {
        byte by = byArray[n + 1] >= 0 ? byArray[n + 1] : byArray[n + 1];
        return mpegLayer[(by & 7) >> 1];
    }

    private static int extractPadding(byte[] byArray, int n) {
        int n2 = byArray[n + 2] >= 0 ? byArray[n + 2] : byArray[n + 2] + 256;
        return n2 >> 1 & 1;
    }

    private int findStart(byte[] byArray, int n, int n2) {
        int n3 = 0;
        int n4 = -1;
        if (null != this.startBuffer) {
            byte[] byArray2 = new byte[this.startBytes + n2];
            System.arraycopy(this.startBuffer, 0, byArray2, 0, this.startBytes);
            System.arraycopy(byArray, n, byArray2, this.startBytes, n2);
            this.startBuffer = byArray2;
            this.startBytes += n2;
            byArray = this.startBuffer;
            n2 = this.startBytes;
            n = 0;
        }
        int n5 = n2;
        int n6 = 0;
        while (n6 < n5 - 1) {
            int n7;
            int n8 = byArray[n6 + n] >= 0 ? byArray[n6 + n] : byArray[n6 + n] + 256;
            int n9 = n7 = byArray[n6 + n + 1] >= 0 ? byArray[n6 + n + 1] : byArray[n6 + n + 1] + 256;
            if (255 != n8 || 240 != (n7 & 0xF0) && 224 != (n7 & 0xF0)) {
                ++n6;
                continue;
            }
            int n10 = Mp3Handler.extractSampleRate(byArray, n6 + n);
            int n11 = Mp3Handler.extractMpegLayer(byArray, n6 + n);
            if (0 == n10) {
                ++n6;
                continue;
            }
            int n12 = Mp3Handler.extractBitRate(byArray, n6 + n);
            int n13 = Mp3Handler.extractSampleRate(byArray, n6 + n);
            int n14 = Mp3Handler.extractPadding(byArray, n6 + n);
            int n15 = 1 == Mp3Handler.extractMpegVer(byArray, n6 + n) ? 144000 * n12 / n13 + n14 : 72000 * n12 / n13 + n14;
            if (n15 <= 1 || 2048 < n15) {
                ++n6;
                continue;
            }
            if (n5 <= n6 + n15) {
                if (null == this.startBuffer) {
                    this.startBytes = n2;
                    this.startBuffer = new byte[n2];
                    System.arraycopy(byArray, n, this.startBuffer, 0, n2);
                }
                return -1;
            }
            int n16 = Mp3Handler.extractSampleRate(byArray, n6 + n + n15);
            int n17 = Mp3Handler.extractMpegLayer(byArray, n6 + n + n15);
            if (n10 == n16 && n11 == n17) {
                ++n3;
                if (n4 < 0) {
                    n4 = n6;
                }
                n6 += n15;
            } else {
                n3 = 0;
                n6 = n4 >= 0 ? n4 + 1 : ++n6;
                n4 = -1;
            }
            if (3 != n3) continue;
            return n4;
        }
        return -1;
    }

    private void resetValues() {
        this.bitRate = 0;
        this.sampleRate = 0;
        this.stereo = false;
        this.duration = 0;
        this.audioSha = null;
        this.frames = 0;
        this.mpegVer = 0;
        this.avgBitRate = 0;
        this.skipSize = 0;
        this.spanningHeader = new byte[3];
        this.spanningSize = 0;
        this.sha = new Sha1();
        this.goodBytes = 0;
        this.badBytes = 0;
        this.startBuffer = null;
        this.startBytes = 0;
        this.audioShaBuffer = null;
        this.audioShaExtra = new byte[3];
        this.audioShaBytes = 0;
    }

    public void analyzeInit() {
        this.resetValues();
    }

    public void analyzeUpdate(byte[] byArray, int n) {
        this.analyzeUpdate(byArray, 0, n);
    }

    public void analyzeUpdate(byte[] byArray, int n, int n2) {
        int n3;
        int n4 = 0;
        byte[] byArray2 = null;
        if (0 == this.badBytes && 0 == this.goodBytes) {
            n3 = this.findStart(byArray, n, n2);
            if (n3 < 0) {
                return;
            }
            if (null != this.startBuffer) {
                byArray = this.startBuffer;
                n2 = this.startBytes;
                n = 0;
            }
            n += n3;
            n2 -= n3;
            n4 = 0;
        }
        if (0 < this.spanningSize) {
            byArray2 = new byte[n2 + this.spanningSize];
            System.arraycopy(this.spanningHeader, 0, byArray2, 0, this.spanningSize);
            System.arraycopy(byArray, n, byArray2, this.spanningSize, n2);
            n2 += this.spanningSize;
            byArray = byArray2;
            n = 0;
        }
        this.updateAudioSha1(byArray, n, this.skipSize);
        System.arraycopy(byArray, n + this.skipSize, this.audioShaExtra, 0, 3);
        n3 = n + this.skipSize;
        int n5 = n + n2;
        while (n3 < n5) {
            int n6;
            if (n5 - n3 < 4) {
                this.spanningSize = n5 - n3;
                System.arraycopy(byArray, n3, this.spanningHeader, 0, this.spanningSize);
                this.skipSize = 0;
                byArray2 = null;
                return;
            }
            int n7 = byArray[n3] >= 0 ? byArray[n3] : byArray[n3] + 256;
            int n8 = n6 = byArray[n3 + 1] >= 0 ? byArray[n3 + 1] : byArray[n3 + 1] + 256;
            if (n7 != 255 || (n6 & 0xF0) != 240 && (n6 & 0xF0) != 224) {
                ++this.badBytes;
                ++n3;
                continue;
            }
            int n9 = Mp3Handler.extractSampleRate(byArray, n3);
            if (0 == n9) {
                ++this.badBytes;
                ++n3;
                continue;
            }
            int n10 = Mp3Handler.extractBitRate(byArray, n3);
            int n11 = Mp3Handler.extractPadding(byArray, n3);
            int n12 = Mp3Handler.extractMpegVer(byArray, n3);
            n4 = 1 == n12 ? 144000 * n10 / n9 + n11 : 72000 * n10 / n9 + n11;
            if (n4 <= 1 || 2048 < n4) {
                ++this.badBytes;
                ++n3;
                continue;
            }
            if (0 == this.frames) {
                this.sampleRate = n9;
                this.bitRate = n10;
                this.mpegVer = n12;
                this.stereo = Mp3Handler.extractStereo(byArray, n3);
            } else {
                if (this.sampleRate != n9) {
                    ++this.badBytes;
                    ++n3;
                    continue;
                }
                if (0 != this.bitRate && this.bitRate != n10) {
                    this.bitRate = 0;
                }
            }
            int n13 = n5 - n3;
            int n14 = n4 > n13 ? n13 : n4;
            this.updateAudioSha1(byArray, n3, n14);
            if (n3 + n14 + 3 < byArray.length) {
                System.arraycopy(byArray, n3 + n14, this.audioShaExtra, 0, 3);
            }
            ++this.frames;
            this.goodBytes += n4;
            this.avgBitRate += n10;
            n3 += n4;
        }
        this.skipSize = n3 - n5;
        this.spanningSize = 0;
        byArray2 = null;
    }

    public void analyzeFinal() {
        this.startBuffer = null;
        if (this.goodBytes < this.badBytes || 0 == this.goodBytes) {
            this.resetValues();
        } else {
            if (null != this.audioShaBuffer) {
                int n;
                System.arraycopy(this.audioShaExtra, 0, this.audioShaBuffer, 128, 3);
                for (n = 0; n < 128 && !"TAG".equals(new String(this.audioShaBuffer, n, 3)); ++n) {
                }
                if (128 < n) {
                    n = 128;
                }
                this.sha.engineUpdate(this.audioShaBuffer, 0, n);
            }
            this.audioSha = this.sha.engineDigest();
            this.duration = 1 == this.mpegVer ? this.frames * 1152 / (this.sampleRate / 1000) : this.frames * 576 / (this.sampleRate / 1000);
            this.avgBitRate /= this.frames;
        }
    }

    public void updateAudioSha1(byte[] byArray, int n, int n2) {
        if (null == this.audioShaBuffer) {
            this.audioShaBuffer = new byte[131];
        }
        if (128 < n2 + this.audioShaBytes) {
            if (128 <= n2) {
                this.sha.engineUpdate(this.audioShaBuffer, 0, this.audioShaBytes);
                this.sha.engineUpdate(byArray, n, n2 - 128);
                System.arraycopy(byArray, n + n2 - 128, this.audioShaBuffer, 0, 128);
                this.audioShaBytes = 128;
            } else {
                int n3 = this.audioShaBytes + n2 - 128;
                this.sha.engineUpdate(this.audioShaBuffer, 0, n3);
                System.arraycopy(this.audioShaBuffer, n3, this.audioShaBuffer, 0, this.audioShaBytes - n3);
                System.arraycopy(byArray, n, this.audioShaBuffer, this.audioShaBytes - n3, n2);
                this.audioShaBytes = this.audioShaBytes - n3 + n2;
            }
        } else {
            System.arraycopy(byArray, n, this.audioShaBuffer, this.audioShaBytes, n2);
            this.audioShaBytes += n2;
        }
    }
}

