/*
 * Decompiled with CFR 0.152.
 */
package net.contrapunctus.lzma;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.concurrent.ArrayBlockingQueue;

class ConcurrentBufferOutputStream
extends OutputStream {
    protected ArrayBlockingQueue<byte[]> q;
    static final int BUFSIZE = 16384;
    static final int QUEUESIZE = 4096;
    private static final PrintStream dbg = System.err;
    private static final boolean DEBUG;

    ConcurrentBufferOutputStream(ArrayBlockingQueue<byte[]> arrayBlockingQueue) {
        if (DEBUG) {
            dbg.printf("%s >> %s%n", this, arrayBlockingQueue);
        }
        this.q = arrayBlockingQueue;
    }

    static OutputStream create(ArrayBlockingQueue<byte[]> arrayBlockingQueue) {
        OutputStream outputStream = new ConcurrentBufferOutputStream(arrayBlockingQueue);
        outputStream = new BufferedOutputStream(outputStream, 16384);
        return outputStream;
    }

    static ArrayBlockingQueue<byte[]> newQueue() {
        return new ArrayBlockingQueue<byte[]>(4096);
    }

    protected void guarded_put(byte[] byArray) throws IOException {
        try {
            this.q.put(byArray);
        }
        catch (InterruptedException interruptedException) {
            throw new InterruptedIOException(interruptedException.getMessage());
        }
    }

    @Override
    public void write(int n) throws IOException {
        byte[] byArray = new byte[]{(byte)(n & 0xFF)};
        this.guarded_put(byArray);
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, n, byArray2, 0, n2);
        this.guarded_put(byArray2);
    }

    @Override
    public void close() throws IOException {
        if (DEBUG) {
            dbg.printf("%s closed%n", this);
        }
        byte[] byArray = new byte[]{};
        this.guarded_put(byArray);
    }

    public String toString() {
        return String.format("cbOut@%x", this.hashCode());
    }

    static {
        String string = null;
        try {
            string = System.getProperty("DEBUG_ConcurrentBuffer");
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        DEBUG = string != null;
    }
}

