/*
 * Decompiled with CFR 0.152.
 */
package net.contrapunctus.lzma;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.PrintStream;
import java.util.concurrent.ArrayBlockingQueue;

class ConcurrentBufferInputStream
extends InputStream {
    protected ArrayBlockingQueue<byte[]> q;
    protected byte[] buf = null;
    protected int next = 0;
    protected boolean eof = false;
    private static final PrintStream dbg = System.err;
    private static final boolean DEBUG;

    ConcurrentBufferInputStream(ArrayBlockingQueue<byte[]> arrayBlockingQueue) {
        if (DEBUG) {
            dbg.printf("%s << %s%n", this, arrayBlockingQueue);
        }
        this.q = arrayBlockingQueue;
        this.eof = false;
    }

    static InputStream create(ArrayBlockingQueue<byte[]> arrayBlockingQueue) {
        ConcurrentBufferInputStream concurrentBufferInputStream = new ConcurrentBufferInputStream(arrayBlockingQueue);
        return concurrentBufferInputStream;
    }

    protected byte[] guarded_take() throws IOException {
        try {
            return this.q.take();
        }
        catch (InterruptedException interruptedException) {
            throw new InterruptedIOException(interruptedException.getMessage());
        }
    }

    protected boolean prepareAndCheckEOF() throws IOException {
        if (this.eof) {
            return true;
        }
        if (this.buf == null || this.next >= this.buf.length) {
            this.buf = this.guarded_take();
            this.next = 0;
            if (this.buf.length == 0) {
                this.eof = true;
                return true;
            }
        }
        return false;
    }

    @Override
    public int read() throws IOException {
        if (this.prepareAndCheckEOF()) {
            return -1;
        }
        byte by = this.buf[this.next];
        ++this.next;
        return by & 0xFF;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (this.prepareAndCheckEOF()) {
            return -1;
        }
        int n3 = this.buf.length - this.next;
        if (n2 < n3) {
            n3 = n2;
        }
        System.arraycopy(this.buf, this.next, byArray, n, n3);
        this.next += n3;
        return n3;
    }

    public String toString() {
        return String.format("cbIn@%x", this.hashCode());
    }

    static {
        String string = null;
        try {
            string = System.getProperty("DEBUG_ConcurrentBuffer");
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        DEBUG = string != null;
    }
}

