/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.marshall;

import com.db4o.foundation.BitMap4;
import com.db4o.internal.ByteArrayBuffer;
import com.db4o.internal.ClassAspect;
import com.db4o.internal.ClassMetadata;
import com.db4o.internal.DefragmentContextImpl;
import com.db4o.internal.FieldMetadata;
import com.db4o.internal.LatinStringIO;
import com.db4o.internal.ObjectContainerBase;
import com.db4o.internal.Transaction;
import com.db4o.internal.handlers.StringHandler;
import com.db4o.internal.handlers.array.ArrayHandler;
import com.db4o.internal.handlers.array.MultidimensionalArrayHandler;
import com.db4o.internal.marshall.AbstractFieldMarshaller;
import com.db4o.internal.marshall.AspectType;
import com.db4o.internal.marshall.RawFieldSpec;
import com.db4o.typehandlers.TypeHandler4;

public class FieldMarshaller0
extends AbstractFieldMarshaller {
    @Override
    public int marshalledLength(ObjectContainerBase stream, ClassAspect aspect) {
        int len = stream.stringIO().shortLength(aspect.getName());
        if (aspect instanceof FieldMetadata) {
            FieldMetadata field = (FieldMetadata)aspect;
            if (field.needsArrayAndPrimitiveInfo()) {
                ++len;
            }
            if (field.needsHandlerId()) {
                len += 4;
            }
        }
        return len;
    }

    @Override
    protected RawFieldSpec readSpec(AspectType aspectType, ObjectContainerBase stream, ByteArrayBuffer reader) {
        String name = StringHandler.readStringNoDebug(stream.transaction().context(), reader);
        if (!aspectType.isFieldMetadata()) {
            return new RawFieldSpec(aspectType, name);
        }
        if (name.indexOf("v4o") == 0 && stream._handlers.virtualFieldByName(name) != null) {
            return new RawFieldSpec(aspectType, name);
        }
        int handlerID = reader.readInt();
        byte attribs = reader.readByte();
        return new RawFieldSpec(aspectType, name, handlerID, attribs);
    }

    @Override
    public final FieldMetadata read(ObjectContainerBase stream, FieldMetadata field, ByteArrayBuffer reader) {
        RawFieldSpec spec = this.readSpec(stream, reader);
        return this.fromSpec(spec, stream, field);
    }

    protected FieldMetadata fromSpec(RawFieldSpec spec, ObjectContainerBase stream, FieldMetadata field) {
        if (spec == null) {
            return field;
        }
        String name = spec.name();
        if (!spec.isFieldMetadata()) {
            field.init(field.containingClass(), name);
            return field;
        }
        if (spec.isVirtual()) {
            return stream._handlers.virtualFieldByName(name);
        }
        field.init(field.containingClass(), name);
        field.init(spec.handlerID(), spec.isPrimitive(), spec.isArray(), spec.isNArray());
        field.loadHandlerById(stream);
        field.alive();
        return field;
    }

    @Override
    public void write(Transaction trans, ClassMetadata clazz, ClassAspect aspect, ByteArrayBuffer writer) {
        writer.writeShortString(trans, aspect.getName());
        if (!(aspect instanceof FieldMetadata)) {
            return;
        }
        FieldMetadata field = (FieldMetadata)aspect;
        field.alive();
        if (field.isVirtual()) {
            return;
        }
        TypeHandler4 handler = field.getHandler();
        if (handler instanceof ClassMetadata && ((ClassMetadata)handler).getID() == 0) {
            trans.container().needsUpdate(clazz);
        }
        writer.writeInt(field.handlerID());
        BitMap4 bitmap = new BitMap4(3);
        bitmap.set(0, field.isPrimitive());
        bitmap.set(1, handler instanceof ArrayHandler);
        bitmap.set(2, handler instanceof MultidimensionalArrayHandler);
        writer.writeByte(bitmap.getByte(0));
    }

    @Override
    public void defrag(ClassMetadata classMetadata, ClassAspect aspect, LatinStringIO sio, DefragmentContextImpl context) {
        context.incrementStringOffset(sio);
        if (!(aspect instanceof FieldMetadata)) {
            return;
        }
        if (((FieldMetadata)aspect).isVirtual()) {
            return;
        }
        context.copyID();
        context.incrementOffset(1);
    }
}

