/*
 * Decompiled with CFR 0.152.
 */
package plugins.UPnP.org.cybergarage.soap;

import java.io.ByteArrayInputStream;
import plugins.UPnP.org.cybergarage.http.HTTPRequest;
import plugins.UPnP.org.cybergarage.http.HTTPResponse;
import plugins.UPnP.org.cybergarage.soap.SOAP;
import plugins.UPnP.org.cybergarage.soap.SOAPResponse;
import plugins.UPnP.org.cybergarage.util.Debug;
import plugins.UPnP.org.cybergarage.xml.Node;
import plugins.UPnP.org.cybergarage.xml.Parser;
import plugins.UPnP.org.cybergarage.xml.ParserException;

public class SOAPRequest
extends HTTPRequest {
    private static final String SOAPACTION = "SOAPACTION";
    private Node rootNode;

    public SOAPRequest() {
        this.setContentType("text/xml; charset=\"utf-8\"");
        this.setMethod("POST");
    }

    public SOAPRequest(HTTPRequest httpReq) {
        this.set(httpReq);
    }

    public void setSOAPAction(String action) {
        this.setStringHeader(SOAPACTION, action);
    }

    public String getSOAPAction() {
        return this.getStringHeaderValue(SOAPACTION);
    }

    public boolean isSOAPAction(String value) {
        String headerValue = this.getHeaderValue(SOAPACTION);
        if (headerValue == null) {
            return false;
        }
        if (headerValue.equals(value)) {
            return true;
        }
        String soapAction = this.getSOAPAction();
        if (soapAction == null) {
            return false;
        }
        return soapAction.equals(value);
    }

    public SOAPResponse postMessage(String host, int port) {
        HTTPResponse httpRes = this.post(host, port);
        SOAPResponse soapRes = new SOAPResponse(httpRes);
        byte[] content = soapRes.getContent();
        if (content.length <= 0) {
            return soapRes;
        }
        try {
            ByteArrayInputStream byteIn = new ByteArrayInputStream(content);
            Parser xmlParser = SOAP.getXMLParser();
            Node rootNode = xmlParser.parse(byteIn);
            soapRes.setEnvelopeNode(rootNode);
        }
        catch (Exception e) {
            Debug.warning(e);
        }
        return soapRes;
    }

    private void setRootNode(Node node) {
        this.rootNode = node;
    }

    private synchronized Node getRootNode() {
        if (this.rootNode != null) {
            return this.rootNode;
        }
        try {
            byte[] content = this.getContent();
            ByteArrayInputStream contentIn = new ByteArrayInputStream(content);
            Parser parser = SOAP.getXMLParser();
            this.rootNode = parser.parse(contentIn);
        }
        catch (ParserException e) {
            Debug.warning(e);
        }
        return this.rootNode;
    }

    public void setEnvelopeNode(Node node) {
        this.setRootNode(node);
    }

    public Node getEnvelopeNode() {
        return this.getRootNode();
    }

    public Node getBodyNode() {
        Node envNode = this.getEnvelopeNode();
        if (envNode == null) {
            return null;
        }
        if (!envNode.hasNodes()) {
            return null;
        }
        return envNode.getNode(0);
    }

    public void setContent(Node node) {
        String conStr = "";
        conStr = conStr + "<?xml version=\"1.0\" encoding=\"utf-8\"?>";
        conStr = conStr + "\n";
        conStr = conStr + node.toString();
        this.setContent(conStr);
    }

    @Override
    public void print() {
        System.out.println(this.toString());
        if (this.hasContent()) {
            return;
        }
        Node rootElem = this.getRootNode();
        if (rootElem == null) {
            return;
        }
        System.out.println(rootElem.toString());
    }
}

