/*
 * Decompiled with CFR 0.152.
 */
package plugins.UPnP.org.cybergarage.http;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.Socket;
import java.util.StringTokenizer;
import plugins.UPnP.org.cybergarage.http.HTTP;
import plugins.UPnP.org.cybergarage.http.HTTPPacket;
import plugins.UPnP.org.cybergarage.http.HTTPResponse;
import plugins.UPnP.org.cybergarage.http.HTTPSocket;
import plugins.UPnP.org.cybergarage.http.Parameter;
import plugins.UPnP.org.cybergarage.http.ParameterList;

public class HTTPRequest
extends HTTPPacket {
    private String method = null;
    private String uri = null;
    private String requestHost = "";
    private int requestPort = -1;
    private HTTPSocket httpSocket = null;
    private Socket postSocket = null;

    public HTTPRequest() {
    }

    public HTTPRequest(InputStream in) {
        super(in);
    }

    public HTTPRequest(HTTPSocket httpSock) {
        this(httpSock.getInputStream());
        this.setSocket(httpSock);
    }

    public void setMethod(String value) {
        this.method = value;
    }

    public String getMethod() {
        if (this.method != null) {
            return this.method;
        }
        return this.getFirstLineToken(0);
    }

    public boolean isMethod(String method) {
        String headerMethod = this.getMethod();
        if (headerMethod == null) {
            return false;
        }
        return headerMethod.equalsIgnoreCase(method);
    }

    public boolean isGetRequest() {
        return this.isMethod("GET");
    }

    public boolean isPostRequest() {
        return this.isMethod("POST");
    }

    public boolean isHeadRequest() {
        return this.isMethod("HEAD");
    }

    public boolean isSubscribeRequest() {
        return this.isMethod("SUBSCRIBE");
    }

    public boolean isUnsubscribeRequest() {
        return this.isMethod("UNSUBSCRIBE");
    }

    public boolean isNotifyRequest() {
        return this.isMethod("NOTIFY");
    }

    public void setURI(String value, boolean isCheckRelativeURL) {
        this.uri = value;
        if (!isCheckRelativeURL) {
            return;
        }
        this.uri = HTTP.toRelativeURL(this.uri);
    }

    public void setURI(String value) {
        this.setURI(value, false);
    }

    public String getURI() {
        if (this.uri != null) {
            return this.uri;
        }
        return this.getFirstLineToken(1);
    }

    public ParameterList getParameterList() {
        ParameterList paramList = new ParameterList();
        String uri = this.getURI();
        if (uri == null) {
            return paramList;
        }
        int paramIdx = uri.indexOf(63);
        if (paramIdx < 0) {
            return paramList;
        }
        while (0 < paramIdx) {
            int eqIdx = uri.indexOf(61, paramIdx + 1);
            String name = uri.substring(paramIdx + 1, eqIdx);
            int nextParamIdx = uri.indexOf(38, eqIdx + 1);
            String value = uri.substring(eqIdx + 1, 0 < nextParamIdx ? nextParamIdx : uri.length());
            Parameter param = new Parameter(name, value);
            paramList.add(param);
            paramIdx = nextParamIdx;
        }
        return paramList;
    }

    public String getParameterValue(String name) {
        ParameterList paramList = this.getParameterList();
        return paramList.getValue(name);
    }

    public boolean isSOAPAction() {
        return this.hasHeader("SOAPACTION");
    }

    public void setRequestHost(String host) {
        this.requestHost = host;
    }

    public String getRequestHost() {
        return this.requestHost;
    }

    public void setRequestPort(int host) {
        this.requestPort = host;
    }

    public int getRequestPort() {
        return this.requestPort;
    }

    public void setSocket(HTTPSocket value) {
        this.httpSocket = value;
    }

    public HTTPSocket getSocket() {
        return this.httpSocket;
    }

    public String getLocalAddress() {
        return this.getSocket().getLocalAddress();
    }

    public int getLocalPort() {
        return this.getSocket().getLocalPort();
    }

    public boolean parseRequestLine(String lineStr) {
        StringTokenizer st = new StringTokenizer(lineStr, " ");
        if (!st.hasMoreTokens()) {
            return false;
        }
        this.setMethod(st.nextToken());
        if (!st.hasMoreTokens()) {
            return false;
        }
        this.setURI(st.nextToken());
        if (!st.hasMoreTokens()) {
            return false;
        }
        this.setVersion(st.nextToken());
        return true;
    }

    public String getHTTPVersion() {
        if (this.hasFirstLine()) {
            return this.getFirstLineToken(2);
        }
        return "HTTP/" + super.getVersion();
    }

    public String getFirstLineString() {
        return this.getMethod() + " " + this.getURI() + " " + this.getHTTPVersion() + "\r\n";
    }

    public String getHeader() {
        StringBuilder str = new StringBuilder();
        str.append(this.getFirstLineString());
        String headerString = this.getHeaderString();
        str.append(headerString);
        return str.toString();
    }

    public boolean isKeepAlive() {
        boolean isHTTP10;
        if (this.isCloseConnection()) {
            return false;
        }
        if (this.isKeepAliveConnection()) {
            return true;
        }
        String httpVer = this.getHTTPVersion();
        boolean bl = isHTTP10 = 0 < httpVer.indexOf("1.0");
        return !isHTTP10;
    }

    public boolean read() {
        return super.read(this.getSocket());
    }

    public boolean post(HTTPResponse httpRes) {
        HTTPSocket httpSock = this.getSocket();
        long offset = 0L;
        long length = httpRes.getContentLength();
        if (this.hasContentRange()) {
            long firstPos = this.getContentRangeFirstPosition();
            long lastPos = this.getContentRangeLastPosition();
            if (lastPos <= 0L) {
                lastPos = length - 1L;
            }
            if (firstPos > length || lastPos > length) {
                return this.returnResponse(416);
            }
            httpRes.setContentRange(firstPos, lastPos, length);
            httpRes.setStatusCode(206);
            offset = firstPos;
            length = lastPos - firstPos + 1L;
        }
        return httpSock.post(httpRes, offset, length, this.isHeadRequest());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HTTPResponse post(String host, int port, boolean isKeepAlive) {
        HTTPResponse httpRes = new HTTPResponse();
        this.setConnection(isKeepAlive ? "Keep-Alive" : "close");
        boolean isHeaderRequest = this.isHeadRequest();
        OutputStream out = null;
        InputStream in = null;
        try {
            if (this.postSocket == null) {
                this.postSocket = new Socket(host, port);
            }
            out = this.postSocket.getOutputStream();
            PrintStream pout = new PrintStream(out);
            pout.print(this.getHeader());
            pout.print("\r\n");
            boolean isChunkedRequest = this.isChunked();
            String content = this.getContentString();
            int contentLength = 0;
            if (content != null) {
                contentLength = content.length();
            }
            if (0 < contentLength) {
                if (isChunkedRequest) {
                    String chunSizeBuf = Long.toString(contentLength);
                    pout.print(chunSizeBuf);
                    pout.print("\r\n");
                }
                pout.print(content);
                if (isChunkedRequest) {
                    pout.print("\r\n");
                }
            }
            if (isChunkedRequest) {
                pout.print("0");
                pout.print("\r\n");
            }
            pout.flush();
            in = this.postSocket.getInputStream();
            httpRes.set(in, isHeaderRequest);
        }
        catch (Exception e) {
            httpRes.setStatusCode(500);
        }
        finally {
            if (!isKeepAlive) {
                try {
                    in.close();
                }
                catch (Exception exception) {}
                if (in != null) {
                    try {
                        out.close();
                    }
                    catch (Exception exception) {}
                }
                if (out != null) {
                    try {
                        this.postSocket.close();
                    }
                    catch (Exception exception) {}
                }
                this.postSocket = null;
            }
        }
        return httpRes;
    }

    public HTTPResponse post(String host, int port) {
        return this.post(host, port, false);
    }

    public void set(HTTPRequest httpReq) {
        this.set((HTTPPacket)httpReq);
        this.setSocket(httpReq.getSocket());
    }

    public boolean returnResponse(int statusCode) {
        HTTPResponse httpRes = new HTTPResponse();
        httpRes.setStatusCode(statusCode);
        httpRes.setContentLength(0L);
        return this.post(httpRes);
    }

    public boolean returnOK() {
        return this.returnResponse(200);
    }

    public boolean returnBadRequest() {
        return this.returnResponse(400);
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append(this.getHeader());
        str.append("\r\n");
        str.append(this.getContentString());
        return str.toString();
    }

    public void print() {
        System.out.println(this.toString());
    }
}

