/*
 * Decompiled with CFR 0.152.
 */
package org.tanukisoftware.wrapper.security;

import java.security.Permission;
import java.security.PermissionCollection;
import java.util.Enumeration;
import java.util.Vector;
import org.tanukisoftware.wrapper.WrapperManager;
import org.tanukisoftware.wrapper.security.WrapperServicePermission;

final class WSCollection
extends PermissionCollection {
    private static final long serialVersionUID = 7056999828486119722L;
    private Vector m_permissions = new Vector();

    @Override
    public void add(Permission permission) {
        if (!(permission instanceof WrapperServicePermission)) {
            throw new IllegalArgumentException(WrapperManager.getRes().getString("invalid permission: {0}", permission));
        }
        if (this.isReadOnly()) {
            throw new SecurityException(WrapperManager.getRes().getString("Collection is read-only."));
        }
        this.m_permissions.add(permission);
    }

    @Override
    public boolean implies(Permission permission) {
        int desiredMask;
        if (!(permission instanceof WrapperServicePermission)) {
            return false;
        }
        WrapperServicePermission wsp = (WrapperServicePermission)permission;
        int pendingMask = desiredMask = wsp.getActionMask();
        int foundMask = 0;
        Enumeration en = this.m_permissions.elements();
        while (en.hasMoreElements()) {
            WrapperServicePermission p2 = (WrapperServicePermission)en.nextElement();
            if ((pendingMask & p2.getActionMask()) == 0 || !wsp.impliesIgnoreActionMask(p2)) continue;
            if ((foundMask |= desiredMask & p2.getActionMask()) == desiredMask) {
                return true;
            }
            pendingMask = desiredMask ^ foundMask;
        }
        return false;
    }

    public Enumeration elements() {
        return this.m_permissions.elements();
    }
}

