/*
 * Decompiled with CFR 0.152.
 */
package org.spaceroots.mantissa.quadrature.scalar;

import org.spaceroots.mantissa.functions.ExhaustedSampleException;
import org.spaceroots.mantissa.functions.FunctionException;
import org.spaceroots.mantissa.functions.scalar.SampledFunctionIterator;
import org.spaceroots.mantissa.functions.scalar.ScalarValuedPair;

public class EnhancedSimpsonIntegratorSampler
implements SampledFunctionIterator {
    private SampledFunctionIterator iter;
    private ScalarValuedPair next;
    private double sum;

    public EnhancedSimpsonIntegratorSampler(SampledFunctionIterator iter) throws ExhaustedSampleException, FunctionException {
        this.iter = iter;
        this.next = iter.nextSamplePoint();
        this.sum = 0.0;
    }

    @Override
    public boolean hasNext() {
        return this.iter.hasNext();
    }

    @Override
    public ScalarValuedPair nextSamplePoint() throws ExhaustedSampleException, FunctionException {
        ScalarValuedPair previous = this.next;
        ScalarValuedPair current = this.iter.nextSamplePoint();
        try {
            this.next = this.iter.nextSamplePoint();
            double h1 = current.getX() - previous.getX();
            double h2 = this.next.getX() - current.getX();
            double cP = (h1 + h2) * (2.0 * h1 - h2) / (6.0 * h1);
            double cC = (h1 + h2) * (h1 + h2) * (h1 + h2) / (6.0 * h1 * h2);
            double cN = (h1 + h2) * (2.0 * h2 - h1) / (6.0 * h2);
            this.sum += cP * previous.getY() + cC * current.getY() + cN * this.next.getY();
        }
        catch (ExhaustedSampleException e) {
            this.sum += 0.5 * (current.getX() - previous.getX()) * (previous.getY() + current.getY());
            return new ScalarValuedPair(current.getX(), this.sum);
        }
        return new ScalarValuedPair(this.next.getX(), this.sum);
    }
}

