/*
 * Decompiled with CFR 0.152.
 */
package org.spaceroots.mantissa.ode;

import org.spaceroots.mantissa.ode.DerivativeException;
import org.spaceroots.mantissa.ode.RungeKuttaStepInterpolator;

class GillStepInterpolator
extends RungeKuttaStepInterpolator {
    private static final double tMq = 2.0 - Math.sqrt(2.0);
    private static final double tPq = 2.0 + Math.sqrt(2.0);
    private static final long serialVersionUID = -107804074496313322L;

    public GillStepInterpolator() {
    }

    public GillStepInterpolator(GillStepInterpolator interpolator) {
        super(interpolator);
    }

    @Override
    public Object clone() {
        return new GillStepInterpolator(this);
    }

    @Override
    protected void computeInterpolatedState(double theta, double oneMinusThetaH) throws DerivativeException {
        double fourTheta = 4.0 * theta;
        double s = oneMinusThetaH / 6.0;
        double soMt = s * (1.0 - theta);
        double c23 = soMt * (1.0 + 2.0 * theta);
        double coeff1 = soMt * (1.0 - fourTheta);
        double coeff2 = c23 * tMq;
        double coeff3 = c23 * tPq;
        double coeff4 = s * (1.0 + theta * (1.0 + fourTheta));
        for (int i = 0; i < this.interpolatedState.length; ++i) {
            this.interpolatedState[i] = this.currentState[i] - coeff1 * this.yDotK[0][i] - coeff2 * this.yDotK[1][i] - coeff3 * this.yDotK[2][i] - coeff4 * this.yDotK[3][i];
        }
    }
}

