/*
 * Decompiled with CFR 0.152.
 */
package org.spaceroots.mantissa.algebra;

import java.io.Serializable;
import java.math.BigInteger;
import java.util.Arrays;
import org.spaceroots.mantissa.algebra.RationalNumber;

public abstract class Polynomial
implements Serializable {
    public abstract boolean isZero();

    public abstract boolean isOne();

    public abstract boolean isIdentity();

    public abstract int getDegree();

    public abstract Polynomial negate();

    public abstract Polynomial multiply(RationalNumber var1);

    public abstract Polynomial multiply(long var1);

    public Polynomial multiply(BigInteger i) {
        return this.multiply(new RationalNumber(i));
    }

    public Polynomial divide(long l) {
        return this.divide(new RationalNumber(l));
    }

    public Polynomial divide(RationalNumber r) {
        return this.multiply(r.invert());
    }

    public Polynomial divide(BigInteger i) {
        return this.divide(new RationalNumber(i));
    }

    public abstract double valueAt(double var1);

    public abstract Polynomial getDerivative();

    public static class Double
    extends Polynomial {
        protected double[] a;
        private static final long serialVersionUID = -4210522025715687648L;

        public Double() {
            this.a = new double[]{0.0};
        }

        public Double(long value) {
            this((double)value);
        }

        public Double(double value) {
            this.a = new double[]{value};
        }

        public Double(long a1, long a0) {
            this((double)a1, (double)a0);
        }

        public Double(double a1, double a0) {
            this.a = a1 != 0.0 ? new double[]{a0, a1} : new double[]{a0};
        }

        public Double(long a2, long a1, long a0) {
            this((double)a2, (double)a1, (double)a0);
        }

        public Double(double a2, double a1, double a0) {
            this.a = a2 != 0.0 ? new double[]{a0, a1, a2} : (a1 != 0.0 ? new double[]{a0, a1} : new double[]{a0});
        }

        public Double(long a3, long a2, long a1, long a0) {
            this((double)a3, (double)a2, (double)a1, (double)a0);
        }

        public Double(double a3, double a2, double a1, double a0) {
            this.a = a3 != 0.0 ? new double[]{a0, a1, a2, a3} : (a2 != 0.0 ? new double[]{a0, a1, a2} : (a1 != 0.0 ? new double[]{a0, a1} : new double[]{a0}));
        }

        public Double(double[] a) {
            int i;
            for (i = a.length - 1; i > 0 && a[i] == 0.0; --i) {
            }
            this.a = new double[i + 1];
            System.arraycopy(a, 0, this.a, 0, i + 1);
        }

        public Double(double c, int degree) {
            if (c == 0.0 || degree < 0) {
                this.a = new double[]{0.0};
            } else {
                this.a = new double[degree + 1];
                Arrays.fill(this.a, 0, degree, 0.0);
                this.a[degree] = c;
            }
        }

        public Double(Rational r) {
            this.a = new double[r.a.length];
            for (int i = 0; i < this.a.length; ++i) {
                this.a[i] = r.a[i].doubleValue();
            }
        }

        @Override
        public boolean isZero() {
            return this.a.length == 1 && this.a[0] == 0.0;
        }

        @Override
        public boolean isOne() {
            return this.a.length == 1 && this.a[0] - 1.0 == 0.0;
        }

        @Override
        public boolean isIdentity() {
            return this.a.length == 2 && this.a[0] == 0.0 && this.a[1] - 1.0 == 0.0;
        }

        @Override
        public int getDegree() {
            return this.a.length - 1;
        }

        public double[] getCoefficients() {
            return (double[])this.a.clone();
        }

        public Double add(Double p) {
            int lowLength = Math.min(this.a.length, p.a.length);
            int highLength = Math.max(this.a.length, p.a.length);
            double[] newA = new double[highLength];
            for (int i = 0; i < lowLength; ++i) {
                newA[i] = this.a[i] + p.a[i];
            }
            System.arraycopy(this.a.length < p.a.length ? p.a : this.a, lowLength, newA, lowLength, highLength - lowLength);
            return new Double(newA);
        }

        public Double subtract(Double p) {
            int i;
            int lowLength = Math.min(this.a.length, p.a.length);
            int highLength = Math.max(this.a.length, p.a.length);
            double[] newA = new double[highLength];
            for (i = 0; i < lowLength; ++i) {
                newA[i] = this.a[i] - p.a[i];
            }
            if (this.a.length < p.a.length) {
                for (i = lowLength; i < highLength; ++i) {
                    newA[i] = -p.a[i];
                }
            } else {
                System.arraycopy(this.a, lowLength, newA, lowLength, highLength - lowLength);
            }
            return new Double(newA);
        }

        @Override
        public Polynomial negate() {
            double[] newA = new double[this.a.length];
            for (int i = 0; i < this.a.length; ++i) {
                newA[i] = -this.a[i];
            }
            return new Double(newA);
        }

        public Double multiply(Double p) {
            double[] newA = new double[this.a.length + p.a.length - 1];
            for (int i = 0; i < newA.length; ++i) {
                newA[i] = 0.0;
                for (int j = Math.max(0, i + 1 - p.a.length); j < Math.min(this.a.length, i + 1); ++j) {
                    int n = i;
                    newA[n] = newA[n] + this.a[j] * p.a[i - j];
                }
            }
            return new Double(newA);
        }

        @Override
        public Polynomial multiply(long l) {
            return this.multiply((double)l);
        }

        @Override
        public Polynomial multiply(RationalNumber r) {
            return this.multiply(r.doubleValue());
        }

        public Polynomial multiply(double r) {
            if (r == 0.0) {
                return new Double(new double[]{0.0});
            }
            double[] newA = new double[this.a.length];
            for (int i = 0; i < this.a.length; ++i) {
                newA[i] = this.a[i] * r;
            }
            return new Double(newA);
        }

        @Override
        public double valueAt(double x) {
            double y = 0.0;
            for (int i = this.a.length - 1; i >= 0; --i) {
                y = y * x + this.a[i];
            }
            return y;
        }

        @Override
        public Polynomial getDerivative() {
            if (this.a.length == 1) {
                return new Double();
            }
            double[] newA = new double[this.a.length - 1];
            for (int i = 1; i < this.a.length; ++i) {
                newA[i - 1] = this.a[i] * (double)i;
            }
            return new Double(newA);
        }

        public String toString() {
            StringBuffer s = new StringBuffer();
            if (this.a[0] == 0.0) {
                if (this.a.length == 1) {
                    return "0";
                }
            } else {
                s.append(java.lang.Double.toString(this.a[0]));
            }
            for (int i = 1; i < this.a.length; ++i) {
                if (this.a[i] == 0.0) continue;
                if (s.length() > 0) {
                    if (this.a[i] < 0.0) {
                        s.append(" - ");
                    } else {
                        s.append(" + ");
                    }
                } else if (this.a[i] < 0.0) {
                    s.append("-");
                }
                double absAi = Math.abs(this.a[i]);
                if (absAi - 1.0 != 0.0) {
                    s.append(java.lang.Double.toString(absAi));
                    s.append(' ');
                }
                s.append("x");
                if (i <= 1) continue;
                s.append('^');
                s.append(Integer.toString(i));
            }
            return s.toString();
        }
    }

    public static class DivisionResult {
        public final Rational quotient;
        public final Rational remainder;

        public DivisionResult(Rational quotient, Rational remainder) {
            this.quotient = quotient;
            this.remainder = remainder;
        }
    }

    public static class Rational
    extends Polynomial {
        protected RationalNumber[] a;
        private static final long serialVersionUID = -794133890636181115L;

        public Rational() {
            this.a = new RationalNumber[]{RationalNumber.ZERO};
        }

        public Rational(long value) {
            this(new RationalNumber(value));
        }

        public Rational(RationalNumber value) {
            this.a = new RationalNumber[]{value};
        }

        public Rational(long a1, long a0) {
            this(new RationalNumber(a1), new RationalNumber(a0));
        }

        public Rational(RationalNumber a1, RationalNumber a0) {
            this.a = !a1.isZero() ? new RationalNumber[]{a0, a1} : new RationalNumber[]{a0};
        }

        public Rational(long a2, long a1, long a0) {
            this(new RationalNumber(a2), new RationalNumber(a1), new RationalNumber(a0));
        }

        public Rational(RationalNumber a2, RationalNumber a1, RationalNumber a0) {
            this.a = !a2.isZero() ? new RationalNumber[]{a0, a1, a2} : (!a1.isZero() ? new RationalNumber[]{a0, a1} : new RationalNumber[]{a0});
        }

        public Rational(long a3, long a2, long a1, long a0) {
            this(new RationalNumber(a3), new RationalNumber(a2), new RationalNumber(a1), new RationalNumber(a0));
        }

        public Rational(RationalNumber a3, RationalNumber a2, RationalNumber a1, RationalNumber a0) {
            this.a = !a3.isZero() ? new RationalNumber[]{a0, a1, a2, a3} : (!a2.isZero() ? new RationalNumber[]{a0, a1, a2} : (!a1.isZero() ? new RationalNumber[]{a0, a1} : new RationalNumber[]{a0}));
        }

        public Rational(RationalNumber[] a) {
            int i;
            for (i = a.length - 1; i > 0 && a[i].isZero(); --i) {
            }
            this.a = new RationalNumber[i + 1];
            System.arraycopy(a, 0, this.a, 0, i + 1);
        }

        public Rational(RationalNumber c, int degree) {
            if (c.isZero() || degree < 0) {
                this.a = new RationalNumber[]{RationalNumber.ZERO};
            } else {
                this.a = new RationalNumber[degree + 1];
                Arrays.fill(this.a, 0, degree, RationalNumber.ZERO);
                this.a[degree] = c;
            }
        }

        @Override
        public boolean isZero() {
            return this.a.length == 1 && this.a[0].isZero();
        }

        @Override
        public boolean isOne() {
            return this.a.length == 1 && this.a[0].isOne();
        }

        @Override
        public boolean isIdentity() {
            return this.a.length == 2 && this.a[0].isZero() && this.a[1].isOne();
        }

        @Override
        public int getDegree() {
            return this.a.length - 1;
        }

        public RationalNumber[] getCoefficients() {
            return (RationalNumber[])this.a.clone();
        }

        public Rational add(Rational p) {
            int lowLength = Math.min(this.a.length, p.a.length);
            int highLength = Math.max(this.a.length, p.a.length);
            RationalNumber[] newA = new RationalNumber[highLength];
            for (int i = 0; i < lowLength; ++i) {
                newA[i] = this.a[i].add(p.a[i]);
            }
            System.arraycopy(this.a.length < p.a.length ? p.a : this.a, lowLength, newA, lowLength, highLength - lowLength);
            return new Rational(newA);
        }

        public Rational subtract(Rational p) {
            int i;
            int lowLength = Math.min(this.a.length, p.a.length);
            int highLength = Math.max(this.a.length, p.a.length);
            RationalNumber[] newA = new RationalNumber[highLength];
            for (i = 0; i < lowLength; ++i) {
                newA[i] = this.a[i].subtract(p.a[i]);
            }
            if (this.a.length < p.a.length) {
                for (i = lowLength; i < highLength; ++i) {
                    newA[i] = p.a[i].negate();
                }
            } else {
                System.arraycopy(this.a, lowLength, newA, lowLength, highLength - lowLength);
            }
            return new Rational(newA);
        }

        @Override
        public Polynomial negate() {
            RationalNumber[] newA = new RationalNumber[this.a.length];
            for (int i = 0; i < this.a.length; ++i) {
                newA[i] = this.a[i].negate();
            }
            return new Rational(newA);
        }

        public Rational multiply(Rational p) {
            RationalNumber[] newA = new RationalNumber[this.a.length + p.a.length - 1];
            for (int i = 0; i < newA.length; ++i) {
                newA[i] = RationalNumber.ZERO;
                for (int j = Math.max(0, i + 1 - p.a.length); j < Math.min(this.a.length, i + 1); ++j) {
                    newA[i] = newA[i].add(this.a[j].multiply(p.a[i - j]));
                }
            }
            return new Rational(newA);
        }

        @Override
        public Polynomial multiply(long l) {
            return this.multiply(new RationalNumber(l));
        }

        @Override
        public Polynomial multiply(RationalNumber r) {
            if (r.isZero()) {
                return new Rational(new RationalNumber[]{RationalNumber.ZERO});
            }
            if (r.isOne()) {
                return this;
            }
            RationalNumber[] newA = new RationalNumber[this.a.length];
            for (int i = 0; i < this.a.length; ++i) {
                newA[i] = this.a[i].multiply(r);
            }
            return new Rational(newA);
        }

        @Override
        public double valueAt(double x) {
            double y = 0.0;
            for (int i = this.a.length - 1; i >= 0; --i) {
                y = y * x + this.a[i].doubleValue();
            }
            return y;
        }

        @Override
        public Polynomial getDerivative() {
            if (this.a.length == 1) {
                return new Rational();
            }
            RationalNumber[] newA = new RationalNumber[this.a.length - 1];
            for (int i = 1; i < this.a.length; ++i) {
                newA[i - 1] = this.a[i].multiply(i);
            }
            return new Rational(newA);
        }

        public static DivisionResult euclidianDivision(Rational dividend, Rational divisor) {
            Rational quotient = new Rational(0L);
            Rational remainder = dividend;
            int divisorDegree = divisor.getDegree();
            int remainderDegree = remainder.getDegree();
            while (!remainder.isZero() && remainderDegree >= divisorDegree) {
                RationalNumber c = remainder.a[remainderDegree].divide(divisor.a[divisorDegree]);
                Rational monomial = new Rational(c, remainderDegree - divisorDegree);
                remainder = remainder.subtract(monomial.multiply(divisor));
                quotient = quotient.add(monomial);
                remainderDegree = remainder.getDegree();
            }
            return new DivisionResult(quotient, remainder);
        }

        public BigInteger getDenominatorsLCM() {
            BigInteger lcm = BigInteger.ONE;
            for (int i = 0; i < this.a.length; ++i) {
                RationalNumber newCoeff = this.a[i].multiply(lcm);
                if (newCoeff.isInteger()) continue;
                lcm = lcm.multiply(newCoeff.getDenominator());
            }
            return lcm;
        }

        public String toString() {
            StringBuffer s = new StringBuffer();
            if (this.a[0].isZero()) {
                if (this.a.length == 1) {
                    return "0";
                }
            } else {
                s.append(this.a[0].toString());
            }
            for (int i = 1; i < this.a.length; ++i) {
                if (this.a[i].isZero()) continue;
                if (s.length() > 0) {
                    if (this.a[i].isNegative()) {
                        s.append(" - ");
                    } else {
                        s.append(" + ");
                    }
                } else if (this.a[i].isNegative()) {
                    s.append("-");
                }
                RationalNumber absAi = RationalNumber.abs(this.a[i]);
                if (!absAi.isOne()) {
                    s.append(absAi.toString());
                    s.append(' ');
                }
                s.append("x");
                if (i <= 1) continue;
                s.append('^');
                s.append(Integer.toString(i));
            }
            return s.toString();
        }
    }
}

