/*
 * Decompiled with CFR 0.152.
 */
package org.bitpedia.collider.core;

import java.util.Arrays;
import org.bitpedia.util.Base32;
import org.bitpedia.util.Sha1;
import org.bitpedia.util.TigerTree;

public class Bitprint {
    public static final int BITPRINT_RAW_LEN = 44;
    public static final int BITPRINT_BASE32_LEN = 72;
    public static final int SHA_BASE32SIZE = 32;
    public static final int TIGER_BASE32SIZE = 39;
    public static final int BUFFER_LEN = 4096;
    private static final int ONEK_SIZE = 1025;
    private static final String EMPTY_SHA = "3I42H3S6NNFQ2MSVX7XZKYAYSCX5QBYJ";
    private static final String ONE_SHA = "GVVBSK3ZCOYEYVCXJUMMFDKG4Y4VIKFL";
    private static final String ONEK_SHA = "CAE54LXWDA55NWGAR4PNRX2II7TR66WL";
    private static final String EMPTY_TIGER = "LWPNACQDBZRYXW3VHJVCJ64QBZNGHOHHHZWCLNQ";
    private static final String ONE_TIGER = "QMLU34VTTAIWJQM5RVN4RIQKRM2JWIFZQFDYY3Y";
    private static final String ONEK_TIGER = "CDYY2OW6F6DTGCH3Q6NMSDLSRV7PNMAL3CED3DA";
    private Sha1 sha1;
    private TigerTree tt;

    private static boolean checkTigertreeHash(String string, byte[] byArray, int n) {
        TigerTree tigerTree = new TigerTree();
        tigerTree.update(byArray, 0, n);
        String string2 = Base32.encode(tigerTree.digest());
        return !string2.equals(string);
    }

    private static boolean checkSha1Hash(String string, byte[] byArray, int n) {
        Sha1 sha1 = new Sha1();
        sha1.engineUpdate(byArray, 0, n);
        String string2 = Base32.encode(sha1.digest());
        return !string2.equals(string);
    }

    private static boolean hashSanityCheck() {
        boolean bl = false;
        byte[] byArray = new byte[]{49};
        bl = bl || Bitprint.checkTigertreeHash(EMPTY_TIGER, byArray, 0);
        bl = bl || Bitprint.checkSha1Hash(EMPTY_SHA, byArray, 0);
        bl = bl || Bitprint.checkTigertreeHash(ONE_TIGER, byArray, 1);
        bl = bl || Bitprint.checkSha1Hash(ONE_SHA, byArray, 1);
        byArray = new byte[1025];
        Arrays.fill(byArray, (byte)97);
        bl = bl || Bitprint.checkTigertreeHash(ONEK_TIGER, byArray, 1025);
        bl = bl || Bitprint.checkSha1Hash(ONEK_SHA, byArray, 1025);
        return bl;
    }

    public boolean analyzeInit() {
        if (Bitprint.hashSanityCheck()) {
            return false;
        }
        this.tt = new TigerTree();
        this.sha1 = new Sha1();
        return true;
    }

    public void analyzeUpdate(byte[] byArray, int n, int n2) {
        this.tt.update(byArray, n, n2);
        this.sha1.update(byArray, n, n2);
    }

    public byte[] analyzeFinal() {
        byte[] byArray = this.tt.digest();
        byte[] byArray2 = this.sha1.digest();
        byte[] byArray3 = new byte[byArray2.length + byArray.length];
        System.arraycopy(byArray2, 0, byArray3, 0, byArray2.length);
        System.arraycopy(byArray, 0, byArray3, byArray2.length, byArray.length);
        return byArray3;
    }

    public static void main(String[] stringArray) {
        if (Bitprint.hashSanityCheck()) {
            System.out.println("Hash test FAILED");
        } else {
            System.out.println("Hash test OK");
        }
    }
}

