/*
 * Decompiled with CFR 0.152.
 */
package com.onionnetworks.fec;

import com.onionnetworks.fec.FECCode;
import com.onionnetworks.fec.FECCodeFactory;
import com.onionnetworks.util.Tuple;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;
import java.util.StringTokenizer;

public class DefaultFECCodeFactory
extends FECCodeFactory {
    public static final int DEFAULT_CACHE_TIME = 120000;
    protected ArrayList eightBitCodes = new ArrayList();
    protected ArrayList sixteenBitCodes = new ArrayList();
    protected Properties fecProperties;

    public DefaultFECCodeFactory() {
        try {
            this.fecProperties = new Properties();
            this.fecProperties.load(DefaultFECCodeFactory.class.getClassLoader().getResourceAsStream(System.getProperty("com.onionnetworks.fec.defaultfeccodefactorypropertiesfile", "lib/fec.properties")));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new IllegalStateException("Unable to load /lib/fec.properties");
        }
        StringTokenizer stringTokenizer = new StringTokenizer(this.getProperty("com.onionnetworks.fec.keys"), ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string = stringTokenizer.nextToken();
            try {
                Constructor<?> constructor = Class.forName(this.getProperty("com.onionnetworks.fec." + string + ".class")).getConstructor(Integer.TYPE, Integer.TYPE);
                String string2 = this.getProperty("com.onionnetworks.fec." + string + ".bits");
                if ("8".equals(string2)) {
                    this.eightBitCodes.add(constructor);
                    continue;
                }
                if ("16".equals(string2)) {
                    this.sixteenBitCodes.add(constructor);
                    continue;
                }
                throw new IllegalArgumentException("Only 8 and 16 bit codes are currently supported");
            }
            catch (Throwable throwable) {
                System.out.println(throwable.getMessage());
            }
        }
    }

    protected synchronized String getProperty(String string) {
        String string2 = System.getProperty(string);
        if (string2 == null) {
            string2 = this.fecProperties.getProperty(string);
        }
        return string2;
    }

    @Override
    public synchronized FECCode createFECCode(int n, int n2) {
        Integer n3 = new Integer(n);
        Integer n4 = new Integer(n2);
        Tuple tuple = new Tuple(n3, n4);
        FECCode fECCode = null;
        if (fECCode == null) {
            if (n < 1 || n > 65536 || n2 < n || n2 > 65536) {
                throw new IllegalArgumentException("k and n must be between 1 and 65536 and n must not be smaller than k: k=" + n + ",n=" + n2);
            }
            Iterator iterator = n2 <= 256 && !this.eightBitCodes.isEmpty() ? this.eightBitCodes.iterator() : this.sixteenBitCodes.iterator();
            while (iterator.hasNext()) {
                try {
                    fECCode = (FECCode)((Constructor)iterator.next()).newInstance(n3, n4);
                    break;
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
        }
        return fECCode;
    }
}

