/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.query.result;

import com.db4o.foundation.Algorithms4;
import com.db4o.foundation.IntArrayList;
import com.db4o.foundation.IntIterator4;
import com.db4o.foundation.QuickSortable4;
import com.db4o.foundation.Tree;
import com.db4o.foundation.Visitor4;
import com.db4o.internal.ByteArrayBuffer;
import com.db4o.internal.ClassMetadata;
import com.db4o.internal.ClassMetadataIterator;
import com.db4o.internal.Transaction;
import com.db4o.internal.TreeInt;
import com.db4o.internal.btree.BTree;
import com.db4o.internal.classindex.BTreeClassIndexStrategy;
import com.db4o.internal.classindex.ClassIndexStrategy;
import com.db4o.internal.query.processor.QCandidate;
import com.db4o.internal.query.processor.QQuery;
import com.db4o.internal.query.result.AbstractQueryResult;
import com.db4o.query.QueryComparator;
import com.db4o.reflect.ReflectClass;

public class IdListQueryResult
extends AbstractQueryResult
implements Visitor4 {
    private Tree _candidates;
    private boolean _checkDuplicates;
    public IntArrayList _ids;

    public IdListQueryResult(Transaction trans, int initialSize) {
        super(trans);
        this._ids = new IntArrayList(initialSize);
    }

    public IdListQueryResult(Transaction trans) {
        this(trans, 0);
    }

    @Override
    public IntIterator4 iterateIDs() {
        return this._ids.intIterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object get(int index) {
        Object object = this.lock();
        synchronized (object) {
            return this.activatedObject(this.getId(index));
        }
    }

    @Override
    public int getId(int index) {
        if (index < 0 || index >= this.size()) {
            throw new IndexOutOfBoundsException();
        }
        return this._ids.get(index);
    }

    public final void checkDuplicates() {
        this._checkDuplicates = true;
    }

    @Override
    public void visit(Object a_tree) {
        QCandidate candidate = (QCandidate)a_tree;
        if (candidate.include()) {
            this.addKeyCheckDuplicates(candidate._key);
        }
    }

    public void addKeyCheckDuplicates(int a_key) {
        if (this._checkDuplicates) {
            TreeInt newNode = new TreeInt(a_key);
            this._candidates = Tree.add(this._candidates, newNode);
            if (newNode._size == 0) {
                return;
            }
        }
        this.add(a_key);
    }

    @Override
    public void sort(final QueryComparator cmp) {
        Algorithms4.qsort(new QuickSortable4(){

            @Override
            public void swap(int leftIndex, int rightIndex) {
                IdListQueryResult.this._ids.swap(leftIndex, rightIndex);
            }

            @Override
            public int size() {
                return IdListQueryResult.this.size();
            }

            @Override
            public int compare(int leftIndex, int rightIndex) {
                return cmp.compare(IdListQueryResult.this.get(leftIndex), IdListQueryResult.this.get(rightIndex));
            }
        });
    }

    @Override
    public void loadFromClassIndex(ClassMetadata clazz) {
        ClassIndexStrategy index = clazz.index();
        if (index instanceof BTreeClassIndexStrategy) {
            BTree btree = ((BTreeClassIndexStrategy)index).btree();
            this._ids = new IntArrayList(btree.size(this.transaction()));
        }
        index.traverseAll(this._transaction, new Visitor4(){

            @Override
            public void visit(Object a_object) {
                IdListQueryResult.this.add((Integer)a_object);
            }
        });
    }

    @Override
    public void loadFromQuery(QQuery query) {
        query.executeLocal(this);
    }

    @Override
    public void loadFromClassIndexes(ClassMetadataIterator iter) {
        final Tree.ByRef duplicates = new Tree.ByRef();
        while (iter.moveNext()) {
            ReflectClass claxx;
            ClassMetadata yapClass = iter.currentClass();
            if (yapClass.getName() == null || (claxx = yapClass.classReflector()) != null && this.stream()._handlers.ICLASS_INTERNAL.isAssignableFrom(claxx)) continue;
            ClassIndexStrategy index = yapClass.index();
            index.traverseAll(this._transaction, new Visitor4(){

                @Override
                public void visit(Object obj) {
                    int id = (Integer)obj;
                    TreeInt newNode = new TreeInt(id);
                    duplicates.value = Tree.add(duplicates.value, newNode);
                    if (newNode.size() != 0) {
                        IdListQueryResult.this.add(id);
                    }
                }
            });
        }
    }

    @Override
    public void loadFromIdReader(ByteArrayBuffer reader) {
        int size = reader.readInt();
        for (int i = 0; i < size; ++i) {
            this.add(reader.readInt());
        }
    }

    public void add(int id) {
        this._ids.add(id);
    }

    @Override
    public int indexOf(int id) {
        return this._ids.indexOf(id);
    }

    @Override
    public int size() {
        return this._ids.size();
    }
}

