/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.marshall;

import com.db4o.ext.IncompatibleFileFormatException;
import com.db4o.internal.marshall.ClassMarshaller;
import com.db4o.internal.marshall.ClassMarshaller0;
import com.db4o.internal.marshall.ClassMarshaller1;
import com.db4o.internal.marshall.ClassMarshaller2;
import com.db4o.internal.marshall.FieldMarshaller;
import com.db4o.internal.marshall.FieldMarshaller0;
import com.db4o.internal.marshall.FieldMarshaller1;
import com.db4o.internal.marshall.FieldMarshaller2;
import com.db4o.internal.marshall.PrimitiveMarshaller;
import com.db4o.internal.marshall.PrimitiveMarshaller0;
import com.db4o.internal.marshall.PrimitiveMarshaller1;

public class MarshallerFamily {
    private static int CURRENT_VERSION = 3;
    public final ClassMarshaller _class;
    public final FieldMarshaller _field;
    public final PrimitiveMarshaller _primitive;
    private final int _converterVersion;
    private final int _handlerVersion;
    private static final MarshallerFamily[] allVersions = new MarshallerFamily[4];

    public MarshallerFamily(int converterVersion, int handlerVersion, ClassMarshaller classMarshaller, FieldMarshaller fieldMarshaller, PrimitiveMarshaller primitiveMarshaller) {
        this._converterVersion = converterVersion;
        this._handlerVersion = handlerVersion;
        this._class = classMarshaller;
        this._class._family = this;
        this._field = fieldMarshaller;
        this._primitive = primitiveMarshaller;
        this._primitive._family = this;
    }

    public static MarshallerFamily latestFamily(int version) {
        return new MarshallerFamily(7, version, new ClassMarshaller2(), new FieldMarshaller2(), new PrimitiveMarshaller1());
    }

    public static MarshallerFamily version(int n) {
        MarshallerFamily.checkIfVersionIsTooNew(n);
        return allVersions[n];
    }

    private static void checkIfVersionIsTooNew(int n) {
        if (n > allVersions.length) {
            throw new IncompatibleFileFormatException("Databasefile was created with a newer db4o version. Marshaller version: " + n);
        }
    }

    public static MarshallerFamily current() {
        if (CURRENT_VERSION < 2) {
            throw new IllegalStateException("Using old marshaller versions to write database files is not supported, source code has been removed.");
        }
        return MarshallerFamily.version(CURRENT_VERSION);
    }

    public static MarshallerFamily forConverterVersion(int n) {
        MarshallerFamily result = allVersions[0];
        for (int i = 1; i < allVersions.length; ++i) {
            if (MarshallerFamily.allVersions[i]._converterVersion > n) {
                return result;
            }
            result = allVersions[i];
        }
        return result;
    }

    public int handlerVersion() {
        return this._handlerVersion;
    }

    static {
        MarshallerFamily.allVersions[0] = new MarshallerFamily(0, 0, new ClassMarshaller0(), new FieldMarshaller0(), new PrimitiveMarshaller0());
        MarshallerFamily.allVersions[1] = new MarshallerFamily(5, 1, new ClassMarshaller1(), new FieldMarshaller0(), new PrimitiveMarshaller1());
        MarshallerFamily.allVersions[2] = new MarshallerFamily(6, 2, new ClassMarshaller2(), new FieldMarshaller1(), new PrimitiveMarshaller1());
        for (int i = 3; i < allVersions.length; ++i) {
            MarshallerFamily.allVersions[i] = MarshallerFamily.latestFamily(i);
        }
    }

    public static class FamilyVersion {
        public static final int PRE_MARSHALLER = 0;
        public static final int MARSHALLER = 1;
        public static final int BTREE_FIELD_INDEXES = 2;
        public static final int CLASS_ASPECTS = 3;
    }
}

