/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.cs;

import com.db4o.foundation.IntIterator4;
import com.db4o.foundation.Iterator4;
import com.db4o.internal.cs.ClientObjectContainer;
import com.db4o.internal.cs.PrefetchingStrategy;
import com.db4o.internal.cs.SingleMessagePrefetchingStrategy;
import com.db4o.internal.query.result.AbstractQueryResult;

class ClientQueryResultIterator
implements Iterator4 {
    private static final PrefetchingStrategy _prefetchingStrategy = SingleMessagePrefetchingStrategy.INSTANCE;
    private Object[] _prefetchedObjects;
    private int _remainingObjects;
    private int _prefetchRight;
    private final AbstractQueryResult _client;
    private final IntIterator4 _ids;

    ClientQueryResultIterator(AbstractQueryResult client) {
        this._client = client;
        this._ids = client.iterateIDs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object current() {
        Object object = this.streamLock();
        synchronized (object) {
            return this._client.activate(this.prefetchedCurrent());
        }
    }

    private Object streamLock() {
        return this._client.lock();
    }

    @Override
    public void reset() {
        this._remainingObjects = 0;
        this._ids.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean moveNext() {
        Object object = this.streamLock();
        synchronized (object) {
            if (this._remainingObjects > 0) {
                --this._remainingObjects;
                return this.skipNulls();
            }
            this.prefetch();
            --this._remainingObjects;
            if (this._remainingObjects < 0) {
                return false;
            }
            return this.skipNulls();
        }
    }

    private boolean skipNulls() {
        if (this.prefetchedCurrent() == null) {
            return this.moveNext();
        }
        return true;
    }

    private void prefetch() {
        this.ensureObjectCacheAllocated(this.prefetchCount());
        this._prefetchRight = this._remainingObjects = _prefetchingStrategy.prefetchObjects(this.stream(), this._client.transaction(), this._ids, this._prefetchedObjects, this.prefetchCount());
    }

    private int prefetchCount() {
        return Math.max(this.stream().config().prefetchObjectCount(), 1);
    }

    private ClientObjectContainer stream() {
        return (ClientObjectContainer)this._client.stream();
    }

    private Object prefetchedCurrent() {
        return this._prefetchedObjects[this._prefetchRight - this._remainingObjects - 1];
    }

    private void ensureObjectCacheAllocated(int prefetchObjectCount) {
        if (this._prefetchedObjects == null) {
            this._prefetchedObjects = new Object[prefetchObjectCount];
            return;
        }
        if (prefetchObjectCount > this._prefetchedObjects.length) {
            Object[] newPrefetchedObjects = new Object[prefetchObjectCount];
            System.arraycopy(this._prefetchedObjects, 0, newPrefetchedObjects, 0, this._prefetchedObjects.length);
            this._prefetchedObjects = newPrefetchedObjects;
        }
    }
}

