/*
 * Decompiled with CFR 0.152.
 */
package freenet.support.io;

import freenet.client.async.ClientContext;
import freenet.support.Logger;
import freenet.support.api.Bucket;
import freenet.support.api.RandomAccessBucket;
import freenet.support.io.BaseFileBucket;
import freenet.support.io.ResumeFailedException;
import freenet.support.io.StorageFormatException;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;

public class FileBucket
extends BaseFileBucket
implements Bucket,
Serializable {
    private static final long serialVersionUID = 1L;
    protected final File file;
    protected boolean readOnly;
    protected boolean deleteOnFree;
    protected final boolean deleteOnExit;
    protected final boolean createFileOnly;
    private static volatile boolean logMINOR;
    public static final int MAGIC = -1880693733;
    static final int VERSION = 1;

    public FileBucket(File file, boolean readOnly, boolean createFileOnly, boolean deleteOnExit, boolean deleteOnFree) {
        super(file, deleteOnExit);
        if (file == null) {
            throw new NullPointerException();
        }
        File origFile = file;
        if (origFile == (file = file.getAbsoluteFile())) {
            file = new File(file.getPath());
        }
        this.readOnly = readOnly;
        this.createFileOnly = createFileOnly;
        this.file = file;
        this.deleteOnFree = deleteOnFree;
        this.deleteOnExit = deleteOnExit;
        this.fileRestartCounter = 0L;
    }

    protected FileBucket() {
        this.file = null;
        this.deleteOnExit = false;
        this.createFileOnly = false;
    }

    @Override
    public synchronized File getFile() {
        return this.file;
    }

    @Override
    public synchronized boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public synchronized void setReadOnly() {
        this.readOnly = true;
    }

    @Override
    protected boolean createFileOnly() {
        return this.createFileOnly;
    }

    @Override
    protected boolean deleteOnExit() {
        return this.deleteOnExit;
    }

    @Override
    protected boolean deleteOnFree() {
        return this.deleteOnFree;
    }

    @Override
    public RandomAccessBucket createShadow() {
        String fnam = this.file.getPath();
        File newFile = new File(fnam);
        return new FileBucket(newFile, true, false, false, false);
    }

    @Override
    public void onResume(ClientContext context) throws ResumeFailedException {
        super.onResume(context);
    }

    @Override
    protected boolean tempFileAlreadyExists() {
        return false;
    }

    @Override
    public void storeTo(DataOutputStream dos) throws IOException {
        dos.writeInt(-1880693733);
        super.storeTo(dos);
        dos.writeInt(1);
        dos.writeUTF(this.file.toString());
        dos.writeBoolean(this.readOnly);
        dos.writeBoolean(this.deleteOnFree);
        if (this.deleteOnExit) {
            throw new IllegalStateException("Must not free on exit if persistent");
        }
        dos.writeBoolean(this.createFileOnly);
    }

    protected FileBucket(DataInputStream dis) throws IOException, StorageFormatException {
        super(dis);
        int version = dis.readInt();
        if (version != 1) {
            throw new StorageFormatException("Bad version");
        }
        this.file = new File(dis.readUTF());
        this.readOnly = dis.readBoolean();
        this.deleteOnFree = dis.readBoolean();
        this.deleteOnExit = false;
        this.createFileOnly = dis.readBoolean();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.createFileOnly ? 1231 : 1237);
        result = 31 * result + (this.deleteOnExit ? 1231 : 1237);
        result = 31 * result + (this.deleteOnFree ? 1231 : 1237);
        result = 31 * result + (this.file == null ? 0 : this.file.hashCode());
        result = 31 * result + (this.readOnly ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FileBucket other = (FileBucket)obj;
        if (this.createFileOnly != other.createFileOnly) {
            return false;
        }
        if (this.deleteOnExit != other.deleteOnExit) {
            return false;
        }
        if (this.deleteOnFree != other.deleteOnFree) {
            return false;
        }
        if (this.file == null ? other.file != null : !this.file.equals(other.file)) {
            return false;
        }
        return this.readOnly == other.readOnly;
    }

    static {
        Logger.registerClass(FileBucket.class);
    }
}

