/*
 * Decompiled with CFR 0.152.
 */
package freenet.support.io;

import freenet.client.async.ClientContext;
import freenet.support.api.LockableRandomAccessBuffer;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;

public class ByteArrayRandomAccessBuffer
implements LockableRandomAccessBuffer,
Serializable {
    private static final long serialVersionUID = 1L;
    private final byte[] data;
    private boolean readOnly;
    private boolean closed;

    public ByteArrayRandomAccessBuffer(byte[] padded) {
        this.data = padded;
    }

    public ByteArrayRandomAccessBuffer(int size) {
        this.data = new byte[size];
    }

    public ByteArrayRandomAccessBuffer(byte[] initialContents, int offset, int size, boolean readOnly) {
        this.data = Arrays.copyOfRange(initialContents, offset, offset + size);
        this.readOnly = readOnly;
    }

    protected ByteArrayRandomAccessBuffer() {
        this.data = null;
    }

    @Override
    public void close() {
        this.closed = true;
    }

    @Override
    public synchronized void pread(long fileOffset, byte[] buf, int bufOffset, int length) throws IOException {
        if (this.closed) {
            throw new IOException("Closed");
        }
        if (fileOffset < 0L) {
            throw new IllegalArgumentException("Cannot read before zero");
        }
        if (fileOffset + (long)length > (long)this.data.length) {
            throw new IOException("Cannot read after end: trying to read from " + fileOffset + " to " + (fileOffset + (long)length) + " on block length " + this.data.length);
        }
        System.arraycopy(this.data, (int)fileOffset, buf, bufOffset, length);
    }

    @Override
    public synchronized void pwrite(long fileOffset, byte[] buf, int bufOffset, int length) throws IOException {
        if (this.closed) {
            throw new IOException("Closed");
        }
        if (fileOffset < 0L) {
            throw new IllegalArgumentException("Cannot write before zero");
        }
        if (fileOffset + (long)length > (long)this.data.length) {
            throw new IOException("Cannot write after end: trying to write from " + fileOffset + " to " + (fileOffset + (long)length) + " on block length " + this.data.length);
        }
        if (this.readOnly) {
            throw new IOException("Read-only");
        }
        System.arraycopy(buf, bufOffset, this.data, (int)fileOffset, length);
    }

    @Override
    public long size() {
        return this.data.length;
    }

    public synchronized void setReadOnly() {
        this.readOnly = true;
    }

    public synchronized boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public LockableRandomAccessBuffer.RAFLock lockOpen() {
        return new LockableRandomAccessBuffer.RAFLock(){

            @Override
            protected void innerUnlock() {
            }
        };
    }

    @Override
    public void free() {
    }

    byte[] getBuffer() {
        return this.data;
    }

    @Override
    public void onResume(ClientContext context) {
    }

    @Override
    public void storeTo(DataOutputStream dos) {
        throw new UnsupportedOperationException();
    }
}

