/*
 * Decompiled with CFR 0.152.
 */
package freenet.support;

import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;

public class TimeUtil {
    public static final TimeZone TZ_UTC = TimeZone.getTimeZone("UTC");

    public static String formatTime(long timeInterval, int maxTerms, boolean withSecondFractions) {
        if (maxTerms > 6) {
            throw new IllegalArgumentException();
        }
        StringBuilder sb = new StringBuilder(64);
        long l = timeInterval;
        int termCount = 0;
        if (l < 0L) {
            sb.append('-');
            l *= -1L;
        }
        if (!withSecondFractions && l < 1000L) {
            return "0s";
        }
        if (termCount >= maxTerms) {
            return sb.toString();
        }
        long weeks = TimeUnit.DAYS.convert(l, TimeUnit.MILLISECONDS) / 7L;
        if (weeks > 0L) {
            sb.append(weeks).append('w');
            ++termCount;
            l -= TimeUnit.DAYS.toMillis(7L * weeks);
        }
        if (termCount >= maxTerms) {
            return sb.toString();
        }
        long days = TimeUnit.DAYS.convert(l, TimeUnit.MILLISECONDS);
        if (days > 0L) {
            sb.append(days).append('d');
            ++termCount;
            l -= TimeUnit.DAYS.toMillis(days);
        }
        if (termCount >= maxTerms) {
            return sb.toString();
        }
        long hours = TimeUnit.HOURS.convert(l, TimeUnit.MILLISECONDS);
        if (hours > 0L) {
            sb.append(hours).append('h');
            ++termCount;
            l -= TimeUnit.HOURS.toMillis(hours);
        }
        if (termCount >= maxTerms) {
            return sb.toString();
        }
        long minutes = TimeUnit.MINUTES.convert(l, TimeUnit.MILLISECONDS);
        if (minutes > 0L) {
            sb.append(minutes).append('m');
            ++termCount;
            l -= TimeUnit.MINUTES.toMillis(minutes);
        }
        if (termCount >= maxTerms) {
            return sb.toString();
        }
        if (withSecondFractions && maxTerms - termCount >= 2) {
            if (l > 0L) {
                double fractionalSeconds = (double)l / 1000.0;
                DecimalFormat fix3 = new DecimalFormat("0.000");
                sb.append(fix3.format(fractionalSeconds)).append('s');
                ++termCount;
            }
        } else {
            long seconds = TimeUnit.SECONDS.convert(l, TimeUnit.MILLISECONDS);
            if (seconds > 0L) {
                sb.append(seconds).append('s');
                ++termCount;
            }
        }
        return sb.toString();
    }

    public static String formatTime(long timeInterval) {
        return TimeUtil.formatTime(timeInterval, 2, false);
    }

    public static String formatTime(long timeInterval, int maxTerms) {
        return TimeUtil.formatTime(timeInterval, maxTerms, false);
    }

    public static String makeHTTPDate(long time) {
        SimpleDateFormat sdf = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss 'GMT'", Locale.US);
        sdf.setTimeZone(TZ_UTC);
        return sdf.format(new Date(time));
    }

    public static Date setTimeToZero(Date date) {
        GregorianCalendar calendar = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
        calendar.setTimeInMillis(date.getTime());
        calendar.set(calendar.get(1), calendar.get(2), calendar.get(5), 0, 0, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }
}

