/*
 * Decompiled with CFR 0.152.
 */
package freenet.support;

import freenet.node.FSParseException;
import freenet.support.Base64;
import freenet.support.Fields;
import freenet.support.IllegalBase64Exception;
import freenet.support.Logger;
import freenet.support.io.Closer;
import freenet.support.io.LineReader;
import freenet.support.io.Readers;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class SimpleFieldSet {
    private final Map<String, String> values;
    private Map<String, SimpleFieldSet> subsets;
    private String endMarker;
    private final boolean shortLived;
    private final boolean alwaysUseBase64;
    protected String[] header;
    public static final char MULTI_LEVEL_CHAR = '.';
    public static final char MULTI_VALUE_CHAR = ';';
    public static final char KEYVALUE_SEPARATOR_CHAR = '=';
    private static final String[] EMPTY_STRING_ARRAY = new String[0];

    public SimpleFieldSet(boolean shortLived) {
        this(shortLived, false);
    }

    public SimpleFieldSet(boolean shortLived, boolean alwaysUseBase64) {
        this.values = new HashMap<String, String>();
        this.subsets = null;
        this.shortLived = shortLived;
        this.alwaysUseBase64 = alwaysUseBase64;
    }

    public SimpleFieldSet(BufferedReader br, boolean allowMultiple, boolean shortLived) throws IOException {
        this(br, allowMultiple, shortLived, false, false);
    }

    public SimpleFieldSet(BufferedReader br, boolean allowMultiple, boolean shortLived, boolean allowBase64, boolean alwaysBase64) throws IOException {
        this(shortLived, alwaysBase64);
        this.read(Readers.fromBufferedReader(br), allowMultiple, allowBase64);
    }

    public SimpleFieldSet(SimpleFieldSet sfs) {
        this.values = new HashMap<String, String>(sfs.values);
        if (sfs.subsets != null) {
            this.subsets = new HashMap<String, SimpleFieldSet>(sfs.subsets);
        }
        this.shortLived = false;
        this.header = sfs.header;
        this.endMarker = sfs.endMarker;
        this.alwaysUseBase64 = sfs.alwaysUseBase64;
    }

    public SimpleFieldSet(LineReader lis, int maxLineLength, int lineBufferSize, boolean utf8OrIso88591, boolean allowMultiple, boolean shortLived) throws IOException {
        this(lis, maxLineLength, lineBufferSize, utf8OrIso88591, allowMultiple, shortLived, false);
    }

    public SimpleFieldSet(LineReader lis, int maxLineLength, int lineBufferSize, boolean utf8OrIso88591, boolean allowMultiple, boolean shortLived, boolean allowBase64) throws IOException {
        this(shortLived);
        this.read(lis, maxLineLength, lineBufferSize, utf8OrIso88591, allowMultiple, allowBase64);
    }

    public SimpleFieldSet(String content, boolean allowMultiple, boolean shortLived, boolean allowBase64) throws IOException {
        this(shortLived);
        StringReader sr = new StringReader(content);
        BufferedReader br = new BufferedReader(sr);
        this.read(Readers.fromBufferedReader(br), allowMultiple, allowBase64);
    }

    public SimpleFieldSet(String[] content, boolean allowMultiple, boolean shortLived, boolean allowBase64) throws IOException {
        this(shortLived);
        this.read(Readers.fromStringArray(content), allowMultiple, allowBase64);
    }

    private void read(LineReader lr, boolean allowMultiple, boolean allowBase64) throws IOException {
        this.read(lr, Integer.MAX_VALUE, 256, true, allowMultiple, allowBase64);
    }

    private void read(LineReader br, int maxLength, int bufferSize, boolean utfOrIso88591, boolean allowMultiple, boolean allowBase64) throws IOException {
        block10: {
            String line;
            boolean firstLine = true;
            boolean headerSection = true;
            ArrayList<String> headers = new ArrayList<String>();
            while (true) {
                int index;
                if ((line = br.readLine(maxLength, bufferSize, utfOrIso88591)) == null) {
                    if (firstLine) {
                        throw new EOFException();
                    }
                    Logger.error(this, "No end marker");
                    break block10;
                }
                if (line.length() == 0) continue;
                firstLine = false;
                char first = line.charAt(0);
                if (first == '#') {
                    if (!headerSection) continue;
                    headers.add(line.substring(1).trim());
                    continue;
                }
                if (headerSection) {
                    if (headers.size() > 0) {
                        this.header = headers.toArray(new String[headers.size()]);
                    }
                    headerSection = false;
                }
                if ((index = line.indexOf(61)) < 0) break;
                String before = line.substring(0, index).trim();
                String after = line.substring(index + 1);
                if (!after.isEmpty() && after.charAt(0) == '=' && allowBase64) {
                    try {
                        after = after.substring(1);
                        after = after.replaceAll("\\s", "");
                        after = Base64.decodeUTF8(after);
                    }
                    catch (IllegalBase64Exception e) {
                        throw new IOException("Unable to decode UTF8, = should not be allowed as first character of a value");
                    }
                }
                if (!this.shortLived) {
                    after = after.intern();
                }
                this.put(before, after, allowMultiple, false, true);
            }
            this.endMarker = line;
        }
    }

    public synchronized String get(String key) {
        int idx = key.indexOf(46);
        if (idx == -1) {
            return this.values.get(key);
        }
        if (idx == 0) {
            return this.subset("") == null ? null : this.subset("").get(key.substring(1));
        }
        if (this.subsets == null) {
            return null;
        }
        String before = key.substring(0, idx);
        String after = key.substring(idx + 1);
        SimpleFieldSet fs = this.subsets.get(before);
        if (fs == null) {
            return null;
        }
        return fs.get(after);
    }

    public String[] getAll(String key) {
        String k = this.get(key);
        if (k == null) {
            return null;
        }
        return SimpleFieldSet.split(k);
    }

    public String[] getAllEncoded(String key) throws IllegalBase64Exception {
        String k = this.get(key);
        if (k == null) {
            return null;
        }
        String[] ret = SimpleFieldSet.split(k);
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = Base64.decodeUTF8(ret[i]);
        }
        return ret;
    }

    public static String[] split(String string) {
        int emptyAtStart;
        if (string == null) {
            return EMPTY_STRING_ARRAY;
        }
        for (emptyAtStart = 0; emptyAtStart < string.length() && string.charAt(emptyAtStart) == ';'; ++emptyAtStart) {
        }
        if (emptyAtStart == string.length()) {
            String[] ret = new String[string.length()];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = "";
            }
            return ret;
        }
        int emptyAtEnd = 0;
        for (int i = string.length() - 1; i >= 0 && string.charAt(i) == ';'; --i) {
            ++emptyAtEnd;
        }
        string = string.substring(emptyAtStart, string.length() - emptyAtEnd);
        String[] split = string.split(String.valueOf(';'));
        if (emptyAtStart != 0 || emptyAtEnd != 0) {
            String[] ret = new String[emptyAtStart + split.length + emptyAtEnd];
            System.arraycopy(split, 0, ret, emptyAtStart, split.length);
            split = ret;
            for (int i = 0; i < split.length; ++i) {
                if (split[i] != null) continue;
                split[i] = "";
            }
        }
        return split;
    }

    private static String unsplit(String[] strings) {
        if (strings.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (String s : strings) {
            sb.append(s);
            assert (s.indexOf(59) == -1);
            sb.append(';');
        }
        sb.deleteCharAt(sb.length() - 1);
        return sb.toString();
    }

    public void putAllOverwrite(SimpleFieldSet fs) {
        for (Map.Entry<String, String> entry : fs.values.entrySet()) {
            this.values.put(entry.getKey(), entry.getValue());
        }
        if (fs.subsets == null) {
            return;
        }
        if (this.subsets == null) {
            this.subsets = new HashMap<String, SimpleFieldSet>();
        }
        for (Map.Entry<String, Object> entry : fs.subsets.entrySet()) {
            String key = entry.getKey();
            SimpleFieldSet hisFS = (SimpleFieldSet)entry.getValue();
            SimpleFieldSet myFS = this.subsets.get(key);
            if (myFS != null) {
                myFS.putAllOverwrite(hisFS);
                continue;
            }
            this.subsets.put(key, hisFS);
        }
    }

    public void putSingle(String key, String value) {
        if (value == null) {
            return;
        }
        if (!this.shortLived) {
            value = value.intern();
        }
        if (!this.put(key, value, false, false, false)) {
            throw new IllegalStateException("Value already exists: " + value + " but want to set " + key + " to " + value);
        }
    }

    public void putAppend(String key, String value) {
        if (value == null) {
            return;
        }
        if (!this.shortLived) {
            value = value.intern();
        }
        this.put(key, value, true, false, false);
    }

    public void putOverwrite(String key, String value) {
        if (value == null) {
            return;
        }
        if (!this.shortLived) {
            value = value.intern();
        }
        this.put(key, value, false, true, false);
    }

    private synchronized boolean put(String key, String value, boolean allowMultiple, boolean overwrite, boolean fromRead) {
        if (value == null) {
            return true;
        }
        if (!this.alwaysUseBase64 && value.indexOf(10) != -1) {
            throw new IllegalArgumentException("A simplefieldSet can't accept newlines !");
        }
        if (allowMultiple && !fromRead && value.indexOf(59) != -1) {
            throw new IllegalArgumentException("Appending a string to a SimpleFieldSet value should not contain the multi-value char \"" + String.valueOf(';') + "\" but it does: \"" + value + "\" for \"" + key + "\"", new Exception("error"));
        }
        int idx = key.indexOf(46);
        if (idx == -1) {
            if (!this.shortLived) {
                key = key.intern();
            }
            if (overwrite) {
                this.values.put(key, value);
            } else if (this.values.get(key) == null) {
                this.values.put(key, value);
            } else {
                if (!allowMultiple) {
                    return false;
                }
                this.values.put(key, this.values.get(key) + ';' + value);
            }
        } else {
            String before = key.substring(0, idx);
            String after = key.substring(idx + 1);
            SimpleFieldSet fs = null;
            if (this.subsets == null) {
                this.subsets = new HashMap<String, SimpleFieldSet>();
            }
            if ((fs = this.subsets.get(before)) == null) {
                fs = new SimpleFieldSet(this.shortLived, this.alwaysUseBase64);
                if (!this.shortLived) {
                    before = before.intern();
                }
                this.subsets.put(before, fs);
            }
            fs.put(after, value, allowMultiple, overwrite, fromRead);
        }
        return true;
    }

    public void put(String key, int value) {
        this.putSingle(key, Integer.toString(value));
    }

    public void put(String key, long value) {
        this.putSingle(key, Long.toString(value));
    }

    public void put(String key, short value) {
        this.putSingle(key, Short.toString(value));
    }

    public void put(String key, char c) {
        this.putSingle(key, Character.toString(c));
    }

    public void put(String key, boolean b) {
        this.put(key, Boolean.toString(b), false, false, false);
    }

    public void put(String key, double windowSize) {
        this.putSingle(key, Double.toString(windowSize));
    }

    public void put(String key, byte[] bytes) {
        this.putSingle(key, Base64.encode(bytes));
    }

    public void writeTo(Writer w) throws IOException {
        this.writeTo(w, "", false, false);
    }

    synchronized void writeTo(Writer w, String prefix, boolean noEndMarker, boolean useBase64) throws IOException {
        String key;
        this.writeHeader(w);
        for (Map.Entry<String, String> entry : this.values.entrySet()) {
            key = entry.getKey();
            String value = entry.getValue();
            this.writeValue(w, key, value, prefix, useBase64);
        }
        if (this.subsets != null) {
            for (Map.Entry<String, Object> entry : this.subsets.entrySet()) {
                key = entry.getKey();
                SimpleFieldSet subset = (SimpleFieldSet)entry.getValue();
                if (subset == null) {
                    throw new NullPointerException();
                }
                subset.writeTo(w, prefix + key + '.', true, useBase64);
            }
        }
        if (!noEndMarker) {
            if (this.endMarker == null) {
                w.write("End\n");
            } else {
                w.write(this.endMarker);
                w.write(10);
            }
        }
    }

    private void writeValue(Writer w, String key, String value, String prefix, boolean useBase64) throws IOException {
        w.write(prefix);
        w.write(key);
        w.write(61);
        if ((useBase64 || this.alwaysUseBase64) && this.shouldBase64(value)) {
            w.write(61);
            w.write(Base64.encodeUTF8(value));
        } else {
            w.write(value);
        }
        w.write(10);
    }

    private boolean shouldBase64(String value) {
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (c == '=') {
                return true;
            }
            if (c == '.') {
                return true;
            }
            if (c == ';') {
                return true;
            }
            if (Character.isISOControl(c)) {
                return true;
            }
            if (!Character.isWhitespace(c)) continue;
            return true;
        }
        return false;
    }

    public void writeToOrdered(Writer w) throws IOException {
        this.writeToOrdered(w, "", false, false);
    }

    private synchronized void writeToOrdered(Writer w, String prefix, boolean noEndMarker, boolean allowOptionalBase64) throws IOException {
        this.writeHeader(w);
        Object[] keys = this.values.keySet().toArray(new String[this.values.size()]);
        int i = 0;
        Arrays.sort(keys);
        for (i = 0; i < keys.length; ++i) {
            this.writeValue(w, (String)keys[i], this.get((String)keys[i]), prefix, allowOptionalBase64);
        }
        if (this.subsets != null) {
            Object[] orderedPrefixes = this.subsets.keySet().toArray(new String[this.subsets.size()]);
            Arrays.sort(orderedPrefixes);
            for (i = 0; i < orderedPrefixes.length; ++i) {
                SimpleFieldSet subset = this.subset((String)orderedPrefixes[i]);
                if (subset == null) {
                    throw new NullPointerException();
                }
                subset.writeToOrdered(w, prefix + (String)orderedPrefixes[i] + '.', true, allowOptionalBase64);
            }
        }
        if (!noEndMarker) {
            if (this.endMarker == null) {
                w.write("End\n");
            } else {
                w.write(this.endMarker + '\n');
            }
        }
    }

    private void writeHeader(Writer w) throws IOException {
        if (this.header != null) {
            for (String line : this.header) {
                w.write("# " + line + "\n");
            }
        }
    }

    public String toString() {
        StringWriter sw = new StringWriter();
        try {
            this.writeTo(sw);
        }
        catch (IOException e) {
            Logger.error(this, "WTF?!: " + e + " in toString()!", (Throwable)e);
        }
        return sw.toString();
    }

    public String toOrderedString() {
        StringWriter sw = new StringWriter();
        try {
            this.writeToOrdered(sw);
        }
        catch (IOException e) {
            Logger.error(this, "WTF?!: " + e + " in toString()!", (Throwable)e);
        }
        return sw.toString();
    }

    public String toOrderedStringWithBase64() {
        StringWriter sw = new StringWriter();
        try {
            this.writeToOrdered(sw, "", false, true);
        }
        catch (IOException e) {
            Logger.error(this, "WTF?!: " + e + " in toString()!", (Throwable)e);
        }
        return sw.toString();
    }

    public String getEndMarker() {
        return this.endMarker;
    }

    public void setEndMarker(String s) {
        this.endMarker = s;
    }

    public synchronized SimpleFieldSet subset(String key) {
        if (this.subsets == null) {
            return null;
        }
        int idx = key.indexOf(46);
        if (idx == -1) {
            return this.subsets.get(key);
        }
        String before = key.substring(0, idx);
        String after = key.substring(idx + 1);
        SimpleFieldSet fs = this.subsets.get(before);
        if (fs == null) {
            return null;
        }
        return fs.subset(after);
    }

    public synchronized SimpleFieldSet getSubset(String key) throws FSParseException {
        SimpleFieldSet fs = this.subset(key);
        if (fs == null) {
            throw new FSParseException("No such subset " + key);
        }
        return fs;
    }

    public Iterator<String> keyIterator() {
        return new KeyIterator("");
    }

    public KeyIterator keyIterator(String prefix) {
        return new KeyIterator(prefix);
    }

    public Iterator<String> toplevelKeyIterator() {
        return this.values.keySet().iterator();
    }

    public Map<String, String> directKeyValues() {
        return Collections.unmodifiableMap(this.values);
    }

    public Set<String> directKeys() {
        return Collections.unmodifiableSet(this.values.keySet());
    }

    public Map<String, SimpleFieldSet> directSubsets() {
        return Collections.unmodifiableMap(this.subsets);
    }

    public void tput(String key, SimpleFieldSet fs) {
        if (fs == null || fs.isEmpty()) {
            return;
        }
        this.put(key, fs);
    }

    public void put(String key, SimpleFieldSet fs) {
        if (fs == null) {
            return;
        }
        if (fs.isEmpty()) {
            throw new IllegalArgumentException("Empty");
        }
        if (this.subsets == null) {
            this.subsets = new HashMap<String, SimpleFieldSet>();
        }
        if (this.subsets.containsKey(key)) {
            throw new IllegalArgumentException("Already contains " + key + " but trying to add a SimpleFieldSet!");
        }
        if (!this.shortLived) {
            key = key.intern();
        }
        this.subsets.put(key, fs);
    }

    public synchronized void removeValue(String key) {
        int idx = key.indexOf(46);
        if (idx == -1) {
            this.values.remove(key);
        } else {
            if (this.subsets == null) {
                return;
            }
            String before = key.substring(0, idx);
            String after = key.substring(idx + 1);
            SimpleFieldSet fs = this.subsets.get(before);
            if (fs == null) {
                return;
            }
            fs.removeValue(after);
            if (fs.isEmpty()) {
                this.subsets.remove(before);
                if (this.subsets.isEmpty()) {
                    this.subsets = null;
                }
            }
        }
    }

    public synchronized void removeSubset(String key) {
        if (this.subsets == null) {
            return;
        }
        int idx = key.indexOf(46);
        if (idx == -1) {
            this.subsets.remove(key);
        } else {
            String before = key.substring(0, idx);
            String after = key.substring(idx + 1);
            SimpleFieldSet fs = this.subsets.get(before);
            if (fs == null) {
                return;
            }
            fs.removeSubset(after);
            if (fs.isEmpty()) {
                this.subsets.remove(before);
                if (this.subsets.isEmpty()) {
                    this.subsets = null;
                }
            }
        }
    }

    public synchronized boolean isEmpty() {
        return this.values.isEmpty() && (this.subsets == null || this.subsets.isEmpty());
    }

    public Iterator<String> directSubsetNameIterator() {
        return this.subsets == null ? null : this.subsets.keySet().iterator();
    }

    public String[] namesOfDirectSubsets() {
        return this.subsets == null ? EMPTY_STRING_ARRAY : this.subsets.keySet().toArray(new String[this.subsets.size()]);
    }

    public static SimpleFieldSet readFrom(InputStream is, boolean allowMultiple, boolean shortLived) throws IOException {
        return SimpleFieldSet.readFrom(is, allowMultiple, shortLived, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SimpleFieldSet readFrom(InputStream is, boolean allowMultiple, boolean shortLived, boolean allowBase64, boolean alwaysBase64) throws IOException {
        SimpleFieldSet simpleFieldSet;
        BufferedInputStream bis = null;
        InputStreamReader isr = null;
        BufferedReader br = null;
        try {
            bis = new BufferedInputStream(is);
            try {
                isr = new InputStreamReader((InputStream)bis, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                Logger.error(SimpleFieldSet.class, "Impossible: " + e, (Throwable)e);
                is.close();
                throw new Error("Impossible: JVM doesn't support UTF-8: " + e, e);
            }
            br = new BufferedReader(isr);
            SimpleFieldSet fs = new SimpleFieldSet(br, allowMultiple, shortLived, allowBase64, alwaysBase64);
            br.close();
            simpleFieldSet = fs;
        }
        catch (Throwable throwable) {
            Closer.close(br);
            Closer.close(isr);
            Closer.close(bis);
            throw throwable;
        }
        Closer.close(br);
        Closer.close(isr);
        Closer.close(bis);
        return simpleFieldSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SimpleFieldSet readFrom(File f, boolean allowMultiple, boolean shortLived) throws IOException {
        try (FileInputStream fis = new FileInputStream(f);){
            SimpleFieldSet simpleFieldSet = SimpleFieldSet.readFrom(fis, allowMultiple, shortLived);
            return simpleFieldSet;
        }
    }

    public void writeTo(OutputStream os) throws IOException {
        this.writeTo(os, 4096);
    }

    public void writeToBigBuffer(OutputStream os) throws IOException {
        this.writeTo(os, 65536);
    }

    public void writeTo(OutputStream os, int bufferSize) throws IOException {
        BufferedOutputStream bos = null;
        OutputStreamWriter osw = null;
        BufferedWriter bw = null;
        bos = new BufferedOutputStream(os, bufferSize);
        try {
            osw = new OutputStreamWriter((OutputStream)bos, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            Logger.error(SimpleFieldSet.class, "Impossible: " + e, (Throwable)e);
            throw e;
        }
        bw = new BufferedWriter(osw);
        this.writeTo(bw);
        bw.flush();
    }

    public int getInt(String key, int def) {
        String s = this.get(key);
        if (s == null) {
            return def;
        }
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            return def;
        }
    }

    public int getInt(String key) throws FSParseException {
        String s = this.get(key);
        if (s == null) {
            throw new FSParseException("No key " + key);
        }
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            throw new FSParseException("Cannot parse " + s + " for integer " + key);
        }
    }

    public double getDouble(String key, double def) {
        String s = this.get(key);
        if (s == null) {
            return def;
        }
        try {
            return Double.parseDouble(s);
        }
        catch (NumberFormatException e) {
            return def;
        }
    }

    public double getDouble(String key) throws FSParseException {
        String s = this.get(key);
        if (s == null) {
            throw new FSParseException("No key " + key);
        }
        try {
            return Double.parseDouble(s);
        }
        catch (NumberFormatException e) {
            throw new FSParseException("Cannot parse " + s + " for integer " + key);
        }
    }

    public long getLong(String key, long def) {
        String s = this.get(key);
        if (s == null) {
            return def;
        }
        try {
            return Long.parseLong(s);
        }
        catch (NumberFormatException e) {
            return def;
        }
    }

    public long getLong(String key) throws FSParseException {
        String s = this.get(key);
        if (s == null) {
            throw new FSParseException("No key " + key);
        }
        try {
            return Long.parseLong(s);
        }
        catch (NumberFormatException e) {
            throw new FSParseException("Cannot parse " + s + " for long " + key);
        }
    }

    public short getShort(String key) throws FSParseException {
        String s = this.get(key);
        if (s == null) {
            throw new FSParseException("No key " + key);
        }
        try {
            return Short.parseShort(s);
        }
        catch (NumberFormatException e) {
            throw new FSParseException("Cannot parse " + s + " for short " + key);
        }
    }

    public short getShort(String key, short def) {
        String s = this.get(key);
        if (s == null) {
            return def;
        }
        try {
            return Short.parseShort(s);
        }
        catch (NumberFormatException e) {
            return def;
        }
    }

    public byte getByte(String key) throws FSParseException {
        String s = this.get(key);
        if (s == null) {
            throw new FSParseException("No key " + key);
        }
        try {
            return Byte.parseByte(s);
        }
        catch (NumberFormatException e) {
            throw new FSParseException("Cannot parse \"" + s + "\" as a byte.");
        }
    }

    public byte getByte(String key, byte def) {
        try {
            return this.getByte(key);
        }
        catch (FSParseException e) {
            return def;
        }
    }

    public byte[] getByteArray(String key) throws FSParseException {
        String s = this.get(key);
        if (s == null) {
            throw new FSParseException("No key " + key);
        }
        try {
            return Base64.decode(s);
        }
        catch (IllegalBase64Exception e) {
            throw new FSParseException("Cannot parse value \"" + s + "\" as a byte[]");
        }
    }

    public char getChar(String key) throws FSParseException {
        String s = this.get(key);
        if (s == null) {
            throw new FSParseException("No key " + key);
        }
        if (s.length() == 1) {
            return s.charAt(0);
        }
        throw new FSParseException("Cannot parse " + s + " for char " + key);
    }

    public char getChar(String key, char def) {
        String s = this.get(key);
        if (s == null) {
            return def;
        }
        if (s.length() == 1) {
            return s.charAt(0);
        }
        return def;
    }

    public boolean getBoolean(String key, boolean def) {
        return Fields.stringToBool(this.get(key), def);
    }

    public boolean getBoolean(String key) throws FSParseException {
        try {
            return Fields.stringToBool(this.get(key));
        }
        catch (NumberFormatException e) {
            throw new FSParseException(e);
        }
    }

    public void put(String key, int[] value) {
        this.removeValue(key);
        for (int v : value) {
            this.putAppend(key, String.valueOf(v));
        }
    }

    public void put(String key, double[] value) {
        this.removeValue(key);
        for (double v : value) {
            this.putAppend(key, String.valueOf(v));
        }
    }

    public void put(String key, float[] value) {
        this.removeValue(key);
        for (float v : value) {
            this.putAppend(key, String.valueOf(v));
        }
    }

    public void put(String key, short[] value) {
        this.removeValue(key);
        for (short v : value) {
            this.putAppend(key, String.valueOf(v));
        }
    }

    public void put(String key, long[] value) {
        this.removeValue(key);
        for (long v : value) {
            this.putAppend(key, String.valueOf(v));
        }
    }

    public void put(String key, boolean[] value) {
        this.removeValue(key);
        for (boolean v : value) {
            this.putAppend(key, String.valueOf(v));
        }
    }

    public int[] getIntArray(String key) {
        String[] strings = this.getAll(key);
        if (strings == null) {
            return null;
        }
        int[] ret = new int[strings.length];
        for (int i = 0; i < strings.length; ++i) {
            try {
                ret[i] = Integer.parseInt(strings[i]);
                continue;
            }
            catch (NumberFormatException e) {
                Logger.error(this, "Cannot parse " + strings[i] + " : " + e, (Throwable)e);
                return null;
            }
        }
        return ret;
    }

    public short[] getShortArray(String key) {
        String[] strings = this.getAll(key);
        if (strings == null) {
            return null;
        }
        short[] ret = new short[strings.length];
        for (int i = 0; i < strings.length; ++i) {
            try {
                ret[i] = Short.parseShort(strings[i]);
                continue;
            }
            catch (NumberFormatException e) {
                Logger.error(this, "Cannot parse " + strings[i] + " : " + e, (Throwable)e);
                return null;
            }
        }
        return ret;
    }

    public long[] getLongArray(String key) {
        String[] strings = this.getAll(key);
        if (strings == null) {
            return null;
        }
        long[] ret = new long[strings.length];
        for (int i = 0; i < strings.length; ++i) {
            try {
                ret[i] = Long.parseLong(strings[i]);
                continue;
            }
            catch (NumberFormatException e) {
                Logger.error(this, "Cannot parse " + strings[i] + " : " + e, (Throwable)e);
                return null;
            }
        }
        return ret;
    }

    public double[] getDoubleArray(String key) {
        String[] strings = this.getAll(key);
        if (strings == null) {
            return null;
        }
        double[] ret = new double[strings.length];
        for (int i = 0; i < strings.length; ++i) {
            try {
                ret[i] = Double.valueOf(strings[i]);
                continue;
            }
            catch (NumberFormatException e) {
                Logger.error(this, "Cannot parse " + strings[i] + " : " + e, (Throwable)e);
                return null;
            }
        }
        return ret;
    }

    public float[] getFloatArray(String key) {
        String[] strings = this.getAll(key);
        if (strings == null) {
            return null;
        }
        float[] ret = new float[strings.length];
        for (int i = 0; i < strings.length; ++i) {
            try {
                ret[i] = Float.valueOf(strings[i]).floatValue();
                continue;
            }
            catch (NumberFormatException e) {
                Logger.error(this, "Cannot parse " + strings[i] + " : " + e, (Throwable)e);
                return null;
            }
        }
        return ret;
    }

    public boolean[] getBooleanArray(String key) {
        String[] strings = this.getAll(key);
        if (strings == null) {
            return null;
        }
        boolean[] ret = new boolean[strings.length];
        for (int i = 0; i < strings.length; ++i) {
            try {
                ret[i] = Boolean.valueOf(strings[i]);
                continue;
            }
            catch (NumberFormatException e) {
                Logger.error(this, "Cannot parse " + strings[i] + " : " + e, (Throwable)e);
                return null;
            }
        }
        return ret;
    }

    public void putOverwrite(String key, String[] strings) {
        this.putOverwrite(key, SimpleFieldSet.unsplit(strings));
    }

    public void putEncoded(String key, String[] strings) {
        String[] copy = Arrays.copyOf(strings, strings.length);
        for (int i = 0; i < copy.length; ++i) {
            copy[i] = Base64.encodeUTF8(strings[i]);
        }
        this.putSingle(key, SimpleFieldSet.unsplit(copy));
    }

    public String getString(String key) throws FSParseException {
        String s = this.get(key);
        if (s == null) {
            throw new FSParseException("No such element " + key);
        }
        return s;
    }

    public void setHeader(String ... headers) {
        this.header = headers;
    }

    public String[] getHeader() {
        return this.header;
    }

    public void put(String key, String[] values) {
        this.putSingle(key, SimpleFieldSet.unsplit(values));
    }

    public class KeyIterator
    implements Iterator<String> {
        final Iterator<String> valuesIterator;
        final Iterator<String> subsetIterator;
        KeyIterator subIterator;
        String prefix;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public KeyIterator(String prefix) {
            SimpleFieldSet simpleFieldSet2 = SimpleFieldSet.this;
            synchronized (simpleFieldSet2) {
                this.valuesIterator = SimpleFieldSet.this.values.keySet().iterator();
                this.subsetIterator = SimpleFieldSet.this.subsets != null ? SimpleFieldSet.this.subsets.keySet().iterator() : null;
                while ((this.valuesIterator == null || !this.valuesIterator.hasNext()) && this.subsetIterator != null && this.subsetIterator.hasNext()) {
                    SimpleFieldSet fs;
                    String name = this.subsetIterator.next();
                    if (name == null || (fs = (SimpleFieldSet)SimpleFieldSet.this.subsets.get(name)) == null) continue;
                    String newPrefix = prefix + name + '.';
                    this.subIterator = fs.keyIterator(newPrefix);
                    if (this.subIterator.hasNext()) break;
                    this.subIterator = null;
                }
                this.prefix = prefix;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean hasNext() {
            SimpleFieldSet simpleFieldSet = SimpleFieldSet.this;
            synchronized (simpleFieldSet) {
                while (true) {
                    if (this.valuesIterator.hasNext()) {
                        return true;
                    }
                    if (this.subIterator != null && this.subIterator.hasNext()) {
                        return true;
                    }
                    if (this.subIterator != null) {
                        this.subIterator = null;
                    }
                    if (this.subsetIterator == null || !this.subsetIterator.hasNext()) break;
                    String key = this.subsetIterator.next();
                    SimpleFieldSet fs = (SimpleFieldSet)SimpleFieldSet.this.subsets.get(key);
                    String newPrefix = this.prefix + key + '.';
                    this.subIterator = fs.keyIterator(newPrefix);
                }
                return false;
            }
        }

        @Override
        public final String next() {
            return this.nextKey();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String nextKey() {
            SimpleFieldSet simpleFieldSet = SimpleFieldSet.this;
            synchronized (simpleFieldSet) {
                String ret = null;
                if (this.valuesIterator != null && this.valuesIterator.hasNext()) {
                    return this.prefix + this.valuesIterator.next();
                }
                while (true) {
                    if (this.subIterator != null && this.subIterator.hasNext()) {
                        if (ret != null) {
                            return ret;
                        }
                        ret = this.subIterator.next();
                        if (this.subIterator.hasNext() && ret != null) {
                            return ret;
                        }
                    }
                    this.subIterator = null;
                    if (this.subsetIterator == null || !this.subsetIterator.hasNext()) break;
                    String key = this.subsetIterator.next();
                    SimpleFieldSet fs = (SimpleFieldSet)SimpleFieldSet.this.subsets.get(key);
                    String newPrefix = this.prefix + key + '.';
                    this.subIterator = fs.keyIterator(newPrefix);
                }
                if (ret == null) {
                    throw new NoSuchElementException();
                }
                return ret;
            }
        }

        @Override
        public synchronized void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

