/*
 * Decompiled with CFR 0.152.
 */
package freenet.support;

import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.concurrent.CopyOnWriteArrayList;

public abstract class LoggerHook
extends Logger {
    protected Logger.LogLevel threshold;
    public DetailedThreshold[] detailedThresholds = new DetailedThreshold[0];
    private CopyOnWriteArrayList<LogThresholdCallback> thresholdsCallbacks = new CopyOnWriteArrayList();

    protected LoggerHook(Logger.LogLevel thresh) {
        this.threshold = thresh;
    }

    LoggerHook(String thresh) throws InvalidThresholdException {
        this.threshold = this.parseThreshold(thresh.toUpperCase());
    }

    @Override
    public abstract void log(Object var1, Class<?> var2, String var3, Throwable var4, Logger.LogLevel var5);

    @Override
    public void log(Object source, String message, Logger.LogLevel priority) {
        if (!this.instanceShouldLog(priority, source)) {
            return;
        }
        this.log(source, source == null ? null : source.getClass(), message, null, priority);
    }

    @Override
    public void log(Object o, String message, Throwable e, Logger.LogLevel priority) {
        if (!this.instanceShouldLog(priority, o)) {
            return;
        }
        this.log(o, o == null ? null : o.getClass(), message, e, priority);
    }

    @Override
    public void log(Class<?> c, String message, Logger.LogLevel priority) {
        if (!this.instanceShouldLog(priority, c)) {
            return;
        }
        this.log(null, c, message, null, priority);
    }

    @Override
    public void log(Class<?> c, String message, Throwable e, Logger.LogLevel priority) {
        if (!this.instanceShouldLog(priority, c)) {
            return;
        }
        this.log(null, c, message, e, priority);
    }

    public boolean acceptPriority(Logger.LogLevel prio) {
        return prio.matchesThreshold(this.threshold);
    }

    @Override
    public void setThreshold(Logger.LogLevel thresh) {
        this.threshold = thresh;
        this.notifyLogThresholdCallbacks();
    }

    @Override
    public Logger.LogLevel getThresholdNew() {
        return this.threshold;
    }

    private Logger.LogLevel parseThreshold(String threshold) throws InvalidThresholdException {
        if (threshold == null) {
            throw new InvalidThresholdException(threshold);
        }
        try {
            return Logger.LogLevel.valueOf(threshold.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new InvalidThresholdException(threshold);
        }
    }

    @Override
    public void setThreshold(String symbolicThreshold) throws InvalidThresholdException {
        this.setThreshold(this.parseThreshold(symbolicThreshold));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDetailedThresholds(String details) throws InvalidThresholdException {
        if (details == null) {
            return;
        }
        StringTokenizer st = new StringTokenizer(details, ",", false);
        ArrayList<DetailedThreshold> stuff = new ArrayList<DetailedThreshold>();
        while (st.hasMoreTokens()) {
            int x;
            String token = st.nextToken();
            if (token.length() == 0 || (x = token.indexOf(58)) < 0 || x == token.length() - 1) continue;
            String section = token.substring(0, x);
            String value = token.substring(x + 1, token.length());
            stuff.add(new DetailedThreshold(section, this.parseThreshold(value.toUpperCase())));
        }
        DetailedThreshold[] newThresholds = new DetailedThreshold[stuff.size()];
        stuff.toArray(newThresholds);
        LoggerHook loggerHook = this;
        synchronized (loggerHook) {
            this.detailedThresholds = newThresholds;
        }
        this.notifyLogThresholdCallbacks();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDetailedThresholds() {
        DetailedThreshold[] thresh = null;
        LoggerHook loggerHook = this;
        synchronized (loggerHook) {
            thresh = this.detailedThresholds;
        }
        if (thresh.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (DetailedThreshold t : thresh) {
            sb.append(t.section);
            sb.append(':');
            sb.append((Object)t.dThreshold);
            sb.append(',');
        }
        sb.deleteCharAt(sb.length() - 1);
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean instanceShouldLog(Logger.LogLevel priority, Class<?> c) {
        Logger.LogLevel thresh;
        DetailedThreshold[] thresholds;
        LoggerHook loggerHook = this;
        synchronized (loggerHook) {
            thresholds = this.detailedThresholds;
            thresh = this.threshold;
        }
        if (c != null && thresholds.length > 0) {
            String cname = c.getName();
            for (DetailedThreshold dt : thresholds) {
                if (!cname.startsWith(dt.section)) continue;
                thresh = dt.dThreshold;
            }
        }
        return priority.matchesThreshold(thresh);
    }

    @Override
    public final boolean instanceShouldLog(Logger.LogLevel prio, Object o) {
        return this.instanceShouldLog(prio, o == null ? null : o.getClass());
    }

    @Override
    public final void instanceRegisterLogThresholdCallback(LogThresholdCallback ltc) {
        this.thresholdsCallbacks.add(ltc);
        ltc.shouldUpdate();
    }

    @Override
    public final void instanceUnregisterLogThresholdCallback(LogThresholdCallback ltc) {
        this.thresholdsCallbacks.remove(ltc);
    }

    private void notifyLogThresholdCallbacks() {
        for (LogThresholdCallback ltc : this.thresholdsCallbacks) {
            ltc.shouldUpdate();
        }
    }

    public static class InvalidThresholdException
    extends Exception {
        private static final long serialVersionUID = -1L;

        InvalidThresholdException(String msg) {
            super(msg);
        }
    }

    public static final class DetailedThreshold {
        final String section;
        final Logger.LogLevel dThreshold;

        public DetailedThreshold(String section, Logger.LogLevel thresh) {
            this.section = section;
            this.dThreshold = thresh;
        }
    }
}

