/*
 * Decompiled with CFR 0.152.
 */
package freenet.store.saltedhash;

import freenet.support.Logger;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class LockManager {
    private static boolean logDEBUG;
    private volatile boolean shutdown;
    private Lock entryLock = new ReentrantLock();
    private Map<Long, Condition> lockMap = new HashMap<Long, Condition>();

    LockManager() {
        logDEBUG = Logger.shouldLog(Logger.LogLevel.DEBUG, (Object)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    Condition lockEntry(long offset) {
        Condition condition;
        if (logDEBUG) {
            Logger.debug(this, "try locking " + offset, (Throwable)new Exception());
        }
        try {
            this.entryLock.lock();
            try {
                while (true) {
                    if (this.shutdown) {
                        Condition condition2 = null;
                        return condition2;
                    }
                    Condition lockCond = this.lockMap.get(offset);
                    if (lockCond == null) break;
                    lockCond.await(10L, TimeUnit.SECONDS);
                }
                condition = this.entryLock.newCondition();
                this.lockMap.put(offset, condition);
            }
            finally {
                this.entryLock.unlock();
            }
        }
        catch (InterruptedException e) {
            Logger.error(this, "lock interrupted", (Throwable)e);
            return null;
        }
        if (!logDEBUG) return condition;
        Logger.debug(this, "locked " + offset, (Throwable)new Exception());
        return condition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unlockEntry(long offset, Condition condition) {
        if (logDEBUG) {
            Logger.debug(this, "unlocking " + offset, (Throwable)new Exception("debug"));
        }
        this.entryLock.lock();
        try {
            Condition cond = this.lockMap.remove(offset);
            assert (cond == condition);
            cond.signal();
        }
        finally {
            this.entryLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void shutdown() {
        this.shutdown = true;
        this.entryLock.lock();
        try {
            while (!this.lockMap.isEmpty()) {
                Condition cond = this.lockMap.values().iterator().next();
                cond.awaitUninterruptibly();
            }
        }
        finally {
            this.entryLock.unlock();
        }
    }
}

