/*
 * Decompiled with CFR 0.152.
 */
package freenet.node.useralerts;

import freenet.l10n.NodeL10n;
import freenet.node.NodeStats;
import freenet.node.updater.NodeUpdateManager;
import freenet.node.useralerts.AbstractUserAlert;
import freenet.support.HTMLNode;
import java.util.concurrent.TimeUnit;

public class PeerManagerUserAlert
extends AbstractUserAlert {
    final NodeStats n;
    final NodeUpdateManager nodeUpdater;
    public int conns = 0;
    public int peers = 0;
    public int neverConn = 0;
    public int clockProblem = 0;
    public int connError = 0;
    public int disconnDarknetPeers = 0;
    int bwlimitDelayTime = 1;
    int nodeAveragePingTime = 1;
    long oldestNeverConnectedPeerAge = 0L;
    private boolean bwlimitDelayAlertRelevant;
    private boolean nodeAveragePingAlertRelevant;
    public int darknetConns = 0;
    public int darknetPeers = 0;
    public int tooNewPeersDarknet = 0;
    public int tooNewPeersTotal = 0;
    public boolean isOpennetEnabled;
    public boolean darknetDefinitelyPortForwarded;
    public boolean opennetDefinitelyPortForwarded;
    public boolean opennetAssumeNAT;
    public boolean darknetAssumeNAT;
    private boolean isOutdated;
    public static final int MIN_CONN_ALERT_THRESHOLD = 3;
    public static final int MAX_DARKNET_CONN_ALERT_THRESHOLD = 100;
    public static final int MAX_DISCONN_PEER_ALERT_THRESHOLD = 50;
    public static final int MAX_NEVER_CONNECTED_PEER_ALERT_THRESHOLD = 5;
    public static final int MIN_CLOCK_PROBLEM_PEER_ALERT_THRESHOLD = 5;
    public static final int MIN_CONN_ERROR_ALERT_THRESHOLD = 5;
    public static final long MAX_OLDEST_NEVER_CONNECTED_PEER_AGE_ALERT_THRESHOLD = TimeUnit.DAYS.toMillis(14L);

    public PeerManagerUserAlert(NodeStats n, NodeUpdateManager nodeUpdater) {
        super(false, null, null, null, null, (short)0, true, NodeL10n.getBase().getString("UserAlert.hide"), false, null);
        this.n = n;
        this.nodeUpdater = nodeUpdater;
    }

    @Override
    public String getTitle() {
        PeerManagerUserAlert peerManagerUserAlert = this;
        synchronized (peerManagerUserAlert) {
            if (this.isOutdated) {
                return this.l10n("outdatedUpdateTitle");
            }
            if (!this.isOpennetEnabled) {
                if (this.peers == 0) {
                    return this.l10n("noPeersTitle");
                }
                if (this.conns == 0) {
                    return this.l10n("noConnsTitle");
                }
                if (this.conns < 3) {
                    return this.l10n("onlyFewConnsTitle", "count", Integer.toString(this.conns));
                }
            }
            if (this.bwlimitDelayAlertRelevant && (long)this.bwlimitDelayTime > NodeStats.MAX_BWLIMIT_DELAY_TIME_ALERT_THRESHOLD) {
                return this.l10n("tooHighBwlimitDelayTimeTitle");
            }
            if (this.nodeAveragePingAlertRelevant && (long)this.nodeAveragePingTime > NodeStats.MAX_NODE_AVERAGE_PING_TIME_ALERT_THRESHOLD) {
                return this.l10n("tooHighPingTimeTitle");
            }
            if (this.clockProblem > 5) {
                return this.l10n("clockProblemTitle");
            }
            if (this.neverConn > 5) {
                return this.l10n("tooManyNeverConnectedTitle");
            }
            if (this.connError > 5) {
                return this.l10n("connErrorTitle");
            }
            if (this.disconnDarknetPeers > 50 && !this.darknetDefinitelyPortForwarded && !this.darknetAssumeNAT) {
                return this.l10n("tooManyDisconnectedTitle");
            }
            if (this.darknetConns > 100) {
                return this.l10n("tooManyConnsTitle");
            }
            if (this.oldestNeverConnectedPeerAge > MAX_OLDEST_NEVER_CONNECTED_PEER_AGE_ALERT_THRESHOLD) {
                return this.l10n("tooOldNeverConnectedPeersTitle");
            }
            throw new IllegalArgumentException("Not valid");
        }
    }

    @Override
    public String getShortText() {
        return this.getTitle();
    }

    private String l10n(String key, String pattern, String value) {
        return NodeL10n.getBase().getString("PeerManagerUserAlert." + key, pattern, value);
    }

    private String l10n(String key, String[] pattern, String[] value) {
        return NodeL10n.getBase().getString("PeerManagerUserAlert." + key, pattern, value);
    }

    private String l10n(String key) {
        return NodeL10n.getBase().getString("PeerManagerUserAlert." + key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getText() {
        PeerManagerUserAlert peerManagerUserAlert = this;
        synchronized (peerManagerUserAlert) {
            String s;
            if (this.isOutdated) {
                return this.l10n("outdatedUpdate");
            }
            if (this.peers == 0 && !this.isOpennetEnabled) {
                return this.l10n("noPeersDarknet");
            }
            if (this.conns < 3 && this.clockProblem > 5) {
                s = this.l10n("clockProblem", "count", Integer.toString(this.clockProblem));
            } else if (this.conns < 3 && this.connError > 5 && !this.isOpennetEnabled) {
                s = this.l10n("connError", "count", Integer.toString(this.connError));
            } else {
                if (this.conns == 0 && !this.isOpennetEnabled) {
                    return this.l10n("noConns");
                }
                if (this.conns == 1 && !this.isOpennetEnabled) {
                    return this.l10n("oneConn");
                }
                if (this.conns == 2 && !this.isOpennetEnabled) {
                    return this.l10n("twoConns");
                }
                if (this.bwlimitDelayAlertRelevant && (long)this.bwlimitDelayTime > NodeStats.MAX_BWLIMIT_DELAY_TIME_ALERT_THRESHOLD) {
                    s = this.l10n("tooHighBwlimitDelayTime", new String[]{"delay", "max"}, new String[]{Integer.toString(this.bwlimitDelayTime), Long.toString(NodeStats.MAX_BWLIMIT_DELAY_TIME_ALERT_THRESHOLD)});
                } else if (this.nodeAveragePingAlertRelevant && (long)this.nodeAveragePingTime > NodeStats.MAX_NODE_AVERAGE_PING_TIME_ALERT_THRESHOLD) {
                    s = this.l10n("tooHighPingTime", new String[]{"ping", "max"}, new String[]{Integer.toString(this.nodeAveragePingTime), Long.toString(NodeStats.MAX_NODE_AVERAGE_PING_TIME_ALERT_THRESHOLD)});
                } else if (this.clockProblem > 5) {
                    s = this.l10n("clockProblem", "count", Integer.toString(this.clockProblem));
                } else if (this.neverConn > 5) {
                    s = this.l10n("tooManyNeverConnected", "count", Integer.toString(this.neverConn));
                } else if (this.connError > 5) {
                    s = this.l10n("connError", "count", Integer.toString(this.connError));
                } else if (this.disconnDarknetPeers > 50 && !this.darknetDefinitelyPortForwarded && !this.darknetAssumeNAT) {
                    s = this.l10n("tooManyDisconnected", new String[]{"count", "max"}, new String[]{Integer.toString(this.disconnDarknetPeers), Integer.toString(50)});
                } else if (this.darknetConns > 100) {
                    s = this.l10n("tooManyConns", new String[]{"count", "max"}, new String[]{Integer.toString(this.conns), Integer.toString(100)});
                } else {
                    if (this.oldestNeverConnectedPeerAge > MAX_OLDEST_NEVER_CONNECTED_PEER_AGE_ALERT_THRESHOLD) {
                        return this.l10n("tooOldNeverConnectedPeers");
                    }
                    throw new IllegalArgumentException("Not valid");
                }
            }
            return s;
        }
    }

    public static String replace(String text, String find, String replace) {
        return PeerManagerUserAlert.replaceCareful(text, find, replace);
    }

    public static String replaceAll(String text, String find, String replace) {
        int i;
        while ((i = text.indexOf(find)) >= 0) {
            text = text.substring(0, i) + replace + text.substring(i + find.length());
        }
        return text;
    }

    public static String replaceCareful(String text, String find, String replace) {
        String[] split = text.split(find, -1);
        StringBuilder sb = new StringBuilder(text.length() + (split.length - 1) * (replace.length() - find.length()));
        for (int i = 0; i < split.length; ++i) {
            sb.append(split[i]);
            if (i >= split.length - 1) continue;
            sb.append(replace);
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HTMLNode getHTMLText() {
        HTMLNode alertNode = new HTMLNode("div");
        PeerManagerUserAlert peerManagerUserAlert = this;
        synchronized (peerManagerUserAlert) {
            if (this.isOutdated) {
                alertNode.addChild("#", this.l10n("outdatedUpdate"));
            } else if (this.peers == 0 && !this.isOpennetEnabled) {
                alertNode.addChild("#", this.l10n("noPeersDarknet"));
            } else if (this.conns < 3 && this.clockProblem > 5) {
                alertNode.addChild("#", this.l10n("clockProblem", "count", Integer.toString(this.clockProblem)));
            } else if (this.conns < 3 && this.connError > 5) {
                alertNode.addChild("#", this.l10n("connError", "count", Integer.toString(this.connError)));
            } else if (this.conns == 0 && !this.isOpennetEnabled) {
                alertNode.addChild("#", this.l10n("noConns"));
            } else if (this.conns == 1 && !this.isOpennetEnabled) {
                alertNode.addChild("#", this.l10n("oneConn"));
            } else if (this.conns == 2 && !this.isOpennetEnabled) {
                alertNode.addChild("#", this.l10n("twoConns"));
            } else if (this.bwlimitDelayAlertRelevant && (long)this.bwlimitDelayTime > NodeStats.MAX_BWLIMIT_DELAY_TIME_ALERT_THRESHOLD) {
                alertNode.addChild("#", this.l10n("tooHighBwlimitDelayTime", new String[]{"delay", "max"}, new String[]{Integer.toString(this.bwlimitDelayTime), Long.toString(NodeStats.MAX_BWLIMIT_DELAY_TIME_ALERT_THRESHOLD)}));
            } else if (this.nodeAveragePingAlertRelevant && (long)this.nodeAveragePingTime > NodeStats.MAX_NODE_AVERAGE_PING_TIME_ALERT_THRESHOLD) {
                alertNode.addChild("#", this.l10n("tooHighPingTime", new String[]{"ping", "max"}, new String[]{Integer.toString(this.nodeAveragePingTime), Long.toString(NodeStats.MAX_NODE_AVERAGE_PING_TIME_ALERT_THRESHOLD)}));
            } else if (this.clockProblem > 5) {
                alertNode.addChild("#", this.l10n("clockProblem", "count", Integer.toString(this.clockProblem)));
            } else if (this.neverConn > 5) {
                NodeL10n.getBase().addL10nSubstitution(alertNode, "PeerManagerUserAlert.tooManyNeverConnectedWithLink", new String[]{"link", "count"}, new HTMLNode[]{HTMLNode.link("/friends/myref.fref"), HTMLNode.text(this.neverConn)});
            } else if (this.connError > 5) {
                alertNode.addChild("#", this.l10n("connError", "count", Integer.toString(this.connError)));
            } else if (this.disconnDarknetPeers > 50 && !this.darknetDefinitelyPortForwarded && !this.darknetAssumeNAT) {
                alertNode.addChild("#", this.l10n("tooManyDisconnected", new String[]{"count", "max"}, new String[]{Integer.toString(this.disconnDarknetPeers), Integer.toString(50)}));
            } else if (this.darknetConns > 100) {
                alertNode.addChild("#", this.l10n("tooManyConns", new String[]{"count", "max"}, new String[]{Integer.toString(this.conns), Integer.toString(100)}));
            } else if (this.oldestNeverConnectedPeerAge > MAX_OLDEST_NEVER_CONNECTED_PEER_AGE_ALERT_THRESHOLD) {
                alertNode.addChild("#", this.l10n("tooOldNeverConnectedPeers"));
            } else {
                throw new IllegalArgumentException("not valid");
            }
        }
        return alertNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean calculateIsOutdated() {
        if (this.nodeUpdater.isEnabled()) {
            return false;
        }
        if (this.nodeUpdater.isBlown()) {
            return false;
        }
        PeerManagerUserAlert peerManagerUserAlert = this;
        synchronized (peerManagerUserAlert) {
            if (this.tooNewPeersDarknet >= 1) {
                return true;
            }
            return this.conns < 5 && this.tooNewPeersTotal >= 5;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public short getPriorityClass() {
        PeerManagerUserAlert peerManagerUserAlert = this;
        synchronized (peerManagerUserAlert) {
            if (this.isOutdated) {
                if (this.conns == 0) {
                    return 0;
                }
                return 1;
            }
            if (this.peers == 0 && !this.isOpennetEnabled) {
                return 0;
            }
            if (this.conns == 0 && !this.isOpennetEnabled) {
                return 1;
            }
            if (this.conns < 3 && this.clockProblem > 5) {
                return 1;
            }
            if (this.conns < 3 && this.connError > 5) {
                return 1;
            }
            if (this.conns < 3 && !this.isOpennetEnabled) {
                return 1;
            }
            if (this.bwlimitDelayAlertRelevant && (long)this.bwlimitDelayTime > NodeStats.MAX_BWLIMIT_DELAY_TIME_ALERT_THRESHOLD) {
                return 1;
            }
            if (this.nodeAveragePingAlertRelevant && (long)this.nodeAveragePingTime > NodeStats.MAX_NODE_AVERAGE_PING_TIME_ALERT_THRESHOLD) {
                return 1;
            }
            if (this.clockProblem > 5) {
                return 1;
            }
            if (this.neverConn > 5) {
                return 2;
            }
            if (this.connError > 5) {
                return 2;
            }
            if (this.disconnDarknetPeers > 50 && !this.darknetDefinitelyPortForwarded && !this.darknetAssumeNAT) {
                return 2;
            }
            if (this.darknetConns > 100) {
                return 2;
            }
            if (this.oldestNeverConnectedPeerAge > MAX_OLDEST_NEVER_CONNECTED_PEER_AGE_ALERT_THRESHOLD) {
                return 2;
            }
            return 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isValid() {
        boolean ret;
        this.update();
        PeerManagerUserAlert peerManagerUserAlert = this;
        synchronized (peerManagerUserAlert) {
            ret = this.peers == 0 && !this.isOpennetEnabled || this.conns < 3 && !this.isOpennetEnabled || this.neverConn > 5 || this.disconnDarknetPeers > 50 && !this.darknetDefinitelyPortForwarded && !this.darknetAssumeNAT || this.darknetConns > 100 || this.clockProblem > 5 || this.connError > 5 || this.bwlimitDelayAlertRelevant && (long)this.bwlimitDelayTime > NodeStats.MAX_BWLIMIT_DELAY_TIME_ALERT_THRESHOLD || this.nodeAveragePingAlertRelevant && (long)this.nodeAveragePingTime > NodeStats.MAX_NODE_AVERAGE_PING_TIME_ALERT_THRESHOLD || this.oldestNeverConnectedPeerAge > MAX_OLDEST_NEVER_CONNECTED_PEER_AGE_ALERT_THRESHOLD;
        }
        if (!ret) {
            ret = this.isOutdated;
        }
        return ret;
    }

    private void update() {
        this.bwlimitDelayTime = (int)this.n.getBwlimitDelayTime();
        this.nodeAveragePingTime = (int)this.n.getNodeAveragePingTime();
        this.oldestNeverConnectedPeerAge = (int)this.n.peers.getOldestNeverConnectedDarknetPeerAge();
        this.bwlimitDelayAlertRelevant = this.n.bwlimitDelayAlertRelevant;
        this.nodeAveragePingAlertRelevant = this.n.nodeAveragePingAlertRelevant;
        this.isOutdated = this.calculateIsOutdated();
    }
}

