/*
 * Decompiled with CFR 0.152.
 */
package freenet.node.simulator;

import freenet.client.HighLevelSimpleClient;
import freenet.crypt.DummyRandomSource;
import freenet.io.comm.PeerParseException;
import freenet.io.comm.ReferenceSignatureVerificationException;
import freenet.keys.CHKBlock;
import freenet.keys.CHKDecodeException;
import freenet.keys.CHKEncodeException;
import freenet.keys.CHKVerifyException;
import freenet.keys.ClientCHK;
import freenet.keys.ClientCHKBlock;
import freenet.node.FSParseException;
import freenet.node.LowLevelPutException;
import freenet.node.Node;
import freenet.node.NodeInitException;
import freenet.node.NodeStarter;
import freenet.node.simulator.RealNodeRequestInsertTest;
import freenet.node.simulator.RealNodeRoutingTest;
import freenet.support.Fields;
import freenet.support.HexUtil;
import freenet.support.Logger;
import freenet.support.LoggerHook;
import freenet.support.PooledExecutor;
import freenet.support.compress.Compressor;
import freenet.support.compress.InvalidCompressionCodecException;
import freenet.support.io.FileUtil;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.util.concurrent.TimeUnit;

public class RealNodeBusyNetworkTest
extends RealNodeRoutingTest {
    static final int NUMBER_OF_NODES = 25;
    static final int DEGREE = 5;
    static final short MAX_HTL = 8;
    static final int INSERT_KEYS = 50;
    static final boolean START_WITH_IDEAL_LOCATIONS = true;
    static final boolean FORCE_NEIGHBOUR_CONNECTIONS = true;
    static final boolean ENABLE_SWAPPING = false;
    static final boolean ENABLE_ULPRS = false;
    static final boolean ENABLE_PER_NODE_FAILURE_TABLES = false;
    static final boolean ENABLE_SWAP_QUEUEING = false;
    static final boolean ENABLE_PACKET_COALESCING = true;
    static final boolean ENABLE_FOAF = true;
    static final boolean FORK_ON_CACHEABLE = false;
    static final boolean REAL_TIME_FLAG = false;
    static final int TARGET_SUCCESSES = 20;
    static final int DARKNET_PORT_BASE = 5008;
    static final int DARKNET_PORT_END = 5033;

    public static void main(String[] args) throws FSParseException, PeerParseException, CHKEncodeException, LoggerHook.InvalidThresholdException, NodeInitException, ReferenceSignatureVerificationException, InterruptedException, UnsupportedEncodingException, CHKVerifyException, CHKDecodeException, InvalidCompressionCodecException {
        int i;
        int i2;
        String name = "realNodeRequestInsertTest";
        File wd = new File(name);
        if (!FileUtil.removeAll(wd)) {
            System.err.println("Mass delete failed, test may not be accurate.");
            System.exit(1027);
        }
        wd.mkdir();
        NodeStarter.globalTestInit(name, false, Logger.LogLevel.ERROR, "", true);
        System.out.println("Busy network test (inserts/retrieves in quantity/stress test)");
        System.out.println();
        DummyRandomSource random = new DummyRandomSource();
        Node[] nodes = new Node[25];
        Logger.normal(RealNodeRoutingTest.class, "Creating nodes...");
        PooledExecutor executor = new PooledExecutor();
        for (i2 = 0; i2 < 25; ++i2) {
            nodes[i2] = NodeStarter.createTestNode(5008 + i2, 0, name, false, (short)8, 20, random, executor, 12500, 3280400L, true, false, false, false, false, false, true, 8000, true, false, true, false, null);
            Logger.normal(RealNodeRoutingTest.class, "Created node " + i2);
        }
        RealNodeBusyNetworkTest.makeKleinbergNetwork(nodes, true, 5, true, random);
        Logger.normal(RealNodeRoutingTest.class, "Added random links");
        for (i2 = 0; i2 < 25; ++i2) {
            nodes[i2].start(false);
            System.err.println("Started node " + i2 + "/" + nodes.length);
        }
        RealNodeBusyNetworkTest.waitForAllConnected(nodes);
        RealNodeBusyNetworkTest.waitForPingAverage(0.95, nodes, random, 2000, 1000);
        System.out.println();
        System.out.println("Ping average > 95%, lets do some inserts/requests");
        System.out.println();
        HighLevelSimpleClient[] clients = new HighLevelSimpleClient[nodes.length];
        for (int i3 = 0; i3 < clients.length; ++i3) {
            clients[i3] = nodes[i3].clientCore.makeClient((short)2, false, false);
        }
        ClientCHK[] keys = new ClientCHK[50];
        String baseString = System.currentTimeMillis() + " ";
        for (i = 0; i < 50; ++i) {
            System.err.println("Inserting " + i + " of " + 50);
            int node1 = random.nextInt(25);
            Node randomNode = nodes[node1];
            String dataString = baseString + i;
            byte[] data = dataString.getBytes("UTF-8");
            ClientCHKBlock b = ClientCHKBlock.encode(data, false, false, (short)-1, 0, Compressor.COMPRESSOR_TYPE.DEFAULT_COMPRESSORDESCRIPTOR, false);
            CHKBlock block = b.getBlock();
            ClientCHK chk = b.getClientKey();
            byte[] encData = block.getData();
            byte[] encHeaders = block.getHeaders();
            ClientCHKBlock newBlock = new ClientCHKBlock(encData, encHeaders, chk, true);
            keys[i] = chk;
            Logger.minor(RealNodeRequestInsertTest.class, "Decoded: " + new String(newBlock.memoryDecode(), "UTF-8"));
            Logger.normal(RealNodeRequestInsertTest.class, "CHK: " + chk.getURI());
            Logger.minor(RealNodeRequestInsertTest.class, "Headers: " + HexUtil.bytesToHex(block.getHeaders()));
            try {
                randomNode.clientCore.realPut(block, false, false, false, false, false);
                Logger.error(RealNodeRequestInsertTest.class, "Inserted to " + node1);
                Logger.minor(RealNodeRequestInsertTest.class, "Data: " + Fields.hashCode(encData) + ", Headers: " + Fields.hashCode(encHeaders));
                continue;
            }
            catch (LowLevelPutException putEx) {
                Logger.error(RealNodeRequestInsertTest.class, "Insert failed: " + putEx);
                System.err.println("Insert failed: " + putEx);
                System.exit(1029);
            }
        }
        for (i = 0; i < 50; ++i) {
            ClientCHK key = keys[i];
            System.err.println("Queueing requests for " + i + " of " + 50);
            for (int j = 0; j < nodes.length; ++j) {
                clients[j].prefetch(key.getURI(), TimeUnit.DAYS.toMillis(1L), 32768L, null);
            }
            long totalRunningRequests = 0L;
            for (int j = 0; j < nodes.length; ++j) {
                totalRunningRequests += nodes[j].clientCore.countQueuedRequests();
            }
            System.err.println("Running requests: " + totalRunningRequests);
        }
        while (true) {
            long totalRunningRequests = 0L;
            for (int i4 = 0; i4 < nodes.length; ++i4) {
                totalRunningRequests += nodes[i4].clientCore.countQueuedRequests();
            }
            System.err.println("Running requests: " + totalRunningRequests);
            if (totalRunningRequests == 0L) break;
            Thread.sleep(1000L);
        }
        System.exit(0);
    }
}

