/*
 * Decompiled with CFR 0.152.
 */
package freenet.node;

import freenet.node.VersionParseException;
import freenet.support.Fields;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import java.util.Calendar;
import java.util.TimeZone;

public class Version {
    public static final String nodeName = "Fred";
    public static final String nodeVersion = "0.7";
    public static final String publicVersion = "0.7.5";
    public static final String protocolVersion = "1.0";
    private static final int buildNumber = 1478;
    private static final int oldLastGoodBuild = 1474;
    private static final int newLastGoodBuild = 1475;
    static final long transitionTime;
    private static volatile boolean logMINOR;
    private static volatile boolean logDEBUG;
    private static int highestSeenBuild;
    public static final String stableNodeVersion = "0.7";
    public static final String stableProtocolVersion = "STABLE-0.7";
    public static final int lastGoodStableBuild = 1;
    public static final String cvsRevision = "build01478-dirty";

    public static int buildNumber() {
        return 1478;
    }

    public static String publicVersion() {
        return publicVersion;
    }

    public static long transitionTime() {
        return transitionTime;
    }

    public static int lastGoodBuild() {
        if (System.currentTimeMillis() >= transitionTime) {
            return 1475;
        }
        return 1474;
    }

    public static String cvsRevision() {
        return cvsRevision;
    }

    public static String[] getVersion() {
        String[] ret = new String[]{nodeName, "0.7", protocolVersion, String.valueOf(1478)};
        return ret;
    }

    public static String[] getLastGoodVersion() {
        String[] ret = new String[]{nodeName, "0.7", protocolVersion, String.valueOf(Version.lastGoodBuild())};
        return ret;
    }

    public static String getVersionString() {
        return Fields.commaList(Version.getVersion());
    }

    public static String getLastGoodVersionString() {
        return Fields.commaList(Version.getLastGoodVersion());
    }

    private static boolean goodProtocol(String prot) {
        return prot.equals(protocolVersion);
    }

    public static boolean checkGoodVersion(String version) {
        int build;
        if (version == null) {
            Logger.error(Version.class, "version == null!", (Throwable)new Exception("error"));
            return false;
        }
        String[] v = Fields.commaList(version);
        if (v.length < 3 || !Version.goodProtocol(v[2])) {
            return false;
        }
        if (Version.sameVersion(v)) {
            try {
                build = Integer.parseInt(v[3]);
                int req = Version.lastGoodBuild();
                if (build < req) {
                    if (logDEBUG) {
                        Logger.debug(Version.class, "Not accepting unstable from version: " + version + "(lastGoodBuild=" + req + ')');
                    }
                    return false;
                }
            }
            catch (NumberFormatException e) {
                if (logMINOR) {
                    Logger.minor(Version.class, "Not accepting (" + e + ") from " + version);
                }
                return false;
            }
        }
        if (Version.stableVersion(v)) {
            try {
                build = Integer.parseInt(v[3]);
                if (build < 1) {
                    if (logDEBUG) {
                        Logger.debug(Version.class, "Not accepting stable from version" + version + "(lastGoodStableBuild=" + 1 + ')');
                    }
                    return false;
                }
            }
            catch (NumberFormatException e) {
                Logger.minor(Version.class, "Not accepting (" + e + ") from " + version);
                return false;
            }
        }
        if (logDEBUG) {
            Logger.minor(Version.class, "Accepting: " + version);
        }
        return true;
    }

    public static boolean checkArbitraryGoodVersion(String version, String lastGoodVersion) {
        int build;
        if (version == null) {
            Logger.error(Version.class, "version == null!", (Throwable)new Exception("error"));
            return false;
        }
        if (lastGoodVersion == null) {
            Logger.error(Version.class, "lastGoodVersion == null!", (Throwable)new Exception("error"));
            return false;
        }
        String[] v = Fields.commaList(version);
        String[] lgv = Fields.commaList(lastGoodVersion);
        if (v == null || v.length < 3 || !Version.goodProtocol(v[2])) {
            return false;
        }
        if (lgv == null || lgv.length < 3 || !Version.goodProtocol(lgv[2])) {
            return false;
        }
        if (Version.sameArbitraryVersion(v, lgv)) {
            try {
                build = Integer.parseInt(v[3]);
                int min_build = Integer.parseInt(lgv[3]);
                if (build < min_build) {
                    if (logDEBUG) {
                        Logger.debug(Version.class, "Not accepting unstable from version: " + version + "(lastGoodVersion=" + lastGoodVersion + ')');
                    }
                    return false;
                }
            }
            catch (NumberFormatException e) {
                if (logMINOR) {
                    Logger.minor(Version.class, "Not accepting (" + e + ") from " + version + " and/or " + lastGoodVersion);
                }
                return false;
            }
        }
        if (Version.stableVersion(v)) {
            try {
                build = Integer.parseInt(v[3]);
                if (build < 1) {
                    if (logDEBUG) {
                        Logger.debug(Version.class, "Not accepting stable from version" + version + "(lastGoodStableBuild=" + 1 + ')');
                    }
                    return false;
                }
            }
            catch (NumberFormatException e) {
                Logger.minor(Version.class, "Not accepting (" + e + ") from " + version);
                return false;
            }
        }
        if (logDEBUG) {
            Logger.minor(Version.class, "Accepting: " + version);
        }
        return true;
    }

    public static String explainBadVersion(String version) {
        int build;
        String[] v = Fields.commaList(version);
        if (v.length < 3 || !Version.goodProtocol(v[2])) {
            return "Required protocol version is 1.0";
        }
        if (Version.sameVersion(v)) {
            try {
                build = Integer.parseInt(v[3]);
                int req = Version.lastGoodBuild();
                if (build < req) {
                    return "Build older than last good build " + req;
                }
            }
            catch (NumberFormatException e) {
                return "Build number not numeric.";
            }
        }
        if (Version.stableVersion(v)) {
            try {
                build = Integer.parseInt(v[3]);
                if (build < 1) {
                    return "Build older than last good stable build 1";
                }
            }
            catch (NumberFormatException e) {
                return "Build number not numeric.";
            }
        }
        return null;
    }

    public static int getArbitraryBuildNumber(String version) throws VersionParseException {
        if (version == null) {
            Logger.error(Version.class, "version == null!", (Throwable)new Exception("error"));
            throw new VersionParseException("version == null");
        }
        String[] v = Fields.commaList(version);
        if (v.length < 3 || !Version.goodProtocol(v[2])) {
            throw new VersionParseException("not long enough or bad protocol: " + version);
        }
        try {
            return Integer.parseInt(v[3]);
        }
        catch (NumberFormatException e) {
            throw (VersionParseException)new VersionParseException("Got NumberFormatException on " + v[3] + " : " + e + " for " + version).initCause(e);
        }
    }

    public static int getArbitraryBuildNumber(String version, int defaultValue) {
        try {
            return Version.getArbitraryBuildNumber(version);
        }
        catch (VersionParseException e) {
            return defaultValue;
        }
    }

    public static void seenVersion(String version) {
        String[] v = Fields.commaList(version);
        if (v == null || v.length < 3) {
            return;
        }
        if (Version.sameVersion(v)) {
            int buildNo;
            try {
                buildNo = Integer.parseInt(v[3]);
            }
            catch (NumberFormatException e) {
                return;
            }
            if (buildNo > highestSeenBuild) {
                if (logMINOR) {
                    Logger.minor(Version.class, "New highest seen build: " + buildNo);
                }
                highestSeenBuild = buildNo;
            }
        }
    }

    public static int getHighestSeenBuild() {
        return highestSeenBuild;
    }

    public static boolean sameVersion(String[] v) {
        return v[0].equals(nodeName) && v[1].equals("0.7") && v.length >= 4;
    }

    public static boolean sameArbitraryVersion(String[] v, String[] lgv) {
        return v[0].equals(lgv[0]) && v[1].equals(lgv[1]) && v.length >= 4 && lgv.length >= 4;
    }

    private static boolean stableVersion(String[] v) {
        return v[0].equals(nodeName) && v[1].equals("0.7") && v.length >= 4;
    }

    public static void main(String[] args) throws Throwable {
        System.out.println("Freenet: Fred 0.7 (protocol 1.0) build 1478 (last good build: " + Version.lastGoodBuild() + ')');
    }

    static {
        Calendar _cal = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        _cal.set(2016, 6, 15, 0, 0, 0);
        transitionTime = _cal.getTimeInMillis();
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            @Override
            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(Logger.LogLevel.MINOR, (Object)this);
                logDEBUG = Logger.shouldLog(Logger.LogLevel.DEBUG, (Object)this);
            }
        });
        highestSeenBuild = 1478;
    }
}

