/*
 * Decompiled with CFR 0.152.
 */
package freenet.node;

import freenet.crypt.DSAPublicKey;
import freenet.io.comm.AsyncMessageCallback;
import freenet.io.comm.ByteCounter;
import freenet.io.comm.DMT;
import freenet.io.comm.Message;
import freenet.io.comm.NotConnectedException;
import freenet.io.comm.PeerParseException;
import freenet.io.comm.PeerRestartedException;
import freenet.io.comm.ReferenceSignatureVerificationException;
import freenet.io.xfer.BlockTransmitter;
import freenet.io.xfer.BulkTransmitter;
import freenet.io.xfer.PartiallyReceivedBlock;
import freenet.io.xfer.WaitedTooLongException;
import freenet.keys.CHKBlock;
import freenet.keys.Key;
import freenet.keys.KeyBlock;
import freenet.keys.NodeCHK;
import freenet.keys.NodeSSK;
import freenet.keys.SSKBlock;
import freenet.node.FSParseException;
import freenet.node.FailureTable;
import freenet.node.MultiMessageCallback;
import freenet.node.Node;
import freenet.node.OpennetManager;
import freenet.node.PeerNode;
import freenet.node.PrioRunnable;
import freenet.node.RequestSender;
import freenet.node.RequestSenderListener;
import freenet.node.RequestTag;
import freenet.node.SyncSendWaitedTooLongException;
import freenet.node.WaitingMultiMessageCallback;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import freenet.support.SimpleFieldSet;
import freenet.support.TimeUtil;
import freenet.support.io.NativeThread;

public class RequestHandler
implements PrioRunnable,
ByteCounter,
RequestSenderListener {
    private static volatile boolean logMINOR;
    final Node node;
    final long uid;
    private final short htl;
    final PeerNode source;
    private boolean needsPubKey;
    final Key key;
    private boolean finalTransferFailed = false;
    private RequestSender rs;
    private int status = -1;
    private boolean appliedByteCounts = false;
    private boolean sentRejectedOverload = false;
    private long searchStartTime;
    private long responseDeadline;
    private BlockTransmitter bt;
    private final RequestTag tag;
    private final boolean realTimeFlag;
    KeyBlock passedInKeyBlock;
    private boolean disconnected = false;
    boolean transferCompleted;
    boolean transferSuccess;
    boolean waitingForTransferSuccess;
    boolean sendTerminalCalled = false;
    private int sentBytes;
    private int receivedBytes;
    private volatile Object bytesSync = new Object();

    public String toString() {
        return super.toString() + " for " + this.uid;
    }

    public RequestHandler(PeerNode source, long id, Node n, short htl, Key key, RequestTag tag, KeyBlock passedInKeyBlock, boolean realTimeFlag, boolean needsPubKey) {
        this.node = n;
        this.uid = id;
        this.realTimeFlag = realTimeFlag;
        this.source = source;
        this.htl = htl;
        this.tag = tag;
        this.key = key;
        this.passedInKeyBlock = passedInKeyBlock;
        this.needsPubKey = needsPubKey;
    }

    @Override
    public void run() {
        Logger.OSThread.logPID(this);
        try {
            this.realRun();
        }
        catch (NotConnectedException e) {
            Logger.normal(this, "requestor gone, could not start request handler wait");
            this.tag.handlerThrew(e);
        }
        catch (Throwable t) {
            Logger.error(this, "Caught " + t, t);
            this.tag.handlerThrew(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyByteCounts() {
        int rcvd;
        int sent;
        RequestHandler requestHandler = this;
        synchronized (requestHandler) {
            if (this.disconnected) {
                Logger.normal(this, "Not applying byte counts as request source disconnected during receive");
                return;
            }
            if (this.appliedByteCounts) {
                return;
            }
            this.appliedByteCounts = true;
            if (this.finalTransferFailed || this.rs == null || this.status == 6 || this.status == 7 || this.status == 8) {
                return;
            }
        }
        Object object = this.bytesSync;
        synchronized (object) {
            sent = this.sentBytes;
            rcvd = this.receivedBytes;
        }
        sent += this.rs.getTotalSentBytes();
        rcvd += this.rs.getTotalReceivedBytes();
        if (this.key instanceof NodeSSK) {
            if (logMINOR) {
                Logger.minor(this, "Remote SSK fetch cost " + sent + '/' + rcvd + " bytes (" + this.status + ')');
            }
            this.node.nodeStats.remoteSskFetchBytesSentAverage.report(sent);
            this.node.nodeStats.remoteSskFetchBytesReceivedAverage.report(rcvd);
            if (this.status == 0) {
                this.node.nodeStats.successfulSskFetchBytesSentAverage.report(sent);
                this.node.nodeStats.successfulSskFetchBytesReceivedAverage.report(rcvd);
            }
        } else {
            if (logMINOR) {
                Logger.minor(this, "Remote CHK fetch cost " + sent + '/' + rcvd + " bytes (" + this.status + ')');
            }
            this.node.nodeStats.remoteChkFetchBytesSentAverage.report(sent);
            this.node.nodeStats.remoteChkFetchBytesReceivedAverage.report(rcvd);
            if (this.status == 0) {
                this.node.nodeStats.successfulChkFetchBytesSentAverage.report(sent);
                this.node.nodeStats.successfulChkFetchBytesReceivedAverage.report(rcvd);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void realRun() throws NotConnectedException {
        if (logMINOR) {
            Logger.minor(this, "Handling a request: " + this.uid);
        }
        Message accepted = DMT.createFNPAccepted(this.uid);
        this.source.sendAsync(accepted, null, this);
        if (this.tag.shouldSlowDown()) {
            try {
                this.source.sendAsync(DMT.createFNPRejectedOverload(this.uid, false, false, this.realTimeFlag), null, this);
            }
            catch (NotConnectedException notConnectedException) {
                // empty catch block
            }
        }
        if (this.passedInKeyBlock != null) {
            this.tag.setServedFromDatastore();
            this.returnLocalData(this.passedInKeyBlock);
            this.passedInKeyBlock = null;
            return;
        }
        Object o = this.node.makeRequestSender(this.key, this.htl, this.uid, this.tag, this.source, false, true, false, false, false, this.realTimeFlag);
        if (o == null) {
            Message dnf = DMT.createFNPDataNotFound(this.uid);
            this.status = 3;
            this.node.failureTable.onFinalFailure(this.key, null, this.htl, this.htl, FailureTable.RECENTLY_FAILED_TIME, FailureTable.REJECT_TIME, this.source);
            this.sendTerminal(dnf);
            this.node.nodeStats.remoteRequest(this.key instanceof NodeSSK, false, false, this.htl, this.key.toNormalizedDouble(), this.realTimeFlag, false);
            return;
        }
        long queueTime = this.source.getProbableSendQueueTime();
        RequestHandler requestHandler = this;
        synchronized (requestHandler) {
            this.rs = (RequestSender)o;
            this.searchStartTime = System.currentTimeMillis();
            this.responseDeadline = this.searchStartTime + this.rs.fetchTimeout() + queueTime;
        }
        this.rs.addListener(this);
    }

    @Override
    public void onReceivedRejectOverload() {
        try {
            if (!this.sentRejectedOverload) {
                if (logMINOR) {
                    Logger.minor(this, "Propagating RejectedOverload on " + this);
                }
                Message msg = DMT.createFNPRejectedOverload(this.uid, false, true, this.realTimeFlag);
                this.source.sendAsync(msg, null, this);
                this.sentRejectedOverload = true;
            }
        }
        catch (NotConnectedException e) {
            Logger.normal(this, "requestor is gone, can't forward reject overload");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onCHKTransferBegins() {
        if (this.tag.hasSourceReallyRestarted()) {
            Logger.normal(this, "requestor is gone, can't send terminal message");
            this.applyByteCounts();
            this.unregisterRequestHandlerWithNode();
            return;
        }
        if (logMINOR) {
            Logger.minor(this, "CHK transfer start on " + this);
        }
        try {
            Message df = DMT.createFNPCHKDataFound(this.uid, this.rs.getHeaders());
            this.source.sendAsync(df, null, this);
            PartiallyReceivedBlock prb = this.rs.getPRB();
            this.bt = new BlockTransmitter(this.node.usm, this.node.getTicker(), this.source, this.uid, prb, this, new BlockTransmitter.ReceiverAbortHandler(){

                @Override
                public boolean onAbort() {
                    RequestSender rs = RequestHandler.this.rs;
                    if (rs != null && rs.uid != RequestHandler.this.uid) {
                        if (logMINOR) {
                            Logger.minor(this, "Not cancelling transfer because was coalesced on " + RequestHandler.this);
                        }
                        return false;
                    }
                    if (RequestHandler.this.node.hasKey(RequestHandler.this.key, false, false)) {
                        return true;
                    }
                    if (rs != null && rs.isTransferCoalesced()) {
                        if (logMINOR) {
                            Logger.minor(this, "Not cancelling transfer because others want the data on " + RequestHandler.this);
                        }
                        RequestHandler.this.node.tracker.reassignTagToSelf(RequestHandler.this.tag);
                        return false;
                    }
                    if (RequestHandler.this.node.failureTable.peersWantKey(RequestHandler.this.key, RequestHandler.this.source)) {
                        Logger.error(this, "Downstream transfer successful but upstream transfer to " + RequestHandler.this.source.shortToString() + " failed. Reassigning tag to self because want the data for peers on " + RequestHandler.this);
                        RequestHandler.this.node.tracker.reassignTagToSelf(RequestHandler.this.tag);
                        return false;
                    }
                    if (RequestHandler.this.node.clientCore != null && RequestHandler.this.node.clientCore.wantKey(RequestHandler.this.key)) {
                        Logger.error(this, "Downstream transfer successful but upstream transfer to " + RequestHandler.this.source.shortToString() + " failed. Reassigning tag to self because want the data for ourselves on " + RequestHandler.this);
                        RequestHandler.this.node.tracker.reassignTagToSelf(RequestHandler.this.tag);
                        return false;
                    }
                    return true;
                }
            }, new BlockTransmitter.BlockTransmitterCompletion(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void blockTransferFinished(boolean success) {
                    RequestHandler requestHandler = RequestHandler.this;
                    synchronized (requestHandler) {
                        if (RequestHandler.this.transferCompleted) {
                            Logger.error(this, "Transfer already completed on " + this, (Throwable)new Exception("debug"));
                            return;
                        }
                        RequestHandler.this.transferCompleted = true;
                        RequestHandler.this.transferSuccess = success;
                        if (!RequestHandler.this.waitingForTransferSuccess) {
                            return;
                        }
                    }
                    RequestHandler.this.transferFinished(success);
                }
            }, this.realTimeFlag, this.node.nodeStats);
            this.tag.handlerTransferBegins();
            this.bt.sendAsync();
        }
        catch (NotConnectedException e) {
            RequestHandler requestHandler = this;
            synchronized (requestHandler) {
                this.disconnected = true;
            }
            this.tag.handlerDisconnected();
            Logger.normal(this, "requestor is gone, can't begin CHK transfer");
        }
    }

    protected void transferFinished(boolean success) {
        if (logMINOR) {
            Logger.minor(this, "Transfer finished (success=" + success + ")");
        }
        if (success) {
            this.status = this.rs.getStatus();
            this.node.executor.execute(new PrioRunnable(){

                @Override
                public void run() {
                    try {
                        RequestHandler.this.finishOpennetChecked();
                    }
                    catch (NotConnectedException notConnectedException) {
                        // empty catch block
                    }
                }

                @Override
                public int getPriority() {
                    return NativeThread.HIGH_PRIORITY;
                }
            });
        } else {
            this.finalTransferFailed = true;
            this.status = this.rs.getStatus();
            this.applyByteCounts();
            this.unregisterRequestHandlerWithNode();
        }
    }

    @Override
    public void onAbortDownstreamTransfers(int reason, String desc) {
        if (this.bt == null) {
            Logger.error(this, "No downstream transfer to abort! on " + this);
            return;
        }
        if (logMINOR) {
            Logger.minor(this, "Aborting downstream transfer on " + this);
        }
        this.tag.onAbortDownstreamTransfers(reason, desc);
        try {
            this.bt.abortSend(reason, desc);
        }
        catch (NotConnectedException notConnectedException) {
            // empty catch block
        }
    }

    private synchronized boolean readyToFinishTransfer() {
        if (this.waitingForTransferSuccess) {
            Logger.error(this, "waitAndFinishCHKTransferOffThread called twice on " + this);
            return false;
        }
        this.waitingForTransferSuccess = true;
        if (!this.transferCompleted) {
            if (logMINOR) {
                Logger.minor(this, "Waiting for transfer to finish on " + this);
            }
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onRequestSenderFinished(int status, boolean fromOfferedKey, RequestSender rs) {
        boolean tooLate;
        if (this.tag.hasSourceReallyRestarted()) {
            Logger.normal(this, "requestor is gone, can't send terminal message");
            this.applyByteCounts();
            this.unregisterRequestHandlerWithNode();
            return;
        }
        if (logMINOR) {
            Logger.minor(this, "onRequestSenderFinished(" + status + ") on " + this);
        }
        long now = System.currentTimeMillis();
        RequestHandler requestHandler = this;
        synchronized (requestHandler) {
            if (this.status != -1) {
                if (logMINOR) {
                    Logger.minor(this, "Ignoring onRequestSenderFinished as status is already " + this.status);
                }
                return;
            }
            this.status = status;
            tooLate = this.responseDeadline > 0L && now > this.responseDeadline;
        }
        this.node.nodeStats.remoteRequest(this.key instanceof NodeSSK, status == 0, false, this.htl, this.key.toNormalizedDouble(), this.realTimeFlag, fromOfferedKey);
        if (tooLate) {
            if (logMINOR) {
                Logger.minor(this, "Too late");
            }
            this.node.failureTable.onFinalFailure(this.key, null, this.htl, this.htl, -1L, -1L, this.source);
            PeerNode routedLast = rs == null ? null : rs.routedLast();
            Logger.normal(this, "requestsender took too long to respond to requestor (" + TimeUtil.formatTime(now - this.searchStartTime, 2, true) + "/" + (rs == null ? "null" : rs.getStatusString()) + ") routed to " + (routedLast == null ? "null" : routedLast.shortToString()));
        }
        if (status == -1) {
            Logger.error(this, "onFinished() but not finished?");
        }
        try {
            switch (status) {
                case -1: 
                case 3: {
                    Message dnf = DMT.createFNPDataNotFound(this.uid);
                    this.sendTerminal(dnf);
                    return;
                }
                case 9: {
                    Message rf = DMT.createFNPRecentlyFailed(this.uid, rs.getRecentlyFailedTimeLeft());
                    this.sendTerminal(rf);
                    return;
                }
                case 6: 
                case 7: 
                case 8: {
                    Message reject = DMT.createFNPRejectedOverload(this.uid, true, true, this.realTimeFlag);
                    this.sendTerminal(reject);
                    return;
                }
                case 1: {
                    Message rnf = DMT.createFNPRouteNotFound(this.uid, rs.getHTL());
                    this.sendTerminal(rnf);
                    return;
                }
                case 0: {
                    if (this.key instanceof NodeSSK) {
                        this.sendSSK(rs.getHeaders(), rs.getSSKData(), this.needsPubKey, rs.getSSKBlock().getKey().getPubKey());
                    } else {
                        this.maybeCompleteTransfer();
                    }
                    return;
                }
                case 5: 
                case 10: {
                    if (this.key instanceof NodeCHK) {
                        this.maybeCompleteTransfer();
                        return;
                    }
                    Message reject = DMT.createFNPRejectedOverload(this.uid, true, true, this.realTimeFlag);
                    this.sendTerminal(reject);
                    return;
                }
                case 4: 
                case 11: {
                    if (this.key instanceof NodeCHK) {
                        this.maybeCompleteTransfer();
                        return;
                    }
                    Logger.error(this, "finish(TRANSFER_FAILED) should not be called on SSK?!?!", (Throwable)new Exception("error"));
                    return;
                }
            }
            Message reject = DMT.createFNPRejectedOverload(this.uid, true, true, this.realTimeFlag);
            this.sendTerminal(reject);
            throw new IllegalStateException("Unknown status code " + status);
        }
        catch (NotConnectedException e) {
            Logger.normal(this, "requestor is gone, can't send terminal message");
            this.applyByteCounts();
            this.unregisterRequestHandlerWithNode();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void maybeCompleteTransfer() throws NotConnectedException {
        Message reject = null;
        boolean disconn = false;
        boolean xferFinished = false;
        boolean xferSuccess = false;
        RequestHandler requestHandler = this;
        synchronized (requestHandler) {
            if (this.disconnected) {
                disconn = true;
            } else if (this.bt == null) {
                Logger.error(this, "Status is " + this.status + " but we never started a transfer on " + this.uid);
                reject = DMT.createFNPRejectedOverload(this.uid, true, false, false);
            } else {
                xferFinished = this.readyToFinishTransfer();
                xferSuccess = this.transferSuccess;
            }
        }
        if (disconn) {
            this.unregisterRequestHandlerWithNode();
        } else if (reject != null) {
            this.sendTerminal(reject);
        } else if (xferFinished) {
            this.transferFinished(xferSuccess);
        }
    }

    private void sendSSK(byte[] headers, final byte[] data, boolean needsPubKey2, DSAPublicKey pubKey) throws NotConnectedException {
        MultiMessageCallback mcb = null;
        mcb = new MultiMessageCallback(){

            @Override
            public void finish(boolean success) {
                RequestHandler.this.sentPayload(data.length);
                RequestHandler.this.applyByteCounts();
                RequestHandler.this.unregisterRequestHandlerWithNode();
            }

            @Override
            void sent(boolean success) {
                RequestHandler.this.tag.unlockHandler();
            }
        };
        Message headersMsg = DMT.createFNPSSKDataFoundHeaders(this.uid, headers, this.realTimeFlag);
        this.source.sendAsync(headersMsg, mcb.make(), this);
        Message dataMsg = DMT.createFNPSSKDataFoundData(this.uid, data, this.realTimeFlag);
        if (this.needsPubKey) {
            Message pk = DMT.createFNPSSKPubKey(this.uid, pubKey, this.realTimeFlag);
            this.source.sendAsync(pk, mcb.make(), this);
        }
        this.source.sendAsync(dataMsg, mcb.make(), this);
        if (mcb != null) {
            mcb.arm();
        }
    }

    static void sendSSK(byte[] headers, byte[] data, boolean needsPubKey, DSAPublicKey pubKey, PeerNode source, long uid, ByteCounter ctr, boolean realTimeFlag) throws NotConnectedException, WaitedTooLongException, PeerRestartedException, SyncSendWaitedTooLongException {
        WaitingMultiMessageCallback mcb = null;
        mcb = new WaitingMultiMessageCallback();
        Message headersMsg = DMT.createFNPSSKDataFoundHeaders(uid, headers, realTimeFlag);
        source.sendAsync(headersMsg, mcb.make(), ctr);
        Message dataMsg = DMT.createFNPSSKDataFoundData(uid, data, realTimeFlag);
        source.sendAsync(dataMsg, mcb.make(), ctr);
        if (needsPubKey) {
            Message pk = DMT.createFNPSSKPubKey(uid, pubKey, realTimeFlag);
            source.sendAsync(pk, mcb.make(), ctr);
        }
        mcb.arm();
        mcb.waitFor();
        ctr.sentPayload(data.length);
    }

    private void returnLocalData(KeyBlock block) throws NotConnectedException {
        if (this.key instanceof NodeSSK) {
            this.sendSSK(block.getRawHeaders(), block.getRawData(), this.needsPubKey, ((SSKBlock)block).getPubKey());
            this.status = 0;
            this.node.nodeStats.remoteRequest(true, true, true, this.htl, this.key.toNormalizedDouble(), this.realTimeFlag, false);
        } else if (block instanceof CHKBlock) {
            Message df = DMT.createFNPCHKDataFound(this.uid, block.getRawHeaders());
            PartiallyReceivedBlock prb = new PartiallyReceivedBlock(32, 1024, block.getRawData());
            BlockTransmitter bt = new BlockTransmitter(this.node.usm, this.node.getTicker(), this.source, this.uid, prb, this, BlockTransmitter.NEVER_CASCADE, new BlockTransmitter.BlockTransmitterCompletion(){

                @Override
                public void blockTransferFinished(boolean success) {
                    if (success) {
                        RequestHandler.this.status = 0;
                        try {
                            RequestHandler.this.finishOpennetNoRelay();
                        }
                        catch (NotConnectedException e) {
                            Logger.normal(this, "requestor gone, could not start request handler wait");
                            RequestHandler.this.tag.handlerThrew(e);
                        }
                    } else {
                        RequestHandler.this.applyByteCounts();
                        RequestHandler.this.unregisterRequestHandlerWithNode();
                    }
                    RequestHandler.this.node.nodeStats.remoteRequest(false, success, true, RequestHandler.this.htl, RequestHandler.this.key.toNormalizedDouble(), RequestHandler.this.realTimeFlag, false);
                }
            }, this.realTimeFlag, this.node.nodeStats);
            this.tag.handlerTransferBegins();
            this.source.sendAsync(df, null, this);
            bt.sendAsync();
        } else {
            throw new IllegalStateException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unregisterRequestHandlerWithNode() {
        PeerNode p;
        RequestSender r;
        RequestHandler requestHandler = this;
        synchronized (requestHandler) {
            r = this.rs;
        }
        if (r != null && (p = r.successFrom()) != null) {
            this.tag.finishedWaitingForOpennet(p);
        }
        this.tag.unlockHandler();
    }

    private void sendTerminal(Message msg) {
        if (logMINOR) {
            Logger.minor(this, "sendTerminal(" + msg + ")", (Throwable)new Exception("debug"));
        }
        if (this.sendTerminalCalled) {
            throw new IllegalStateException("sendTerminal should only be called once");
        }
        this.sendTerminalCalled = true;
        this.tag.unlockHandler();
        try {
            this.source.sendAsync(msg, new TerminalMessageByteCountCollector(), this);
        }
        catch (NotConnectedException notConnectedException) {
            // empty catch block
        }
    }

    private void finishOpennetChecked() throws NotConnectedException {
        OpennetManager om = this.node.getOpennet();
        if (om != null && (this.node.passOpennetRefsThroughDarknet() || this.source.isOpennet())) {
            this.finishOpennetInner(om);
        } else {
            this.ackOpennet();
        }
    }

    private void finishOpennetNoRelay() throws NotConnectedException {
        OpennetManager om = this.node.getOpennet();
        if (om != null && (this.source.isOpennet() || this.node.passOpennetRefsThroughDarknet())) {
            this.finishOpennetNoRelayInner(om);
        } else {
            this.ackOpennet();
        }
    }

    private void ackOpennet() {
        Message msg = DMT.createFNPOpennetCompletedAck(this.uid);
        this.sendTerminal(msg);
    }

    private void finishOpennetInner(OpennetManager om) {
        SimpleFieldSet ref;
        byte[] noderef;
        if (logMINOR) {
            Logger.minor(this, "Finish opennet on " + this);
        }
        try {
            noderef = this.rs.waitForOpennetNoderef();
        }
        catch (OpennetManager.WaitedTooLongForOpennetNoderefException e) {
            this.sendTerminal(DMT.createFNPOpennetCompletedTimeout(this.uid));
            this.rs.ackOpennet(this.rs.successFrom());
            return;
        }
        if (noderef == null) {
            if (logMINOR) {
                Logger.minor(this, "Not relaying as no noderef on " + this);
            }
            this.finishOpennetNoRelayInner(om);
            return;
        }
        if (noderef != null && this.node.random.nextInt(20) == 0 && (ref = OpennetManager.validateNoderef(noderef, 0, noderef.length, this.source, false)) != null && !om.alreadyHaveOpennetNode(ref)) {
            if (logMINOR) {
                Logger.minor(this, "Resetting path folding on " + this);
            }
            this.rs.ackOpennet(this.rs.successFrom());
            this.finishOpennetNoRelayInner(om);
            return;
        }
        this.finishOpennetRelay(noderef, om);
    }

    private void finishOpennetNoRelayInner(final OpennetManager om) {
        if (logMINOR) {
            Logger.minor(this, "Finishing opennet: sending own reference on " + this, (Throwable)new Exception("debug"));
        }
        if (!om.wantPeer(null, false, false, false, OpennetManager.ConnectionType.PATH_FOLDING)) {
            this.ackOpennet();
            return;
        }
        try {
            om.sendOpennetRef(false, this.uid, this.source, om.crypto.myCompressedFullRef(), this);
        }
        catch (NotConnectedException e) {
            Logger.normal(this, "Can't send opennet ref because node disconnected on " + this);
            this.applyByteCounts();
            this.unregisterRequestHandlerWithNode();
            return;
        }
        OpennetManager.waitForOpennetNoderef(true, this.source, this.uid, this, new OpennetManager.NoderefCallback(){

            @Override
            public void gotNoderef(byte[] noderef) {
                if (logMINOR) {
                    Logger.minor(this, "Got noderef on " + RequestHandler.this);
                }
                RequestHandler.this.finishOpennetNoRelayInner(om, noderef);
                RequestHandler.this.applyByteCounts();
                RequestHandler.this.unregisterRequestHandlerWithNode();
            }

            @Override
            public void timedOut() {
                if (logMINOR) {
                    Logger.minor(this, "Timed out waiting for noderef from " + RequestHandler.this.source + " on " + RequestHandler.this);
                }
                this.gotNoderef(null);
            }

            @Override
            public void acked(boolean timedOutMessage) {
                if (logMINOR) {
                    Logger.minor(this, "Noderef acknowledged from " + RequestHandler.this.source + " on " + RequestHandler.this);
                }
                this.gotNoderef(null);
            }
        }, this.node);
    }

    private void finishOpennetNoRelayInner(OpennetManager om, byte[] noderef) {
        if (noderef == null) {
            return;
        }
        SimpleFieldSet ref = OpennetManager.validateNoderef(noderef, 0, noderef.length, this.source, false);
        if (ref == null) {
            return;
        }
        try {
            if (this.node.addNewOpennetNode(ref, OpennetManager.ConnectionType.PATH_FOLDING) == null) {
                Logger.normal(this, "Asked for opennet ref but didn't want it for " + this + " :\n" + ref);
            } else {
                Logger.normal(this, "Added opennet noderef in " + this);
            }
        }
        catch (FSParseException e) {
            Logger.error(this, "Could not parse opennet noderef for " + this + " from " + this.source, (Throwable)e);
        }
        catch (PeerParseException e) {
            Logger.error(this, "Could not parse opennet noderef for " + this + " from " + this.source, (Throwable)e);
        }
        catch (ReferenceSignatureVerificationException e) {
            Logger.error(this, "Bad signature on opennet noderef for " + this + " from " + this.source + " : " + e, (Throwable)e);
        }
    }

    private void finishOpennetRelay(byte[] noderef, final OpennetManager om) {
        final PeerNode dataSource = this.rs.successFrom();
        if (logMINOR) {
            Logger.minor(this, "Finishing opennet: relaying reference from " + dataSource + " on " + this);
        }
        try {
            om.sendOpennetRef(false, this.uid, this.source, noderef, this);
        }
        catch (NotConnectedException e) {
            this.rs.ackOpennet(dataSource);
            this.applyByteCounts();
            this.unregisterRequestHandlerWithNode();
            return;
        }
        OpennetManager.waitForOpennetNoderef(true, this.source, this.uid, this, new OpennetManager.NoderefCallback(){

            @Override
            public void gotNoderef(byte[] newNoderef) {
                if (newNoderef == null) {
                    RequestHandler.this.tag.unlockHandler();
                    RequestHandler.this.rs.ackOpennet(dataSource);
                } else {
                    if (OpennetManager.validateNoderef(newNoderef, 0, newNoderef.length, RequestHandler.this.source, false) != null) {
                        try {
                            if (logMINOR) {
                                Logger.minor(this, "Relaying noderef from source to data source for " + RequestHandler.this);
                            }
                            om.sendOpennetRef(true, RequestHandler.this.uid, dataSource, newNoderef, RequestHandler.this, new BulkTransmitter.AllSentCallback(){

                                @Override
                                public void allSent(BulkTransmitter bulkTransmitter, boolean anyFailed) {
                                    RequestHandler.this.tag.finishedWaitingForOpennet(dataSource);
                                    RequestHandler.this.tag.unlockHandler();
                                    RequestHandler.this.applyByteCounts();
                                }
                            });
                        }
                        catch (NotConnectedException notConnectedException) {
                            // empty catch block
                        }
                    }
                    RequestHandler.this.tag.finishedWaitingForOpennet(dataSource);
                    RequestHandler.this.tag.unlockHandler();
                    RequestHandler.this.applyByteCounts();
                }
            }

            @Override
            public void timedOut() {
                RequestHandler.this.tag.unlockHandler();
                try {
                    dataSource.sendAsync(DMT.createFNPOpennetCompletedTimeout(RequestHandler.this.uid), RequestHandler.this.rs.finishOpennetOnAck(dataSource), RequestHandler.this);
                }
                catch (NotConnectedException notConnectedException) {
                    // empty catch block
                }
                RequestHandler.this.rs.ackOpennet(RequestHandler.this.rs.successFrom());
                RequestHandler.this.applyByteCounts();
            }

            @Override
            public void acked(boolean timedOutMessage) {
                RequestHandler.this.tag.unlockHandler();
                RequestHandler.this.rs.ackOpennet(dataSource);
                RequestHandler.this.applyByteCounts();
            }
        }, this.node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sentBytes(int x) {
        Object object = this.bytesSync;
        synchronized (object) {
            this.sentBytes += x;
        }
        this.node.nodeStats.requestSentBytes(this.key instanceof NodeSSK, x);
        if (logMINOR) {
            Logger.minor(this, "sentBytes(" + x + ") on " + this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void receivedBytes(int x) {
        Object object = this.bytesSync;
        synchronized (object) {
            this.receivedBytes += x;
        }
        this.node.nodeStats.requestReceivedBytes(this.key instanceof NodeSSK, x);
    }

    @Override
    public void sentPayload(int x) {
        this.node.sentPayload(x);
        this.node.nodeStats.requestSentBytes(this.key instanceof NodeSSK, -x);
        if (logMINOR) {
            Logger.minor(this, "sentPayload(" + x + ") on " + this);
        }
    }

    @Override
    public int getPriority() {
        return NativeThread.HIGH_PRIORITY;
    }

    @Override
    public void onNotStarted(boolean internalError) {
        assert (false);
    }

    @Override
    public void onDataFoundLocally() {
        assert (false);
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            @Override
            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(Logger.LogLevel.MINOR, (Object)this);
            }
        });
    }

    private class TerminalMessageByteCountCollector
    implements AsyncMessageCallback {
        private boolean completed = false;

        private TerminalMessageByteCountCollector() {
        }

        @Override
        public void acknowledged() {
            if (logMINOR) {
                Logger.minor(this, "Acknowledged terminal message: " + RequestHandler.this);
            }
            this.complete();
        }

        @Override
        public void disconnected() {
            if (logMINOR) {
                Logger.minor(this, "Peer disconnected before terminal message sent for " + RequestHandler.this);
            }
            this.complete();
        }

        @Override
        public void fatalError() {
            Logger.error(this, "Error sending terminal message?! for " + RequestHandler.this);
            this.complete();
        }

        @Override
        public void sent() {
            if (logMINOR) {
                Logger.minor(this, "Sent terminal message: " + RequestHandler.this);
            }
            this.complete();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void complete() {
            TerminalMessageByteCountCollector terminalMessageByteCountCollector = this;
            synchronized (terminalMessageByteCountCollector) {
                if (this.completed) {
                    return;
                }
                this.completed = true;
            }
            if (logMINOR) {
                Logger.minor(this, "Completing: " + RequestHandler.this);
            }
            RequestHandler.this.applyByteCounts();
            RequestHandler.this.unregisterRequestHandlerWithNode();
        }
    }
}

