/*
 * Decompiled with CFR 0.152.
 */
package freenet.crypt;

import freenet.support.Logger;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public enum HMAC {
    SHA2_256("HmacSHA256", 32);

    final String algo;
    final int digestSize;

    private HMAC(String name, int size) {
        this.algo = name;
        this.digestSize = size;
    }

    public static byte[] mac(HMAC hash, byte[] key, byte[] data) {
        Mac mac;
        if (key.length != hash.digestSize) {
            throw new IllegalArgumentException("Wrong keysize! We're not doing key stretching " + key.length + " expected " + hash.digestSize);
        }
        SecretKeySpec signingKey = new SecretKeySpec(key, hash.algo);
        try {
            mac = Mac.getInstance(hash.algo);
        }
        catch (NoSuchAlgorithmException e) {
            Logger.error(HMAC.class, "No such AlgorithmException", (Throwable)e);
            throw new Error(e);
        }
        try {
            mac.init(signingKey);
        }
        catch (InvalidKeyException e) {
            Logger.error(HMAC.class, "Impossible InvalidKeyException", (Throwable)e);
            throw new Error(e);
        }
        return mac.doFinal(data);
    }

    public static boolean verify(HMAC hash, byte[] key, byte[] data, byte[] mac) {
        return MessageDigest.isEqual(mac, HMAC.mac(hash, key, data));
    }

    public static byte[] macWithSHA256(byte[] K, byte[] text) {
        return HMAC.mac(SHA2_256, K, text);
    }

    public static boolean verifyWithSHA256(byte[] K, byte[] text, byte[] mac) {
        return HMAC.verify(SHA2_256, K, text, mac);
    }
}

