/*
 * Decompiled with CFR 0.152.
 */
package freenet.crypt;

import freenet.client.async.ClientContext;
import freenet.crypt.CryptByteBuffer;
import freenet.crypt.EncryptedRandomAccessBufferType;
import freenet.crypt.KeyGenUtils;
import freenet.crypt.MasterSecret;
import freenet.crypt.MessageAuthCode;
import freenet.support.Fields;
import freenet.support.Logger;
import freenet.support.api.LockableRandomAccessBuffer;
import freenet.support.io.BucketTools;
import freenet.support.io.FilenameGenerator;
import freenet.support.io.PersistentFileTracker;
import freenet.support.io.ResumeFailedException;
import freenet.support.io.StorageFormatException;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.util.concurrent.locks.ReentrantLock;
import javax.crypto.SecretKey;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.SkippingStreamCipher;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;

public final class EncryptedRandomAccessBuffer
implements LockableRandomAccessBuffer,
Serializable {
    private static final long serialVersionUID = 1L;
    private final ReentrantLock readLock = new ReentrantLock();
    private final ReentrantLock writeLock = new ReentrantLock();
    private final EncryptedRandomAccessBufferType type;
    private final LockableRandomAccessBuffer underlyingBuffer;
    private transient SkippingStreamCipher cipherRead;
    private transient SkippingStreamCipher cipherWrite;
    private transient ParametersWithIV cipherParams;
    private transient SecretKey headerMacKey;
    private volatile transient boolean isClosed = false;
    private transient SecretKey unencryptedBaseKey;
    private transient SecretKey headerEncKey;
    private transient byte[] headerEncIV;
    private int version;
    private static final long END_MAGIC = 3176597310644858067L;
    private static final int VERSION_AND_MAGIC_LENGTH = 12;
    public static final int MAGIC = 971674818;

    public EncryptedRandomAccessBuffer(EncryptedRandomAccessBufferType type, LockableRandomAccessBuffer underlying, MasterSecret masterKey, boolean newFile) throws IOException, GeneralSecurityException {
        this.type = type;
        this.underlyingBuffer = underlying;
        this.setup(masterKey, newFile);
    }

    private void setup(MasterSecret masterKey, boolean newFile) throws IOException, GeneralSecurityException {
        this.cipherRead = this.type.get();
        this.cipherWrite = this.type.get();
        MasterSecret masterSecret = masterKey;
        this.headerEncKey = masterSecret.deriveKey(this.type.encryptKey);
        this.headerMacKey = masterSecret.deriveKey(this.type.macKey);
        if (this.underlyingBuffer.size() < (long)this.type.headerLen) {
            throw new IOException("Underlying RandomAccessBuffer is not long enough to include the footer.");
        }
        byte[] header = new byte[12];
        int offset = 0;
        this.underlyingBuffer.pread(this.type.headerLen - 12, header, offset, 12);
        int readVersion = ByteBuffer.wrap(header, offset, 4).getInt();
        long magic = ByteBuffer.wrap(header, offset += 4, 8).getLong();
        if (!newFile && 3176597310644858067L != magic) {
            throw new IOException("This is not an EncryptedRandomAccessBuffer!");
        }
        this.version = this.type.bitmask;
        if (newFile) {
            this.headerEncIV = KeyGenUtils.genIV(this.type.encryptType.ivSize).getIV();
            this.unencryptedBaseKey = KeyGenUtils.genSecretKey(this.type.encryptKey);
            this.writeHeader();
        } else {
            if (readVersion != this.version) {
                throw new IOException("Version of the underlying RandomAccessBuffer is incompatible with this ERATType");
            }
            if (!this.verifyHeader()) {
                throw new GeneralSecurityException("MAC is incorrect");
            }
        }
        ParametersWithIV tempPram = null;
        try {
            KeyParameter cipherKey = new KeyParameter(KeyGenUtils.deriveSecretKey(this.unencryptedBaseKey, this.getClass(), kdfInput.underlyingKey.input, this.type.encryptKey).getEncoded());
            tempPram = new ParametersWithIV((CipherParameters)cipherKey, KeyGenUtils.deriveIvParameterSpec(this.unencryptedBaseKey, this.getClass(), kdfInput.underlyingIV.input, this.type.encryptKey).getIV());
        }
        catch (InvalidKeyException e) {
            throw new IllegalStateException(e);
        }
        this.cipherParams = tempPram;
        this.cipherRead.init(false, (CipherParameters)this.cipherParams);
        this.cipherWrite.init(true, (CipherParameters)this.cipherParams);
    }

    @Override
    public long size() {
        return this.underlyingBuffer.size() - (long)this.type.headerLen;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pread(long fileOffset, byte[] buf, int bufOffset, int length) throws IOException {
        if (this.isClosed) {
            throw new IOException("This RandomAccessBuffer has already been closed. It can no longer be read from.");
        }
        if (fileOffset < 0L) {
            throw new IllegalArgumentException("Cannot read before zero");
        }
        if (fileOffset + (long)length > this.size()) {
            throw new IOException("Cannot read after end: trying to read from " + fileOffset + " to " + (fileOffset + (long)length) + " on block length " + this.size());
        }
        byte[] cipherText = new byte[length];
        this.underlyingBuffer.pread(fileOffset + (long)this.type.headerLen, cipherText, 0, length);
        this.readLock.lock();
        try {
            long position = this.cipherRead.getPosition();
            long delta = fileOffset - position;
            this.cipherRead.skip(delta);
            assert (this.cipherRead.getPosition() == fileOffset);
            this.cipherRead.processBytes(cipherText, 0, length, buf, bufOffset);
            assert (this.cipherRead.getPosition() == fileOffset + (long)length);
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pwrite(long fileOffset, byte[] buf, int bufOffset, int length) throws IOException {
        if (this.isClosed) {
            throw new IOException("This RandomAccessBuffer has already been closed. It can no longer be written to.");
        }
        if (fileOffset < 0L) {
            throw new IllegalArgumentException("Cannot read before zero");
        }
        if (fileOffset + (long)length > this.size()) {
            throw new IOException("Cannot write after end: trying to write from " + fileOffset + " to " + (fileOffset + (long)length) + " on block length " + this.size());
        }
        byte[] cipherText = new byte[length];
        this.writeLock.lock();
        try {
            long position = this.cipherWrite.getPosition();
            long delta = fileOffset - position;
            this.cipherWrite.skip(delta);
            assert (this.cipherWrite.getPosition() == fileOffset);
            this.cipherWrite.processBytes(buf, bufOffset, length, cipherText, 0);
            assert (this.cipherWrite.getPosition() == fileOffset + (long)length);
        }
        finally {
            this.writeLock.unlock();
        }
        this.underlyingBuffer.pwrite(fileOffset + (long)this.type.headerLen, cipherText, 0, length);
    }

    @Override
    public void close() {
        if (!this.isClosed) {
            this.isClosed = true;
            this.underlyingBuffer.close();
        }
    }

    @Override
    public void free() {
        this.close();
        this.underlyingBuffer.free();
    }

    private void writeHeader() throws IOException, GeneralSecurityException {
        byte[] macResult;
        if (this.isClosed) {
            throw new IOException("This RandomAccessBuffer has already been closed. This should not happen.");
        }
        byte[] header = new byte[this.type.headerLen];
        int offset = 0;
        int ivLen = this.headerEncIV.length;
        System.arraycopy(this.headerEncIV, 0, header, offset, ivLen);
        offset += ivLen;
        byte[] encryptedKey = null;
        try {
            CryptByteBuffer crypt = new CryptByteBuffer(this.type.encryptType, this.headerEncKey, this.headerEncIV);
            encryptedKey = crypt.encryptCopy(this.unencryptedBaseKey.getEncoded());
        }
        catch (InvalidKeyException e) {
            throw new GeneralSecurityException("Something went wrong with key generation. please report", e.fillInStackTrace());
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new GeneralSecurityException("Something went wrong with key generation. please report", e.fillInStackTrace());
        }
        System.arraycopy(encryptedKey, 0, header, offset, encryptedKey.length);
        offset += encryptedKey.length;
        byte[] ver = ByteBuffer.allocate(4).putInt(this.version).array();
        try {
            MessageAuthCode mac = new MessageAuthCode(this.type.macType, this.headerMacKey);
            macResult = Fields.copyToArray(mac.genMac(this.headerEncIV, this.unencryptedBaseKey.getEncoded(), ver));
            System.arraycopy(macResult, 0, header, offset, macResult.length);
        }
        catch (InvalidKeyException e) {
            throw new GeneralSecurityException("Something went wrong with key generation. please report", e.fillInStackTrace());
        }
        System.arraycopy(ver, 0, header, offset += macResult.length, ver.length);
        byte[] magic = ByteBuffer.allocate(8).putLong(3176597310644858067L).array();
        System.arraycopy(magic, 0, header, offset += ver.length, magic.length);
        this.underlyingBuffer.pwrite(0L, header, 0, header.length);
    }

    private boolean verifyHeader() throws IOException, InvalidKeyException {
        if (this.isClosed) {
            throw new IOException("This RandomAccessBuffer has already been closed. This should not happen.");
        }
        byte[] footer = new byte[this.type.headerLen - 12];
        int offset = 0;
        this.underlyingBuffer.pread(0L, footer, offset, this.type.headerLen - 12);
        this.headerEncIV = new byte[this.type.encryptType.ivSize.intValue()];
        System.arraycopy(footer, offset, this.headerEncIV, 0, this.headerEncIV.length);
        int keySize = this.type.encryptKey.keySize >> 3;
        byte[] encryptedKey = new byte[keySize];
        System.arraycopy(footer, offset += this.headerEncIV.length, encryptedKey, 0, keySize);
        offset += keySize;
        try {
            CryptByteBuffer crypt = new CryptByteBuffer(this.type.encryptType, this.headerEncKey, this.headerEncIV);
            this.unencryptedBaseKey = KeyGenUtils.getSecretKey(this.type.encryptKey, crypt.decryptCopy(encryptedKey));
        }
        catch (InvalidKeyException e) {
            throw new IOException("Error reading encryption keys from header.");
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new IOException("Error reading encryption keys from header.");
        }
        byte[] mac = new byte[this.type.macLen];
        System.arraycopy(footer, offset, mac, 0, this.type.macLen);
        byte[] ver = ByteBuffer.allocate(4).putInt(this.version).array();
        MessageAuthCode authcode = new MessageAuthCode(this.type.macType, this.headerMacKey);
        return authcode.verifyData(mac, this.headerEncIV, this.unencryptedBaseKey.getEncoded(), ver);
    }

    @Override
    public LockableRandomAccessBuffer.RAFLock lockOpen() throws IOException {
        return this.underlyingBuffer.lockOpen();
    }

    @Override
    public void onResume(ClientContext context) throws ResumeFailedException {
        this.underlyingBuffer.onResume(context);
        try {
            this.setup(context.getPersistentMasterSecret(), false);
        }
        catch (IOException e) {
            Logger.error(this, "Disk I/O error resuming: " + e, (Throwable)e);
            throw new ResumeFailedException(e);
        }
        catch (GeneralSecurityException e) {
            Logger.error(this, "Impossible security error resuming - maybe we lost a codec?: " + e, (Throwable)e);
            throw new ResumeFailedException(e);
        }
    }

    @Override
    public void storeTo(DataOutputStream dos) throws IOException {
        dos.writeInt(971674818);
        dos.writeInt(this.type.bitmask);
        this.underlyingBuffer.storeTo(dos);
    }

    public static LockableRandomAccessBuffer create(DataInputStream dis, FilenameGenerator fg, PersistentFileTracker persistentFileTracker, MasterSecret masterKey) throws IOException, StorageFormatException, ResumeFailedException {
        EncryptedRandomAccessBufferType type = EncryptedRandomAccessBufferType.getByBitmask(dis.readInt());
        if (type == null) {
            throw new StorageFormatException("Unknown EncryptedRandomAccessBufferType");
        }
        LockableRandomAccessBuffer underlying = BucketTools.restoreRAFFrom(dis, fg, persistentFileTracker, masterKey);
        try {
            return new EncryptedRandomAccessBuffer(type, underlying, masterKey, false);
        }
        catch (GeneralSecurityException e) {
            Logger.error(EncryptedRandomAccessBuffer.class, "Crypto error resuming: " + e, (Throwable)e);
            throw new ResumeFailedException(e);
        }
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        result = 31 * result + (this.underlyingBuffer == null ? 0 : this.underlyingBuffer.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EncryptedRandomAccessBuffer other = (EncryptedRandomAccessBuffer)obj;
        if (this.type != other.type) {
            return false;
        }
        return this.underlyingBuffer.equals(other.underlyingBuffer);
    }

    static enum kdfInput {
        underlyingKey,
        underlyingIV;

        public final String input = this.name();
    }
}

